// Code generated by smithy-go-codegen DO NOT EDIT.

package timestreaminfluxdb

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/timestreaminfluxdb/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves information about a Timestream for InfluxDB cluster.
func (c *Client) GetDbCluster(ctx context.Context, params *GetDbClusterInput, optFns ...func(*Options)) (*GetDbClusterOutput, error) {
	if params == nil {
		params = &GetDbClusterInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDbCluster", params, optFns, c.addOperationGetDbClusterMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDbClusterOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDbClusterInput struct {

	// Service-generated unique identifier of the DB cluster to retrieve.
	//
	// This member is required.
	DbClusterId *string

	noSmithyDocumentSerde
}

type GetDbClusterOutput struct {

	// The Amazon Resource Name (ARN) of the DB cluster.
	//
	// This member is required.
	Arn *string

	// Service-generated unique identifier of the DB cluster to retrieve.
	//
	// This member is required.
	Id *string

	// Customer-supplied name of the Timestream for InfluxDB cluster.
	//
	// This member is required.
	Name *string

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB instance type that InfluxDB runs on.
	DbInstanceType types.DbInstanceType

	// The ID of the DB parameter group assigned to your DB cluster.
	DbParameterGroupIdentifier *string

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType types.DbStorageType

	// Deployment type of the DB cluster.
	DeploymentType types.ClusterDeploymentType

	// The endpoint used to connect to the Timestream for InfluxDB cluster for write
	// and read operations.
	Endpoint *string

	// The configured failover mode for the DB cluster.
	FailoverMode types.FailoverMode

	// The Amazon Resource Name (ARN) of the Amazon Web Services Secrets Manager
	// secret containing the initial InfluxDB authorization parameters. The secret
	// value is a JSON formatted key-value pair holding InfluxDB authorization values:
	// organization, bucket, username, and password.
	InfluxAuthParametersSecretArn *string

	// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
	LogDeliveryConfiguration *types.LogDeliveryConfiguration

	// Specifies whether the network type of the Timestream for InfluxDB cluster is
	// IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType types.NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// Indicates if the DB cluster has a public IP to facilitate access from outside
	// the VPC.
	PubliclyAccessible *bool

	// The endpoint used to connect to the Timestream for InfluxDB cluster for
	// read-only operations.
	ReaderEndpoint *string

	// The status of the DB cluster.
	Status types.ClusterStatus

	// A list of VPC security group IDs associated with the DB cluster.
	VpcSecurityGroupIds []string

	// A list of VPC subnet IDs associated with the DB cluster.
	VpcSubnetIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDbClusterMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetDbCluster{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetDbCluster{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDbCluster"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetDbClusterValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDbCluster(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetDbCluster(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDbCluster",
	}
}
