// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Describes a summary of a Timestream for InfluxDB cluster.
type DbClusterSummary struct {

	// The Amazon Resource Name (ARN) of the DB cluster.
	//
	// This member is required.
	Arn *string

	// Service-generated unique identifier of the DB cluster to retrieve.
	//
	// This member is required.
	Id *string

	// Customer supplied name of the Timestream for InfluxDB cluster.
	//
	// This member is required.
	Name *string

	// The amount of storage allocated for your DB storage type (in gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB DB instance type that InfluxDB runs on.
	DbInstanceType DbInstanceType

	// The Timestream for InfluxDB DB storage type that InfluxDB stores data on.
	DbStorageType DbStorageType

	// Deployment type of the DB cluster
	DeploymentType ClusterDeploymentType

	// The endpoint used to connect to the Timestream for InfluxDB cluster for write
	// and read operations.
	Endpoint *string

	// Specifies whether the network type of the Timestream for InfluxDB Cluster is
	// IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// The endpoint used to connect to the Timestream for InfluxDB cluster for
	// read-only operations.
	ReaderEndpoint *string

	// The status of the DB cluster.
	Status ClusterStatus

	noSmithyDocumentSerde
}

// Contains a summary of a DB instance belonging to a DB cluster.
type DbInstanceForClusterSummary struct {

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// This member is required.
	Arn *string

	// The service-generated unique identifier of the DB instance.
	//
	// This member is required.
	Id *string

	// A service-generated name for the DB instance based on the customer-supplied
	// name for the DB cluster.
	//
	// This member is required.
	Name *string

	// The amount of storage allocated for your DB storage type in GiB (gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB instance type to run InfluxDB on.
	DbInstanceType DbInstanceType

	// The storage type for your DB instance.
	DbStorageType DbStorageType

	// Specifies the deployment type if applicable.
	DeploymentType DeploymentType

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string

	// Specifies the DB instance's role in the cluster.
	InstanceMode InstanceMode

	// Specifies whether the network type of the Timestream for InfluxDB instance is
	// IPv4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// The status of the DB instance.
	Status Status

	noSmithyDocumentSerde
}

// Contains a summary of a DB instance.
type DbInstanceSummary struct {

	// The Amazon Resource Name (ARN) of the DB instance.
	//
	// This member is required.
	Arn *string

	// The service-generated unique identifier of the DB instance.
	//
	// This member is required.
	Id *string

	// This customer-supplied name uniquely identifies the DB instance when
	// interacting with the Amazon Timestream for InfluxDB API and Amazon Web Services
	// CLI commands.
	//
	// This member is required.
	Name *string

	// The amount of storage to allocate for your DbStorageType in GiB (gibibytes).
	AllocatedStorage *int32

	// The Timestream for InfluxDB instance type to run InfluxDB on.
	DbInstanceType DbInstanceType

	// The storage type for your DB instance.
	DbStorageType DbStorageType

	// Single-Instance or with a MultiAZ Standby for High availability.
	DeploymentType DeploymentType

	// The endpoint used to connect to InfluxDB. The default InfluxDB port is 8086.
	Endpoint *string

	// Specifies whether the networkType of the Timestream for InfluxDB instance is
	// IPV4, which can communicate over IPv4 protocol only, or DUAL, which can
	// communicate over both IPv4 and IPv6 protocols.
	NetworkType NetworkType

	// The port number on which InfluxDB accepts connections.
	Port *int32

	// The status of the DB instance.
	Status Status

	noSmithyDocumentSerde
}

// Contains a summary of a DB parameter group.
type DbParameterGroupSummary struct {

	// The Amazon Resource Name (ARN) of the DB parameter group.
	//
	// This member is required.
	Arn *string

	// A service-generated unique identifier.
	//
	// This member is required.
	Id *string

	// This customer-supplied name uniquely identifies the parameter group.
	//
	// This member is required.
	Name *string

	// A description of the DB parameter group.
	Description *string

	noSmithyDocumentSerde
}

// Duration for InfluxDB parameters in Timestream for InfluxDB.
type Duration struct {

	// The type of duration for InfluxDB parameters.
	//
	// This member is required.
	DurationType DurationType

	// The value of duration for InfluxDB parameters.
	//
	// This member is required.
	Value *int64

	noSmithyDocumentSerde
}

// All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
type InfluxDBv2Parameters struct {

	// Include option to show detailed logs for Flux queries.
	//
	// Default: false
	FluxLogEnabled *bool

	// Maximum duration the server should keep established connections alive while
	// waiting for new requests. Set to 0 for no timeout.
	//
	// Default: 3 minutes
	HttpIdleTimeout *Duration

	// Maximum duration the server should try to read HTTP headers for new requests.
	// Set to 0 for no timeout.
	//
	// Default: 10 seconds
	HttpReadHeaderTimeout *Duration

	// Maximum duration the server should try to read the entirety of new requests.
	// Set to 0 for no timeout.
	//
	// Default: 0
	HttpReadTimeout *Duration

	// Maximum duration the server should spend processing and responding to write
	// requests. Set to 0 for no timeout.
	//
	// Default: 0
	HttpWriteTimeout *Duration

	// Maximum number of group by time buckets a SELECT statement can create. 0 allows
	// an unlimited number of buckets.
	//
	// Default: 0
	InfluxqlMaxSelectBuckets *int64

	// Maximum number of points a SELECT statement can process. 0 allows an unlimited
	// number of points. InfluxDB checks the point count every second (so queries
	// exceeding the maximum aren’t immediately aborted).
	//
	// Default: 0
	InfluxqlMaxSelectPoint *int64

	// Maximum number of series a SELECT statement can return. 0 allows an unlimited
	// number of series.
	//
	// Default: 0
	InfluxqlMaxSelectSeries *int64

	// Log output level. InfluxDB outputs log entries with severity levels greater
	// than or equal to the level specified.
	//
	// Default: info
	LogLevel LogLevel

	// Disable the HTTP /metrics endpoint which exposes [internal InfluxDB metrics].
	//
	// Default: false
	//
	// [internal InfluxDB metrics]: https://docs.influxdata.com/influxdb/v2/reference/internals/metrics/
	MetricsDisabled *bool

	// Disable the task scheduler. If problematic tasks prevent InfluxDB from
	// starting, use this option to start InfluxDB without scheduling or executing
	// tasks.
	//
	// Default: false
	NoTasks *bool

	// Disable the /debug/pprof HTTP endpoint. This endpoint provides runtime
	// profiling data and can be helpful when debugging.
	//
	// Default: false
	PprofDisabled *bool

	// Number of queries allowed to execute concurrently. Setting to 0 allows an
	// unlimited number of concurrent queries.
	//
	// Default: 0
	QueryConcurrency *int32

	// Initial bytes of memory allocated for a query.
	//
	// Default: 0
	QueryInitialMemoryBytes *int64

	// Maximum number of queries allowed in execution queue. When queue limit is
	// reached, new queries are rejected. Setting to 0 allows an unlimited number of
	// queries in the queue.
	//
	// Default: 0
	QueryMaxMemoryBytes *int64

	// Maximum bytes of memory allowed for a single query. Must be greater or equal to
	// queryInitialMemoryBytes.
	//
	// Default: 0
	QueryMemoryBytes *int64

	// Maximum number of queries allowed in execution queue. When queue limit is
	// reached, new queries are rejected. Setting to 0 allows an unlimited number of
	// queries in the queue.
	//
	// Default: 0
	QueryQueueSize *int32

	// Specifies the Time to Live (TTL) in minutes for newly created user sessions.
	//
	// Default: 60
	SessionLength *int32

	// Disables automatically extending a user’s session TTL on each request. By
	// default, every request sets the session’s expiration time to five minutes from
	// now. When disabled, sessions expire after the specified [session length]and the user is
	// redirected to the login page, even if recently active.
	//
	// Default: false
	//
	// [session length]: https://docs.influxdata.com/influxdb/v2/reference/config-options/#session-length
	SessionRenewDisabled *bool

	// Maximum size (in bytes) a shard’s cache can reach before it starts rejecting
	// writes. Must be greater than storageCacheSnapShotMemorySize and lower than
	// instance’s total memory capacity. We recommend setting it to below 15% of the
	// total memory capacity.
	//
	// Default: 1073741824
	StorageCacheMaxMemorySize *int64

	// Size (in bytes) at which the storage engine will snapshot the cache and write
	// it to a TSM file to make more memory available. Must not be greater than
	// storageCacheMaxMemorySize.
	//
	// Default: 26214400
	StorageCacheSnapshotMemorySize *int64

	// Duration at which the storage engine will snapshot the cache and write it to a
	// new TSM file if the shard hasn’t received writes or deletes.
	//
	// Default: 10 minutes
	StorageCacheSnapshotWriteColdDuration *Duration

	// Duration at which the storage engine will compact all TSM files in a shard if
	// it hasn't received writes or deletes.
	//
	// Default: 4 hours
	StorageCompactFullWriteColdDuration *Duration

	// Rate limit (in bytes per second) that TSM compactions can write to disk.
	//
	// Default: 50331648
	StorageCompactThroughputBurst *int64

	// Maximum number of full and level compactions that can run concurrently. A value
	// of 0 results in 50% of runtime.GOMAXPROCS(0) used at runtime. Any number greater
	// than zero limits compactions to that value. This setting does not apply to cache
	// snapshotting.
	//
	// Default: 0
	StorageMaxConcurrentCompactions *int32

	// Size (in bytes) at which an index write-ahead log (WAL) file will compact into
	// an index file. Lower sizes will cause log files to be compacted more quickly and
	// result in lower heap usage at the expense of write throughput.
	//
	// Default: 1048576
	StorageMaxIndexLogFileSize *int64

	// Skip field size validation on incoming write requests.
	//
	// Default: false
	StorageNoValidateFieldSize *bool

	// Interval of retention policy enforcement checks. Must be greater than 0.
	//
	// Default: 30 minutes
	StorageRetentionCheckInterval *Duration

	// Maximum number of snapshot compactions that can run concurrently across all
	// series partitions in a database.
	//
	// Default: 0
	StorageSeriesFileMaxConcurrentSnapshotCompactions *int32

	// Size of the internal cache used in the TSI index to store previously calculated
	// series results. Cached results are returned quickly rather than needing to be
	// recalculated when a subsequent query with the same tag key/value predicate is
	// executed. Setting this value to 0 will disable the cache and may decrease query
	// performance.
	//
	// Default: 100
	StorageSeriesIdSetCacheSize *int64

	// Maximum number writes to the WAL directory to attempt at the same time. Setting
	// this value to 0 results in number of processing units available x2.
	//
	// Default: 0
	StorageWalMaxConcurrentWrites *int32

	// Maximum amount of time a write request to the WAL directory will wait when the [maximum number of concurrent active writes to the WAL directory has been met]
	// . Set to 0 to disable the timeout.
	//
	// Default: 10 minutes
	//
	// [maximum number of concurrent active writes to the WAL directory has been met]: https://docs.influxdata.com/influxdb/v2/reference/config-options/#storage-wal-max-concurrent-writes
	StorageWalMaxWriteDelay *Duration

	// Enable tracing in InfluxDB and specifies the tracing type. Tracing is disabled
	// by default.
	TracingType TracingType

	// Disable the InfluxDB user interface (UI). The UI is enabled by default.
	//
	// Default: false
	UiDisabled *bool

	noSmithyDocumentSerde
}

// Configuration for sending InfluxDB engine logs to send to specified S3 bucket.
type LogDeliveryConfiguration struct {

	// Configuration for S3 bucket log delivery.
	//
	// This member is required.
	S3Configuration *S3Configuration

	noSmithyDocumentSerde
}

// The parameters that comprise the parameter group.
//
// The following types satisfy this interface:
//
//	ParametersMemberInfluxDBv2
type Parameters interface {
	isParameters()
}

// All the customer-modifiable InfluxDB v2 parameters in Timestream for InfluxDB.
type ParametersMemberInfluxDBv2 struct {
	Value InfluxDBv2Parameters

	noSmithyDocumentSerde
}

func (*ParametersMemberInfluxDBv2) isParameters() {}

// Configuration for S3 bucket log delivery.
type S3Configuration struct {

	// The name of the S3 bucket to deliver logs to.
	//
	// This member is required.
	BucketName *string

	// Indicates whether log delivery to the S3 bucket is enabled.
	//
	// This member is required.
	Enabled *bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isParameters() {}
