// Code generated by smithy-go-codegen DO NOT EDIT.

package transfer

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of the contents of a directory from a remote SFTP server. You
// specify the connector ID, the output path, and the remote directory path. You
// can also specify the optional MaxItems value to control the maximum number of
// items that are listed from the remote directory. This API returns a list of all
// files and directories in the remote directory (up to the maximum value), but
// does not return files or folders in sub-directories. That is, it only returns a
// list of files and directories one-level deep.
//
// After you receive the listing file, you can provide the files that you want to
// transfer to the RetrieveFilePaths parameter of the StartFileTransfer API call.
//
// The naming convention for the output file is  connector-ID-listing-ID.json . The
// output file contains the following information:
//
//   - filePath : the complete path of a remote file, relative to the directory of
//     the listing request for your SFTP connector on the remote server.
//
//   - modifiedTimestamp : the last time the file was modified, in UTC time format.
//     This field is optional. If the remote file attributes don't contain a timestamp,
//     it is omitted from the file listing.
//
//   - size : the size of the file, in bytes. This field is optional. If the remote
//     file attributes don't contain a file size, it is omitted from the file listing.
//
//   - path : the complete path of a remote directory, relative to the directory of
//     the listing request for your SFTP connector on the remote server.
//
//   - truncated : a flag indicating whether the list output contains all of the
//     items contained in the remote directory or not. If your Truncated output value
//     is true, you can increase the value provided in the optional max-items input
//     attribute to be able to list more items (up to the maximum allowed list size of
//     10,000 items).
func (c *Client) StartDirectoryListing(ctx context.Context, params *StartDirectoryListingInput, optFns ...func(*Options)) (*StartDirectoryListingOutput, error) {
	if params == nil {
		params = &StartDirectoryListingInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartDirectoryListing", params, optFns, c.addOperationStartDirectoryListingMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartDirectoryListingOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartDirectoryListingInput struct {

	// The unique identifier for the connector.
	//
	// This member is required.
	ConnectorId *string

	// Specifies the path (bucket and prefix) in Amazon S3 storage to store the
	// results of the directory listing.
	//
	// This member is required.
	OutputDirectoryPath *string

	// Specifies the directory on the remote SFTP server for which you want to list
	// its contents.
	//
	// This member is required.
	RemoteDirectoryPath *string

	// An optional parameter where you can specify the maximum number of
	// file/directory names to retrieve. The default value is 1,000.
	MaxItems *int32

	noSmithyDocumentSerde
}

type StartDirectoryListingOutput struct {

	// Returns a unique identifier for the directory listing call.
	//
	// This member is required.
	ListingId *string

	// Returns the file name where the results are stored. This is a combination of
	// the connector ID and the listing ID: <connector-id>-<listing-id>.json .
	//
	// This member is required.
	OutputFileName *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartDirectoryListingMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartDirectoryListing{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartDirectoryListing{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartDirectoryListing"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStartDirectoryListingValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartDirectoryListing(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartDirectoryListing(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartDirectoryListing",
	}
}
