// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about the specified resource configuration.
func (c *Client) GetResourceConfiguration(ctx context.Context, params *GetResourceConfigurationInput, optFns ...func(*Options)) (*GetResourceConfigurationOutput, error) {
	if params == nil {
		params = &GetResourceConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourceConfiguration", params, optFns, c.addOperationGetResourceConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourceConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourceConfigurationInput struct {

	// The ID of the resource configuration.
	//
	// This member is required.
	ResourceConfigurationIdentifier *string

	noSmithyDocumentSerde
}

type GetResourceConfigurationOutput struct {

	// Specifies whether the resource configuration is associated with a sharable
	// service network.
	AllowAssociationToShareableServiceNetwork *bool

	// Indicates whether the resource configuration was created and is managed by
	// Amazon.
	AmazonManaged *bool

	// The Amazon Resource Name (ARN) of the resource configuration.
	Arn *string

	// The date and time that the resource configuration was created, in ISO-8601
	// format.
	CreatedAt *time.Time

	// The custom domain name of the resource configuration.
	CustomDomainName *string

	// The reason the create-resource-configuration request failed.
	FailureReason *string

	// The ID of the resource configuration.
	Id *string

	// The most recent date and time that the resource configuration was updated, in
	// ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the resource configuration.
	Name *string

	// The TCP port ranges that a consumer can use to access a resource configuration.
	// You can separate port ranges with a comma. Example: 1-65535 or 1,2,22-30
	PortRanges []string

	// The TCP protocol accepted by the specified resource configuration.
	Protocol types.ProtocolType

	// The resource configuration.
	ResourceConfigurationDefinition types.ResourceConfigurationDefinition

	// The ID of the group resource configuration.
	ResourceConfigurationGroupId *string

	// The ID of the resource gateway used to connect to the resource configuration in
	// a given VPC. You can specify the resource gateway identifier only for resource
	// configurations with type SINGLE, GROUP, or ARN.
	ResourceGatewayId *string

	// The status of the resource configuration.
	Status types.ResourceConfigurationStatus

	// The type of resource configuration.
	//
	//   - SINGLE - A single resource.
	//
	//   - GROUP - A group of resources.
	//
	//   - CHILD - A single resource that is part of a group resource configuration.
	//
	//   - ARN - An Amazon Web Services resource.
	Type types.ResourceConfigurationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourceConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetResourceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetResourceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetResourceConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetResourceConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourceConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetResourceConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetResourceConfiguration",
	}
}
