// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the access log subscriptions for the specified service network or service.
func (c *Client) ListAccessLogSubscriptions(ctx context.Context, params *ListAccessLogSubscriptionsInput, optFns ...func(*Options)) (*ListAccessLogSubscriptionsOutput, error) {
	if params == nil {
		params = &ListAccessLogSubscriptionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAccessLogSubscriptions", params, optFns, c.addOperationListAccessLogSubscriptionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAccessLogSubscriptionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAccessLogSubscriptionsInput struct {

	// The ID or ARN of the service network or service.
	//
	// This member is required.
	ResourceIdentifier *string

	// The maximum number of results to return.
	MaxResults *int32

	// A pagination token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAccessLogSubscriptionsOutput struct {

	// Information about the access log subscriptions.
	//
	// This member is required.
	Items []types.AccessLogSubscriptionSummary

	// A pagination token for the next page of results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAccessLogSubscriptionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAccessLogSubscriptions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAccessLogSubscriptions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAccessLogSubscriptions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListAccessLogSubscriptionsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAccessLogSubscriptions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListAccessLogSubscriptionsPaginatorOptions is the paginator options for
// ListAccessLogSubscriptions
type ListAccessLogSubscriptionsPaginatorOptions struct {
	// The maximum number of results to return.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAccessLogSubscriptionsPaginator is a paginator for
// ListAccessLogSubscriptions
type ListAccessLogSubscriptionsPaginator struct {
	options   ListAccessLogSubscriptionsPaginatorOptions
	client    ListAccessLogSubscriptionsAPIClient
	params    *ListAccessLogSubscriptionsInput
	nextToken *string
	firstPage bool
}

// NewListAccessLogSubscriptionsPaginator returns a new
// ListAccessLogSubscriptionsPaginator
func NewListAccessLogSubscriptionsPaginator(client ListAccessLogSubscriptionsAPIClient, params *ListAccessLogSubscriptionsInput, optFns ...func(*ListAccessLogSubscriptionsPaginatorOptions)) *ListAccessLogSubscriptionsPaginator {
	if params == nil {
		params = &ListAccessLogSubscriptionsInput{}
	}

	options := ListAccessLogSubscriptionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAccessLogSubscriptionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAccessLogSubscriptionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAccessLogSubscriptions page.
func (p *ListAccessLogSubscriptionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAccessLogSubscriptionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListAccessLogSubscriptions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListAccessLogSubscriptionsAPIClient is a client that implements the
// ListAccessLogSubscriptions operation.
type ListAccessLogSubscriptionsAPIClient interface {
	ListAccessLogSubscriptions(context.Context, *ListAccessLogSubscriptionsInput, ...func(*Options)) (*ListAccessLogSubscriptionsOutput, error)
}

var _ ListAccessLogSubscriptionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListAccessLogSubscriptions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAccessLogSubscriptions",
	}
}
