// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the associations for the specified VPC endpoint.
func (c *Client) ListResourceEndpointAssociations(ctx context.Context, params *ListResourceEndpointAssociationsInput, optFns ...func(*Options)) (*ListResourceEndpointAssociationsOutput, error) {
	if params == nil {
		params = &ListResourceEndpointAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListResourceEndpointAssociations", params, optFns, c.addOperationListResourceEndpointAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListResourceEndpointAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListResourceEndpointAssociationsInput struct {

	// The ID for the resource configuration associated with the VPC endpoint.
	//
	// This member is required.
	ResourceConfigurationIdentifier *string

	// The maximum page size.
	MaxResults *int32

	// A pagination token for the next page of results.
	NextToken *string

	// The ID of the association.
	ResourceEndpointAssociationIdentifier *string

	// The ID of the VPC endpoint in the association.
	VpcEndpointId *string

	// The owner of the VPC endpoint in the association.
	VpcEndpointOwner *string

	noSmithyDocumentSerde
}

type ListResourceEndpointAssociationsOutput struct {

	// Information about the VPC endpoint associations.
	//
	// This member is required.
	Items []types.ResourceEndpointAssociationSummary

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListResourceEndpointAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListResourceEndpointAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListResourceEndpointAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListResourceEndpointAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListResourceEndpointAssociationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListResourceEndpointAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListResourceEndpointAssociationsPaginatorOptions is the paginator options for
// ListResourceEndpointAssociations
type ListResourceEndpointAssociationsPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListResourceEndpointAssociationsPaginator is a paginator for
// ListResourceEndpointAssociations
type ListResourceEndpointAssociationsPaginator struct {
	options   ListResourceEndpointAssociationsPaginatorOptions
	client    ListResourceEndpointAssociationsAPIClient
	params    *ListResourceEndpointAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListResourceEndpointAssociationsPaginator returns a new
// ListResourceEndpointAssociationsPaginator
func NewListResourceEndpointAssociationsPaginator(client ListResourceEndpointAssociationsAPIClient, params *ListResourceEndpointAssociationsInput, optFns ...func(*ListResourceEndpointAssociationsPaginatorOptions)) *ListResourceEndpointAssociationsPaginator {
	if params == nil {
		params = &ListResourceEndpointAssociationsInput{}
	}

	options := ListResourceEndpointAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListResourceEndpointAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListResourceEndpointAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListResourceEndpointAssociations page.
func (p *ListResourceEndpointAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListResourceEndpointAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListResourceEndpointAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListResourceEndpointAssociationsAPIClient is a client that implements the
// ListResourceEndpointAssociations operation.
type ListResourceEndpointAssociationsAPIClient interface {
	ListResourceEndpointAssociations(context.Context, *ListResourceEndpointAssociationsInput, ...func(*Options)) (*ListResourceEndpointAssociationsOutput, error)
}

var _ ListResourceEndpointAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListResourceEndpointAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListResourceEndpointAssociations",
	}
}
