// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the associations between a service network and a resource configuration.
func (c *Client) ListServiceNetworkResourceAssociations(ctx context.Context, params *ListServiceNetworkResourceAssociationsInput, optFns ...func(*Options)) (*ListServiceNetworkResourceAssociationsOutput, error) {
	if params == nil {
		params = &ListServiceNetworkResourceAssociationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListServiceNetworkResourceAssociations", params, optFns, c.addOperationListServiceNetworkResourceAssociationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListServiceNetworkResourceAssociationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListServiceNetworkResourceAssociationsInput struct {

	// The maximum page size.
	MaxResults *int32

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	// The ID of the resource configurationk.
	ResourceConfigurationIdentifier *string

	// The ID of the service network.
	ServiceNetworkIdentifier *string

	noSmithyDocumentSerde
}

type ListServiceNetworkResourceAssociationsOutput struct {

	// Information about the associations.
	//
	// This member is required.
	Items []types.ServiceNetworkResourceAssociationSummary

	// If there are additional results, a pagination token for the next page of
	// results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListServiceNetworkResourceAssociationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListServiceNetworkResourceAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListServiceNetworkResourceAssociations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListServiceNetworkResourceAssociations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListServiceNetworkResourceAssociations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListServiceNetworkResourceAssociationsPaginatorOptions is the paginator options
// for ListServiceNetworkResourceAssociations
type ListServiceNetworkResourceAssociationsPaginatorOptions struct {
	// The maximum page size.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListServiceNetworkResourceAssociationsPaginator is a paginator for
// ListServiceNetworkResourceAssociations
type ListServiceNetworkResourceAssociationsPaginator struct {
	options   ListServiceNetworkResourceAssociationsPaginatorOptions
	client    ListServiceNetworkResourceAssociationsAPIClient
	params    *ListServiceNetworkResourceAssociationsInput
	nextToken *string
	firstPage bool
}

// NewListServiceNetworkResourceAssociationsPaginator returns a new
// ListServiceNetworkResourceAssociationsPaginator
func NewListServiceNetworkResourceAssociationsPaginator(client ListServiceNetworkResourceAssociationsAPIClient, params *ListServiceNetworkResourceAssociationsInput, optFns ...func(*ListServiceNetworkResourceAssociationsPaginatorOptions)) *ListServiceNetworkResourceAssociationsPaginator {
	if params == nil {
		params = &ListServiceNetworkResourceAssociationsInput{}
	}

	options := ListServiceNetworkResourceAssociationsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListServiceNetworkResourceAssociationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListServiceNetworkResourceAssociationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListServiceNetworkResourceAssociations page.
func (p *ListServiceNetworkResourceAssociationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListServiceNetworkResourceAssociationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListServiceNetworkResourceAssociations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListServiceNetworkResourceAssociationsAPIClient is a client that implements the
// ListServiceNetworkResourceAssociations operation.
type ListServiceNetworkResourceAssociationsAPIClient interface {
	ListServiceNetworkResourceAssociations(context.Context, *ListServiceNetworkResourceAssociationsInput, ...func(*Options)) (*ListServiceNetworkResourceAssociationsOutput, error)
}

var _ ListServiceNetworkResourceAssociationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListServiceNetworkResourceAssociations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListServiceNetworkResourceAssociations",
	}
}
