// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the service network and VPC association. If you add a security group to
// the service network and VPC association, the association must continue to have
// at least one security group. You can add or edit security groups at any time.
// However, to remove all security groups, you must first delete the association
// and then recreate it without security groups.
func (c *Client) UpdateServiceNetworkVpcAssociation(ctx context.Context, params *UpdateServiceNetworkVpcAssociationInput, optFns ...func(*Options)) (*UpdateServiceNetworkVpcAssociationOutput, error) {
	if params == nil {
		params = &UpdateServiceNetworkVpcAssociationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateServiceNetworkVpcAssociation", params, optFns, c.addOperationUpdateServiceNetworkVpcAssociationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateServiceNetworkVpcAssociationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateServiceNetworkVpcAssociationInput struct {

	// The IDs of the security groups.
	//
	// This member is required.
	SecurityGroupIds []string

	// The ID or ARN of the association.
	//
	// This member is required.
	ServiceNetworkVpcAssociationIdentifier *string

	noSmithyDocumentSerde
}

type UpdateServiceNetworkVpcAssociationOutput struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The account that created the association.
	CreatedBy *string

	// The ID of the association.
	Id *string

	// The IDs of the security groups.
	SecurityGroupIds []string

	// The status. You can retry the operation if the status is DELETE_FAILED .
	// However, if you retry it while the status is DELETE_IN_PROGRESS , there is no
	// change in the status.
	Status types.ServiceNetworkVpcAssociationStatus

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateServiceNetworkVpcAssociationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateServiceNetworkVpcAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateServiceNetworkVpcAssociation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateServiceNetworkVpcAssociation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateServiceNetworkVpcAssociationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateServiceNetworkVpcAssociation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateServiceNetworkVpcAssociation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateServiceNetworkVpcAssociation",
	}
}
