// Code generated by smithy-go-codegen DO NOT EDIT.

package wellarchitected

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/wellarchitected/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// List the answers of a review template.
func (c *Client) ListReviewTemplateAnswers(ctx context.Context, params *ListReviewTemplateAnswersInput, optFns ...func(*Options)) (*ListReviewTemplateAnswersOutput, error) {
	if params == nil {
		params = &ListReviewTemplateAnswersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListReviewTemplateAnswers", params, optFns, c.addOperationListReviewTemplateAnswersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListReviewTemplateAnswersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListReviewTemplateAnswersInput struct {

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such as
	// serverless , or the lens ARN, such as
	// arn:aws:wellarchitected:us-east-1::lens/serverless . Note that some operations
	// (such as ExportLens and CreateLensShare) are not permitted on Amazon Web
	// Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as
	// arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef
	// .
	//
	// Each lens is identified by its LensSummary$LensAlias.
	//
	// This member is required.
	LensAlias *string

	// The ARN of the review template.
	//
	// This member is required.
	TemplateArn *string

	// The maximum number of results to return for this request.
	MaxResults *int32

	// The token to use to retrieve the next set of results.
	NextToken *string

	// The ID used to identify a pillar, for example, security .
	//
	// A pillar is identified by its PillarReviewSummary$PillarId.
	PillarId *string

	noSmithyDocumentSerde
}

type ListReviewTemplateAnswersOutput struct {

	// List of answer summaries of a lens review in a review template.
	AnswerSummaries []types.ReviewTemplateAnswerSummary

	// The alias of the lens.
	//
	// For Amazon Web Services official lenses, this is either the lens alias, such as
	// serverless , or the lens ARN, such as
	// arn:aws:wellarchitected:us-east-1::lens/serverless . Note that some operations
	// (such as ExportLens and CreateLensShare) are not permitted on Amazon Web
	// Services official lenses.
	//
	// For custom lenses, this is the lens ARN, such as
	// arn:aws:wellarchitected:us-west-2:123456789012:lens/0123456789abcdef01234567890abcdef
	// .
	//
	// Each lens is identified by its LensSummary$LensAlias.
	LensAlias *string

	// The token to use to retrieve the next set of results.
	NextToken *string

	// The ARN of the review template.
	TemplateArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListReviewTemplateAnswersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListReviewTemplateAnswers{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListReviewTemplateAnswers{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListReviewTemplateAnswers"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListReviewTemplateAnswersValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListReviewTemplateAnswers(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListReviewTemplateAnswersPaginatorOptions is the paginator options for
// ListReviewTemplateAnswers
type ListReviewTemplateAnswersPaginatorOptions struct {
	// The maximum number of results to return for this request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListReviewTemplateAnswersPaginator is a paginator for ListReviewTemplateAnswers
type ListReviewTemplateAnswersPaginator struct {
	options   ListReviewTemplateAnswersPaginatorOptions
	client    ListReviewTemplateAnswersAPIClient
	params    *ListReviewTemplateAnswersInput
	nextToken *string
	firstPage bool
}

// NewListReviewTemplateAnswersPaginator returns a new
// ListReviewTemplateAnswersPaginator
func NewListReviewTemplateAnswersPaginator(client ListReviewTemplateAnswersAPIClient, params *ListReviewTemplateAnswersInput, optFns ...func(*ListReviewTemplateAnswersPaginatorOptions)) *ListReviewTemplateAnswersPaginator {
	if params == nil {
		params = &ListReviewTemplateAnswersInput{}
	}

	options := ListReviewTemplateAnswersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListReviewTemplateAnswersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListReviewTemplateAnswersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListReviewTemplateAnswers page.
func (p *ListReviewTemplateAnswersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListReviewTemplateAnswersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListReviewTemplateAnswers(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListReviewTemplateAnswersAPIClient is a client that implements the
// ListReviewTemplateAnswers operation.
type ListReviewTemplateAnswersAPIClient interface {
	ListReviewTemplateAnswers(context.Context, *ListReviewTemplateAnswersInput, ...func(*Options)) (*ListReviewTemplateAnswersOutput, error)
}

var _ ListReviewTemplateAnswersAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListReviewTemplateAnswers(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListReviewTemplateAnswers",
	}
}
