// Code generated by smithy-go-codegen DO NOT EDIT.

package xray

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

//	Initiates a trace retrieval process using the specified time range and for the
//
// give trace IDs on Transaction Search generated by the CloudWatch log group. For
// more information, see [Transaction Search].
//
// API returns a RetrievalToken , which can be used with ListRetrievedTraces or
// GetRetrievedTracesGraph to fetch results. Retrievals will time out after 60
// minutes. To execute long time ranges, consider segmenting into multiple
// retrievals.
//
// If you are using [CloudWatch cross-account observability], you can use this operation in a monitoring account to
// retrieve data from a linked source account, as long as both accounts have
// transaction search enabled.
//
// For retrieving data from X-Ray directly as opposed to the Transaction-Search
// Log group, see [BatchGetTraces].
//
// [BatchGetTraces]: https://docs.aws.amazon.com/xray/latest/api/API_BatchGetTraces.html
// [Transaction Search]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Transaction-Search.html
// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
func (c *Client) StartTraceRetrieval(ctx context.Context, params *StartTraceRetrievalInput, optFns ...func(*Options)) (*StartTraceRetrievalOutput, error) {
	if params == nil {
		params = &StartTraceRetrievalInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartTraceRetrieval", params, optFns, c.addOperationStartTraceRetrievalMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartTraceRetrievalOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartTraceRetrievalInput struct {

	//  The end of the time range to retrieve traces. The range is inclusive, so the
	// specified end time is included in the query. Specified as epoch time, the number
	// of seconds since January 1, 1970, 00:00:00 UTC.
	//
	// This member is required.
	EndTime *time.Time

	//  The start of the time range to retrieve traces. The range is inclusive, so the
	// specified start time is included in the query. Specified as epoch time, the
	// number of seconds since January 1, 1970, 00:00:00 UTC.
	//
	// This member is required.
	StartTime *time.Time

	//  Specify the trace IDs of the traces to be retrieved.
	//
	// This member is required.
	TraceIds []string

	noSmithyDocumentSerde
}

type StartTraceRetrievalOutput struct {

	//  Retrieval token.
	RetrievalToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartTraceRetrievalMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartTraceRetrieval{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartTraceRetrieval{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartTraceRetrieval"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpStartTraceRetrievalValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartTraceRetrieval(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartTraceRetrieval(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartTraceRetrieval",
	}
}
