# Copyright (c) 2021 NetApp, Inc.
# Prometheus ruby client: prometheus-client-1.0.0

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

# http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Modifed the process_id method in the MetricStore class to return a constant
# string instead of the real pid, so that when initializing a counter metric
# at registration time, only update the existing metric file, no new file created.
# This change is based on the fact that mgmt-api is the only service using
# the prometheus ruby client lib to manage those metrics.
require 'prometheus/client/data_stores/direct_file_store'

module Prometheus
  module Client
    module DataStores
      class DirectFileStore
        private
        class MetricStore
          private
          def process_id
            'daemon'
          end
        end
      end
    end
  end
end
