# - Try to find OPENSSL
# Once done, this will define
#
#  OPENSSL_FOUND - system has OPENSSL
#  OPENSSL_INCLUDE_DIRS - the OPENSSL include directories
#  OPENSSL_LIBRARIES - the OPENSSL library
find_package(PkgConfig)

pkg_check_modules(OPENSSL_PKGCONF libcrypto)

find_path(OPENSSL_INCLUDE_DIRS
  NAMES openssl/core.h
  PATHS ${OPENSSL_PKGCONF_INCLUDE_DIRS}
)


find_library(OPENSSL_LIBRARIES
  NAMES crypto ssl
  PATHS ${OPENSSL_PKGCONF_LIBRARY_DIRS}
)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(OPENSSL DEFAULT_MSG OPENSSL_INCLUDE_DIRS OPENSSL_LIBRARIES)

mark_as_advanced(OPENSSL_INCLUDE_DIRS OPENSSL_LIBRARIES)
