#!/bin/bash

# Install occurs at build time in both PGE and StorageGRID.
# Upgrade occurs only in StorageGRID during StorageGRID upgrade.
# It's unlikely to have the same kernel-modules package for StorageGRID upgrade.
# When upgrading the same kernel-modules it's most-likely a QA same-version upgrade.

# If we're in an upgrade, don't remove diversions
if [[ $1 == 'upgrade' ]]; then
  echo "Upgrade of kernel-modules detected, not removing diversions"
  exit 0
fi

# Developer NOTE:
#   If MODLIST changes, the logic below may need to change.
#   MODLIST is only available in the component build script.
#   Mostly-likely a true statement only for same-version upgrade in StorageGRID.
#   If a diversion does not exist, nothing bad happens
for mod in !!MODLIST!! ; do
  package=$(dpkg-divert --listpackage $mod)
  # If we can't get a package name then the file is not diverted
  if [[ -n $package ]]; then
    echo "Removing diversion of kernel module $(basename $mod)"
    dpkg-divert --remove --rename "$mod"
    rc=$?
    if [ $rc -ne 0 ] ; then
      echo "Warning: Error $rc while diverting $mod"
    fi
  fi
done
