// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/netapp/v1/active_directory.proto

package netapppb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The Active Directory States
type ActiveDirectory_State int32

const (
	// Unspecified Active Directory State
	ActiveDirectory_STATE_UNSPECIFIED ActiveDirectory_State = 0
	// Active Directory State is Creating
	ActiveDirectory_CREATING ActiveDirectory_State = 1
	// Active Directory State is Ready
	ActiveDirectory_READY ActiveDirectory_State = 2
	// Active Directory State is Updating
	ActiveDirectory_UPDATING ActiveDirectory_State = 3
	// Active Directory State is In use
	ActiveDirectory_IN_USE ActiveDirectory_State = 4
	// Active Directory State is Deleting
	ActiveDirectory_DELETING ActiveDirectory_State = 5
	// Active Directory State is Error
	ActiveDirectory_ERROR ActiveDirectory_State = 6
	// Active Directory State is Diagnosing.
	ActiveDirectory_DIAGNOSING ActiveDirectory_State = 7
)

// Enum value maps for ActiveDirectory_State.
var (
	ActiveDirectory_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "READY",
		3: "UPDATING",
		4: "IN_USE",
		5: "DELETING",
		6: "ERROR",
		7: "DIAGNOSING",
	}
	ActiveDirectory_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"READY":             2,
		"UPDATING":          3,
		"IN_USE":            4,
		"DELETING":          5,
		"ERROR":             6,
		"DIAGNOSING":        7,
	}
)

func (x ActiveDirectory_State) Enum() *ActiveDirectory_State {
	p := new(ActiveDirectory_State)
	*p = x
	return p
}

func (x ActiveDirectory_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ActiveDirectory_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_active_directory_proto_enumTypes[0].Descriptor()
}

func (ActiveDirectory_State) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_active_directory_proto_enumTypes[0]
}

func (x ActiveDirectory_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ActiveDirectory_State.Descriptor instead.
func (ActiveDirectory_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{6, 0}
}

// ListActiveDirectoriesRequest for requesting multiple active directories.
type ListActiveDirectoriesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value for ListActiveDirectoriesRequest
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Requested page size. Server may return fewer items than requested.
	// If unspecified, the server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Filtering results
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListActiveDirectoriesRequest) Reset() {
	*x = ListActiveDirectoriesRequest{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListActiveDirectoriesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListActiveDirectoriesRequest) ProtoMessage() {}

func (x *ListActiveDirectoriesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListActiveDirectoriesRequest.ProtoReflect.Descriptor instead.
func (*ListActiveDirectoriesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{0}
}

func (x *ListActiveDirectoriesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListActiveDirectoriesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListActiveDirectoriesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListActiveDirectoriesRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListActiveDirectoriesRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// ListActiveDirectoriesResponse contains all the active directories requested.
type ListActiveDirectoriesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of active directories.
	ActiveDirectories []*ActiveDirectory `protobuf:"bytes,1,rep,name=active_directories,json=activeDirectories,proto3" json:"active_directories,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListActiveDirectoriesResponse) Reset() {
	*x = ListActiveDirectoriesResponse{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListActiveDirectoriesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListActiveDirectoriesResponse) ProtoMessage() {}

func (x *ListActiveDirectoriesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListActiveDirectoriesResponse.ProtoReflect.Descriptor instead.
func (*ListActiveDirectoriesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{1}
}

func (x *ListActiveDirectoriesResponse) GetActiveDirectories() []*ActiveDirectory {
	if x != nil {
		return x.ActiveDirectories
	}
	return nil
}

func (x *ListActiveDirectoriesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListActiveDirectoriesResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// GetActiveDirectory for getting a single active directory.
type GetActiveDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the active directory.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetActiveDirectoryRequest) Reset() {
	*x = GetActiveDirectoryRequest{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetActiveDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetActiveDirectoryRequest) ProtoMessage() {}

func (x *GetActiveDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetActiveDirectoryRequest.ProtoReflect.Descriptor instead.
func (*GetActiveDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{2}
}

func (x *GetActiveDirectoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// CreateActiveDirectoryRequest for creating an active directory.
type CreateActiveDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Fields of the to be created active directory.
	ActiveDirectory *ActiveDirectory `protobuf:"bytes,2,opt,name=active_directory,json=activeDirectory,proto3" json:"active_directory,omitempty"`
	// Required. ID of the active directory to create. Must be unique within the
	// parent resource. Must contain only letters, numbers and hyphen, with the
	// first character a letter , the last a letter or a number, and a 63
	// character maximum.
	ActiveDirectoryId string `protobuf:"bytes,3,opt,name=active_directory_id,json=activeDirectoryId,proto3" json:"active_directory_id,omitempty"`
}

func (x *CreateActiveDirectoryRequest) Reset() {
	*x = CreateActiveDirectoryRequest{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateActiveDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateActiveDirectoryRequest) ProtoMessage() {}

func (x *CreateActiveDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateActiveDirectoryRequest.ProtoReflect.Descriptor instead.
func (*CreateActiveDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{3}
}

func (x *CreateActiveDirectoryRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateActiveDirectoryRequest) GetActiveDirectory() *ActiveDirectory {
	if x != nil {
		return x.ActiveDirectory
	}
	return nil
}

func (x *CreateActiveDirectoryRequest) GetActiveDirectoryId() string {
	if x != nil {
		return x.ActiveDirectoryId
	}
	return ""
}

// UpdateActiveDirectoryRequest for updating an active directory.
type UpdateActiveDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// Active Directory resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The volume being updated
	ActiveDirectory *ActiveDirectory `protobuf:"bytes,2,opt,name=active_directory,json=activeDirectory,proto3" json:"active_directory,omitempty"`
}

func (x *UpdateActiveDirectoryRequest) Reset() {
	*x = UpdateActiveDirectoryRequest{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateActiveDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateActiveDirectoryRequest) ProtoMessage() {}

func (x *UpdateActiveDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateActiveDirectoryRequest.ProtoReflect.Descriptor instead.
func (*UpdateActiveDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateActiveDirectoryRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateActiveDirectoryRequest) GetActiveDirectory() *ActiveDirectory {
	if x != nil {
		return x.ActiveDirectory
	}
	return nil
}

// DeleteActiveDirectoryRequest for deleting a single active directory.
type DeleteActiveDirectoryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the active directory.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteActiveDirectoryRequest) Reset() {
	*x = DeleteActiveDirectoryRequest{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteActiveDirectoryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteActiveDirectoryRequest) ProtoMessage() {}

func (x *DeleteActiveDirectoryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteActiveDirectoryRequest.ProtoReflect.Descriptor instead.
func (*DeleteActiveDirectoryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteActiveDirectoryRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ActiveDirectory is the public representation of the active directory config.
type ActiveDirectory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The resource name of the active directory.
	// Format:
	// `projects/{project_number}/locations/{location_id}/activeDirectories/{active_directory_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Create time of the active directory.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The state of the AD.
	State ActiveDirectory_State `protobuf:"varint,3,opt,name=state,proto3,enum=google.cloud.netapp.v1.ActiveDirectory_State" json:"state,omitempty"`
	// Required. Name of the Active Directory domain
	Domain string `protobuf:"bytes,4,opt,name=domain,proto3" json:"domain,omitempty"`
	// The Active Directory site the service will limit Domain Controller
	// discovery too.
	Site string `protobuf:"bytes,5,opt,name=site,proto3" json:"site,omitempty"`
	// Required. Comma separated list of DNS server IP addresses for the Active
	// Directory domain.
	Dns string `protobuf:"bytes,6,opt,name=dns,proto3" json:"dns,omitempty"`
	// Required. NetBIOSPrefix is used as a prefix for SMB server name.
	NetBiosPrefix string `protobuf:"bytes,7,opt,name=net_bios_prefix,json=netBiosPrefix,proto3" json:"net_bios_prefix,omitempty"`
	// The Organizational Unit (OU) within the Windows Active Directory the user
	// belongs to.
	OrganizationalUnit string `protobuf:"bytes,8,opt,name=organizational_unit,json=organizationalUnit,proto3" json:"organizational_unit,omitempty"`
	// If enabled, AES encryption will be enabled for SMB communication.
	AesEncryption bool `protobuf:"varint,9,opt,name=aes_encryption,json=aesEncryption,proto3" json:"aes_encryption,omitempty"`
	// Required. Username of the Active Directory domain administrator.
	Username string `protobuf:"bytes,10,opt,name=username,proto3" json:"username,omitempty"`
	// Required. Password of the Active Directory domain administrator.
	Password string `protobuf:"bytes,11,opt,name=password,proto3" json:"password,omitempty"`
	// Optional. Users to be added to the Built-in Backup Operator active
	// directory group.
	BackupOperators []string `protobuf:"bytes,12,rep,name=backup_operators,json=backupOperators,proto3" json:"backup_operators,omitempty"`
	// Optional. Users to be added to the Built-in Admininstrators group.
	Administrators []string `protobuf:"bytes,22,rep,name=administrators,proto3" json:"administrators,omitempty"`
	// Optional. Domain users to be given the SeSecurityPrivilege.
	SecurityOperators []string `protobuf:"bytes,13,rep,name=security_operators,json=securityOperators,proto3" json:"security_operators,omitempty"`
	// Name of the active directory machine. This optional parameter is used only
	// while creating kerberos volume
	KdcHostname string `protobuf:"bytes,14,opt,name=kdc_hostname,json=kdcHostname,proto3" json:"kdc_hostname,omitempty"`
	// KDC server IP address for the active directory machine.
	KdcIp string `protobuf:"bytes,15,opt,name=kdc_ip,json=kdcIp,proto3" json:"kdc_ip,omitempty"`
	// If enabled, will allow access to local users and LDAP users. If access is
	// needed for only LDAP users, it has to be disabled.
	NfsUsersWithLdap bool `protobuf:"varint,16,opt,name=nfs_users_with_ldap,json=nfsUsersWithLdap,proto3" json:"nfs_users_with_ldap,omitempty"`
	// Description of the active directory.
	Description string `protobuf:"bytes,17,opt,name=description,proto3" json:"description,omitempty"`
	// Specifies whether or not the LDAP traffic needs to be signed.
	LdapSigning bool `protobuf:"varint,18,opt,name=ldap_signing,json=ldapSigning,proto3" json:"ldap_signing,omitempty"`
	// If enabled, traffic between the SMB server to Domain Controller (DC) will
	// be encrypted.
	EncryptDcConnections bool `protobuf:"varint,19,opt,name=encrypt_dc_connections,json=encryptDcConnections,proto3" json:"encrypt_dc_connections,omitempty"`
	// Labels for the active directory.
	Labels map[string]string `protobuf:"bytes,20,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. The state details of the Active Directory.
	StateDetails string `protobuf:"bytes,21,opt,name=state_details,json=stateDetails,proto3" json:"state_details,omitempty"`
}

func (x *ActiveDirectory) Reset() {
	*x = ActiveDirectory{}
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ActiveDirectory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ActiveDirectory) ProtoMessage() {}

func (x *ActiveDirectory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_active_directory_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ActiveDirectory.ProtoReflect.Descriptor instead.
func (*ActiveDirectory) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP(), []int{6}
}

func (x *ActiveDirectory) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ActiveDirectory) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *ActiveDirectory) GetState() ActiveDirectory_State {
	if x != nil {
		return x.State
	}
	return ActiveDirectory_STATE_UNSPECIFIED
}

func (x *ActiveDirectory) GetDomain() string {
	if x != nil {
		return x.Domain
	}
	return ""
}

func (x *ActiveDirectory) GetSite() string {
	if x != nil {
		return x.Site
	}
	return ""
}

func (x *ActiveDirectory) GetDns() string {
	if x != nil {
		return x.Dns
	}
	return ""
}

func (x *ActiveDirectory) GetNetBiosPrefix() string {
	if x != nil {
		return x.NetBiosPrefix
	}
	return ""
}

func (x *ActiveDirectory) GetOrganizationalUnit() string {
	if x != nil {
		return x.OrganizationalUnit
	}
	return ""
}

func (x *ActiveDirectory) GetAesEncryption() bool {
	if x != nil {
		return x.AesEncryption
	}
	return false
}

func (x *ActiveDirectory) GetUsername() string {
	if x != nil {
		return x.Username
	}
	return ""
}

func (x *ActiveDirectory) GetPassword() string {
	if x != nil {
		return x.Password
	}
	return ""
}

func (x *ActiveDirectory) GetBackupOperators() []string {
	if x != nil {
		return x.BackupOperators
	}
	return nil
}

func (x *ActiveDirectory) GetAdministrators() []string {
	if x != nil {
		return x.Administrators
	}
	return nil
}

func (x *ActiveDirectory) GetSecurityOperators() []string {
	if x != nil {
		return x.SecurityOperators
	}
	return nil
}

func (x *ActiveDirectory) GetKdcHostname() string {
	if x != nil {
		return x.KdcHostname
	}
	return ""
}

func (x *ActiveDirectory) GetKdcIp() string {
	if x != nil {
		return x.KdcIp
	}
	return ""
}

func (x *ActiveDirectory) GetNfsUsersWithLdap() bool {
	if x != nil {
		return x.NfsUsersWithLdap
	}
	return false
}

func (x *ActiveDirectory) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *ActiveDirectory) GetLdapSigning() bool {
	if x != nil {
		return x.LdapSigning
	}
	return false
}

func (x *ActiveDirectory) GetEncryptDcConnections() bool {
	if x != nil {
		return x.EncryptDcConnections
	}
	return false
}

func (x *ActiveDirectory) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *ActiveDirectory) GetStateDetails() string {
	if x != nil {
		return x.StateDetails
	}
	return ""
}

var File_google_cloud_netapp_v1_active_directory_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_active_directory_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f,
	0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x16, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd4, 0x01, 0x0a, 0x1c, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12,
	0x25, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74,
	0x65, 0x72, 0x12, 0x19, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xc1, 0x01,
	0x0a, 0x1d, 0x4c, 0x69, 0x73, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x56, 0x0a, 0x12, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x69, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12,
	0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03,
	0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c,
	0x65, 0x22, 0x5e, 0x0a, 0x19, 0x47, 0x65, 0x74, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69,
	0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x22, 0xf3, 0x01, 0x0a, 0x1c, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x45, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x12, 0x25, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a, 0x10, 0x61, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f,
	0x72, 0x79, 0x12, 0x33, 0x0a, 0x13, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x49, 0x64, 0x22, 0xb9, 0x01, 0x0a, 0x1c, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x57, 0x0a, 0x10, 0x61, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74,
	0x6f, 0x72, 0x79, 0x22, 0x61, 0x0a, 0x1c, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x88, 0x0a, 0x0a, 0x0f, 0x41, 0x63, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x48, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12,
	0x1b, 0x0a, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x12, 0x12, 0x0a, 0x04,
	0x73, 0x69, 0x74, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x73, 0x69, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x03, 0x64, 0x6e, 0x73, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x03, 0x64, 0x6e, 0x73, 0x12, 0x2b, 0x0a, 0x0f, 0x6e, 0x65, 0x74, 0x5f, 0x62,
	0x69, 0x6f, 0x73, 0x5f, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x6e, 0x65, 0x74, 0x42, 0x69, 0x6f, 0x73, 0x50, 0x72,
	0x65, 0x66, 0x69, 0x78, 0x12, 0x2f, 0x0a, 0x13, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x08, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x12, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61,
	0x6c, 0x55, 0x6e, 0x69, 0x74, 0x12, 0x25, 0x0a, 0x0e, 0x61, 0x65, 0x73, 0x5f, 0x65, 0x6e, 0x63,
	0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0d, 0x61,
	0x65, 0x73, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x08,
	0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x12, 0x2e,
	0x0a, 0x10, 0x62, 0x61, 0x63, 0x6b, 0x75, 0x70, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f,
	0x72, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0f, 0x62,
	0x61, 0x63, 0x6b, 0x75, 0x70, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x2b,
	0x0a, 0x0e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73,
	0x18, 0x16, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x61, 0x64, 0x6d,
	0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12, 0x32, 0x0a, 0x12, 0x73,
	0x65, 0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x5f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x11, 0x73, 0x65,
	0x63, 0x75, 0x72, 0x69, 0x74, 0x79, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x6b, 0x64, 0x63, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x0e, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x6b, 0x64, 0x63, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x15, 0x0a, 0x06, 0x6b, 0x64, 0x63, 0x5f, 0x69, 0x70, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x6b, 0x64, 0x63, 0x49, 0x70, 0x12, 0x2d, 0x0a, 0x13, 0x6e, 0x66, 0x73,
	0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x5f, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x6c, 0x64, 0x61, 0x70,
	0x18, 0x10, 0x20, 0x01, 0x28, 0x08, 0x52, 0x10, 0x6e, 0x66, 0x73, 0x55, 0x73, 0x65, 0x72, 0x73,
	0x57, 0x69, 0x74, 0x68, 0x4c, 0x64, 0x61, 0x70, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63,
	0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x11, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64,
	0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x64,
	0x61, 0x70, 0x5f, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x18, 0x12, 0x20, 0x01, 0x28, 0x08,
	0x52, 0x0b, 0x6c, 0x64, 0x61, 0x70, 0x53, 0x69, 0x67, 0x6e, 0x69, 0x6e, 0x67, 0x12, 0x34, 0x0a,
	0x16, 0x65, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x5f, 0x64, 0x63, 0x5f, 0x63, 0x6f, 0x6e, 0x6e,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x13, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x44, 0x63, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x12, 0x4b, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x14, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x2e, 0x4c, 0x61, 0x62,
	0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74, 0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c,
	0x73, 0x18, 0x15, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x7a, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15,
	0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x02, 0x12, 0x0c,
	0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06,
	0x49, 0x4e, 0x5f, 0x55, 0x53, 0x45, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10,
	0x06, 0x12, 0x0e, 0x0a, 0x0a, 0x44, 0x49, 0x41, 0x47, 0x4e, 0x4f, 0x53, 0x49, 0x4e, 0x47, 0x10,
	0x07, 0x3a, 0x9d, 0x01, 0xea, 0x41, 0x99, 0x01, 0x0a, 0x25, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x12,
	0x4c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x2f, 0x7b, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x7d, 0x2a, 0x11, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73,
	0x32, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x42, 0xb6, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31,
	0x42, 0x14, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
	0x79, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0xaa, 0x02, 0x16, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x41,
	0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43,
	0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x5c, 0x56, 0x31, 0xea, 0x02,
	0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_active_directory_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_active_directory_proto_rawDescData = file_google_cloud_netapp_v1_active_directory_proto_rawDesc
)

func file_google_cloud_netapp_v1_active_directory_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_active_directory_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_active_directory_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_active_directory_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_active_directory_proto_rawDescData
}

var file_google_cloud_netapp_v1_active_directory_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_netapp_v1_active_directory_proto_msgTypes = make([]protoimpl.MessageInfo, 8)
var file_google_cloud_netapp_v1_active_directory_proto_goTypes = []any{
	(ActiveDirectory_State)(0),            // 0: google.cloud.netapp.v1.ActiveDirectory.State
	(*ListActiveDirectoriesRequest)(nil),  // 1: google.cloud.netapp.v1.ListActiveDirectoriesRequest
	(*ListActiveDirectoriesResponse)(nil), // 2: google.cloud.netapp.v1.ListActiveDirectoriesResponse
	(*GetActiveDirectoryRequest)(nil),     // 3: google.cloud.netapp.v1.GetActiveDirectoryRequest
	(*CreateActiveDirectoryRequest)(nil),  // 4: google.cloud.netapp.v1.CreateActiveDirectoryRequest
	(*UpdateActiveDirectoryRequest)(nil),  // 5: google.cloud.netapp.v1.UpdateActiveDirectoryRequest
	(*DeleteActiveDirectoryRequest)(nil),  // 6: google.cloud.netapp.v1.DeleteActiveDirectoryRequest
	(*ActiveDirectory)(nil),               // 7: google.cloud.netapp.v1.ActiveDirectory
	nil,                                   // 8: google.cloud.netapp.v1.ActiveDirectory.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),         // 9: google.protobuf.FieldMask
	(*timestamppb.Timestamp)(nil),         // 10: google.protobuf.Timestamp
}
var file_google_cloud_netapp_v1_active_directory_proto_depIdxs = []int32{
	7,  // 0: google.cloud.netapp.v1.ListActiveDirectoriesResponse.active_directories:type_name -> google.cloud.netapp.v1.ActiveDirectory
	7,  // 1: google.cloud.netapp.v1.CreateActiveDirectoryRequest.active_directory:type_name -> google.cloud.netapp.v1.ActiveDirectory
	9,  // 2: google.cloud.netapp.v1.UpdateActiveDirectoryRequest.update_mask:type_name -> google.protobuf.FieldMask
	7,  // 3: google.cloud.netapp.v1.UpdateActiveDirectoryRequest.active_directory:type_name -> google.cloud.netapp.v1.ActiveDirectory
	10, // 4: google.cloud.netapp.v1.ActiveDirectory.create_time:type_name -> google.protobuf.Timestamp
	0,  // 5: google.cloud.netapp.v1.ActiveDirectory.state:type_name -> google.cloud.netapp.v1.ActiveDirectory.State
	8,  // 6: google.cloud.netapp.v1.ActiveDirectory.labels:type_name -> google.cloud.netapp.v1.ActiveDirectory.LabelsEntry
	7,  // [7:7] is the sub-list for method output_type
	7,  // [7:7] is the sub-list for method input_type
	7,  // [7:7] is the sub-list for extension type_name
	7,  // [7:7] is the sub-list for extension extendee
	0,  // [0:7] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_active_directory_proto_init() }
func file_google_cloud_netapp_v1_active_directory_proto_init() {
	if File_google_cloud_netapp_v1_active_directory_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_active_directory_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   8,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_netapp_v1_active_directory_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_active_directory_proto_depIdxs,
		EnumInfos:         file_google_cloud_netapp_v1_active_directory_proto_enumTypes,
		MessageInfos:      file_google_cloud_netapp_v1_active_directory_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_active_directory_proto = out.File
	file_google_cloud_netapp_v1_active_directory_proto_rawDesc = nil
	file_google_cloud_netapp_v1_active_directory_proto_goTypes = nil
	file_google_cloud_netapp_v1_active_directory_proto_depIdxs = nil
}
