// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/cloud/netapp/v1/storage_pool.proto

package netapppb

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The Storage Pool States
type StoragePool_State int32

const (
	// Unspecified Storage Pool State
	StoragePool_STATE_UNSPECIFIED StoragePool_State = 0
	// Storage Pool State is Ready
	StoragePool_READY StoragePool_State = 1
	// Storage Pool State is Creating
	StoragePool_CREATING StoragePool_State = 2
	// Storage Pool State is Deleting
	StoragePool_DELETING StoragePool_State = 3
	// Storage Pool State is Updating
	StoragePool_UPDATING StoragePool_State = 4
	// Storage Pool State is Restoring
	StoragePool_RESTORING StoragePool_State = 5
	// Storage Pool State is Disabled
	StoragePool_DISABLED StoragePool_State = 6
	// Storage Pool State is Error
	StoragePool_ERROR StoragePool_State = 7
)

// Enum value maps for StoragePool_State.
var (
	StoragePool_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "READY",
		2: "CREATING",
		3: "DELETING",
		4: "UPDATING",
		5: "RESTORING",
		6: "DISABLED",
		7: "ERROR",
	}
	StoragePool_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"READY":             1,
		"CREATING":          2,
		"DELETING":          3,
		"UPDATING":          4,
		"RESTORING":         5,
		"DISABLED":          6,
		"ERROR":             7,
	}
)

func (x StoragePool_State) Enum() *StoragePool_State {
	p := new(StoragePool_State)
	*p = x
	return p
}

func (x StoragePool_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (StoragePool_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_netapp_v1_storage_pool_proto_enumTypes[0].Descriptor()
}

func (StoragePool_State) Type() protoreflect.EnumType {
	return &file_google_cloud_netapp_v1_storage_pool_proto_enumTypes[0]
}

func (x StoragePool_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use StoragePool_State.Descriptor instead.
func (StoragePool_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{7, 0}
}

// GetStoragePoolRequest gets a Storage Pool.
type GetStoragePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the storage pool
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetStoragePoolRequest) Reset() {
	*x = GetStoragePoolRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetStoragePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetStoragePoolRequest) ProtoMessage() {}

func (x *GetStoragePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetStoragePoolRequest.ProtoReflect.Descriptor instead.
func (*GetStoragePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{0}
}

func (x *GetStoragePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// ListStoragePoolsRequest lists Storage Pools.
type ListStoragePoolsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Parent value
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of items to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value to use if there are additional
	// results to retrieve for this list request.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Sort results. Supported values are "name", "name desc" or ""
	// (unsorted).
	OrderBy string `protobuf:"bytes,4,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional. List filter.
	Filter string `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListStoragePoolsRequest) Reset() {
	*x = ListStoragePoolsRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStoragePoolsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStoragePoolsRequest) ProtoMessage() {}

func (x *ListStoragePoolsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStoragePoolsRequest.ProtoReflect.Descriptor instead.
func (*ListStoragePoolsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{1}
}

func (x *ListStoragePoolsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListStoragePoolsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListStoragePoolsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListStoragePoolsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

func (x *ListStoragePoolsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// ListStoragePoolsResponse is the response to a ListStoragePoolsRequest.
type ListStoragePoolsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of StoragePools
	StoragePools []*StoragePool `protobuf:"bytes,1,rep,name=storage_pools,json=storagePools,proto3" json:"storage_pools,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListStoragePoolsResponse) Reset() {
	*x = ListStoragePoolsResponse{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListStoragePoolsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListStoragePoolsResponse) ProtoMessage() {}

func (x *ListStoragePoolsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListStoragePoolsResponse.ProtoReflect.Descriptor instead.
func (*ListStoragePoolsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{2}
}

func (x *ListStoragePoolsResponse) GetStoragePools() []*StoragePool {
	if x != nil {
		return x.StoragePools
	}
	return nil
}

func (x *ListStoragePoolsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListStoragePoolsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// CreateStoragePoolRequest creates a Storage Pool.
type CreateStoragePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Value for parent.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Id of the requesting storage pool. Must be unique within the
	// parent resource. Must contain only letters, numbers and hyphen, with the
	// first character a letter, the last a letter or a number, and a 63 character
	// maximum.
	StoragePoolId string `protobuf:"bytes,2,opt,name=storage_pool_id,json=storagePoolId,proto3" json:"storage_pool_id,omitempty"`
	// Required. The required parameters to create a new storage pool.
	StoragePool *StoragePool `protobuf:"bytes,3,opt,name=storage_pool,json=storagePool,proto3" json:"storage_pool,omitempty"`
}

func (x *CreateStoragePoolRequest) Reset() {
	*x = CreateStoragePoolRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateStoragePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateStoragePoolRequest) ProtoMessage() {}

func (x *CreateStoragePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateStoragePoolRequest.ProtoReflect.Descriptor instead.
func (*CreateStoragePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{3}
}

func (x *CreateStoragePoolRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateStoragePoolRequest) GetStoragePoolId() string {
	if x != nil {
		return x.StoragePoolId
	}
	return ""
}

func (x *CreateStoragePoolRequest) GetStoragePool() *StoragePool {
	if x != nil {
		return x.StoragePool
	}
	return nil
}

// UpdateStoragePoolRequest updates a Storage Pool.
type UpdateStoragePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Field mask is used to specify the fields to be overwritten in the
	// StoragePool resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. The pool being updated
	StoragePool *StoragePool `protobuf:"bytes,2,opt,name=storage_pool,json=storagePool,proto3" json:"storage_pool,omitempty"`
}

func (x *UpdateStoragePoolRequest) Reset() {
	*x = UpdateStoragePoolRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateStoragePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateStoragePoolRequest) ProtoMessage() {}

func (x *UpdateStoragePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateStoragePoolRequest.ProtoReflect.Descriptor instead.
func (*UpdateStoragePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateStoragePoolRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateStoragePoolRequest) GetStoragePool() *StoragePool {
	if x != nil {
		return x.StoragePool
	}
	return nil
}

// DeleteStoragePoolRequest deletes a Storage Pool.
type DeleteStoragePoolRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the storage pool
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteStoragePoolRequest) Reset() {
	*x = DeleteStoragePoolRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteStoragePoolRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteStoragePoolRequest) ProtoMessage() {}

func (x *DeleteStoragePoolRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteStoragePoolRequest.ProtoReflect.Descriptor instead.
func (*DeleteStoragePoolRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteStoragePoolRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// SwitchActiveReplicaZoneRequest switch the active/replica zone for a regional
// storagePool.
type SwitchActiveReplicaZoneRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the storage pool
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *SwitchActiveReplicaZoneRequest) Reset() {
	*x = SwitchActiveReplicaZoneRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SwitchActiveReplicaZoneRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SwitchActiveReplicaZoneRequest) ProtoMessage() {}

func (x *SwitchActiveReplicaZoneRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SwitchActiveReplicaZoneRequest.ProtoReflect.Descriptor instead.
func (*SwitchActiveReplicaZoneRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{6}
}

func (x *SwitchActiveReplicaZoneRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// StoragePool is a container for volumes with a service level and capacity.
// Volumes can be created in a pool of sufficient available capacity.
// StoragePool capacity is what you are billed for.
type StoragePool struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the storage pool
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Service level of the storage pool
	ServiceLevel ServiceLevel `protobuf:"varint,2,opt,name=service_level,json=serviceLevel,proto3,enum=google.cloud.netapp.v1.ServiceLevel" json:"service_level,omitempty"`
	// Required. Capacity in GIB of the pool
	CapacityGib int64 `protobuf:"varint,3,opt,name=capacity_gib,json=capacityGib,proto3" json:"capacity_gib,omitempty"`
	// Output only. Allocated size of all volumes in GIB in the storage pool
	VolumeCapacityGib int64 `protobuf:"varint,4,opt,name=volume_capacity_gib,json=volumeCapacityGib,proto3" json:"volume_capacity_gib,omitempty"`
	// Output only. Volume count of the storage pool
	VolumeCount int32 `protobuf:"varint,5,opt,name=volume_count,json=volumeCount,proto3" json:"volume_count,omitempty"`
	// Output only. State of the storage pool
	State StoragePool_State `protobuf:"varint,6,opt,name=state,proto3,enum=google.cloud.netapp.v1.StoragePool_State" json:"state,omitempty"`
	// Output only. State details of the storage pool
	StateDetails string `protobuf:"bytes,7,opt,name=state_details,json=stateDetails,proto3" json:"state_details,omitempty"`
	// Output only. Create time of the storage pool
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,8,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Optional. Description of the storage pool
	Description string `protobuf:"bytes,9,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. Labels as key value pairs
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Required. VPC Network name.
	// Format: projects/{project}/global/networks/{network}
	Network string `protobuf:"bytes,11,opt,name=network,proto3" json:"network,omitempty"`
	// Optional. Specifies the Active Directory to be used for creating a SMB
	// volume.
	ActiveDirectory string `protobuf:"bytes,12,opt,name=active_directory,json=activeDirectory,proto3" json:"active_directory,omitempty"`
	// Optional. Specifies the KMS config to be used for volume encryption.
	KmsConfig string `protobuf:"bytes,13,opt,name=kms_config,json=kmsConfig,proto3" json:"kms_config,omitempty"`
	// Optional. Flag indicating if the pool is NFS LDAP enabled or not.
	LdapEnabled bool `protobuf:"varint,14,opt,name=ldap_enabled,json=ldapEnabled,proto3" json:"ldap_enabled,omitempty"`
	// Optional. This field is not implemented. The values provided in this field
	// are ignored.
	PsaRange string `protobuf:"bytes,15,opt,name=psa_range,json=psaRange,proto3" json:"psa_range,omitempty"`
	// Output only. Specifies the current pool encryption key source.
	EncryptionType EncryptionType `protobuf:"varint,16,opt,name=encryption_type,json=encryptionType,proto3,enum=google.cloud.netapp.v1.EncryptionType" json:"encryption_type,omitempty"`
	// Deprecated. Used to allow SO pool to access AD or DNS server from other
	// regions.
	//
	// Deprecated: Marked as deprecated in google/cloud/netapp/v1/storage_pool.proto.
	GlobalAccessAllowed *bool `protobuf:"varint,17,opt,name=global_access_allowed,json=globalAccessAllowed,proto3,oneof" json:"global_access_allowed,omitempty"`
	// Optional. True if the storage pool supports Auto Tiering enabled volumes.
	// Default is false. Auto-tiering can be enabled after storage pool creation
	// but it can't be disabled once enabled.
	AllowAutoTiering bool `protobuf:"varint,18,opt,name=allow_auto_tiering,json=allowAutoTiering,proto3" json:"allow_auto_tiering,omitempty"`
	// Optional. Specifies the replica zone for regional storagePool.
	ReplicaZone string `protobuf:"bytes,20,opt,name=replica_zone,json=replicaZone,proto3" json:"replica_zone,omitempty"`
	// Optional. Specifies the active zone for regional storagePool.
	Zone string `protobuf:"bytes,21,opt,name=zone,proto3" json:"zone,omitempty"`
	// Output only. Reserved for future use
	SatisfiesPzs bool `protobuf:"varint,23,opt,name=satisfies_pzs,json=satisfiesPzs,proto3" json:"satisfies_pzs,omitempty"`
	// Output only. Reserved for future use
	SatisfiesPzi bool `protobuf:"varint,24,opt,name=satisfies_pzi,json=satisfiesPzi,proto3" json:"satisfies_pzi,omitempty"`
	// Optional. True if using Independent Scaling of capacity and performance
	// (Hyperdisk) By default set to false
	CustomPerformanceEnabled bool `protobuf:"varint,25,opt,name=custom_performance_enabled,json=customPerformanceEnabled,proto3" json:"custom_performance_enabled,omitempty"`
	// Optional. Custom Performance Total Throughput of the pool (in MiB/s)
	TotalThroughputMibps int64 `protobuf:"varint,26,opt,name=total_throughput_mibps,json=totalThroughputMibps,proto3" json:"total_throughput_mibps,omitempty"`
	// Optional. Custom Performance Total IOPS of the pool
	// If not provided, it will be calculated based on the total_throughput_mibps
	TotalIops int64 `protobuf:"varint,27,opt,name=total_iops,json=totalIops,proto3" json:"total_iops,omitempty"`
}

func (x *StoragePool) Reset() {
	*x = StoragePool{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *StoragePool) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StoragePool) ProtoMessage() {}

func (x *StoragePool) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StoragePool.ProtoReflect.Descriptor instead.
func (*StoragePool) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{7}
}

func (x *StoragePool) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *StoragePool) GetServiceLevel() ServiceLevel {
	if x != nil {
		return x.ServiceLevel
	}
	return ServiceLevel_SERVICE_LEVEL_UNSPECIFIED
}

func (x *StoragePool) GetCapacityGib() int64 {
	if x != nil {
		return x.CapacityGib
	}
	return 0
}

func (x *StoragePool) GetVolumeCapacityGib() int64 {
	if x != nil {
		return x.VolumeCapacityGib
	}
	return 0
}

func (x *StoragePool) GetVolumeCount() int32 {
	if x != nil {
		return x.VolumeCount
	}
	return 0
}

func (x *StoragePool) GetState() StoragePool_State {
	if x != nil {
		return x.State
	}
	return StoragePool_STATE_UNSPECIFIED
}

func (x *StoragePool) GetStateDetails() string {
	if x != nil {
		return x.StateDetails
	}
	return ""
}

func (x *StoragePool) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *StoragePool) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *StoragePool) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *StoragePool) GetNetwork() string {
	if x != nil {
		return x.Network
	}
	return ""
}

func (x *StoragePool) GetActiveDirectory() string {
	if x != nil {
		return x.ActiveDirectory
	}
	return ""
}

func (x *StoragePool) GetKmsConfig() string {
	if x != nil {
		return x.KmsConfig
	}
	return ""
}

func (x *StoragePool) GetLdapEnabled() bool {
	if x != nil {
		return x.LdapEnabled
	}
	return false
}

func (x *StoragePool) GetPsaRange() string {
	if x != nil {
		return x.PsaRange
	}
	return ""
}

func (x *StoragePool) GetEncryptionType() EncryptionType {
	if x != nil {
		return x.EncryptionType
	}
	return EncryptionType_ENCRYPTION_TYPE_UNSPECIFIED
}

// Deprecated: Marked as deprecated in google/cloud/netapp/v1/storage_pool.proto.
func (x *StoragePool) GetGlobalAccessAllowed() bool {
	if x != nil && x.GlobalAccessAllowed != nil {
		return *x.GlobalAccessAllowed
	}
	return false
}

func (x *StoragePool) GetAllowAutoTiering() bool {
	if x != nil {
		return x.AllowAutoTiering
	}
	return false
}

func (x *StoragePool) GetReplicaZone() string {
	if x != nil {
		return x.ReplicaZone
	}
	return ""
}

func (x *StoragePool) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

func (x *StoragePool) GetSatisfiesPzs() bool {
	if x != nil {
		return x.SatisfiesPzs
	}
	return false
}

func (x *StoragePool) GetSatisfiesPzi() bool {
	if x != nil {
		return x.SatisfiesPzi
	}
	return false
}

func (x *StoragePool) GetCustomPerformanceEnabled() bool {
	if x != nil {
		return x.CustomPerformanceEnabled
	}
	return false
}

func (x *StoragePool) GetTotalThroughputMibps() int64 {
	if x != nil {
		return x.TotalThroughputMibps
	}
	return 0
}

func (x *StoragePool) GetTotalIops() int64 {
	if x != nil {
		return x.TotalIops
	}
	return 0
}

// ValidateDirectoryServiceRequest validates the directory service policy
// attached to the storage pool.
type ValidateDirectoryServiceRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the storage pool
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Type of directory service policy attached to the storage pool.
	DirectoryServiceType DirectoryServiceType `protobuf:"varint,2,opt,name=directory_service_type,json=directoryServiceType,proto3,enum=google.cloud.netapp.v1.DirectoryServiceType" json:"directory_service_type,omitempty"`
}

func (x *ValidateDirectoryServiceRequest) Reset() {
	*x = ValidateDirectoryServiceRequest{}
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ValidateDirectoryServiceRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ValidateDirectoryServiceRequest) ProtoMessage() {}

func (x *ValidateDirectoryServiceRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ValidateDirectoryServiceRequest.ProtoReflect.Descriptor instead.
func (*ValidateDirectoryServiceRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP(), []int{8}
}

func (x *ValidateDirectoryServiceRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ValidateDirectoryServiceRequest) GetDirectoryServiceType() DirectoryServiceType {
	if x != nil {
		return x.DirectoryServiceType
	}
	return DirectoryServiceType_DIRECTORY_SERVICE_TYPE_UNSPECIFIED
}

var File_google_cloud_netapp_v1_storage_pool_proto protoreflect.FileDescriptor

var file_google_cloud_netapp_v1_storage_pool_proto_rawDesc = []byte{
	0x0a, 0x29, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x16, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70,
	0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e, 0x65,
	0x74, 0x61, 0x70, 0x70, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x56, 0x0a, 0x15, 0x47, 0x65, 0x74, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22,
	0xdf, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x41, 0x0a, 0x06, 0x70,
	0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x23, 0x12, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64,
	0x65, 0x72, 0x42, 0x79, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65,
	0x72, 0x22, 0xae, 0x01, 0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67,
	0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48,
	0x0a, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x0c, 0x73, 0x74, 0x6f, 0x72,
	0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74,
	0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18,
	0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62,
	0x6c, 0x65, 0x22, 0xd7, 0x01, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x41, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x12, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x12, 0x2b, 0x0a, 0x0f, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f,
	0x6f, 0x6c, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0d, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x49, 0x64, 0x12,
	0x4b, 0x0a, 0x0c, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0xa9, 0x01, 0x0a,
	0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f,
	0x6f, 0x6c, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4b, 0x0a, 0x0c, 0x73,
	0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x22, 0x59, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0x5f, 0x0a, 0x1e, 0x53, 0x77, 0x69, 0x74, 0x63, 0x68, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x65, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5a, 0x6f, 0x6e, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa9, 0x0d, 0x0a, 0x0b, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65,
	0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x4e, 0x0a,
	0x0d, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x65, 0x76, 0x65, 0x6c, 0x12, 0x26, 0x0a,
	0x0c, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69,
	0x74, 0x79, 0x47, 0x69, 0x62, 0x12, 0x33, 0x0a, 0x13, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x5f,
	0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x5f, 0x67, 0x69, 0x62, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x11, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43,
	0x61, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x47, 0x69, 0x62, 0x12, 0x26, 0x0a, 0x0c, 0x76, 0x6f,
	0x6c, 0x75, 0x6d, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0b, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x12, 0x44, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x74, 0x61, 0x74,
	0x65, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x74, 0x61, 0x74, 0x65, 0x44, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b,
	0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4c, 0x0a, 0x06, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70,
	0x70, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x40, 0x0a, 0x07, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x20, 0x0a, 0x1e, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x52, 0x07, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x12, 0x58, 0x0a, 0x10, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x18,
	0x0c, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x6e,
	0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x6f, 0x72, 0x79, 0x52, 0x0f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x12, 0x46, 0x0a, 0x0a, 0x6b, 0x6d, 0x73, 0x5f, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x42, 0x27, 0xe0, 0x41, 0x01, 0xfa, 0x41,
	0x21, 0x0a, 0x1f, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x52, 0x09, 0x6b, 0x6d, 0x73, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x26, 0x0a,
	0x0c, 0x6c, 0x64, 0x61, 0x70, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18, 0x0e, 0x20,
	0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x6c, 0x64, 0x61, 0x70, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x73, 0x61, 0x5f, 0x72, 0x61, 0x6e,
	0x67, 0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70,
	0x73, 0x61, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x12, 0x54, 0x0a, 0x0f, 0x65, 0x6e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0e, 0x65,
	0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x3b, 0x0a,
	0x15, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x61,
	0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x18, 0x11, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01,
	0x48, 0x00, 0x52, 0x13, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x41, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x61, 0x6c,
	0x6c, 0x6f, 0x77, 0x5f, 0x61, 0x75, 0x74, 0x6f, 0x5f, 0x74, 0x69, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x18, 0x12, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x10, 0x61, 0x6c, 0x6c,
	0x6f, 0x77, 0x41, 0x75, 0x74, 0x6f, 0x54, 0x69, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x12, 0x26, 0x0a,
	0x0c, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x14, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63,
	0x61, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x15, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x28,
	0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x73, 0x18,
	0x17, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x50, 0x7a, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x73, 0x61, 0x74, 0x69,
	0x73, 0x66, 0x69, 0x65, 0x73, 0x5f, 0x70, 0x7a, 0x69, 0x18, 0x18, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x69, 0x65, 0x73, 0x50,
	0x7a, 0x69, 0x12, 0x41, 0x0a, 0x1a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x65, 0x72,
	0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64,
	0x18, 0x19, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x18, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e,
	0x61, 0x62, 0x6c, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x16, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x74,
	0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x5f, 0x6d, 0x69, 0x62, 0x70, 0x73, 0x18,
	0x1a, 0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x74, 0x6f, 0x74, 0x61,
	0x6c, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x70, 0x75, 0x74, 0x4d, 0x69, 0x62, 0x70, 0x73,
	0x12, 0x22, 0x0a, 0x0a, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x5f, 0x69, 0x6f, 0x70, 0x73, 0x18, 0x1b,
	0x20, 0x01, 0x28, 0x03, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x6f, 0x74, 0x61, 0x6c,
	0x49, 0x6f, 0x70, 0x73, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22,
	0x7b, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x09, 0x0a, 0x05, 0x52, 0x45, 0x41, 0x44, 0x59, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x52,
	0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49,
	0x4e, 0x47, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x52, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x49, 0x4e,
	0x47, 0x10, 0x05, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x49, 0x53, 0x41, 0x42, 0x4c, 0x45, 0x44, 0x10,
	0x06, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x07, 0x3a, 0x87, 0x01, 0xea,
	0x41, 0x83, 0x01, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x12, 0x43, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x73, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x7b, 0x73, 0x74,
	0x6f, 0x72, 0x61, 0x67, 0x65, 0x5f, 0x70, 0x6f, 0x6f, 0x6c, 0x7d, 0x2a, 0x0c, 0x73, 0x74, 0x6f,
	0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x73, 0x32, 0x0b, 0x73, 0x74, 0x6f, 0x72, 0x61,
	0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x67, 0x6c, 0x6f, 0x62, 0x61,
	0x6c, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
	0x22, 0xc4, 0x01, 0x0a, 0x1f, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3d, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x6e, 0x65, 0x74, 0x61,
	0x70, 0x70, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50, 0x6f, 0x6f, 0x6c, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x62, 0x0a, 0x16, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x69, 0x72,
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x14, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x42, 0xb2, 0x01, 0x0a, 0x1a, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x2e, 0x76, 0x31, 0x42, 0x10, 0x53, 0x74, 0x6f, 0x72, 0x61, 0x67, 0x65, 0x50,
	0x6f, 0x6f, 0x6c, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x32, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f,
	0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74,
	0x61, 0x70, 0x70, 0x70, 0x62, 0x3b, 0x6e, 0x65, 0x74, 0x61, 0x70, 0x70, 0x70, 0x62, 0xaa, 0x02,
	0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65,
	0x74, 0x41, 0x70, 0x70, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x16, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x5c, 0x56, 0x31,
	0xea, 0x02, 0x19, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x41, 0x70, 0x70, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_netapp_v1_storage_pool_proto_rawDescOnce sync.Once
	file_google_cloud_netapp_v1_storage_pool_proto_rawDescData = file_google_cloud_netapp_v1_storage_pool_proto_rawDesc
)

func file_google_cloud_netapp_v1_storage_pool_proto_rawDescGZIP() []byte {
	file_google_cloud_netapp_v1_storage_pool_proto_rawDescOnce.Do(func() {
		file_google_cloud_netapp_v1_storage_pool_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_netapp_v1_storage_pool_proto_rawDescData)
	})
	return file_google_cloud_netapp_v1_storage_pool_proto_rawDescData
}

var file_google_cloud_netapp_v1_storage_pool_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_netapp_v1_storage_pool_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_netapp_v1_storage_pool_proto_goTypes = []any{
	(StoragePool_State)(0),                  // 0: google.cloud.netapp.v1.StoragePool.State
	(*GetStoragePoolRequest)(nil),           // 1: google.cloud.netapp.v1.GetStoragePoolRequest
	(*ListStoragePoolsRequest)(nil),         // 2: google.cloud.netapp.v1.ListStoragePoolsRequest
	(*ListStoragePoolsResponse)(nil),        // 3: google.cloud.netapp.v1.ListStoragePoolsResponse
	(*CreateStoragePoolRequest)(nil),        // 4: google.cloud.netapp.v1.CreateStoragePoolRequest
	(*UpdateStoragePoolRequest)(nil),        // 5: google.cloud.netapp.v1.UpdateStoragePoolRequest
	(*DeleteStoragePoolRequest)(nil),        // 6: google.cloud.netapp.v1.DeleteStoragePoolRequest
	(*SwitchActiveReplicaZoneRequest)(nil),  // 7: google.cloud.netapp.v1.SwitchActiveReplicaZoneRequest
	(*StoragePool)(nil),                     // 8: google.cloud.netapp.v1.StoragePool
	(*ValidateDirectoryServiceRequest)(nil), // 9: google.cloud.netapp.v1.ValidateDirectoryServiceRequest
	nil,                                     // 10: google.cloud.netapp.v1.StoragePool.LabelsEntry
	(*fieldmaskpb.FieldMask)(nil),           // 11: google.protobuf.FieldMask
	(ServiceLevel)(0),                       // 12: google.cloud.netapp.v1.ServiceLevel
	(*timestamppb.Timestamp)(nil),           // 13: google.protobuf.Timestamp
	(EncryptionType)(0),                     // 14: google.cloud.netapp.v1.EncryptionType
	(DirectoryServiceType)(0),               // 15: google.cloud.netapp.v1.DirectoryServiceType
}
var file_google_cloud_netapp_v1_storage_pool_proto_depIdxs = []int32{
	8,  // 0: google.cloud.netapp.v1.ListStoragePoolsResponse.storage_pools:type_name -> google.cloud.netapp.v1.StoragePool
	8,  // 1: google.cloud.netapp.v1.CreateStoragePoolRequest.storage_pool:type_name -> google.cloud.netapp.v1.StoragePool
	11, // 2: google.cloud.netapp.v1.UpdateStoragePoolRequest.update_mask:type_name -> google.protobuf.FieldMask
	8,  // 3: google.cloud.netapp.v1.UpdateStoragePoolRequest.storage_pool:type_name -> google.cloud.netapp.v1.StoragePool
	12, // 4: google.cloud.netapp.v1.StoragePool.service_level:type_name -> google.cloud.netapp.v1.ServiceLevel
	0,  // 5: google.cloud.netapp.v1.StoragePool.state:type_name -> google.cloud.netapp.v1.StoragePool.State
	13, // 6: google.cloud.netapp.v1.StoragePool.create_time:type_name -> google.protobuf.Timestamp
	10, // 7: google.cloud.netapp.v1.StoragePool.labels:type_name -> google.cloud.netapp.v1.StoragePool.LabelsEntry
	14, // 8: google.cloud.netapp.v1.StoragePool.encryption_type:type_name -> google.cloud.netapp.v1.EncryptionType
	15, // 9: google.cloud.netapp.v1.ValidateDirectoryServiceRequest.directory_service_type:type_name -> google.cloud.netapp.v1.DirectoryServiceType
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_netapp_v1_storage_pool_proto_init() }
func file_google_cloud_netapp_v1_storage_pool_proto_init() {
	if File_google_cloud_netapp_v1_storage_pool_proto != nil {
		return
	}
	file_google_cloud_netapp_v1_common_proto_init()
	file_google_cloud_netapp_v1_storage_pool_proto_msgTypes[7].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_netapp_v1_storage_pool_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_netapp_v1_storage_pool_proto_goTypes,
		DependencyIndexes: file_google_cloud_netapp_v1_storage_pool_proto_depIdxs,
		EnumInfos:         file_google_cloud_netapp_v1_storage_pool_proto_enumTypes,
		MessageInfos:      file_google_cloud_netapp_v1_storage_pool_proto_msgTypes,
	}.Build()
	File_google_cloud_netapp_v1_storage_pool_proto = out.File
	file_google_cloud_netapp_v1_storage_pool_proto_rawDesc = nil
	file_google_cloud_netapp_v1_storage_pool_proto_goTypes = nil
	file_google_cloud_netapp_v1_storage_pool_proto_depIdxs = nil
}
