//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcontainerservice

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"reflect"
)

// MarshalJSON implements the json.Marshaller interface for type AbsoluteMonthlySchedule.
func (a AbsoluteMonthlySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfMonth", a.DayOfMonth)
	populate(objectMap, "intervalMonths", a.IntervalMonths)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AbsoluteMonthlySchedule.
func (a *AbsoluteMonthlySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfMonth":
			err = unpopulate(val, "DayOfMonth", &a.DayOfMonth)
			delete(rawMsg, key)
		case "intervalMonths":
			err = unpopulate(val, "IntervalMonths", &a.IntervalMonths)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AccessProfile.
func (a AccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateByteArray(objectMap, "kubeConfig", a.KubeConfig, func() any {
		return runtime.EncodeByteArray(a.KubeConfig, runtime.Base64StdFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AccessProfile.
func (a *AccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubeConfig":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &a.KubeConfig, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPool.
func (a AgentPool) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPool.
func (a *AgentPool) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersions.
func (a AgentPoolAvailableVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolAvailableVersions.
func (a *AgentPoolAvailableVersions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersionsProperties.
func (a AgentPoolAvailableVersionsProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolVersions", a.AgentPoolVersions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolAvailableVersionsProperties.
func (a *AgentPoolAvailableVersionsProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolVersions":
			err = unpopulate(val, "AgentPoolVersions", &a.AgentPoolVersions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.
func (a AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "default", a.Default)
	populate(objectMap, "isPreview", a.IsPreview)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.
func (a *AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "default":
			err = unpopulate(val, "Default", &a.Default)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &a.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolListResult.
func (a AgentPoolListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", a.NextLink)
	populate(objectMap, "value", a.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolListResult.
func (a *AgentPoolListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &a.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &a.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolNetworkProfile.
func (a AgentPoolNetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedHostPorts", a.AllowedHostPorts)
	populate(objectMap, "applicationSecurityGroups", a.ApplicationSecurityGroups)
	populate(objectMap, "nodePublicIPTags", a.NodePublicIPTags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolNetworkProfile.
func (a *AgentPoolNetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedHostPorts":
			err = unpopulate(val, "AllowedHostPorts", &a.AllowedHostPorts)
			delete(rawMsg, key)
		case "applicationSecurityGroups":
			err = unpopulate(val, "ApplicationSecurityGroups", &a.ApplicationSecurityGroups)
			delete(rawMsg, key)
		case "nodePublicIPTags":
			err = unpopulate(val, "NodePublicIPTags", &a.NodePublicIPTags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfile.
func (a AgentPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", a.ID)
	populate(objectMap, "name", a.Name)
	populate(objectMap, "properties", a.Properties)
	populate(objectMap, "type", a.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeProfile.
func (a *AgentPoolUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &a.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &a.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &a.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &a.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfileProperties.
func (a AgentPoolUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	populate(objectMap, "latestNodeImageVersion", a.LatestNodeImageVersion)
	populate(objectMap, "osType", a.OSType)
	populate(objectMap, "upgrades", a.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeProfileProperties.
func (a *AgentPoolUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		case "latestNodeImageVersion":
			err = unpopulate(val, "LatestNodeImageVersion", &a.LatestNodeImageVersion)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &a.OSType)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &a.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeProfilePropertiesUpgradesItem.
func (a AgentPoolUpgradeProfilePropertiesUpgradesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPreview", a.IsPreview)
	populate(objectMap, "kubernetesVersion", a.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeProfilePropertiesUpgradesItem.
func (a *AgentPoolUpgradeProfilePropertiesUpgradesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &a.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &a.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AgentPoolUpgradeSettings.
func (a AgentPoolUpgradeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "drainTimeoutInMinutes", a.DrainTimeoutInMinutes)
	populate(objectMap, "maxSurge", a.MaxSurge)
	populate(objectMap, "nodeSoakDurationInMinutes", a.NodeSoakDurationInMinutes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AgentPoolUpgradeSettings.
func (a *AgentPoolUpgradeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "drainTimeoutInMinutes":
			err = unpopulate(val, "DrainTimeoutInMinutes", &a.DrainTimeoutInMinutes)
			delete(rawMsg, key)
		case "maxSurge":
			err = unpopulate(val, "MaxSurge", &a.MaxSurge)
			delete(rawMsg, key)
		case "nodeSoakDurationInMinutes":
			err = unpopulate(val, "NodeSoakDurationInMinutes", &a.NodeSoakDurationInMinutes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AzureKeyVaultKms.
func (a AzureKeyVaultKms) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", a.Enabled)
	populate(objectMap, "keyId", a.KeyID)
	populate(objectMap, "keyVaultNetworkAccess", a.KeyVaultNetworkAccess)
	populate(objectMap, "keyVaultResourceId", a.KeyVaultResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AzureKeyVaultKms.
func (a *AzureKeyVaultKms) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &a.Enabled)
			delete(rawMsg, key)
		case "keyId":
			err = unpopulate(val, "KeyID", &a.KeyID)
			delete(rawMsg, key)
		case "keyVaultNetworkAccess":
			err = unpopulate(val, "KeyVaultNetworkAccess", &a.KeyVaultNetworkAccess)
			delete(rawMsg, key)
		case "keyVaultResourceId":
			err = unpopulate(val, "KeyVaultResourceID", &a.KeyVaultResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ClusterUpgradeSettings.
func (c ClusterUpgradeSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "overrideSettings", c.OverrideSettings)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ClusterUpgradeSettings.
func (c *ClusterUpgradeSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "overrideSettings":
			err = unpopulate(val, "OverrideSettings", &c.OverrideSettings)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CommandResultProperties.
func (c CommandResultProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "exitCode", c.ExitCode)
	populateDateTimeRFC3339(objectMap, "finishedAt", c.FinishedAt)
	populate(objectMap, "logs", c.Logs)
	populate(objectMap, "provisioningState", c.ProvisioningState)
	populate(objectMap, "reason", c.Reason)
	populateDateTimeRFC3339(objectMap, "startedAt", c.StartedAt)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CommandResultProperties.
func (c *CommandResultProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "exitCode":
			err = unpopulate(val, "ExitCode", &c.ExitCode)
			delete(rawMsg, key)
		case "finishedAt":
			err = unpopulateDateTimeRFC3339(val, "FinishedAt", &c.FinishedAt)
			delete(rawMsg, key)
		case "logs":
			err = unpopulate(val, "Logs", &c.Logs)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &c.ProvisioningState)
			delete(rawMsg, key)
		case "reason":
			err = unpopulate(val, "Reason", &c.Reason)
			delete(rawMsg, key)
		case "startedAt":
			err = unpopulateDateTimeRFC3339(val, "StartedAt", &c.StartedAt)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CompatibleVersions.
func (c CompatibleVersions) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populate(objectMap, "versions", c.Versions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CompatibleVersions.
func (c *CompatibleVersions) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "versions":
			err = unpopulate(val, "Versions", &c.Versions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CreationData.
func (c CreationData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "sourceResourceId", c.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CreationData.
func (c *CreationData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &c.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResult.
func (c CredentialResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", c.Name)
	populateByteArray(objectMap, "value", c.Value, func() any {
		return runtime.EncodeByteArray(c.Value, runtime.Base64StdFormat)
	})
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialResult.
func (c *CredentialResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &c.Name)
			delete(rawMsg, key)
		case "value":
			if val != nil && string(val) != "null" {
				err = runtime.DecodeByteArray(string(val), &c.Value, runtime.Base64StdFormat)
			}
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CredentialResults.
func (c CredentialResults) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubeconfigs", c.Kubeconfigs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CredentialResults.
func (c *CredentialResults) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubeconfigs":
			err = unpopulate(val, "Kubeconfigs", &c.Kubeconfigs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DailySchedule.
func (d DailySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "intervalDays", d.IntervalDays)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DailySchedule.
func (d *DailySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "intervalDays":
			err = unpopulate(val, "IntervalDays", &d.IntervalDays)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DateSpan.
func (d DateSpan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateType(objectMap, "end", d.End)
	populateDateType(objectMap, "start", d.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DateSpan.
func (d *DateSpan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulateDateType(val, "End", &d.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulateDateType(val, "Start", &d.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type DelegatedResource.
func (d DelegatedResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "location", d.Location)
	populate(objectMap, "referralResource", d.ReferralResource)
	populate(objectMap, "resourceId", d.ResourceID)
	populate(objectMap, "tenantId", d.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DelegatedResource.
func (d *DelegatedResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "location":
			err = unpopulate(val, "Location", &d.Location)
			delete(rawMsg, key)
		case "referralResource":
			err = unpopulate(val, "ReferralResource", &d.ReferralResource)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &d.ResourceID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &d.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDependency.
func (e EndpointDependency) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "domainName", e.DomainName)
	populate(objectMap, "endpointDetails", e.EndpointDetails)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDependency.
func (e *EndpointDependency) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "domainName":
			err = unpopulate(val, "DomainName", &e.DomainName)
			delete(rawMsg, key)
		case "endpointDetails":
			err = unpopulate(val, "EndpointDetails", &e.EndpointDetails)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type EndpointDetail.
func (e EndpointDetail) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", e.Description)
	populate(objectMap, "ipAddress", e.IPAddress)
	populate(objectMap, "port", e.Port)
	populate(objectMap, "protocol", e.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type EndpointDetail.
func (e *EndpointDetail) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &e.Description)
			delete(rawMsg, key)
		case "ipAddress":
			err = unpopulate(val, "IPAddress", &e.IPAddress)
			delete(rawMsg, key)
		case "port":
			err = unpopulate(val, "Port", &e.Port)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &e.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ExtendedLocation.
func (e ExtendedLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", e.Name)
	populate(objectMap, "type", e.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ExtendedLocation.
func (e *ExtendedLocation) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", e, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &e.Name)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &e.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", e, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IPTag.
func (i IPTag) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "ipTagType", i.IPTagType)
	populate(objectMap, "tag", i.Tag)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IPTag.
func (i *IPTag) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "ipTagType":
			err = unpopulate(val, "IPTagType", &i.IPTagType)
			delete(rawMsg, key)
		case "tag":
			err = unpopulate(val, "Tag", &i.Tag)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IstioCertificateAuthority.
func (i IstioCertificateAuthority) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "plugin", i.Plugin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IstioCertificateAuthority.
func (i *IstioCertificateAuthority) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "plugin":
			err = unpopulate(val, "Plugin", &i.Plugin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IstioComponents.
func (i IstioComponents) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "egressGateways", i.EgressGateways)
	populate(objectMap, "ingressGateways", i.IngressGateways)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IstioComponents.
func (i *IstioComponents) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "egressGateways":
			err = unpopulate(val, "EgressGateways", &i.EgressGateways)
			delete(rawMsg, key)
		case "ingressGateways":
			err = unpopulate(val, "IngressGateways", &i.IngressGateways)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IstioEgressGateway.
func (i IstioEgressGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", i.Enabled)
	populate(objectMap, "nodeSelector", i.NodeSelector)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IstioEgressGateway.
func (i *IstioEgressGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &i.Enabled)
			delete(rawMsg, key)
		case "nodeSelector":
			err = unpopulate(val, "NodeSelector", &i.NodeSelector)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IstioIngressGateway.
func (i IstioIngressGateway) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", i.Enabled)
	populate(objectMap, "mode", i.Mode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IstioIngressGateway.
func (i *IstioIngressGateway) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &i.Enabled)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &i.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IstioPluginCertificateAuthority.
func (i IstioPluginCertificateAuthority) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certChainObjectName", i.CertChainObjectName)
	populate(objectMap, "certObjectName", i.CertObjectName)
	populate(objectMap, "keyObjectName", i.KeyObjectName)
	populate(objectMap, "keyVaultId", i.KeyVaultID)
	populate(objectMap, "rootCertObjectName", i.RootCertObjectName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IstioPluginCertificateAuthority.
func (i *IstioPluginCertificateAuthority) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certChainObjectName":
			err = unpopulate(val, "CertChainObjectName", &i.CertChainObjectName)
			delete(rawMsg, key)
		case "certObjectName":
			err = unpopulate(val, "CertObjectName", &i.CertObjectName)
			delete(rawMsg, key)
		case "keyObjectName":
			err = unpopulate(val, "KeyObjectName", &i.KeyObjectName)
			delete(rawMsg, key)
		case "keyVaultId":
			err = unpopulate(val, "KeyVaultID", &i.KeyVaultID)
			delete(rawMsg, key)
		case "rootCertObjectName":
			err = unpopulate(val, "RootCertObjectName", &i.RootCertObjectName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type IstioServiceMesh.
func (i IstioServiceMesh) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "certificateAuthority", i.CertificateAuthority)
	populate(objectMap, "components", i.Components)
	populate(objectMap, "revisions", i.Revisions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type IstioServiceMesh.
func (i *IstioServiceMesh) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", i, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "certificateAuthority":
			err = unpopulate(val, "CertificateAuthority", &i.CertificateAuthority)
			delete(rawMsg, key)
		case "components":
			err = unpopulate(val, "Components", &i.Components)
			delete(rawMsg, key)
		case "revisions":
			err = unpopulate(val, "Revisions", &i.Revisions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", i, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubeletConfig.
func (k KubeletConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowedUnsafeSysctls", k.AllowedUnsafeSysctls)
	populate(objectMap, "cpuCfsQuota", k.CPUCfsQuota)
	populate(objectMap, "cpuCfsQuotaPeriod", k.CPUCfsQuotaPeriod)
	populate(objectMap, "cpuManagerPolicy", k.CPUManagerPolicy)
	populate(objectMap, "containerLogMaxFiles", k.ContainerLogMaxFiles)
	populate(objectMap, "containerLogMaxSizeMB", k.ContainerLogMaxSizeMB)
	populate(objectMap, "failSwapOn", k.FailSwapOn)
	populate(objectMap, "imageGcHighThreshold", k.ImageGcHighThreshold)
	populate(objectMap, "imageGcLowThreshold", k.ImageGcLowThreshold)
	populate(objectMap, "podMaxPids", k.PodMaxPids)
	populate(objectMap, "topologyManagerPolicy", k.TopologyManagerPolicy)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubeletConfig.
func (k *KubeletConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowedUnsafeSysctls":
			err = unpopulate(val, "AllowedUnsafeSysctls", &k.AllowedUnsafeSysctls)
			delete(rawMsg, key)
		case "cpuCfsQuota":
			err = unpopulate(val, "CPUCfsQuota", &k.CPUCfsQuota)
			delete(rawMsg, key)
		case "cpuCfsQuotaPeriod":
			err = unpopulate(val, "CPUCfsQuotaPeriod", &k.CPUCfsQuotaPeriod)
			delete(rawMsg, key)
		case "cpuManagerPolicy":
			err = unpopulate(val, "CPUManagerPolicy", &k.CPUManagerPolicy)
			delete(rawMsg, key)
		case "containerLogMaxFiles":
			err = unpopulate(val, "ContainerLogMaxFiles", &k.ContainerLogMaxFiles)
			delete(rawMsg, key)
		case "containerLogMaxSizeMB":
			err = unpopulate(val, "ContainerLogMaxSizeMB", &k.ContainerLogMaxSizeMB)
			delete(rawMsg, key)
		case "failSwapOn":
			err = unpopulate(val, "FailSwapOn", &k.FailSwapOn)
			delete(rawMsg, key)
		case "imageGcHighThreshold":
			err = unpopulate(val, "ImageGcHighThreshold", &k.ImageGcHighThreshold)
			delete(rawMsg, key)
		case "imageGcLowThreshold":
			err = unpopulate(val, "ImageGcLowThreshold", &k.ImageGcLowThreshold)
			delete(rawMsg, key)
		case "podMaxPids":
			err = unpopulate(val, "PodMaxPids", &k.PodMaxPids)
			delete(rawMsg, key)
		case "topologyManagerPolicy":
			err = unpopulate(val, "TopologyManagerPolicy", &k.TopologyManagerPolicy)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesPatchVersion.
func (k KubernetesPatchVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "upgrades", k.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesPatchVersion.
func (k *KubernetesPatchVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "upgrades":
			err = unpopulate(val, "Upgrades", &k.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersion.
func (k KubernetesVersion) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "capabilities", k.Capabilities)
	populate(objectMap, "isPreview", k.IsPreview)
	populate(objectMap, "patchVersions", k.PatchVersions)
	populate(objectMap, "version", k.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersion.
func (k *KubernetesVersion) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "capabilities":
			err = unpopulate(val, "Capabilities", &k.Capabilities)
			delete(rawMsg, key)
		case "isPreview":
			err = unpopulate(val, "IsPreview", &k.IsPreview)
			delete(rawMsg, key)
		case "patchVersions":
			err = unpopulate(val, "PatchVersions", &k.PatchVersions)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &k.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionCapabilities.
func (k KubernetesVersionCapabilities) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "supportPlan", k.SupportPlan)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionCapabilities.
func (k *KubernetesVersionCapabilities) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "supportPlan":
			err = unpopulate(val, "SupportPlan", &k.SupportPlan)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type KubernetesVersionListResult.
func (k KubernetesVersionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "values", k.Values)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type KubernetesVersionListResult.
func (k *KubernetesVersionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", k, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "values":
			err = unpopulate(val, "Values", &k.Values)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", k, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxOSConfig.
func (l LinuxOSConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "swapFileSizeMB", l.SwapFileSizeMB)
	populate(objectMap, "sysctls", l.Sysctls)
	populate(objectMap, "transparentHugePageDefrag", l.TransparentHugePageDefrag)
	populate(objectMap, "transparentHugePageEnabled", l.TransparentHugePageEnabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxOSConfig.
func (l *LinuxOSConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "swapFileSizeMB":
			err = unpopulate(val, "SwapFileSizeMB", &l.SwapFileSizeMB)
			delete(rawMsg, key)
		case "sysctls":
			err = unpopulate(val, "Sysctls", &l.Sysctls)
			delete(rawMsg, key)
		case "transparentHugePageDefrag":
			err = unpopulate(val, "TransparentHugePageDefrag", &l.TransparentHugePageDefrag)
			delete(rawMsg, key)
		case "transparentHugePageEnabled":
			err = unpopulate(val, "TransparentHugePageEnabled", &l.TransparentHugePageEnabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type LinuxProfile.
func (l LinuxProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminUsername", l.AdminUsername)
	populate(objectMap, "ssh", l.SSH)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type LinuxProfile.
func (l *LinuxProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", l, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &l.AdminUsername)
			delete(rawMsg, key)
		case "ssh":
			err = unpopulate(val, "SSH", &l.SSH)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", l, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceConfiguration.
func (m MaintenanceConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceConfiguration.
func (m *MaintenanceConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceConfigurationListResult.
func (m MaintenanceConfigurationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceConfigurationListResult.
func (m *MaintenanceConfigurationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceConfigurationProperties.
func (m MaintenanceConfigurationProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "maintenanceWindow", m.MaintenanceWindow)
	populate(objectMap, "notAllowedTime", m.NotAllowedTime)
	populate(objectMap, "timeInWeek", m.TimeInWeek)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceConfigurationProperties.
func (m *MaintenanceConfigurationProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "maintenanceWindow":
			err = unpopulate(val, "MaintenanceWindow", &m.MaintenanceWindow)
			delete(rawMsg, key)
		case "notAllowedTime":
			err = unpopulate(val, "NotAllowedTime", &m.NotAllowedTime)
			delete(rawMsg, key)
		case "timeInWeek":
			err = unpopulate(val, "TimeInWeek", &m.TimeInWeek)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MaintenanceWindow.
func (m MaintenanceWindow) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "durationHours", m.DurationHours)
	populate(objectMap, "notAllowedDates", m.NotAllowedDates)
	populate(objectMap, "schedule", m.Schedule)
	populateDateType(objectMap, "startDate", m.StartDate)
	populate(objectMap, "startTime", m.StartTime)
	populate(objectMap, "utcOffset", m.UTCOffset)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MaintenanceWindow.
func (m *MaintenanceWindow) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "durationHours":
			err = unpopulate(val, "DurationHours", &m.DurationHours)
			delete(rawMsg, key)
		case "notAllowedDates":
			err = unpopulate(val, "NotAllowedDates", &m.NotAllowedDates)
			delete(rawMsg, key)
		case "schedule":
			err = unpopulate(val, "Schedule", &m.Schedule)
			delete(rawMsg, key)
		case "startDate":
			err = unpopulateDateType(val, "StartDate", &m.StartDate)
			delete(rawMsg, key)
		case "startTime":
			err = unpopulate(val, "StartTime", &m.StartTime)
			delete(rawMsg, key)
		case "utcOffset":
			err = unpopulate(val, "UTCOffset", &m.UTCOffset)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedCluster.
func (m ManagedCluster) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "extendedLocation", m.ExtendedLocation)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "sku", m.SKU)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedCluster.
func (m *ManagedCluster) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "extendedLocation":
			err = unpopulate(val, "ExtendedLocation", &m.ExtendedLocation)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "sku":
			err = unpopulate(val, "SKU", &m.SKU)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAADProfile.
func (m ManagedClusterAADProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminGroupObjectIDs", m.AdminGroupObjectIDs)
	populate(objectMap, "clientAppID", m.ClientAppID)
	populate(objectMap, "enableAzureRBAC", m.EnableAzureRBAC)
	populate(objectMap, "managed", m.Managed)
	populate(objectMap, "serverAppID", m.ServerAppID)
	populate(objectMap, "serverAppSecret", m.ServerAppSecret)
	populate(objectMap, "tenantID", m.TenantID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAADProfile.
func (m *ManagedClusterAADProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminGroupObjectIDs":
			err = unpopulate(val, "AdminGroupObjectIDs", &m.AdminGroupObjectIDs)
			delete(rawMsg, key)
		case "clientAppID":
			err = unpopulate(val, "ClientAppID", &m.ClientAppID)
			delete(rawMsg, key)
		case "enableAzureRBAC":
			err = unpopulate(val, "EnableAzureRBAC", &m.EnableAzureRBAC)
			delete(rawMsg, key)
		case "managed":
			err = unpopulate(val, "Managed", &m.Managed)
			delete(rawMsg, key)
		case "serverAppID":
			err = unpopulate(val, "ServerAppID", &m.ServerAppID)
			delete(rawMsg, key)
		case "serverAppSecret":
			err = unpopulate(val, "ServerAppSecret", &m.ServerAppSecret)
			delete(rawMsg, key)
		case "tenantID":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAPIServerAccessProfile.
func (m ManagedClusterAPIServerAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "authorizedIPRanges", m.AuthorizedIPRanges)
	populate(objectMap, "disableRunCommand", m.DisableRunCommand)
	populate(objectMap, "enablePrivateCluster", m.EnablePrivateCluster)
	populate(objectMap, "enablePrivateClusterPublicFQDN", m.EnablePrivateClusterPublicFQDN)
	populate(objectMap, "privateDNSZone", m.PrivateDNSZone)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAPIServerAccessProfile.
func (m *ManagedClusterAPIServerAccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "authorizedIPRanges":
			err = unpopulate(val, "AuthorizedIPRanges", &m.AuthorizedIPRanges)
			delete(rawMsg, key)
		case "disableRunCommand":
			err = unpopulate(val, "DisableRunCommand", &m.DisableRunCommand)
			delete(rawMsg, key)
		case "enablePrivateCluster":
			err = unpopulate(val, "EnablePrivateCluster", &m.EnablePrivateCluster)
			delete(rawMsg, key)
		case "enablePrivateClusterPublicFQDN":
			err = unpopulate(val, "EnablePrivateClusterPublicFQDN", &m.EnablePrivateClusterPublicFQDN)
			delete(rawMsg, key)
		case "privateDNSZone":
			err = unpopulate(val, "PrivateDNSZone", &m.PrivateDNSZone)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAccessProfile.
func (m ManagedClusterAccessProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "location", m.Location)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAccessProfile.
func (m *ManagedClusterAccessProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &m.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAddonProfile.
func (m ManagedClusterAddonProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "config", m.Config)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "identity", m.Identity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAddonProfile.
func (m *ManagedClusterAddonProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "config":
			err = unpopulate(val, "Config", &m.Config)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAddonProfileIdentity.
func (m ManagedClusterAddonProfileIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	populate(objectMap, "objectId", m.ObjectID)
	populate(objectMap, "resourceId", m.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAddonProfileIdentity.
func (m *ManagedClusterAddonProfileIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &m.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &m.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAgentPoolProfile.
func (m ManagedClusterAgentPoolProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", m.AvailabilityZones)
	populate(objectMap, "capacityReservationGroupID", m.CapacityReservationGroupID)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "creationData", m.CreationData)
	populate(objectMap, "currentOrchestratorVersion", m.CurrentOrchestratorVersion)
	populate(objectMap, "enableAutoScaling", m.EnableAutoScaling)
	populate(objectMap, "enableEncryptionAtHost", m.EnableEncryptionAtHost)
	populate(objectMap, "enableFIPS", m.EnableFIPS)
	populate(objectMap, "enableNodePublicIP", m.EnableNodePublicIP)
	populate(objectMap, "enableUltraSSD", m.EnableUltraSSD)
	populate(objectMap, "gpuInstanceProfile", m.GpuInstanceProfile)
	populate(objectMap, "hostGroupID", m.HostGroupID)
	populate(objectMap, "kubeletConfig", m.KubeletConfig)
	populate(objectMap, "kubeletDiskType", m.KubeletDiskType)
	populate(objectMap, "linuxOSConfig", m.LinuxOSConfig)
	populate(objectMap, "maxCount", m.MaxCount)
	populate(objectMap, "maxPods", m.MaxPods)
	populate(objectMap, "minCount", m.MinCount)
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "networkProfile", m.NetworkProfile)
	populate(objectMap, "nodeImageVersion", m.NodeImageVersion)
	populate(objectMap, "nodeLabels", m.NodeLabels)
	populate(objectMap, "nodePublicIPPrefixID", m.NodePublicIPPrefixID)
	populate(objectMap, "nodeTaints", m.NodeTaints)
	populate(objectMap, "osDiskSizeGB", m.OSDiskSizeGB)
	populate(objectMap, "osDiskType", m.OSDiskType)
	populate(objectMap, "osSKU", m.OSSKU)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "orchestratorVersion", m.OrchestratorVersion)
	populate(objectMap, "podSubnetID", m.PodSubnetID)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "proximityPlacementGroupID", m.ProximityPlacementGroupID)
	populate(objectMap, "scaleDownMode", m.ScaleDownMode)
	populate(objectMap, "scaleSetEvictionPolicy", m.ScaleSetEvictionPolicy)
	populate(objectMap, "scaleSetPriority", m.ScaleSetPriority)
	populate(objectMap, "spotMaxPrice", m.SpotMaxPrice)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "upgradeSettings", m.UpgradeSettings)
	populate(objectMap, "vmSize", m.VMSize)
	populate(objectMap, "vnetSubnetID", m.VnetSubnetID)
	populate(objectMap, "workloadRuntime", m.WorkloadRuntime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAgentPoolProfile.
func (m *ManagedClusterAgentPoolProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &m.AvailabilityZones)
			delete(rawMsg, key)
		case "capacityReservationGroupID":
			err = unpopulate(val, "CapacityReservationGroupID", &m.CapacityReservationGroupID)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "creationData":
			err = unpopulate(val, "CreationData", &m.CreationData)
			delete(rawMsg, key)
		case "currentOrchestratorVersion":
			err = unpopulate(val, "CurrentOrchestratorVersion", &m.CurrentOrchestratorVersion)
			delete(rawMsg, key)
		case "enableAutoScaling":
			err = unpopulate(val, "EnableAutoScaling", &m.EnableAutoScaling)
			delete(rawMsg, key)
		case "enableEncryptionAtHost":
			err = unpopulate(val, "EnableEncryptionAtHost", &m.EnableEncryptionAtHost)
			delete(rawMsg, key)
		case "enableFIPS":
			err = unpopulate(val, "EnableFIPS", &m.EnableFIPS)
			delete(rawMsg, key)
		case "enableNodePublicIP":
			err = unpopulate(val, "EnableNodePublicIP", &m.EnableNodePublicIP)
			delete(rawMsg, key)
		case "enableUltraSSD":
			err = unpopulate(val, "EnableUltraSSD", &m.EnableUltraSSD)
			delete(rawMsg, key)
		case "gpuInstanceProfile":
			err = unpopulate(val, "GpuInstanceProfile", &m.GpuInstanceProfile)
			delete(rawMsg, key)
		case "hostGroupID":
			err = unpopulate(val, "HostGroupID", &m.HostGroupID)
			delete(rawMsg, key)
		case "kubeletConfig":
			err = unpopulate(val, "KubeletConfig", &m.KubeletConfig)
			delete(rawMsg, key)
		case "kubeletDiskType":
			err = unpopulate(val, "KubeletDiskType", &m.KubeletDiskType)
			delete(rawMsg, key)
		case "linuxOSConfig":
			err = unpopulate(val, "LinuxOSConfig", &m.LinuxOSConfig)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &m.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &m.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &m.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &m.NetworkProfile)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &m.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &m.NodeLabels)
			delete(rawMsg, key)
		case "nodePublicIPPrefixID":
			err = unpopulate(val, "NodePublicIPPrefixID", &m.NodePublicIPPrefixID)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &m.NodeTaints)
			delete(rawMsg, key)
		case "osDiskSizeGB":
			err = unpopulate(val, "OSDiskSizeGB", &m.OSDiskSizeGB)
			delete(rawMsg, key)
		case "osDiskType":
			err = unpopulate(val, "OSDiskType", &m.OSDiskType)
			delete(rawMsg, key)
		case "osSKU":
			err = unpopulate(val, "OSSKU", &m.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &m.OrchestratorVersion)
			delete(rawMsg, key)
		case "podSubnetID":
			err = unpopulate(val, "PodSubnetID", &m.PodSubnetID)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &m.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroupID":
			err = unpopulate(val, "ProximityPlacementGroupID", &m.ProximityPlacementGroupID)
			delete(rawMsg, key)
		case "scaleDownMode":
			err = unpopulate(val, "ScaleDownMode", &m.ScaleDownMode)
			delete(rawMsg, key)
		case "scaleSetEvictionPolicy":
			err = unpopulate(val, "ScaleSetEvictionPolicy", &m.ScaleSetEvictionPolicy)
			delete(rawMsg, key)
		case "scaleSetPriority":
			err = unpopulate(val, "ScaleSetPriority", &m.ScaleSetPriority)
			delete(rawMsg, key)
		case "spotMaxPrice":
			err = unpopulate(val, "SpotMaxPrice", &m.SpotMaxPrice)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &m.UpgradeSettings)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &m.VMSize)
			delete(rawMsg, key)
		case "vnetSubnetID":
			err = unpopulate(val, "VnetSubnetID", &m.VnetSubnetID)
			delete(rawMsg, key)
		case "workloadRuntime":
			err = unpopulate(val, "WorkloadRuntime", &m.WorkloadRuntime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAgentPoolProfileProperties.
func (m ManagedClusterAgentPoolProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "availabilityZones", m.AvailabilityZones)
	populate(objectMap, "capacityReservationGroupID", m.CapacityReservationGroupID)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "creationData", m.CreationData)
	populate(objectMap, "currentOrchestratorVersion", m.CurrentOrchestratorVersion)
	populate(objectMap, "enableAutoScaling", m.EnableAutoScaling)
	populate(objectMap, "enableEncryptionAtHost", m.EnableEncryptionAtHost)
	populate(objectMap, "enableFIPS", m.EnableFIPS)
	populate(objectMap, "enableNodePublicIP", m.EnableNodePublicIP)
	populate(objectMap, "enableUltraSSD", m.EnableUltraSSD)
	populate(objectMap, "gpuInstanceProfile", m.GpuInstanceProfile)
	populate(objectMap, "hostGroupID", m.HostGroupID)
	populate(objectMap, "kubeletConfig", m.KubeletConfig)
	populate(objectMap, "kubeletDiskType", m.KubeletDiskType)
	populate(objectMap, "linuxOSConfig", m.LinuxOSConfig)
	populate(objectMap, "maxCount", m.MaxCount)
	populate(objectMap, "maxPods", m.MaxPods)
	populate(objectMap, "minCount", m.MinCount)
	populate(objectMap, "mode", m.Mode)
	populate(objectMap, "networkProfile", m.NetworkProfile)
	populate(objectMap, "nodeImageVersion", m.NodeImageVersion)
	populate(objectMap, "nodeLabels", m.NodeLabels)
	populate(objectMap, "nodePublicIPPrefixID", m.NodePublicIPPrefixID)
	populate(objectMap, "nodeTaints", m.NodeTaints)
	populate(objectMap, "osDiskSizeGB", m.OSDiskSizeGB)
	populate(objectMap, "osDiskType", m.OSDiskType)
	populate(objectMap, "osSKU", m.OSSKU)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "orchestratorVersion", m.OrchestratorVersion)
	populate(objectMap, "podSubnetID", m.PodSubnetID)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "proximityPlacementGroupID", m.ProximityPlacementGroupID)
	populate(objectMap, "scaleDownMode", m.ScaleDownMode)
	populate(objectMap, "scaleSetEvictionPolicy", m.ScaleSetEvictionPolicy)
	populate(objectMap, "scaleSetPriority", m.ScaleSetPriority)
	populate(objectMap, "spotMaxPrice", m.SpotMaxPrice)
	populate(objectMap, "tags", m.Tags)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "upgradeSettings", m.UpgradeSettings)
	populate(objectMap, "vmSize", m.VMSize)
	populate(objectMap, "vnetSubnetID", m.VnetSubnetID)
	populate(objectMap, "workloadRuntime", m.WorkloadRuntime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAgentPoolProfileProperties.
func (m *ManagedClusterAgentPoolProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "availabilityZones":
			err = unpopulate(val, "AvailabilityZones", &m.AvailabilityZones)
			delete(rawMsg, key)
		case "capacityReservationGroupID":
			err = unpopulate(val, "CapacityReservationGroupID", &m.CapacityReservationGroupID)
			delete(rawMsg, key)
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "creationData":
			err = unpopulate(val, "CreationData", &m.CreationData)
			delete(rawMsg, key)
		case "currentOrchestratorVersion":
			err = unpopulate(val, "CurrentOrchestratorVersion", &m.CurrentOrchestratorVersion)
			delete(rawMsg, key)
		case "enableAutoScaling":
			err = unpopulate(val, "EnableAutoScaling", &m.EnableAutoScaling)
			delete(rawMsg, key)
		case "enableEncryptionAtHost":
			err = unpopulate(val, "EnableEncryptionAtHost", &m.EnableEncryptionAtHost)
			delete(rawMsg, key)
		case "enableFIPS":
			err = unpopulate(val, "EnableFIPS", &m.EnableFIPS)
			delete(rawMsg, key)
		case "enableNodePublicIP":
			err = unpopulate(val, "EnableNodePublicIP", &m.EnableNodePublicIP)
			delete(rawMsg, key)
		case "enableUltraSSD":
			err = unpopulate(val, "EnableUltraSSD", &m.EnableUltraSSD)
			delete(rawMsg, key)
		case "gpuInstanceProfile":
			err = unpopulate(val, "GpuInstanceProfile", &m.GpuInstanceProfile)
			delete(rawMsg, key)
		case "hostGroupID":
			err = unpopulate(val, "HostGroupID", &m.HostGroupID)
			delete(rawMsg, key)
		case "kubeletConfig":
			err = unpopulate(val, "KubeletConfig", &m.KubeletConfig)
			delete(rawMsg, key)
		case "kubeletDiskType":
			err = unpopulate(val, "KubeletDiskType", &m.KubeletDiskType)
			delete(rawMsg, key)
		case "linuxOSConfig":
			err = unpopulate(val, "LinuxOSConfig", &m.LinuxOSConfig)
			delete(rawMsg, key)
		case "maxCount":
			err = unpopulate(val, "MaxCount", &m.MaxCount)
			delete(rawMsg, key)
		case "maxPods":
			err = unpopulate(val, "MaxPods", &m.MaxPods)
			delete(rawMsg, key)
		case "minCount":
			err = unpopulate(val, "MinCount", &m.MinCount)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &m.Mode)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &m.NetworkProfile)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &m.NodeImageVersion)
			delete(rawMsg, key)
		case "nodeLabels":
			err = unpopulate(val, "NodeLabels", &m.NodeLabels)
			delete(rawMsg, key)
		case "nodePublicIPPrefixID":
			err = unpopulate(val, "NodePublicIPPrefixID", &m.NodePublicIPPrefixID)
			delete(rawMsg, key)
		case "nodeTaints":
			err = unpopulate(val, "NodeTaints", &m.NodeTaints)
			delete(rawMsg, key)
		case "osDiskSizeGB":
			err = unpopulate(val, "OSDiskSizeGB", &m.OSDiskSizeGB)
			delete(rawMsg, key)
		case "osDiskType":
			err = unpopulate(val, "OSDiskType", &m.OSDiskType)
			delete(rawMsg, key)
		case "osSKU":
			err = unpopulate(val, "OSSKU", &m.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "orchestratorVersion":
			err = unpopulate(val, "OrchestratorVersion", &m.OrchestratorVersion)
			delete(rawMsg, key)
		case "podSubnetID":
			err = unpopulate(val, "PodSubnetID", &m.PodSubnetID)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &m.PowerState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "proximityPlacementGroupID":
			err = unpopulate(val, "ProximityPlacementGroupID", &m.ProximityPlacementGroupID)
			delete(rawMsg, key)
		case "scaleDownMode":
			err = unpopulate(val, "ScaleDownMode", &m.ScaleDownMode)
			delete(rawMsg, key)
		case "scaleSetEvictionPolicy":
			err = unpopulate(val, "ScaleSetEvictionPolicy", &m.ScaleSetEvictionPolicy)
			delete(rawMsg, key)
		case "scaleSetPriority":
			err = unpopulate(val, "ScaleSetPriority", &m.ScaleSetPriority)
			delete(rawMsg, key)
		case "spotMaxPrice":
			err = unpopulate(val, "SpotMaxPrice", &m.SpotMaxPrice)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &m.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &m.UpgradeSettings)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &m.VMSize)
			delete(rawMsg, key)
		case "vnetSubnetID":
			err = unpopulate(val, "VnetSubnetID", &m.VnetSubnetID)
			delete(rawMsg, key)
		case "workloadRuntime":
			err = unpopulate(val, "WorkloadRuntime", &m.WorkloadRuntime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAutoUpgradeProfile.
func (m ManagedClusterAutoUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nodeOSUpgradeChannel", m.NodeOSUpgradeChannel)
	populate(objectMap, "upgradeChannel", m.UpgradeChannel)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAutoUpgradeProfile.
func (m *ManagedClusterAutoUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nodeOSUpgradeChannel":
			err = unpopulate(val, "NodeOSUpgradeChannel", &m.NodeOSUpgradeChannel)
			delete(rawMsg, key)
		case "upgradeChannel":
			err = unpopulate(val, "UpgradeChannel", &m.UpgradeChannel)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAzureMonitorProfile.
func (m ManagedClusterAzureMonitorProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metrics", m.Metrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAzureMonitorProfile.
func (m *ManagedClusterAzureMonitorProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metrics":
			err = unpopulate(val, "Metrics", &m.Metrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAzureMonitorProfileKubeStateMetrics.
func (m ManagedClusterAzureMonitorProfileKubeStateMetrics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "metricAnnotationsAllowList", m.MetricAnnotationsAllowList)
	populate(objectMap, "metricLabelsAllowlist", m.MetricLabelsAllowlist)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAzureMonitorProfileKubeStateMetrics.
func (m *ManagedClusterAzureMonitorProfileKubeStateMetrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "metricAnnotationsAllowList":
			err = unpopulate(val, "MetricAnnotationsAllowList", &m.MetricAnnotationsAllowList)
			delete(rawMsg, key)
		case "metricLabelsAllowlist":
			err = unpopulate(val, "MetricLabelsAllowlist", &m.MetricLabelsAllowlist)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterAzureMonitorProfileMetrics.
func (m ManagedClusterAzureMonitorProfileMetrics) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "kubeStateMetrics", m.KubeStateMetrics)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterAzureMonitorProfileMetrics.
func (m *ManagedClusterAzureMonitorProfileMetrics) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "kubeStateMetrics":
			err = unpopulate(val, "KubeStateMetrics", &m.KubeStateMetrics)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterHTTPProxyConfig.
func (m ManagedClusterHTTPProxyConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "httpProxy", m.HTTPProxy)
	populate(objectMap, "httpsProxy", m.HTTPSProxy)
	populate(objectMap, "noProxy", m.NoProxy)
	populate(objectMap, "trustedCa", m.TrustedCa)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterHTTPProxyConfig.
func (m *ManagedClusterHTTPProxyConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "httpProxy":
			err = unpopulate(val, "HTTPProxy", &m.HTTPProxy)
			delete(rawMsg, key)
		case "httpsProxy":
			err = unpopulate(val, "HTTPSProxy", &m.HTTPSProxy)
			delete(rawMsg, key)
		case "noProxy":
			err = unpopulate(val, "NoProxy", &m.NoProxy)
			delete(rawMsg, key)
		case "trustedCa":
			err = unpopulate(val, "TrustedCa", &m.TrustedCa)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterIdentity.
func (m ManagedClusterIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "delegatedResources", m.DelegatedResources)
	populate(objectMap, "principalId", m.PrincipalID)
	populate(objectMap, "tenantId", m.TenantID)
	populate(objectMap, "type", m.Type)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterIdentity.
func (m *ManagedClusterIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "delegatedResources":
			err = unpopulate(val, "DelegatedResources", &m.DelegatedResources)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		case "tenantId":
			err = unpopulate(val, "TenantID", &m.TenantID)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterIngressProfile.
func (m ManagedClusterIngressProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "webAppRouting", m.WebAppRouting)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterIngressProfile.
func (m *ManagedClusterIngressProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "webAppRouting":
			err = unpopulate(val, "WebAppRouting", &m.WebAppRouting)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterIngressProfileWebAppRouting.
func (m ManagedClusterIngressProfileWebAppRouting) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsZoneResourceIds", m.DNSZoneResourceIDs)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "identity", m.Identity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterIngressProfileWebAppRouting.
func (m *ManagedClusterIngressProfileWebAppRouting) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsZoneResourceIds":
			err = unpopulate(val, "DNSZoneResourceIDs", &m.DNSZoneResourceIDs)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterListResult.
func (m ManagedClusterListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterListResult.
func (m *ManagedClusterListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfile.
func (m ManagedClusterLoadBalancerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allocatedOutboundPorts", m.AllocatedOutboundPorts)
	populate(objectMap, "backendPoolType", m.BackendPoolType)
	populate(objectMap, "effectiveOutboundIPs", m.EffectiveOutboundIPs)
	populate(objectMap, "enableMultipleStandardLoadBalancers", m.EnableMultipleStandardLoadBalancers)
	populate(objectMap, "idleTimeoutInMinutes", m.IdleTimeoutInMinutes)
	populate(objectMap, "managedOutboundIPs", m.ManagedOutboundIPs)
	populate(objectMap, "outboundIPPrefixes", m.OutboundIPPrefixes)
	populate(objectMap, "outboundIPs", m.OutboundIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfile.
func (m *ManagedClusterLoadBalancerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allocatedOutboundPorts":
			err = unpopulate(val, "AllocatedOutboundPorts", &m.AllocatedOutboundPorts)
			delete(rawMsg, key)
		case "backendPoolType":
			err = unpopulate(val, "BackendPoolType", &m.BackendPoolType)
			delete(rawMsg, key)
		case "effectiveOutboundIPs":
			err = unpopulate(val, "EffectiveOutboundIPs", &m.EffectiveOutboundIPs)
			delete(rawMsg, key)
		case "enableMultipleStandardLoadBalancers":
			err = unpopulate(val, "EnableMultipleStandardLoadBalancers", &m.EnableMultipleStandardLoadBalancers)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &m.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "managedOutboundIPs":
			err = unpopulate(val, "ManagedOutboundIPs", &m.ManagedOutboundIPs)
			delete(rawMsg, key)
		case "outboundIPPrefixes":
			err = unpopulate(val, "OutboundIPPrefixes", &m.OutboundIPPrefixes)
			delete(rawMsg, key)
		case "outboundIPs":
			err = unpopulate(val, "OutboundIPs", &m.OutboundIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileManagedOutboundIPs.
func (m ManagedClusterLoadBalancerProfileManagedOutboundIPs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", m.Count)
	populate(objectMap, "countIPv6", m.CountIPv6)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfileManagedOutboundIPs.
func (m *ManagedClusterLoadBalancerProfileManagedOutboundIPs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		case "countIPv6":
			err = unpopulate(val, "CountIPv6", &m.CountIPv6)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPPrefixes.
func (m ManagedClusterLoadBalancerProfileOutboundIPPrefixes) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPPrefixes", m.PublicIPPrefixes)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPPrefixes.
func (m *ManagedClusterLoadBalancerProfileOutboundIPPrefixes) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPPrefixes":
			err = unpopulate(val, "PublicIPPrefixes", &m.PublicIPPrefixes)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPs.
func (m ManagedClusterLoadBalancerProfileOutboundIPs) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicIPs", m.PublicIPs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterLoadBalancerProfileOutboundIPs.
func (m *ManagedClusterLoadBalancerProfileOutboundIPs) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicIPs":
			err = unpopulate(val, "PublicIPs", &m.PublicIPs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterManagedOutboundIPProfile.
func (m ManagedClusterManagedOutboundIPProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "count", m.Count)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterManagedOutboundIPProfile.
func (m *ManagedClusterManagedOutboundIPProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "count":
			err = unpopulate(val, "Count", &m.Count)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterNATGatewayProfile.
func (m ManagedClusterNATGatewayProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "effectiveOutboundIPs", m.EffectiveOutboundIPs)
	populate(objectMap, "idleTimeoutInMinutes", m.IdleTimeoutInMinutes)
	populate(objectMap, "managedOutboundIPProfile", m.ManagedOutboundIPProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterNATGatewayProfile.
func (m *ManagedClusterNATGatewayProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "effectiveOutboundIPs":
			err = unpopulate(val, "EffectiveOutboundIPs", &m.EffectiveOutboundIPs)
			delete(rawMsg, key)
		case "idleTimeoutInMinutes":
			err = unpopulate(val, "IdleTimeoutInMinutes", &m.IdleTimeoutInMinutes)
			delete(rawMsg, key)
		case "managedOutboundIPProfile":
			err = unpopulate(val, "ManagedOutboundIPProfile", &m.ManagedOutboundIPProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterOIDCIssuerProfile.
func (m ManagedClusterOIDCIssuerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "issuerURL", m.IssuerURL)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterOIDCIssuerProfile.
func (m *ManagedClusterOIDCIssuerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "issuerURL":
			err = unpopulate(val, "IssuerURL", &m.IssuerURL)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentity.
func (m ManagedClusterPodIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "bindingSelector", m.BindingSelector)
	populate(objectMap, "identity", m.Identity)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "provisioningInfo", m.ProvisioningInfo)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentity.
func (m *ManagedClusterPodIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bindingSelector":
			err = unpopulate(val, "BindingSelector", &m.BindingSelector)
			delete(rawMsg, key)
		case "identity":
			err = unpopulate(val, "Identity", &m.Identity)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &m.Namespace)
			delete(rawMsg, key)
		case "provisioningInfo":
			err = unpopulate(val, "ProvisioningInfo", &m.ProvisioningInfo)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityException.
func (m ManagedClusterPodIdentityException) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "namespace", m.Namespace)
	populate(objectMap, "podLabels", m.PodLabels)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityException.
func (m *ManagedClusterPodIdentityException) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "namespace":
			err = unpopulate(val, "Namespace", &m.Namespace)
			delete(rawMsg, key)
		case "podLabels":
			err = unpopulate(val, "PodLabels", &m.PodLabels)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProfile.
func (m ManagedClusterPodIdentityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "allowNetworkPluginKubenet", m.AllowNetworkPluginKubenet)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "userAssignedIdentities", m.UserAssignedIdentities)
	populate(objectMap, "userAssignedIdentityExceptions", m.UserAssignedIdentityExceptions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityProfile.
func (m *ManagedClusterPodIdentityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "allowNetworkPluginKubenet":
			err = unpopulate(val, "AllowNetworkPluginKubenet", &m.AllowNetworkPluginKubenet)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "userAssignedIdentities":
			err = unpopulate(val, "UserAssignedIdentities", &m.UserAssignedIdentities)
			delete(rawMsg, key)
		case "userAssignedIdentityExceptions":
			err = unpopulate(val, "UserAssignedIdentityExceptions", &m.UserAssignedIdentityExceptions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProvisioningError.
func (m ManagedClusterPodIdentityProvisioningError) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", m.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityProvisioningError.
func (m *ManagedClusterPodIdentityProvisioningError) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProvisioningErrorBody.
func (m ManagedClusterPodIdentityProvisioningErrorBody) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", m.Code)
	populate(objectMap, "details", m.Details)
	populate(objectMap, "message", m.Message)
	populate(objectMap, "target", m.Target)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityProvisioningErrorBody.
func (m *ManagedClusterPodIdentityProvisioningErrorBody) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &m.Code)
			delete(rawMsg, key)
		case "details":
			err = unpopulate(val, "Details", &m.Details)
			delete(rawMsg, key)
		case "message":
			err = unpopulate(val, "Message", &m.Message)
			delete(rawMsg, key)
		case "target":
			err = unpopulate(val, "Target", &m.Target)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPodIdentityProvisioningInfo.
func (m ManagedClusterPodIdentityProvisioningInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "error", m.Error)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPodIdentityProvisioningInfo.
func (m *ManagedClusterPodIdentityProvisioningInfo) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "error":
			err = unpopulate(val, "Error", &m.Error)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPoolUpgradeProfile.
func (m ManagedClusterPoolUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "osType", m.OSType)
	populate(objectMap, "upgrades", m.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPoolUpgradeProfile.
func (m *ManagedClusterPoolUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &m.KubernetesVersion)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &m.OSType)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &m.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPoolUpgradeProfileUpgradesItem.
func (m ManagedClusterPoolUpgradeProfileUpgradesItem) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "isPreview", m.IsPreview)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPoolUpgradeProfileUpgradesItem.
func (m *ManagedClusterPoolUpgradeProfileUpgradesItem) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "isPreview":
			err = unpopulate(val, "IsPreview", &m.IsPreview)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &m.KubernetesVersion)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterProperties.
func (m ManagedClusterProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "aadProfile", m.AADProfile)
	populate(objectMap, "apiServerAccessProfile", m.APIServerAccessProfile)
	populate(objectMap, "addonProfiles", m.AddonProfiles)
	populate(objectMap, "agentPoolProfiles", m.AgentPoolProfiles)
	populate(objectMap, "autoScalerProfile", m.AutoScalerProfile)
	populate(objectMap, "autoUpgradeProfile", m.AutoUpgradeProfile)
	populate(objectMap, "azureMonitorProfile", m.AzureMonitorProfile)
	populate(objectMap, "azurePortalFQDN", m.AzurePortalFQDN)
	populate(objectMap, "currentKubernetesVersion", m.CurrentKubernetesVersion)
	populate(objectMap, "dnsPrefix", m.DNSPrefix)
	populate(objectMap, "disableLocalAccounts", m.DisableLocalAccounts)
	populate(objectMap, "diskEncryptionSetID", m.DiskEncryptionSetID)
	populate(objectMap, "enablePodSecurityPolicy", m.EnablePodSecurityPolicy)
	populate(objectMap, "enableRBAC", m.EnableRBAC)
	populate(objectMap, "fqdn", m.Fqdn)
	populate(objectMap, "fqdnSubdomain", m.FqdnSubdomain)
	populate(objectMap, "httpProxyConfig", m.HTTPProxyConfig)
	populate(objectMap, "identityProfile", m.IdentityProfile)
	populate(objectMap, "ingressProfile", m.IngressProfile)
	populate(objectMap, "kubernetesVersion", m.KubernetesVersion)
	populate(objectMap, "linuxProfile", m.LinuxProfile)
	populate(objectMap, "maxAgentPools", m.MaxAgentPools)
	populate(objectMap, "networkProfile", m.NetworkProfile)
	populate(objectMap, "nodeResourceGroup", m.NodeResourceGroup)
	populate(objectMap, "oidcIssuerProfile", m.OidcIssuerProfile)
	populate(objectMap, "podIdentityProfile", m.PodIdentityProfile)
	populate(objectMap, "powerState", m.PowerState)
	populate(objectMap, "privateFQDN", m.PrivateFQDN)
	populate(objectMap, "privateLinkResources", m.PrivateLinkResources)
	populate(objectMap, "provisioningState", m.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", m.PublicNetworkAccess)
	populate(objectMap, "resourceUID", m.ResourceUID)
	populate(objectMap, "securityProfile", m.SecurityProfile)
	populate(objectMap, "serviceMeshProfile", m.ServiceMeshProfile)
	populate(objectMap, "servicePrincipalProfile", m.ServicePrincipalProfile)
	populate(objectMap, "storageProfile", m.StorageProfile)
	populate(objectMap, "supportPlan", m.SupportPlan)
	populate(objectMap, "upgradeSettings", m.UpgradeSettings)
	populate(objectMap, "windowsProfile", m.WindowsProfile)
	populate(objectMap, "workloadAutoScalerProfile", m.WorkloadAutoScalerProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterProperties.
func (m *ManagedClusterProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "aadProfile":
			err = unpopulate(val, "AADProfile", &m.AADProfile)
			delete(rawMsg, key)
		case "apiServerAccessProfile":
			err = unpopulate(val, "APIServerAccessProfile", &m.APIServerAccessProfile)
			delete(rawMsg, key)
		case "addonProfiles":
			err = unpopulate(val, "AddonProfiles", &m.AddonProfiles)
			delete(rawMsg, key)
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &m.AgentPoolProfiles)
			delete(rawMsg, key)
		case "autoScalerProfile":
			err = unpopulate(val, "AutoScalerProfile", &m.AutoScalerProfile)
			delete(rawMsg, key)
		case "autoUpgradeProfile":
			err = unpopulate(val, "AutoUpgradeProfile", &m.AutoUpgradeProfile)
			delete(rawMsg, key)
		case "azureMonitorProfile":
			err = unpopulate(val, "AzureMonitorProfile", &m.AzureMonitorProfile)
			delete(rawMsg, key)
		case "azurePortalFQDN":
			err = unpopulate(val, "AzurePortalFQDN", &m.AzurePortalFQDN)
			delete(rawMsg, key)
		case "currentKubernetesVersion":
			err = unpopulate(val, "CurrentKubernetesVersion", &m.CurrentKubernetesVersion)
			delete(rawMsg, key)
		case "dnsPrefix":
			err = unpopulate(val, "DNSPrefix", &m.DNSPrefix)
			delete(rawMsg, key)
		case "disableLocalAccounts":
			err = unpopulate(val, "DisableLocalAccounts", &m.DisableLocalAccounts)
			delete(rawMsg, key)
		case "diskEncryptionSetID":
			err = unpopulate(val, "DiskEncryptionSetID", &m.DiskEncryptionSetID)
			delete(rawMsg, key)
		case "enablePodSecurityPolicy":
			err = unpopulate(val, "EnablePodSecurityPolicy", &m.EnablePodSecurityPolicy)
			delete(rawMsg, key)
		case "enableRBAC":
			err = unpopulate(val, "EnableRBAC", &m.EnableRBAC)
			delete(rawMsg, key)
		case "fqdn":
			err = unpopulate(val, "Fqdn", &m.Fqdn)
			delete(rawMsg, key)
		case "fqdnSubdomain":
			err = unpopulate(val, "FqdnSubdomain", &m.FqdnSubdomain)
			delete(rawMsg, key)
		case "httpProxyConfig":
			err = unpopulate(val, "HTTPProxyConfig", &m.HTTPProxyConfig)
			delete(rawMsg, key)
		case "identityProfile":
			err = unpopulate(val, "IdentityProfile", &m.IdentityProfile)
			delete(rawMsg, key)
		case "ingressProfile":
			err = unpopulate(val, "IngressProfile", &m.IngressProfile)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &m.KubernetesVersion)
			delete(rawMsg, key)
		case "linuxProfile":
			err = unpopulate(val, "LinuxProfile", &m.LinuxProfile)
			delete(rawMsg, key)
		case "maxAgentPools":
			err = unpopulate(val, "MaxAgentPools", &m.MaxAgentPools)
			delete(rawMsg, key)
		case "networkProfile":
			err = unpopulate(val, "NetworkProfile", &m.NetworkProfile)
			delete(rawMsg, key)
		case "nodeResourceGroup":
			err = unpopulate(val, "NodeResourceGroup", &m.NodeResourceGroup)
			delete(rawMsg, key)
		case "oidcIssuerProfile":
			err = unpopulate(val, "OidcIssuerProfile", &m.OidcIssuerProfile)
			delete(rawMsg, key)
		case "podIdentityProfile":
			err = unpopulate(val, "PodIdentityProfile", &m.PodIdentityProfile)
			delete(rawMsg, key)
		case "powerState":
			err = unpopulate(val, "PowerState", &m.PowerState)
			delete(rawMsg, key)
		case "privateFQDN":
			err = unpopulate(val, "PrivateFQDN", &m.PrivateFQDN)
			delete(rawMsg, key)
		case "privateLinkResources":
			err = unpopulate(val, "PrivateLinkResources", &m.PrivateLinkResources)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &m.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &m.PublicNetworkAccess)
			delete(rawMsg, key)
		case "resourceUID":
			err = unpopulate(val, "ResourceUID", &m.ResourceUID)
			delete(rawMsg, key)
		case "securityProfile":
			err = unpopulate(val, "SecurityProfile", &m.SecurityProfile)
			delete(rawMsg, key)
		case "serviceMeshProfile":
			err = unpopulate(val, "ServiceMeshProfile", &m.ServiceMeshProfile)
			delete(rawMsg, key)
		case "servicePrincipalProfile":
			err = unpopulate(val, "ServicePrincipalProfile", &m.ServicePrincipalProfile)
			delete(rawMsg, key)
		case "storageProfile":
			err = unpopulate(val, "StorageProfile", &m.StorageProfile)
			delete(rawMsg, key)
		case "supportPlan":
			err = unpopulate(val, "SupportPlan", &m.SupportPlan)
			delete(rawMsg, key)
		case "upgradeSettings":
			err = unpopulate(val, "UpgradeSettings", &m.UpgradeSettings)
			delete(rawMsg, key)
		case "windowsProfile":
			err = unpopulate(val, "WindowsProfile", &m.WindowsProfile)
			delete(rawMsg, key)
		case "workloadAutoScalerProfile":
			err = unpopulate(val, "WorkloadAutoScalerProfile", &m.WorkloadAutoScalerProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterPropertiesAutoScalerProfile.
func (m ManagedClusterPropertiesAutoScalerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "balance-similar-node-groups", m.BalanceSimilarNodeGroups)
	populate(objectMap, "expander", m.Expander)
	populate(objectMap, "max-empty-bulk-delete", m.MaxEmptyBulkDelete)
	populate(objectMap, "max-graceful-termination-sec", m.MaxGracefulTerminationSec)
	populate(objectMap, "max-node-provision-time", m.MaxNodeProvisionTime)
	populate(objectMap, "max-total-unready-percentage", m.MaxTotalUnreadyPercentage)
	populate(objectMap, "new-pod-scale-up-delay", m.NewPodScaleUpDelay)
	populate(objectMap, "ok-total-unready-count", m.OkTotalUnreadyCount)
	populate(objectMap, "scale-down-delay-after-add", m.ScaleDownDelayAfterAdd)
	populate(objectMap, "scale-down-delay-after-delete", m.ScaleDownDelayAfterDelete)
	populate(objectMap, "scale-down-delay-after-failure", m.ScaleDownDelayAfterFailure)
	populate(objectMap, "scale-down-unneeded-time", m.ScaleDownUnneededTime)
	populate(objectMap, "scale-down-unready-time", m.ScaleDownUnreadyTime)
	populate(objectMap, "scale-down-utilization-threshold", m.ScaleDownUtilizationThreshold)
	populate(objectMap, "scan-interval", m.ScanInterval)
	populate(objectMap, "skip-nodes-with-local-storage", m.SkipNodesWithLocalStorage)
	populate(objectMap, "skip-nodes-with-system-pods", m.SkipNodesWithSystemPods)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterPropertiesAutoScalerProfile.
func (m *ManagedClusterPropertiesAutoScalerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "balance-similar-node-groups":
			err = unpopulate(val, "BalanceSimilarNodeGroups", &m.BalanceSimilarNodeGroups)
			delete(rawMsg, key)
		case "expander":
			err = unpopulate(val, "Expander", &m.Expander)
			delete(rawMsg, key)
		case "max-empty-bulk-delete":
			err = unpopulate(val, "MaxEmptyBulkDelete", &m.MaxEmptyBulkDelete)
			delete(rawMsg, key)
		case "max-graceful-termination-sec":
			err = unpopulate(val, "MaxGracefulTerminationSec", &m.MaxGracefulTerminationSec)
			delete(rawMsg, key)
		case "max-node-provision-time":
			err = unpopulate(val, "MaxNodeProvisionTime", &m.MaxNodeProvisionTime)
			delete(rawMsg, key)
		case "max-total-unready-percentage":
			err = unpopulate(val, "MaxTotalUnreadyPercentage", &m.MaxTotalUnreadyPercentage)
			delete(rawMsg, key)
		case "new-pod-scale-up-delay":
			err = unpopulate(val, "NewPodScaleUpDelay", &m.NewPodScaleUpDelay)
			delete(rawMsg, key)
		case "ok-total-unready-count":
			err = unpopulate(val, "OkTotalUnreadyCount", &m.OkTotalUnreadyCount)
			delete(rawMsg, key)
		case "scale-down-delay-after-add":
			err = unpopulate(val, "ScaleDownDelayAfterAdd", &m.ScaleDownDelayAfterAdd)
			delete(rawMsg, key)
		case "scale-down-delay-after-delete":
			err = unpopulate(val, "ScaleDownDelayAfterDelete", &m.ScaleDownDelayAfterDelete)
			delete(rawMsg, key)
		case "scale-down-delay-after-failure":
			err = unpopulate(val, "ScaleDownDelayAfterFailure", &m.ScaleDownDelayAfterFailure)
			delete(rawMsg, key)
		case "scale-down-unneeded-time":
			err = unpopulate(val, "ScaleDownUnneededTime", &m.ScaleDownUnneededTime)
			delete(rawMsg, key)
		case "scale-down-unready-time":
			err = unpopulate(val, "ScaleDownUnreadyTime", &m.ScaleDownUnreadyTime)
			delete(rawMsg, key)
		case "scale-down-utilization-threshold":
			err = unpopulate(val, "ScaleDownUtilizationThreshold", &m.ScaleDownUtilizationThreshold)
			delete(rawMsg, key)
		case "scan-interval":
			err = unpopulate(val, "ScanInterval", &m.ScanInterval)
			delete(rawMsg, key)
		case "skip-nodes-with-local-storage":
			err = unpopulate(val, "SkipNodesWithLocalStorage", &m.SkipNodesWithLocalStorage)
			delete(rawMsg, key)
		case "skip-nodes-with-system-pods":
			err = unpopulate(val, "SkipNodesWithSystemPods", &m.SkipNodesWithSystemPods)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSKU.
func (m ManagedClusterSKU) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "tier", m.Tier)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSKU.
func (m *ManagedClusterSKU) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "tier":
			err = unpopulate(val, "Tier", &m.Tier)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSecurityProfile.
func (m ManagedClusterSecurityProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "azureKeyVaultKms", m.AzureKeyVaultKms)
	populate(objectMap, "defender", m.Defender)
	populate(objectMap, "imageCleaner", m.ImageCleaner)
	populate(objectMap, "workloadIdentity", m.WorkloadIdentity)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSecurityProfile.
func (m *ManagedClusterSecurityProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureKeyVaultKms":
			err = unpopulate(val, "AzureKeyVaultKms", &m.AzureKeyVaultKms)
			delete(rawMsg, key)
		case "defender":
			err = unpopulate(val, "Defender", &m.Defender)
			delete(rawMsg, key)
		case "imageCleaner":
			err = unpopulate(val, "ImageCleaner", &m.ImageCleaner)
			delete(rawMsg, key)
		case "workloadIdentity":
			err = unpopulate(val, "WorkloadIdentity", &m.WorkloadIdentity)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSecurityProfileDefender.
func (m ManagedClusterSecurityProfileDefender) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "logAnalyticsWorkspaceResourceId", m.LogAnalyticsWorkspaceResourceID)
	populate(objectMap, "securityMonitoring", m.SecurityMonitoring)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSecurityProfileDefender.
func (m *ManagedClusterSecurityProfileDefender) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "logAnalyticsWorkspaceResourceId":
			err = unpopulate(val, "LogAnalyticsWorkspaceResourceID", &m.LogAnalyticsWorkspaceResourceID)
			delete(rawMsg, key)
		case "securityMonitoring":
			err = unpopulate(val, "SecurityMonitoring", &m.SecurityMonitoring)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSecurityProfileDefenderSecurityMonitoring.
func (m ManagedClusterSecurityProfileDefenderSecurityMonitoring) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSecurityProfileDefenderSecurityMonitoring.
func (m *ManagedClusterSecurityProfileDefenderSecurityMonitoring) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSecurityProfileImageCleaner.
func (m ManagedClusterSecurityProfileImageCleaner) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	populate(objectMap, "intervalHours", m.IntervalHours)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSecurityProfileImageCleaner.
func (m *ManagedClusterSecurityProfileImageCleaner) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		case "intervalHours":
			err = unpopulate(val, "IntervalHours", &m.IntervalHours)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterSecurityProfileWorkloadIdentity.
func (m ManagedClusterSecurityProfileWorkloadIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterSecurityProfileWorkloadIdentity.
func (m *ManagedClusterSecurityProfileWorkloadIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterServicePrincipalProfile.
func (m ManagedClusterServicePrincipalProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	populate(objectMap, "secret", m.Secret)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterServicePrincipalProfile.
func (m *ManagedClusterServicePrincipalProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		case "secret":
			err = unpopulate(val, "Secret", &m.Secret)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterStorageProfile.
func (m ManagedClusterStorageProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "blobCSIDriver", m.BlobCSIDriver)
	populate(objectMap, "diskCSIDriver", m.DiskCSIDriver)
	populate(objectMap, "fileCSIDriver", m.FileCSIDriver)
	populate(objectMap, "snapshotController", m.SnapshotController)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterStorageProfile.
func (m *ManagedClusterStorageProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "blobCSIDriver":
			err = unpopulate(val, "BlobCSIDriver", &m.BlobCSIDriver)
			delete(rawMsg, key)
		case "diskCSIDriver":
			err = unpopulate(val, "DiskCSIDriver", &m.DiskCSIDriver)
			delete(rawMsg, key)
		case "fileCSIDriver":
			err = unpopulate(val, "FileCSIDriver", &m.FileCSIDriver)
			delete(rawMsg, key)
		case "snapshotController":
			err = unpopulate(val, "SnapshotController", &m.SnapshotController)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterStorageProfileBlobCSIDriver.
func (m ManagedClusterStorageProfileBlobCSIDriver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterStorageProfileBlobCSIDriver.
func (m *ManagedClusterStorageProfileBlobCSIDriver) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterStorageProfileDiskCSIDriver.
func (m ManagedClusterStorageProfileDiskCSIDriver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterStorageProfileDiskCSIDriver.
func (m *ManagedClusterStorageProfileDiskCSIDriver) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterStorageProfileFileCSIDriver.
func (m ManagedClusterStorageProfileFileCSIDriver) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterStorageProfileFileCSIDriver.
func (m *ManagedClusterStorageProfileFileCSIDriver) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterStorageProfileSnapshotController.
func (m ManagedClusterStorageProfileSnapshotController) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterStorageProfileSnapshotController.
func (m *ManagedClusterStorageProfileSnapshotController) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterUpgradeProfile.
func (m ManagedClusterUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterUpgradeProfile.
func (m *ManagedClusterUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterUpgradeProfileProperties.
func (m ManagedClusterUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "agentPoolProfiles", m.AgentPoolProfiles)
	populate(objectMap, "controlPlaneProfile", m.ControlPlaneProfile)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterUpgradeProfileProperties.
func (m *ManagedClusterUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "agentPoolProfiles":
			err = unpopulate(val, "AgentPoolProfiles", &m.AgentPoolProfiles)
			delete(rawMsg, key)
		case "controlPlaneProfile":
			err = unpopulate(val, "ControlPlaneProfile", &m.ControlPlaneProfile)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterWindowsProfile.
func (m ManagedClusterWindowsProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "adminPassword", m.AdminPassword)
	populate(objectMap, "adminUsername", m.AdminUsername)
	populate(objectMap, "enableCSIProxy", m.EnableCSIProxy)
	populate(objectMap, "gmsaProfile", m.GmsaProfile)
	populate(objectMap, "licenseType", m.LicenseType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterWindowsProfile.
func (m *ManagedClusterWindowsProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "adminPassword":
			err = unpopulate(val, "AdminPassword", &m.AdminPassword)
			delete(rawMsg, key)
		case "adminUsername":
			err = unpopulate(val, "AdminUsername", &m.AdminUsername)
			delete(rawMsg, key)
		case "enableCSIProxy":
			err = unpopulate(val, "EnableCSIProxy", &m.EnableCSIProxy)
			delete(rawMsg, key)
		case "gmsaProfile":
			err = unpopulate(val, "GmsaProfile", &m.GmsaProfile)
			delete(rawMsg, key)
		case "licenseType":
			err = unpopulate(val, "LicenseType", &m.LicenseType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterWorkloadAutoScalerProfile.
func (m ManagedClusterWorkloadAutoScalerProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keda", m.Keda)
	populate(objectMap, "verticalPodAutoscaler", m.VerticalPodAutoscaler)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterWorkloadAutoScalerProfile.
func (m *ManagedClusterWorkloadAutoScalerProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keda":
			err = unpopulate(val, "Keda", &m.Keda)
			delete(rawMsg, key)
		case "verticalPodAutoscaler":
			err = unpopulate(val, "VerticalPodAutoscaler", &m.VerticalPodAutoscaler)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterWorkloadAutoScalerProfileKeda.
func (m ManagedClusterWorkloadAutoScalerProfileKeda) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterWorkloadAutoScalerProfileKeda.
func (m *ManagedClusterWorkloadAutoScalerProfileKeda) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler.
func (m ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enabled", m.Enabled)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler.
func (m *ManagedClusterWorkloadAutoScalerProfileVerticalPodAutoscaler) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enabled":
			err = unpopulate(val, "Enabled", &m.Enabled)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ManagedServiceIdentityUserAssignedIdentitiesValue.
func (m ManagedServiceIdentityUserAssignedIdentitiesValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", m.ClientID)
	populate(objectMap, "principalId", m.PrincipalID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ManagedServiceIdentityUserAssignedIdentitiesValue.
func (m *ManagedServiceIdentityUserAssignedIdentitiesValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &m.ClientID)
			delete(rawMsg, key)
		case "principalId":
			err = unpopulate(val, "PrincipalID", &m.PrincipalID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshRevision.
func (m MeshRevision) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compatibleWith", m.CompatibleWith)
	populate(objectMap, "revision", m.Revision)
	populate(objectMap, "upgrades", m.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshRevision.
func (m *MeshRevision) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compatibleWith":
			err = unpopulate(val, "CompatibleWith", &m.CompatibleWith)
			delete(rawMsg, key)
		case "revision":
			err = unpopulate(val, "Revision", &m.Revision)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &m.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshRevisionProfile.
func (m MeshRevisionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshRevisionProfile.
func (m *MeshRevisionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshRevisionProfileList.
func (m MeshRevisionProfileList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshRevisionProfileList.
func (m *MeshRevisionProfileList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshRevisionProfileProperties.
func (m MeshRevisionProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "meshRevisions", m.MeshRevisions)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshRevisionProfileProperties.
func (m *MeshRevisionProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "meshRevisions":
			err = unpopulate(val, "MeshRevisions", &m.MeshRevisions)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshUpgradeProfile.
func (m MeshUpgradeProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", m.ID)
	populate(objectMap, "name", m.Name)
	populate(objectMap, "properties", m.Properties)
	populate(objectMap, "systemData", m.SystemData)
	populate(objectMap, "type", m.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshUpgradeProfile.
func (m *MeshUpgradeProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &m.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &m.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &m.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &m.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &m.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshUpgradeProfileList.
func (m MeshUpgradeProfileList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", m.NextLink)
	populate(objectMap, "value", m.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshUpgradeProfileList.
func (m *MeshUpgradeProfileList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &m.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &m.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type MeshUpgradeProfileProperties.
func (m MeshUpgradeProfileProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "compatibleWith", m.CompatibleWith)
	populate(objectMap, "revision", m.Revision)
	populate(objectMap, "upgrades", m.Upgrades)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MeshUpgradeProfileProperties.
func (m *MeshUpgradeProfileProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "compatibleWith":
			err = unpopulate(val, "CompatibleWith", &m.CompatibleWith)
			delete(rawMsg, key)
		case "revision":
			err = unpopulate(val, "Revision", &m.Revision)
			delete(rawMsg, key)
		case "upgrades":
			err = unpopulate(val, "Upgrades", &m.Upgrades)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type NetworkProfile.
func (n NetworkProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServiceIP", n.DNSServiceIP)
	populate(objectMap, "ipFamilies", n.IPFamilies)
	populate(objectMap, "loadBalancerProfile", n.LoadBalancerProfile)
	populate(objectMap, "loadBalancerSku", n.LoadBalancerSKU)
	populate(objectMap, "natGatewayProfile", n.NatGatewayProfile)
	populate(objectMap, "networkDataplane", n.NetworkDataplane)
	populate(objectMap, "networkMode", n.NetworkMode)
	populate(objectMap, "networkPlugin", n.NetworkPlugin)
	populate(objectMap, "networkPluginMode", n.NetworkPluginMode)
	populate(objectMap, "networkPolicy", n.NetworkPolicy)
	populate(objectMap, "outboundType", n.OutboundType)
	populate(objectMap, "podCidr", n.PodCidr)
	populate(objectMap, "podCidrs", n.PodCidrs)
	populate(objectMap, "serviceCidr", n.ServiceCidr)
	populate(objectMap, "serviceCidrs", n.ServiceCidrs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type NetworkProfile.
func (n *NetworkProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", n, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServiceIP":
			err = unpopulate(val, "DNSServiceIP", &n.DNSServiceIP)
			delete(rawMsg, key)
		case "ipFamilies":
			err = unpopulate(val, "IPFamilies", &n.IPFamilies)
			delete(rawMsg, key)
		case "loadBalancerProfile":
			err = unpopulate(val, "LoadBalancerProfile", &n.LoadBalancerProfile)
			delete(rawMsg, key)
		case "loadBalancerSku":
			err = unpopulate(val, "LoadBalancerSKU", &n.LoadBalancerSKU)
			delete(rawMsg, key)
		case "natGatewayProfile":
			err = unpopulate(val, "NatGatewayProfile", &n.NatGatewayProfile)
			delete(rawMsg, key)
		case "networkDataplane":
			err = unpopulate(val, "NetworkDataplane", &n.NetworkDataplane)
			delete(rawMsg, key)
		case "networkMode":
			err = unpopulate(val, "NetworkMode", &n.NetworkMode)
			delete(rawMsg, key)
		case "networkPlugin":
			err = unpopulate(val, "NetworkPlugin", &n.NetworkPlugin)
			delete(rawMsg, key)
		case "networkPluginMode":
			err = unpopulate(val, "NetworkPluginMode", &n.NetworkPluginMode)
			delete(rawMsg, key)
		case "networkPolicy":
			err = unpopulate(val, "NetworkPolicy", &n.NetworkPolicy)
			delete(rawMsg, key)
		case "outboundType":
			err = unpopulate(val, "OutboundType", &n.OutboundType)
			delete(rawMsg, key)
		case "podCidr":
			err = unpopulate(val, "PodCidr", &n.PodCidr)
			delete(rawMsg, key)
		case "podCidrs":
			err = unpopulate(val, "PodCidrs", &n.PodCidrs)
			delete(rawMsg, key)
		case "serviceCidr":
			err = unpopulate(val, "ServiceCidr", &n.ServiceCidr)
			delete(rawMsg, key)
		case "serviceCidrs":
			err = unpopulate(val, "ServiceCidrs", &n.ServiceCidrs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", n, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSOptionProfile.
func (o OSOptionProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", o.ID)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "properties", o.Properties)
	populate(objectMap, "type", o.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSOptionProfile.
func (o *OSOptionProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &o.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &o.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &o.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSOptionProperty.
func (o OSOptionProperty) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "enable-fips-image", o.EnableFipsImage)
	populate(objectMap, "os-type", o.OSType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSOptionProperty.
func (o *OSOptionProperty) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "enable-fips-image":
			err = unpopulate(val, "EnableFipsImage", &o.EnableFipsImage)
			delete(rawMsg, key)
		case "os-type":
			err = unpopulate(val, "OSType", &o.OSType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OSOptionPropertyList.
func (o OSOptionPropertyList) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "osOptionPropertyList", o.OSOptionPropertyList)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OSOptionPropertyList.
func (o *OSOptionPropertyList) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "osOptionPropertyList":
			err = unpopulate(val, "OSOptionPropertyList", &o.OSOptionPropertyList)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationListResult.
func (o OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationListResult.
func (o *OperationListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValue.
func (o OperationValue) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "display", o.Display)
	populate(objectMap, "name", o.Name)
	populate(objectMap, "origin", o.Origin)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValue.
func (o *OperationValue) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "display":
			err = unpopulate(val, "Display", &o.Display)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &o.Name)
			delete(rawMsg, key)
		case "origin":
			err = unpopulate(val, "Origin", &o.Origin)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OperationValueDisplay.
func (o OperationValueDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", o.Description)
	populate(objectMap, "operation", o.Operation)
	populate(objectMap, "provider", o.Provider)
	populate(objectMap, "resource", o.Resource)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OperationValueDisplay.
func (o *OperationValueDisplay) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &o.Description)
			delete(rawMsg, key)
		case "operation":
			err = unpopulate(val, "Operation", &o.Operation)
			delete(rawMsg, key)
		case "provider":
			err = unpopulate(val, "Provider", &o.Provider)
			delete(rawMsg, key)
		case "resource":
			err = unpopulate(val, "Resource", &o.Resource)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpoint.
func (o OutboundEnvironmentEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "category", o.Category)
	populate(objectMap, "endpoints", o.Endpoints)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundEnvironmentEndpoint.
func (o *OutboundEnvironmentEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "category":
			err = unpopulate(val, "Category", &o.Category)
			delete(rawMsg, key)
		case "endpoints":
			err = unpopulate(val, "Endpoints", &o.Endpoints)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type OutboundEnvironmentEndpointCollection.
func (o OutboundEnvironmentEndpointCollection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", o.NextLink)
	populate(objectMap, "value", o.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type OutboundEnvironmentEndpointCollection.
func (o *OutboundEnvironmentEndpointCollection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", o, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &o.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &o.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", o, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PortRange.
func (p PortRange) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "portEnd", p.PortEnd)
	populate(objectMap, "portStart", p.PortStart)
	populate(objectMap, "protocol", p.Protocol)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PortRange.
func (p *PortRange) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "portEnd":
			err = unpopulate(val, "PortEnd", &p.PortEnd)
			delete(rawMsg, key)
		case "portStart":
			err = unpopulate(val, "PortStart", &p.PortStart)
			delete(rawMsg, key)
		case "protocol":
			err = unpopulate(val, "Protocol", &p.Protocol)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PowerState.
func (p PowerState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "code", p.Code)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PowerState.
func (p *PowerState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "code":
			err = unpopulate(val, "Code", &p.Code)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpoint.
func (p PrivateEndpoint) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpoint.
func (p *PrivateEndpoint) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnection.
func (p PrivateEndpointConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnection.
func (p *PrivateEndpointConnection) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &p.Properties)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionListResult.
func (p PrivateEndpointConnectionListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionListResult.
func (p *PrivateEndpointConnectionListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateEndpointConnectionProperties.
func (p PrivateEndpointConnectionProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "privateEndpoint", p.PrivateEndpoint)
	populate(objectMap, "privateLinkServiceConnectionState", p.PrivateLinkServiceConnectionState)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateEndpointConnectionProperties.
func (p *PrivateEndpointConnectionProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "privateEndpoint":
			err = unpopulate(val, "PrivateEndpoint", &p.PrivateEndpoint)
			delete(rawMsg, key)
		case "privateLinkServiceConnectionState":
			err = unpopulate(val, "PrivateLinkServiceConnectionState", &p.PrivateLinkServiceConnectionState)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResource.
func (p PrivateLinkResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "groupId", p.GroupID)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "privateLinkServiceID", p.PrivateLinkServiceID)
	populate(objectMap, "requiredMembers", p.RequiredMembers)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResource.
func (p *PrivateLinkResource) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "groupId":
			err = unpopulate(val, "GroupID", &p.GroupID)
			delete(rawMsg, key)
		case "id":
			err = unpopulate(val, "ID", &p.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &p.Name)
			delete(rawMsg, key)
		case "privateLinkServiceID":
			err = unpopulate(val, "PrivateLinkServiceID", &p.PrivateLinkServiceID)
			delete(rawMsg, key)
		case "requiredMembers":
			err = unpopulate(val, "RequiredMembers", &p.RequiredMembers)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &p.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkResourcesListResult.
func (p PrivateLinkResourcesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "value", p.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkResourcesListResult.
func (p *PrivateLinkResourcesListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "value":
			err = unpopulate(val, "Value", &p.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type PrivateLinkServiceConnectionState.
func (p PrivateLinkServiceConnectionState) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "description", p.Description)
	populate(objectMap, "status", p.Status)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type PrivateLinkServiceConnectionState.
func (p *PrivateLinkServiceConnectionState) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "description":
			err = unpopulate(val, "Description", &p.Description)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &p.Status)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RelativeMonthlySchedule.
func (r RelativeMonthlySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", r.DayOfWeek)
	populate(objectMap, "intervalMonths", r.IntervalMonths)
	populate(objectMap, "weekIndex", r.WeekIndex)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RelativeMonthlySchedule.
func (r *RelativeMonthlySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &r.DayOfWeek)
			delete(rawMsg, key)
		case "intervalMonths":
			err = unpopulate(val, "IntervalMonths", &r.IntervalMonths)
			delete(rawMsg, key)
		case "weekIndex":
			err = unpopulate(val, "WeekIndex", &r.WeekIndex)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ResourceReference.
func (r ResourceReference) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ResourceReference.
func (r *ResourceReference) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandRequest.
func (r RunCommandRequest) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clusterToken", r.ClusterToken)
	populate(objectMap, "command", r.Command)
	populate(objectMap, "context", r.Context)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandRequest.
func (r *RunCommandRequest) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clusterToken":
			err = unpopulate(val, "ClusterToken", &r.ClusterToken)
			delete(rawMsg, key)
		case "command":
			err = unpopulate(val, "Command", &r.Command)
			delete(rawMsg, key)
		case "context":
			err = unpopulate(val, "Context", &r.Context)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type RunCommandResult.
func (r RunCommandResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", r.ID)
	populate(objectMap, "properties", r.Properties)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type RunCommandResult.
func (r *RunCommandResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", r, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &r.ID)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &r.Properties)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", r, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHConfiguration.
func (s SSHConfiguration) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "publicKeys", s.PublicKeys)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHConfiguration.
func (s *SSHConfiguration) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "publicKeys":
			err = unpopulate(val, "PublicKeys", &s.PublicKeys)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SSHPublicKey.
func (s SSHPublicKey) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "keyData", s.KeyData)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SSHPublicKey.
func (s *SSHPublicKey) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "keyData":
			err = unpopulate(val, "KeyData", &s.KeyData)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Schedule.
func (s Schedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "absoluteMonthly", s.AbsoluteMonthly)
	populate(objectMap, "daily", s.Daily)
	populate(objectMap, "relativeMonthly", s.RelativeMonthly)
	populate(objectMap, "weekly", s.Weekly)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Schedule.
func (s *Schedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "absoluteMonthly":
			err = unpopulate(val, "AbsoluteMonthly", &s.AbsoluteMonthly)
			delete(rawMsg, key)
		case "daily":
			err = unpopulate(val, "Daily", &s.Daily)
			delete(rawMsg, key)
		case "relativeMonthly":
			err = unpopulate(val, "RelativeMonthly", &s.RelativeMonthly)
			delete(rawMsg, key)
		case "weekly":
			err = unpopulate(val, "Weekly", &s.Weekly)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type ServiceMeshProfile.
func (s ServiceMeshProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "istio", s.Istio)
	populate(objectMap, "mode", s.Mode)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ServiceMeshProfile.
func (s *ServiceMeshProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "istio":
			err = unpopulate(val, "Istio", &s.Istio)
			delete(rawMsg, key)
		case "mode":
			err = unpopulate(val, "Mode", &s.Mode)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Snapshot.
func (s Snapshot) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", s.ID)
	populate(objectMap, "location", s.Location)
	populate(objectMap, "name", s.Name)
	populate(objectMap, "properties", s.Properties)
	populate(objectMap, "systemData", s.SystemData)
	populate(objectMap, "tags", s.Tags)
	populate(objectMap, "type", s.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type Snapshot.
func (s *Snapshot) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &s.ID)
			delete(rawMsg, key)
		case "location":
			err = unpopulate(val, "Location", &s.Location)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &s.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &s.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &s.SystemData)
			delete(rawMsg, key)
		case "tags":
			err = unpopulate(val, "Tags", &s.Tags)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &s.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotListResult.
func (s SnapshotListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", s.NextLink)
	populate(objectMap, "value", s.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotListResult.
func (s *SnapshotListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &s.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &s.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SnapshotProperties.
func (s SnapshotProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "creationData", s.CreationData)
	populate(objectMap, "enableFIPS", s.EnableFIPS)
	populate(objectMap, "kubernetesVersion", s.KubernetesVersion)
	populate(objectMap, "nodeImageVersion", s.NodeImageVersion)
	populate(objectMap, "osSku", s.OSSKU)
	populate(objectMap, "osType", s.OSType)
	populate(objectMap, "snapshotType", s.SnapshotType)
	populate(objectMap, "vmSize", s.VMSize)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SnapshotProperties.
func (s *SnapshotProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "creationData":
			err = unpopulate(val, "CreationData", &s.CreationData)
			delete(rawMsg, key)
		case "enableFIPS":
			err = unpopulate(val, "EnableFIPS", &s.EnableFIPS)
			delete(rawMsg, key)
		case "kubernetesVersion":
			err = unpopulate(val, "KubernetesVersion", &s.KubernetesVersion)
			delete(rawMsg, key)
		case "nodeImageVersion":
			err = unpopulate(val, "NodeImageVersion", &s.NodeImageVersion)
			delete(rawMsg, key)
		case "osSku":
			err = unpopulate(val, "OSSKU", &s.OSSKU)
			delete(rawMsg, key)
		case "osType":
			err = unpopulate(val, "OSType", &s.OSType)
			delete(rawMsg, key)
		case "snapshotType":
			err = unpopulate(val, "SnapshotType", &s.SnapshotType)
			delete(rawMsg, key)
		case "vmSize":
			err = unpopulate(val, "VMSize", &s.VMSize)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SysctlConfig.
func (s SysctlConfig) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "fsAioMaxNr", s.FsAioMaxNr)
	populate(objectMap, "fsFileMax", s.FsFileMax)
	populate(objectMap, "fsInotifyMaxUserWatches", s.FsInotifyMaxUserWatches)
	populate(objectMap, "fsNrOpen", s.FsNrOpen)
	populate(objectMap, "kernelThreadsMax", s.KernelThreadsMax)
	populate(objectMap, "netCoreNetdevMaxBacklog", s.NetCoreNetdevMaxBacklog)
	populate(objectMap, "netCoreOptmemMax", s.NetCoreOptmemMax)
	populate(objectMap, "netCoreRmemDefault", s.NetCoreRmemDefault)
	populate(objectMap, "netCoreRmemMax", s.NetCoreRmemMax)
	populate(objectMap, "netCoreSomaxconn", s.NetCoreSomaxconn)
	populate(objectMap, "netCoreWmemDefault", s.NetCoreWmemDefault)
	populate(objectMap, "netCoreWmemMax", s.NetCoreWmemMax)
	populate(objectMap, "netIpv4IpLocalPortRange", s.NetIPv4IPLocalPortRange)
	populate(objectMap, "netIpv4NeighDefaultGcThresh1", s.NetIPv4NeighDefaultGcThresh1)
	populate(objectMap, "netIpv4NeighDefaultGcThresh2", s.NetIPv4NeighDefaultGcThresh2)
	populate(objectMap, "netIpv4NeighDefaultGcThresh3", s.NetIPv4NeighDefaultGcThresh3)
	populate(objectMap, "netIpv4TcpFinTimeout", s.NetIPv4TCPFinTimeout)
	populate(objectMap, "netIpv4TcpKeepaliveProbes", s.NetIPv4TCPKeepaliveProbes)
	populate(objectMap, "netIpv4TcpKeepaliveTime", s.NetIPv4TCPKeepaliveTime)
	populate(objectMap, "netIpv4TcpMaxSynBacklog", s.NetIPv4TCPMaxSynBacklog)
	populate(objectMap, "netIpv4TcpMaxTwBuckets", s.NetIPv4TCPMaxTwBuckets)
	populate(objectMap, "netIpv4TcpTwReuse", s.NetIPv4TCPTwReuse)
	populate(objectMap, "netIpv4TcpkeepaliveIntvl", s.NetIPv4TcpkeepaliveIntvl)
	populate(objectMap, "netNetfilterNfConntrackBuckets", s.NetNetfilterNfConntrackBuckets)
	populate(objectMap, "netNetfilterNfConntrackMax", s.NetNetfilterNfConntrackMax)
	populate(objectMap, "vmMaxMapCount", s.VMMaxMapCount)
	populate(objectMap, "vmSwappiness", s.VMSwappiness)
	populate(objectMap, "vmVfsCachePressure", s.VMVfsCachePressure)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SysctlConfig.
func (s *SysctlConfig) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "fsAioMaxNr":
			err = unpopulate(val, "FsAioMaxNr", &s.FsAioMaxNr)
			delete(rawMsg, key)
		case "fsFileMax":
			err = unpopulate(val, "FsFileMax", &s.FsFileMax)
			delete(rawMsg, key)
		case "fsInotifyMaxUserWatches":
			err = unpopulate(val, "FsInotifyMaxUserWatches", &s.FsInotifyMaxUserWatches)
			delete(rawMsg, key)
		case "fsNrOpen":
			err = unpopulate(val, "FsNrOpen", &s.FsNrOpen)
			delete(rawMsg, key)
		case "kernelThreadsMax":
			err = unpopulate(val, "KernelThreadsMax", &s.KernelThreadsMax)
			delete(rawMsg, key)
		case "netCoreNetdevMaxBacklog":
			err = unpopulate(val, "NetCoreNetdevMaxBacklog", &s.NetCoreNetdevMaxBacklog)
			delete(rawMsg, key)
		case "netCoreOptmemMax":
			err = unpopulate(val, "NetCoreOptmemMax", &s.NetCoreOptmemMax)
			delete(rawMsg, key)
		case "netCoreRmemDefault":
			err = unpopulate(val, "NetCoreRmemDefault", &s.NetCoreRmemDefault)
			delete(rawMsg, key)
		case "netCoreRmemMax":
			err = unpopulate(val, "NetCoreRmemMax", &s.NetCoreRmemMax)
			delete(rawMsg, key)
		case "netCoreSomaxconn":
			err = unpopulate(val, "NetCoreSomaxconn", &s.NetCoreSomaxconn)
			delete(rawMsg, key)
		case "netCoreWmemDefault":
			err = unpopulate(val, "NetCoreWmemDefault", &s.NetCoreWmemDefault)
			delete(rawMsg, key)
		case "netCoreWmemMax":
			err = unpopulate(val, "NetCoreWmemMax", &s.NetCoreWmemMax)
			delete(rawMsg, key)
		case "netIpv4IpLocalPortRange":
			err = unpopulate(val, "NetIPv4IPLocalPortRange", &s.NetIPv4IPLocalPortRange)
			delete(rawMsg, key)
		case "netIpv4NeighDefaultGcThresh1":
			err = unpopulate(val, "NetIPv4NeighDefaultGcThresh1", &s.NetIPv4NeighDefaultGcThresh1)
			delete(rawMsg, key)
		case "netIpv4NeighDefaultGcThresh2":
			err = unpopulate(val, "NetIPv4NeighDefaultGcThresh2", &s.NetIPv4NeighDefaultGcThresh2)
			delete(rawMsg, key)
		case "netIpv4NeighDefaultGcThresh3":
			err = unpopulate(val, "NetIPv4NeighDefaultGcThresh3", &s.NetIPv4NeighDefaultGcThresh3)
			delete(rawMsg, key)
		case "netIpv4TcpFinTimeout":
			err = unpopulate(val, "NetIPv4TCPFinTimeout", &s.NetIPv4TCPFinTimeout)
			delete(rawMsg, key)
		case "netIpv4TcpKeepaliveProbes":
			err = unpopulate(val, "NetIPv4TCPKeepaliveProbes", &s.NetIPv4TCPKeepaliveProbes)
			delete(rawMsg, key)
		case "netIpv4TcpKeepaliveTime":
			err = unpopulate(val, "NetIPv4TCPKeepaliveTime", &s.NetIPv4TCPKeepaliveTime)
			delete(rawMsg, key)
		case "netIpv4TcpMaxSynBacklog":
			err = unpopulate(val, "NetIPv4TCPMaxSynBacklog", &s.NetIPv4TCPMaxSynBacklog)
			delete(rawMsg, key)
		case "netIpv4TcpMaxTwBuckets":
			err = unpopulate(val, "NetIPv4TCPMaxTwBuckets", &s.NetIPv4TCPMaxTwBuckets)
			delete(rawMsg, key)
		case "netIpv4TcpTwReuse":
			err = unpopulate(val, "NetIPv4TCPTwReuse", &s.NetIPv4TCPTwReuse)
			delete(rawMsg, key)
		case "netIpv4TcpkeepaliveIntvl":
			err = unpopulate(val, "NetIPv4TcpkeepaliveIntvl", &s.NetIPv4TcpkeepaliveIntvl)
			delete(rawMsg, key)
		case "netNetfilterNfConntrackBuckets":
			err = unpopulate(val, "NetNetfilterNfConntrackBuckets", &s.NetNetfilterNfConntrackBuckets)
			delete(rawMsg, key)
		case "netNetfilterNfConntrackMax":
			err = unpopulate(val, "NetNetfilterNfConntrackMax", &s.NetNetfilterNfConntrackMax)
			delete(rawMsg, key)
		case "vmMaxMapCount":
			err = unpopulate(val, "VMMaxMapCount", &s.VMMaxMapCount)
			delete(rawMsg, key)
		case "vmSwappiness":
			err = unpopulate(val, "VMSwappiness", &s.VMSwappiness)
			delete(rawMsg, key)
		case "vmVfsCachePressure":
			err = unpopulate(val, "VMVfsCachePressure", &s.VMVfsCachePressure)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type SystemData.
func (s SystemData) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "createdAt", s.CreatedAt)
	populate(objectMap, "createdBy", s.CreatedBy)
	populate(objectMap, "createdByType", s.CreatedByType)
	populateDateTimeRFC3339(objectMap, "lastModifiedAt", s.LastModifiedAt)
	populate(objectMap, "lastModifiedBy", s.LastModifiedBy)
	populate(objectMap, "lastModifiedByType", s.LastModifiedByType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type SystemData.
func (s *SystemData) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", s, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "createdAt":
			err = unpopulateDateTimeRFC3339(val, "CreatedAt", &s.CreatedAt)
			delete(rawMsg, key)
		case "createdBy":
			err = unpopulate(val, "CreatedBy", &s.CreatedBy)
			delete(rawMsg, key)
		case "createdByType":
			err = unpopulate(val, "CreatedByType", &s.CreatedByType)
			delete(rawMsg, key)
		case "lastModifiedAt":
			err = unpopulateDateTimeRFC3339(val, "LastModifiedAt", &s.LastModifiedAt)
			delete(rawMsg, key)
		case "lastModifiedBy":
			err = unpopulate(val, "LastModifiedBy", &s.LastModifiedBy)
			delete(rawMsg, key)
		case "lastModifiedByType":
			err = unpopulate(val, "LastModifiedByType", &s.LastModifiedByType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", s, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TagsObject.
func (t TagsObject) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "tags", t.Tags)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TagsObject.
func (t *TagsObject) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "tags":
			err = unpopulate(val, "Tags", &t.Tags)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeInWeek.
func (t TimeInWeek) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "day", t.Day)
	populate(objectMap, "hourSlots", t.HourSlots)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeInWeek.
func (t *TimeInWeek) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "day":
			err = unpopulate(val, "Day", &t.Day)
			delete(rawMsg, key)
		case "hourSlots":
			err = unpopulate(val, "HourSlots", &t.HourSlots)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TimeSpan.
func (t TimeSpan) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populateDateTimeRFC3339(objectMap, "end", t.End)
	populateDateTimeRFC3339(objectMap, "start", t.Start)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TimeSpan.
func (t *TimeSpan) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "end":
			err = unpopulateDateTimeRFC3339(val, "End", &t.End)
			delete(rawMsg, key)
		case "start":
			err = unpopulateDateTimeRFC3339(val, "Start", &t.Start)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrustedAccessRole.
func (t TrustedAccessRole) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "rules", t.Rules)
	populate(objectMap, "sourceResourceType", t.SourceResourceType)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrustedAccessRole.
func (t *TrustedAccessRole) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "rules":
			err = unpopulate(val, "Rules", &t.Rules)
			delete(rawMsg, key)
		case "sourceResourceType":
			err = unpopulate(val, "SourceResourceType", &t.SourceResourceType)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrustedAccessRoleBinding.
func (t TrustedAccessRoleBinding) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "id", t.ID)
	populate(objectMap, "name", t.Name)
	populate(objectMap, "properties", t.Properties)
	populate(objectMap, "systemData", t.SystemData)
	populate(objectMap, "type", t.Type)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrustedAccessRoleBinding.
func (t *TrustedAccessRoleBinding) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &t.ID)
			delete(rawMsg, key)
		case "name":
			err = unpopulate(val, "Name", &t.Name)
			delete(rawMsg, key)
		case "properties":
			err = unpopulate(val, "Properties", &t.Properties)
			delete(rawMsg, key)
		case "systemData":
			err = unpopulate(val, "SystemData", &t.SystemData)
			delete(rawMsg, key)
		case "type":
			err = unpopulate(val, "Type", &t.Type)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrustedAccessRoleBindingListResult.
func (t TrustedAccessRoleBindingListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrustedAccessRoleBindingListResult.
func (t *TrustedAccessRoleBindingListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrustedAccessRoleBindingProperties.
func (t TrustedAccessRoleBindingProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "provisioningState", t.ProvisioningState)
	populate(objectMap, "roles", t.Roles)
	populate(objectMap, "sourceResourceId", t.SourceResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrustedAccessRoleBindingProperties.
func (t *TrustedAccessRoleBindingProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &t.ProvisioningState)
			delete(rawMsg, key)
		case "roles":
			err = unpopulate(val, "Roles", &t.Roles)
			delete(rawMsg, key)
		case "sourceResourceId":
			err = unpopulate(val, "SourceResourceID", &t.SourceResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrustedAccessRoleListResult.
func (t TrustedAccessRoleListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "nextLink", t.NextLink)
	populate(objectMap, "value", t.Value)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrustedAccessRoleListResult.
func (t *TrustedAccessRoleListResult) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "nextLink":
			err = unpopulate(val, "NextLink", &t.NextLink)
			delete(rawMsg, key)
		case "value":
			err = unpopulate(val, "Value", &t.Value)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type TrustedAccessRoleRule.
func (t TrustedAccessRoleRule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "apiGroups", t.APIGroups)
	populate(objectMap, "nonResourceURLs", t.NonResourceURLs)
	populate(objectMap, "resourceNames", t.ResourceNames)
	populate(objectMap, "resources", t.Resources)
	populate(objectMap, "verbs", t.Verbs)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type TrustedAccessRoleRule.
func (t *TrustedAccessRoleRule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", t, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "apiGroups":
			err = unpopulate(val, "APIGroups", &t.APIGroups)
			delete(rawMsg, key)
		case "nonResourceURLs":
			err = unpopulate(val, "NonResourceURLs", &t.NonResourceURLs)
			delete(rawMsg, key)
		case "resourceNames":
			err = unpopulate(val, "ResourceNames", &t.ResourceNames)
			delete(rawMsg, key)
		case "resources":
			err = unpopulate(val, "Resources", &t.Resources)
			delete(rawMsg, key)
		case "verbs":
			err = unpopulate(val, "Verbs", &t.Verbs)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", t, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UpgradeOverrideSettings.
func (u UpgradeOverrideSettings) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "forceUpgrade", u.ForceUpgrade)
	populateDateTimeRFC3339(objectMap, "until", u.Until)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UpgradeOverrideSettings.
func (u *UpgradeOverrideSettings) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "forceUpgrade":
			err = unpopulate(val, "ForceUpgrade", &u.ForceUpgrade)
			delete(rawMsg, key)
		case "until":
			err = unpopulateDateTimeRFC3339(val, "Until", &u.Until)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type UserAssignedIdentity.
func (u UserAssignedIdentity) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "clientId", u.ClientID)
	populate(objectMap, "objectId", u.ObjectID)
	populate(objectMap, "resourceId", u.ResourceID)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type UserAssignedIdentity.
func (u *UserAssignedIdentity) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", u, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "clientId":
			err = unpopulate(val, "ClientID", &u.ClientID)
			delete(rawMsg, key)
		case "objectId":
			err = unpopulate(val, "ObjectID", &u.ObjectID)
			delete(rawMsg, key)
		case "resourceId":
			err = unpopulate(val, "ResourceID", &u.ResourceID)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", u, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WeeklySchedule.
func (w WeeklySchedule) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dayOfWeek", w.DayOfWeek)
	populate(objectMap, "intervalWeeks", w.IntervalWeeks)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WeeklySchedule.
func (w *WeeklySchedule) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dayOfWeek":
			err = unpopulate(val, "DayOfWeek", &w.DayOfWeek)
			delete(rawMsg, key)
		case "intervalWeeks":
			err = unpopulate(val, "IntervalWeeks", &w.IntervalWeeks)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type WindowsGmsaProfile.
func (w WindowsGmsaProfile) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]any)
	populate(objectMap, "dnsServer", w.DNSServer)
	populate(objectMap, "enabled", w.Enabled)
	populate(objectMap, "rootDomainName", w.RootDomainName)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type WindowsGmsaProfile.
func (w *WindowsGmsaProfile) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", w, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "dnsServer":
			err = unpopulate(val, "DNSServer", &w.DNSServer)
			delete(rawMsg, key)
		case "enabled":
			err = unpopulate(val, "Enabled", &w.Enabled)
			delete(rawMsg, key)
		case "rootDomainName":
			err = unpopulate(val, "RootDomainName", &w.RootDomainName)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", w, err)
		}
	}
	return nil
}

func populate(m map[string]any, k string, v any) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func populateByteArray[T any](m map[string]any, k string, b []T, convert func() any) {
	if azcore.IsNullValue(b) {
		m[k] = nil
	} else if len(b) == 0 {
		return
	} else {
		m[k] = convert()
	}
}

func unpopulate(data json.RawMessage, fn string, v any) error {
	if data == nil || string(data) == "null" {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
