// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetapp

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	subscriptionID string
	internal       *arm.Client
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	internal, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		subscriptionID: subscriptionID,
		internal:       internal,
	}, nil
}

// NewAccountsClient creates a new instance of AccountsClient.
func (c *ClientFactory) NewAccountsClient() *AccountsClient {
	return &AccountsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupPoliciesClient creates a new instance of BackupPoliciesClient.
func (c *ClientFactory) NewBackupPoliciesClient() *BackupPoliciesClient {
	return &BackupPoliciesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupVaultsClient creates a new instance of BackupVaultsClient.
func (c *ClientFactory) NewBackupVaultsClient() *BackupVaultsClient {
	return &BackupVaultsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupsClient creates a new instance of BackupsClient.
func (c *ClientFactory) NewBackupsClient() *BackupsClient {
	return &BackupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupsUnderAccountClient creates a new instance of BackupsUnderAccountClient.
func (c *ClientFactory) NewBackupsUnderAccountClient() *BackupsUnderAccountClient {
	return &BackupsUnderAccountClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupsUnderBackupVaultClient creates a new instance of BackupsUnderBackupVaultClient.
func (c *ClientFactory) NewBackupsUnderBackupVaultClient() *BackupsUnderBackupVaultClient {
	return &BackupsUnderBackupVaultClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewBackupsUnderVolumeClient creates a new instance of BackupsUnderVolumeClient.
func (c *ClientFactory) NewBackupsUnderVolumeClient() *BackupsUnderVolumeClient {
	return &BackupsUnderVolumeClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewOperationsClient creates a new instance of OperationsClient.
func (c *ClientFactory) NewOperationsClient() *OperationsClient {
	return &OperationsClient{
		internal: c.internal,
	}
}

// NewPoolsClient creates a new instance of PoolsClient.
func (c *ClientFactory) NewPoolsClient() *PoolsClient {
	return &PoolsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewResourceClient creates a new instance of ResourceClient.
func (c *ClientFactory) NewResourceClient() *ResourceClient {
	return &ResourceClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewResourceQuotaLimitsClient creates a new instance of ResourceQuotaLimitsClient.
func (c *ClientFactory) NewResourceQuotaLimitsClient() *ResourceQuotaLimitsClient {
	return &ResourceQuotaLimitsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewResourceRegionInfosClient creates a new instance of ResourceRegionInfosClient.
func (c *ClientFactory) NewResourceRegionInfosClient() *ResourceRegionInfosClient {
	return &ResourceRegionInfosClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewResourceUsagesClient creates a new instance of ResourceUsagesClient.
func (c *ClientFactory) NewResourceUsagesClient() *ResourceUsagesClient {
	return &ResourceUsagesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSnapshotPoliciesClient creates a new instance of SnapshotPoliciesClient.
func (c *ClientFactory) NewSnapshotPoliciesClient() *SnapshotPoliciesClient {
	return &SnapshotPoliciesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSnapshotsClient creates a new instance of SnapshotsClient.
func (c *ClientFactory) NewSnapshotsClient() *SnapshotsClient {
	return &SnapshotsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewSubvolumesClient creates a new instance of SubvolumesClient.
func (c *ClientFactory) NewSubvolumesClient() *SubvolumesClient {
	return &SubvolumesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewVolumeGroupsClient creates a new instance of VolumeGroupsClient.
func (c *ClientFactory) NewVolumeGroupsClient() *VolumeGroupsClient {
	return &VolumeGroupsClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewVolumeQuotaRulesClient creates a new instance of VolumeQuotaRulesClient.
func (c *ClientFactory) NewVolumeQuotaRulesClient() *VolumeQuotaRulesClient {
	return &VolumeQuotaRulesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}

// NewVolumesClient creates a new instance of VolumesClient.
func (c *ClientFactory) NewVolumesClient() *VolumesClient {
	return &VolumesClient{
		subscriptionID: c.subscriptionID,
		internal:       c.internal,
	}
}
