// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetapp

import "time"

// Account - NetApp account resource
type Account struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// The identity used for the resource.
	Identity *ManagedServiceIdentity

	// NetApp Account properties
	Properties *AccountProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// AccountEncryption - Encryption settings
type AccountEncryption struct {
	// Identity used to authenticate to KeyVault. Applicable if keySource is 'Microsoft.KeyVault'.
	Identity *EncryptionIdentity

	// The encryption keySource (provider). Possible values (case-insensitive): Microsoft.NetApp, Microsoft.KeyVault
	KeySource *KeySource

	// Properties provided by KeVault. Applicable if keySource is 'Microsoft.KeyVault'.
	KeyVaultProperties *KeyVaultProperties
}

// AccountList - List of NetApp account resources
type AccountList struct {
	// URL to get the next set of results.
	NextLink *string

	// Multiple NetApp accounts
	Value []*Account
}

// AccountPatch - NetApp account patch resource
type AccountPatch struct {
	// The identity used for the resource.
	Identity *ManagedServiceIdentity

	// Resource location
	Location *string

	// NetApp Account properties
	Properties *AccountProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// AccountProperties - NetApp account properties
type AccountProperties struct {
	// Active Directories
	ActiveDirectories []*ActiveDirectory

	// Encryption settings
	Encryption *AccountEncryption

	// Domain for NFSv4 user ID mapping. This property will be set for all NetApp accounts in the subscription and region and
	// only affect non ldap NFSv4 volumes.
	NfsV4IDDomain *string

	// READ-ONLY; Shows the status of disableShowmount for all volumes under the subscription, null equals false
	DisableShowmount *bool

	// READ-ONLY; MultiAD Status for the account
	MultiAdStatus *MultiAdStatus

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string
}

// ActiveDirectory - Active Directory
type ActiveDirectory struct {
	// Id of the Active Directory
	ActiveDirectoryID *string

	// Name of the active directory machine. This optional parameter is used only while creating kerberos volume
	AdName *string

	// Users to be added to the Built-in Administrators active directory group. A list of unique usernames without domain specifier
	Administrators []*string

	// If enabled, AES encryption will be enabled for SMB communication.
	AesEncryption *bool

	// If enabled, NFS client local users can also (in addition to LDAP users) access the NFS volumes.
	AllowLocalNfsUsersWithLdap *bool

	// Users to be added to the Built-in Backup Operator active directory group. A list of unique usernames without domain specifier
	BackupOperators []*string

	// Comma separated list of DNS server IP addresses (IPv4 only) for the Active Directory domain
	DNS *string

	// Name of the Active Directory domain
	Domain *string

	// If enabled, Traffic between the SMB server to Domain Controller (DC) will be encrypted.
	EncryptDCConnections *bool

	// kdc server IP address for the active directory machine. This optional parameter is used only while creating kerberos volume.
	KdcIP *string

	// Specifies whether or not the LDAP traffic needs to be secured via TLS.
	LdapOverTLS *bool

	// LDAP Search scope options
	LdapSearchScope *LdapSearchScopeOpt

	// Specifies whether or not the LDAP traffic needs to be signed.
	LdapSigning *bool

	// The Organizational Unit (OU) within the Windows Active Directory
	OrganizationalUnit *string

	// Plain text password of Active Directory domain administrator, value is masked in the response
	Password *string

	// Comma separated list of IPv4 addresses of preferred servers for LDAP client. At most two comma separated IPv4 addresses
	// can be passed.
	PreferredServersForLdapClient *string

	// Domain Users in the Active directory to be given SeSecurityPrivilege privilege (Needed for SMB Continuously available shares
	// for SQL). A list of unique usernames without domain specifier
	SecurityOperators []*string

	// When LDAP over SSL/TLS is enabled, the LDAP client is required to have base64 encoded Active Directory Certificate Service's
	// self-signed root CA certificate, this optional parameter is used only for
	// dual protocol with LDAP user-mapping volumes.
	ServerRootCACertificate *string

	// The Active Directory site the service will limit Domain Controller discovery to
	Site *string

	// NetBIOS name of the SMB server. This name will be registered as a computer account in the AD and used to mount volumes
	SmbServerName *string

	// A domain user account with permission to create machine accounts
	Username *string

	// READ-ONLY; Status of the Active Directory
	Status *ActiveDirectoryStatus

	// READ-ONLY; Any details in regards to the Status of the Active Directory
	StatusDetails *string
}

// AuthorizeRequest - Authorize request
type AuthorizeRequest struct {
	// Resource id of the remote volume
	RemoteVolumeResourceID *string
}

// Backup under a Backup Vault
type Backup struct {
	// REQUIRED; Backup Properties
	Properties *BackupProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BackupPatch - Backup patch
type BackupPatch struct {
	// Backup Patch Properties
	Properties *BackupPatchProperties
}

// BackupPatchProperties - Backup patch properties
type BackupPatchProperties struct {
	// Label for backup
	Label *string
}

// BackupPoliciesList - List of Backup Policies
type BackupPoliciesList struct {
	// A list of backup policies
	Value []*BackupPolicy
}

// BackupPolicy - Backup policy information
type BackupPolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Backup policy Properties
	Properties *BackupPolicyProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BackupPolicyPatch - Backup policy Details for create and update
type BackupPolicyPatch struct {
	// Resource location
	Location *string

	// Backup policy Properties
	Properties *BackupPolicyProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// BackupPolicyProperties - Backup policy properties
type BackupPolicyProperties struct {
	// Daily backups count to keep
	DailyBackupsToKeep *int32

	// The property to decide policy is enabled or not
	Enabled *bool

	// Monthly backups count to keep
	MonthlyBackupsToKeep *int32

	// Weekly backups count to keep
	WeeklyBackupsToKeep *int32

	// READ-ONLY; Backup Policy GUID ID
	BackupPolicyID *string

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string

	// READ-ONLY; A list of volumes assigned to this policy
	VolumeBackups []*VolumeBackups

	// READ-ONLY; Volumes using current backup policy
	VolumesAssigned *int32
}

// BackupProperties - Backup properties
type BackupProperties struct {
	// REQUIRED; ResourceId used to identify the Volume
	VolumeResourceID *string

	// Label for backup
	Label *string

	// The name of the snapshot
	SnapshotName *string

	// Manual backup an already existing snapshot. This will always be false for scheduled backups and true/false for manual backups
	UseExistingSnapshot *bool

	// READ-ONLY; UUID v4 used to identify the Backup
	BackupID *string

	// READ-ONLY; ResourceId used to identify the backup policy
	BackupPolicyResourceID *string

	// READ-ONLY; Type of backup Manual or Scheduled
	BackupType *BackupType

	// READ-ONLY; The completion date of the backup
	CompletionDate *time.Time

	// READ-ONLY; The creation date of the backup
	CreationDate *time.Time

	// READ-ONLY; Failure reason
	FailureReason *string

	// READ-ONLY; Specifies if the backup is for a large volume.
	IsLargeVolume *bool

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string

	// READ-ONLY; Size of backup in bytes
	Size *int64

	// READ-ONLY; The snapshot creation date of the backup
	SnapshotCreationDate *time.Time
}

// BackupRestoreFiles - Restore payload for Single File Backup Restore
type BackupRestoreFiles struct {
	// REQUIRED; Resource Id of the destination volume on which the files need to be restored
	DestinationVolumeID *string

	// REQUIRED; List of files to be restored
	FileList []*string

	// Destination folder where the files will be restored. The path name should start with a forward slash. If it is omitted
	// from request then restore is done at the root folder of the destination volume by
	// default
	RestoreFilePath *string
}

// BackupStatus - Backup status
type BackupStatus struct {
	// READ-ONLY; Displays error message if the backup is in an error state
	ErrorMessage *string

	// READ-ONLY; Backup health status
	Healthy *bool

	// READ-ONLY; Displays the last transfer size
	LastTransferSize *int64

	// READ-ONLY; Displays the last transfer type
	LastTransferType *string

	// READ-ONLY; The status of the backup
	MirrorState *MirrorState

	// READ-ONLY; Status of the backup mirror relationship
	RelationshipStatus *RelationshipStatus

	// READ-ONLY; Displays the total bytes transferred
	TotalTransferBytes *int64

	// READ-ONLY; Displays the total number of bytes transferred for the ongoing operation
	TransferProgressBytes *int64

	// READ-ONLY; Reason for the unhealthy backup relationship
	UnhealthyReason *string
}

// BackupVault - Backup Vault information
type BackupVault struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Backup Vault Properties
	Properties *BackupVaultProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// BackupVaultPatch - Backup Vault information
type BackupVaultPatch struct {
	// Resource tags
	Tags map[string]*string
}

// BackupVaultProperties - Backup Vault properties
type BackupVaultProperties struct {
	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string
}

// BackupVaultsList - List of Backup Vaults
type BackupVaultsList struct {
	// URL to get the next set of results.
	NextLink *string

	// A list of Backup Vaults
	Value []*BackupVault
}

// BackupsList - List of Backups
type BackupsList struct {
	// URL to get the next set of results.
	NextLink *string

	// A list of Backups
	Value []*Backup
}

// BackupsMigrationRequest - Migrate Backups Request
type BackupsMigrationRequest struct {
	// REQUIRED; The ResourceId of the Backup Vault
	BackupVaultID *string
}

// BreakFileLocksRequest - Break file locks request
type BreakFileLocksRequest struct {
	// To clear file locks on a volume for a particular client
	ClientIP *string

	// Break File locks could be a disruptive operation for application as locks on the volume will be broken, if want to process,
	// set to true.
	ConfirmRunningDisruptiveOperation *bool
}

// BreakReplicationRequest - Break replication request
type BreakReplicationRequest struct {
	// If replication is in status transferring and you want to force break the replication, set to true
	ForceBreakReplication *bool
}

// CapacityPool - Capacity pool resource
type CapacityPool struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Capacity pool properties
	Properties *PoolProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// CapacityPoolList - List of capacity pool resources
type CapacityPoolList struct {
	// URL to get the next set of results.
	NextLink *string

	// List of Capacity pools
	Value []*CapacityPool
}

// CapacityPoolPatch - Capacity pool patch resource
type CapacityPoolPatch struct {
	// Resource location
	Location *string

	// Capacity pool properties
	Properties *PoolPatchProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// ChangeKeyVault - Change key vault request
type ChangeKeyVault struct {
	// REQUIRED; The name of the key that should be used for encryption.
	KeyName *string

	// REQUIRED; Pairs of virtual network ID and private endpoint ID. Every virtual network that has volumes encrypted with customer-managed
	// keys needs its own key vault private endpoint.
	KeyVaultPrivateEndpoints []*KeyVaultPrivateEndpoint

	// REQUIRED; The URI of the key vault/managed HSM that should be used for encryption.
	KeyVaultURI *string

	// Azure resource ID of the key vault/managed HSM that should be used for encryption.
	KeyVaultResourceID *string
}

// CheckAvailabilityResponse - Information regarding availability of a resource.
type CheckAvailabilityResponse struct {
	// true indicates name is valid and available. false indicates the name is invalid, unavailable, or both.
	IsAvailable *bool

	// If reason == invalid, provide the user with the reason why the given name is invalid, and provide the resource naming requirements
	// so that the user can select a valid name. If reason == AlreadyExists,
	// explain that resource name is already in use, and direct them to select a different name.
	Message *string

	// Invalid indicates the name provided does not match Azure App Service naming requirements. AlreadyExists indicates that
	// the name is already in use and is therefore unavailable.
	Reason *InAvailabilityReasonType
}

// ClusterPeerCommandResponse - Information about cluster peering process
type ClusterPeerCommandResponse struct {
	// A command that needs to be run on the external ONTAP to accept cluster peering. Will only be present if clusterPeeringStatus
	// is pending
	PeerAcceptCommand *string
}

// DailySchedule - Daily Schedule properties
type DailySchedule struct {
	// Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32

	// Indicates which minute snapshot should be taken
	Minute *int32

	// Daily snapshot count to keep
	SnapshotsToKeep *int32

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64
}

// DestinationReplication - Destination replication properties
type DestinationReplication struct {
	// The remote region for the destination volume.
	Region *string

	// Indicates whether the replication is cross zone or cross region.
	ReplicationType *ReplicationType

	// The resource ID of the remote volume
	ResourceID *string

	// The remote zone for the destination volume.
	Zone *string
}

// Dimension of blobs, possibly be blob type or access tier.
type Dimension struct {
	// Display name of dimension.
	DisplayName *string

	// Display name of dimension.
	Name *string
}

// EncryptionIdentity - Identity used to authenticate with key vault.
type EncryptionIdentity struct {
	// ClientId of the multi-tenant AAD Application. Used to access cross-tenant keyvaults.
	FederatedClientID *string

	// The ARM resource identifier of the user assigned identity used to authenticate with key vault. Applicable if identity.type
	// has 'UserAssigned'. It should match key of identity.userAssignedIdentities.
	UserAssignedIdentity *string

	// READ-ONLY; The principal ID (object ID) of the identity used to authenticate with key vault. Read-only.
	PrincipalID *string
}

// EncryptionTransitionRequest - Encryption transition request
type EncryptionTransitionRequest struct {
	// REQUIRED; Identifier of the private endpoint to reach the Azure Key Vault
	PrivateEndpointID *string

	// REQUIRED; Identifier for the virtual network
	VirtualNetworkID *string
}

// ExportPolicyRule - Volume Export Policy Rule
type ExportPolicyRule struct {
	// Client ingress specification as comma separated string with IPv4 CIDRs, IPv4 host addresses and host names
	AllowedClients *string

	// This parameter specifies who is authorized to change the ownership of a file. restricted - Only root user can change the
	// ownership of the file. unrestricted - Non-root users can change ownership of
	// files that they own.
	ChownMode *ChownMode

	// Allows CIFS protocol
	Cifs *bool

	// Has root access to volume
	HasRootAccess *bool

	// Kerberos5i Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5IReadOnly *bool

	// Kerberos5i Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5IReadWrite *bool

	// Kerberos5p Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5PReadOnly *bool

	// Kerberos5p Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5PReadWrite *bool

	// Kerberos5 Read only access. To be use with swagger version 2020-05-01 or later
	Kerberos5ReadOnly *bool

	// Kerberos5 Read and write access. To be use with swagger version 2020-05-01 or later
	Kerberos5ReadWrite *bool

	// Allows NFSv3 protocol. Enable only for NFSv3 type volumes
	Nfsv3 *bool

	// Allows NFSv4.1 protocol. Enable only for NFSv4.1 type volumes
	Nfsv41 *bool

	// Order index
	RuleIndex *int32

	// Read only access
	UnixReadOnly *bool

	// Read and write access
	UnixReadWrite *bool
}

// FilePathAvailabilityRequest - File path availability request content - availability is based on the name and the subnetId.
type FilePathAvailabilityRequest struct {
	// REQUIRED; File path to verify.
	Name *string

	// REQUIRED; The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string

	// The Azure Resource logical availability zone which is used within zone mapping lookup for the subscription and region.
	// The lookup will retrieve the physical zone where volume is placed.
	AvailabilityZone *string
}

// GetGroupIDListForLDAPUserRequest - Get group Id list for LDAP User request
type GetGroupIDListForLDAPUserRequest struct {
	// REQUIRED; username is required to fetch the group to which user is part of
	Username *string
}

// GetGroupIDListForLDAPUserResponse - Group Id list for Ldap user
type GetGroupIDListForLDAPUserResponse struct {
	// Group Id list
	GroupIDsForLdapUser []*string
}

// GetKeyVaultStatusResponse - Result of getKeyVaultStatus with information about how volumes under NetApp account are encrypted.
type GetKeyVaultStatusResponse struct {
	// Represents the properties of the getKeyVaultStatus.
	Properties *GetKeyVaultStatusResponseProperties
}

// GetKeyVaultStatusResponseProperties - Properties which represents Change key vault status.
type GetKeyVaultStatusResponseProperties struct {
	// The name of the key that should be used for encryption.
	KeyName *string

	// Pairs of virtual network ID and private endpoint ID. Every virtual network that has volumes encrypted with customer-managed
	// keys needs its own key vault private endpoint.
	KeyVaultPrivateEndpoints []*KeyVaultPrivateEndpoint

	// Azure resource ID of the key vault/managed HSM that should be used for encryption.
	KeyVaultResourceID *string

	// The URI of the key vault/managed HSM that should be used for encryption.
	KeyVaultURI *string
}

// HourlySchedule - Hourly Schedule properties
type HourlySchedule struct {
	// Indicates which minute snapshot should be taken
	Minute *int32

	// Hourly snapshot count to keep
	SnapshotsToKeep *int32

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64
}

// KeyVaultPrivateEndpoint - Pairs of virtual network ID and private endpoint ID. Every virtual network that has volumes encrypted
// with customer-managed keys needs its own key vault private endpoint.
type KeyVaultPrivateEndpoint struct {
	// Identifier of the private endpoint to reach the Azure Key Vault
	PrivateEndpointID *string

	// Identifier for the virtual network id
	VirtualNetworkID *string
}

// KeyVaultProperties - Properties of key vault.
type KeyVaultProperties struct {
	// REQUIRED; The name of KeyVault key.
	KeyName *string

	// REQUIRED; The Uri of KeyVault.
	KeyVaultURI *string

	// The resource ID of KeyVault.
	KeyVaultResourceID *string

	// READ-ONLY; UUID v4 used to identify the Azure Key Vault configuration
	KeyVaultID *string

	// READ-ONLY; Status of the KeyVault connection.
	Status *KeyVaultStatus
}

// LdapSearchScopeOpt - LDAP search scope
type LdapSearchScopeOpt struct {
	// This specifies the group DN, which overrides the base DN for group lookups.
	GroupDN *string

	// This specifies the custom LDAP search filter to be used when looking up group membership from LDAP server.
	GroupMembershipFilter *string

	// This specifies the user DN, which overrides the base DN for user lookups.
	UserDN *string
}

// ListReplications - List Replications
type ListReplications struct {
	// A list of replications
	Value []*Replication
}

// LogSpecification - Log Definition of a single resource metric.
type LogSpecification struct {
	// Display name of log specification.
	DisplayName *string

	// Name of log specification.
	Name *string
}

// ManagedServiceIdentity - Managed service identity (system assigned and/or user assigned identities)
type ManagedServiceIdentity struct {
	// REQUIRED; Type of managed service identity (where both SystemAssigned and UserAssigned types are allowed).
	Type *ManagedServiceIdentityType

	// The set of user assigned identities associated with the resource. The userAssignedIdentities dictionary keys will be ARM
	// resource ids in the form:
	// '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
	// The dictionary values can be empty objects ({}) in
	// requests.
	UserAssignedIdentities map[string]*UserAssignedIdentity

	// READ-ONLY; The service principal ID of the system assigned identity. This property will only be provided for a system assigned
	// identity.
	PrincipalID *string

	// READ-ONLY; The tenant ID of the system assigned identity. This property will only be provided for a system assigned identity.
	TenantID *string
}

// MetricSpecification - Metric specification of operation.
type MetricSpecification struct {
	// Aggregation type could be Average.
	AggregationType *string

	// The category this metric specification belong to, could be Capacity.
	Category *string

	// Dimensions of blobs, including blob type and access tier.
	Dimensions []*Dimension

	// Display description of metric specification.
	DisplayDescription *string

	// Display name of metric specification.
	DisplayName *string

	// Whether or not the service is using regional MDM accounts.
	EnableRegionalMdmAccount *bool

	// The property to decide fill gap with zero or not.
	FillGapWithZero *bool

	// The internal metric name.
	InternalMetricName *string

	// Whether the metric is internal.
	IsInternal *bool

	// Name of metric specification.
	Name *string

	// Account Resource Id.
	ResourceIDDimensionNameOverride *string

	// The source MDM account.
	SourceMdmAccount *string

	// The source MDM namespace.
	SourceMdmNamespace *string

	// Support metric aggregation type.
	SupportedAggregationTypes []*MetricAggregationType

	// The supported time grain types for the metrics.
	SupportedTimeGrainTypes []*string

	// Unit could be Bytes or Count.
	Unit *string
}

// MonthlySchedule - Monthly Schedule properties
type MonthlySchedule struct {
	// Indicates which days of the month snapshot should be taken. A comma delimited string.
	DaysOfMonth *string

	// Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32

	// Indicates which minute snapshot should be taken
	Minute *int32

	// Monthly snapshot count to keep
	SnapshotsToKeep *int32

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64
}

// MountTargetProperties - Mount target properties
type MountTargetProperties struct {
	// REQUIRED; UUID v4 used to identify the MountTarget
	FileSystemID *string

	// The SMB server's Fully Qualified Domain Name, FQDN
	SmbServerFqdn *string

	// READ-ONLY; The mount target's IPv4 address
	IPAddress *string

	// READ-ONLY; UUID v4 used to identify the MountTarget
	MountTargetID *string
}

// NetworkSiblingSet - Describes the contents of a network sibling set.
type NetworkSiblingSet struct {
	// Network features available to the volume, or current state of update.
	NetworkFeatures *NetworkFeatures

	// Network Sibling Set ID for a group of volumes sharing networking resources in a subnet.
	NetworkSiblingSetID *string

	// Network sibling set state Id identifying the current state of the sibling set.
	NetworkSiblingSetStateID *string

	// List of NIC information
	NicInfoList []*NicInfo

	// The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes. Example
	// /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}
	SubnetID *string

	// READ-ONLY; Gets the status of the NetworkSiblingSet at the time the operation was called.
	ProvisioningState *NetworkSiblingSetProvisioningState
}

// NicInfo - NIC information and list of volumes for which the NIC has the primary mount ip address.
type NicInfo struct {
	// Volume resource Ids
	VolumeResourceIDs []*string

	// READ-ONLY; ipAddress
	IPAddress *string
}

// Operation - Microsoft.NetApp REST API operation definition.
type Operation struct {
	// Display metadata associated with the operation.
	Display *OperationDisplay

	// Operation name: {provider}/{resource}/{operation}
	Name *string

	// The origin of operations.
	Origin *string

	// Properties of operation, include metric specifications.
	Properties *OperationProperties
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// Operation description.
	Description *string

	// Type of operation: get, read, delete, etc.
	Operation *string

	// Service provider: Microsoft NetApp.
	Provider *string

	// Resource on which the operation is performed etc.
	Resource *string
}

// OperationListResult - Result of the request to list Cloud Volume operations. It contains a list of operations and a URL
// link to get the next set of results.
type OperationListResult struct {
	// List of Storage operations supported by the Storage resource provider.
	Value []*Operation

	// READ-ONLY; URL to get the next set of operation list results (if there are any).
	NextLink *string
}

// OperationProperties - Properties of operation, include metric specifications.
type OperationProperties struct {
	// One property of operation, include metric specifications.
	ServiceSpecification *ServiceSpecification
}

// PeerClusterForVolumeMigrationRequest - Source Cluster properties for a cluster peer request
type PeerClusterForVolumeMigrationRequest struct {
	// REQUIRED; A list of IC-LIF IPs that can be used to connect to the On-prem cluster
	PeerIPAddresses []*string
}

// PlacementKeyValuePairs - Application specific parameters for the placement of volumes in the volume group
type PlacementKeyValuePairs struct {
	// REQUIRED; Key for an application specific parameter for the placement of volumes in the volume group
	Key *string

	// REQUIRED; Value for an application specific parameter for the placement of volumes in the volume group
	Value *string
}

// PoolChangeRequest - Pool change request
type PoolChangeRequest struct {
	// REQUIRED; Resource id of the pool to move volume to
	NewPoolResourceID *string
}

// PoolPatchProperties - Patchable pool properties
type PoolPatchProperties struct {
	// If enabled (true) the pool can contain cool Access enabled volumes.
	CoolAccess *bool

	// The qos type of the pool
	QosType *QosType

	// Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiple of 1099511627776).
	Size *int64
}

// PoolProperties - Pool properties
type PoolProperties struct {
	// REQUIRED; The service level of the file system
	ServiceLevel *ServiceLevel

	// REQUIRED; Provisioned size of the pool (in bytes). Allowed values are in 1TiB chunks (value must be multiple of 1099511627776).
	Size *int64

	// If enabled (true) the pool can contain cool Access enabled volumes.
	CoolAccess *bool

	// Encryption type of the capacity pool, set encryption type for data at rest for this pool and all volumes in it. This value
	// can only be set when creating new pool.
	EncryptionType *EncryptionType

	// The qos type of the pool
	QosType *QosType

	// READ-ONLY; UUID v4 used to identify the Pool
	PoolID *string

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string

	// READ-ONLY; Total throughput of pool in MiB/s
	TotalThroughputMibps *float32

	// READ-ONLY; Utilized throughput of pool in MiB/s
	UtilizedThroughputMibps *float32
}

// QueryNetworkSiblingSetRequest - Network sibling set query.
type QueryNetworkSiblingSetRequest struct {
	// REQUIRED; Network Sibling Set ID for a group of volumes sharing networking resources in a subnet.
	NetworkSiblingSetID *string

	// REQUIRED; The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes. Example
	// /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}
	SubnetID *string
}

// QuotaAvailabilityRequest - Quota availability request content.
type QuotaAvailabilityRequest struct {
	// REQUIRED; Name of the resource to verify.
	Name *string

	// REQUIRED; Resource group name.
	ResourceGroup *string

	// REQUIRED; Resource type used for verification.
	Type *CheckQuotaNameResourceTypes
}

// ReestablishReplicationRequest - Re-establish request object supplied in the body of the operation.
type ReestablishReplicationRequest struct {
	// Resource id of the source volume for the replication
	SourceVolumeID *string
}

// RegionInfo - Provides region specific information.
type RegionInfo struct {
	// Provides logical availability zone mappings for the subscription for a region.
	AvailabilityZoneMappings []*RegionInfoAvailabilityZoneMappingsItem

	// Provides storage to network proximity information in the region.
	StorageToNetworkProximity *RegionStorageToNetworkProximity
}

type RegionInfoAvailabilityZoneMappingsItem struct {
	// Logical availability zone.
	AvailabilityZone *string

	// Available availability zone
	IsAvailable *bool
}

// RegionInfoResource - Information regarding regionInfo Item.
type RegionInfoResource struct {
	// regionInfo properties
	Properties *RegionInfo

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// RegionInfosList - List of regionInfo resources
type RegionInfosList struct {
	// URL to get the next set of results.
	NextLink *string

	// A list of regionInfo resources
	Value []*RegionInfoResource
}

// RelocateVolumeRequest - Relocate volume request
type RelocateVolumeRequest struct {
	// New creation token for the volume that controls the mount point name
	CreationToken *string
}

// RemotePath - The full path to a volume that is to be migrated into ANF. Required for Migration volumes
type RemotePath struct {
	// REQUIRED; The Path to a ONTAP Host
	ExternalHostName *string

	// REQUIRED; The name of a server on the ONTAP Host
	ServerName *string

	// REQUIRED; The name of a volume on the server
	VolumeName *string
}

// Replication properties
type Replication struct {
	// REQUIRED; The resource ID of the remote volume.
	RemoteVolumeResourceID *string

	// Indicates whether the local volume is the source or destination for the Volume Replication
	EndpointType *EndpointType

	// The remote region for the other end of the Volume Replication.
	RemoteVolumeRegion *string

	// Schedule
	ReplicationSchedule *ReplicationSchedule

	// READ-ONLY; UUID v4 used to identify the replication.
	ReplicationID *string
}

// ReplicationObject - Replication properties
type ReplicationObject struct {
	// Indicates whether the local volume is the source or destination for the Volume Replication
	EndpointType *EndpointType

	// The full path to a volume that is to be migrated into ANF. Required for Migration volumes
	RemotePath *RemotePath

	// The remote region for the other end of the Volume Replication.
	RemoteVolumeRegion *string

	// The resource ID of the remote volume. Required for cross region and cross zone replication
	RemoteVolumeResourceID *string

	// Schedule
	ReplicationSchedule *ReplicationSchedule

	// READ-ONLY; A list of destination replications
	DestinationReplications []*DestinationReplication

	// READ-ONLY; Id
	ReplicationID *string
}

// ReplicationStatus - Replication status
type ReplicationStatus struct {
	// Displays error message if the replication is in an error state
	ErrorMessage *string

	// Replication health check
	Healthy *bool

	// The status of the replication
	MirrorState *MirrorState

	// Status of the mirror relationship
	RelationshipStatus *RelationshipStatus

	// The progress of the replication
	TotalProgress *string
}

// ResourceNameAvailabilityRequest - Resource name availability request content.
type ResourceNameAvailabilityRequest struct {
	// REQUIRED; Resource name to verify.
	Name *string

	// REQUIRED; Resource group name.
	ResourceGroup *string

	// REQUIRED; Resource type used for verification.
	Type *CheckNameResourceTypes
}

// RestoreStatus - Restore status
type RestoreStatus struct {
	// READ-ONLY; Displays error message if the restore is in an error state
	ErrorMessage *string

	// READ-ONLY; Restore health status
	Healthy *bool

	// READ-ONLY; The status of the restore
	MirrorState *MirrorState

	// READ-ONLY; Status of the restore SnapMirror relationship
	RelationshipStatus *RelationshipStatus

	// READ-ONLY; Displays the total bytes transferred
	TotalTransferBytes *int64

	// READ-ONLY; Reason for the unhealthy restore relationship
	UnhealthyReason *string
}

// ServiceSpecification - One property of operation, include metric specifications.
type ServiceSpecification struct {
	// Log specification of operation.
	LogSpecifications []*LogSpecification

	// Metric specifications of operation.
	MetricSpecifications []*MetricSpecification
}

// Snapshot of a Volume
type Snapshot struct {
	// REQUIRED; Resource location
	Location *string

	// Snapshot Properties
	Properties *SnapshotProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SnapshotPoliciesList - List of Snapshot Policies
type SnapshotPoliciesList struct {
	// A list of snapshot policies
	Value []*SnapshotPolicy
}

// SnapshotPolicy - Snapshot policy information
type SnapshotPolicy struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Snapshot policy Properties
	Properties *SnapshotPolicyProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SnapshotPolicyPatch - Snapshot policy Details for create and update
type SnapshotPolicyPatch struct {
	// Resource location
	Location *string

	// Snapshot Policy properties
	Properties *SnapshotPolicyProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SnapshotPolicyProperties - Snapshot policy properties
type SnapshotPolicyProperties struct {
	// Schedule for daily snapshots
	DailySchedule *DailySchedule

	// The property to decide policy is enabled or not
	Enabled *bool

	// Schedule for hourly snapshots
	HourlySchedule *HourlySchedule

	// Schedule for monthly snapshots
	MonthlySchedule *MonthlySchedule

	// Schedule for weekly snapshots
	WeeklySchedule *WeeklySchedule

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string
}

// SnapshotPolicyVolumeList - Volumes associated with snapshot policy
type SnapshotPolicyVolumeList struct {
	// List of volumes
	Value []*Volume
}

// SnapshotProperties - Snapshot properties
type SnapshotProperties struct {
	// READ-ONLY; The creation date of the snapshot
	Created *time.Time

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string

	// READ-ONLY; UUID v4 used to identify the Snapshot
	SnapshotID *string
}

// SnapshotRestoreFiles - Restore payload for Single File Snapshot Restore
type SnapshotRestoreFiles struct {
	// REQUIRED; List of files to be restored
	FilePaths []*string

	// Destination folder where the files will be restored
	DestinationPath *string
}

// SnapshotsList - List of Snapshots
type SnapshotsList struct {
	// A list of Snapshots
	Value []*Snapshot
}

// SubscriptionQuotaItem - Information regarding Subscription Quota Item.
type SubscriptionQuotaItem struct {
	// SubscriptionQuotaItem properties
	Properties *SubscriptionQuotaItemProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SubscriptionQuotaItemList - List of Subscription Quota Items
type SubscriptionQuotaItemList struct {
	// A list of SubscriptionQuotaItems
	Value []*SubscriptionQuotaItem
}

// SubscriptionQuotaItemProperties - SubscriptionQuotaItem Properties
type SubscriptionQuotaItemProperties struct {
	// READ-ONLY; The current quota value.
	Current *int32

	// READ-ONLY; The default quota value.
	Default *int32
}

// SubvolumeInfo - Subvolume Information properties
type SubvolumeInfo struct {
	// Subvolume Properties
	Properties *SubvolumeProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SubvolumeModel - Result of the post subvolume and action is to get metadata of the subvolume.
type SubvolumeModel struct {
	// It represents the minimal properties of the subvolume.
	Properties *SubvolumeModelProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// SubvolumeModelProperties - Properties which represents actual subvolume model which is stored as a file in the system.
type SubvolumeModelProperties struct {
	// Most recent access time and date
	AccessedTimeStamp *time.Time

	// Bytes used
	BytesUsed *int64

	// Most recent change time and date
	ChangedTimeStamp *time.Time

	// Creation time and date
	CreationTimeStamp *time.Time

	// Most recent modification time and date
	ModifiedTimeStamp *time.Time

	// Path to the parent subvolume
	ParentPath *string

	// Path to the subvolume
	Path *string

	// Permissions of the subvolume
	Permissions *string

	// Azure lifecycle management
	ProvisioningState *string

	// Size of subvolume
	Size *int64
}

// SubvolumePatchParams - Parameters with which a subvolume can be updated
type SubvolumePatchParams struct {
	// path to the subvolume
	Path *string

	// Truncate subvolume to the provided size in bytes
	Size *int64
}

// SubvolumePatchRequest - Subvolume Patch Request properties
type SubvolumePatchRequest struct {
	// Subvolume Properties
	Properties *SubvolumePatchParams
}

// SubvolumeProperties - This represents path associated with the subvolume
type SubvolumeProperties struct {
	// parent path to the subvolume
	ParentPath *string

	// Path to the subvolume
	Path *string

	// Truncate subvolume to the provided size in bytes
	Size *int64

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string
}

// SubvolumesList - List of Subvolumes
type SubvolumesList struct {
	// URL to get the next set of results.
	NextLink *string

	// A list of Subvolumes
	Value []*SubvolumeInfo
}

// SvmPeerCommandResponse - Information about svm peering process
type SvmPeerCommandResponse struct {
	// A command that needs to be run on the external ONTAP to accept svm peering. Will only be present if svmPeeringStatus is
	// pending
	SvmPeeringCommand *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UpdateNetworkSiblingSetRequest - Network sibling set update.
type UpdateNetworkSiblingSetRequest struct {
	// REQUIRED; Network features available to the volume.
	NetworkFeatures *NetworkFeatures

	// REQUIRED; Network Sibling Set ID for a group of volumes sharing networking resources in a subnet.
	NetworkSiblingSetID *string

	// REQUIRED; Network sibling set state Id identifying the current state of the sibling set.
	NetworkSiblingSetStateID *string

	// REQUIRED; The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes. Example
	// /subscriptions/subscriptionId/resourceGroups/resourceGroup/providers/Microsoft.Network/virtualNetworks/testVnet/subnets/{mySubnet}
	SubnetID *string
}

// UsageName - The name of the usage.
type UsageName struct {
	// The localized name of the usage.
	LocalizedValue *string

	// The name of the usage.
	Value *string
}

// UsageProperties - Usage properties
type UsageProperties struct {
	// READ-ONLY; The current usage value for the subscription.
	CurrentValue *int32

	// READ-ONLY; The limit of the usage.
	Limit *int32

	// READ-ONLY; The unit of the usage.
	Unit *string
}

// UsageResult - Usages entity model
type UsageResult struct {
	// Usage properties
	Properties *UsageProperties

	// READ-ONLY; The id of the usage.
	ID *string

	// READ-ONLY; The name of the usage.
	Name *UsageName
}

// UsagesListResult - Usages result
type UsagesListResult struct {
	// URL to get the next set of results.
	NextLink *string

	// A list of usages
	Value []*UsageResult
}

// UserAssignedIdentity - User assigned identity properties
type UserAssignedIdentity struct {
	// READ-ONLY; The client ID of the assigned identity.
	ClientID *string

	// READ-ONLY; The principal ID of the assigned identity.
	PrincipalID *string
}

// Volume resource
type Volume struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// REQUIRED; Volume properties
	Properties *VolumeProperties

	// Resource tags.
	Tags map[string]*string

	// Availability Zone
	Zones []*string

	// READ-ONLY; A unique read-only string that changes whenever the resource is updated.
	Etag *string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VolumeBackupProperties - Volume Backup Properties
type VolumeBackupProperties struct {
	// Backup Policy Resource ID
	BackupPolicyID *string

	// Backup Vault Resource ID
	BackupVaultID *string

	// Policy Enforced
	PolicyEnforced *bool
}

// VolumeBackups - Volume details using the backup policy
type VolumeBackups struct {
	// Total count of backups for volume
	BackupsCount *int32

	// Policy enabled
	PolicyEnabled *bool

	// Volume name
	VolumeName *string

	// ResourceId used to identify the Volume
	VolumeResourceID *string
}

// VolumeGroup - Volume group resource
type VolumeGroup struct {
	// Resource location
	Location *string

	// Volume group properties
	Properties *VolumeGroupListProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// VolumeGroupDetails - Volume group resource for create
type VolumeGroupDetails struct {
	// Resource location
	Location *string

	// Volume group properties
	Properties *VolumeGroupProperties

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// VolumeGroupList - List of volume group resources
type VolumeGroupList struct {
	// List of volume Groups
	Value []*VolumeGroup
}

// VolumeGroupListProperties - Volume group properties
type VolumeGroupListProperties struct {
	// Volume group details
	GroupMetaData *VolumeGroupMetaData

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string
}

// VolumeGroupMetaData - Volume group properties
type VolumeGroupMetaData struct {
	// Application specific identifier
	ApplicationIdentifier *string

	// Application Type
	ApplicationType *ApplicationType

	// Application specific placement rules for the volume group
	GlobalPlacementRules []*PlacementKeyValuePairs

	// Group Description
	GroupDescription *string

	// READ-ONLY; Number of volumes in volume group
	VolumesCount *int64
}

// VolumeGroupProperties - Volume group properties
type VolumeGroupProperties struct {
	// Volume group details
	GroupMetaData *VolumeGroupMetaData

	// List of volumes from group
	Volumes []*VolumeGroupVolumeProperties

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string
}

// VolumeGroupVolumeProperties - Volume resource
type VolumeGroupVolumeProperties struct {
	// REQUIRED; Volume properties
	Properties *VolumeProperties

	// Resource name
	Name *string

	// Resource tags
	Tags map[string]*string

	// Availability Zone
	Zones []*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource type
	Type *string
}

// VolumeList - List of volume resources
type VolumeList struct {
	// URL to get the next set of results.
	NextLink *string

	// List of volumes
	Value []*Volume
}

// VolumePatch - Volume patch resource
type VolumePatch struct {
	// Resource location
	Location *string

	// Patchable volume properties
	Properties *VolumePatchProperties

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Resource Id
	ID *string

	// READ-ONLY; Resource name
	Name *string

	// READ-ONLY; Resource type
	Type *string
}

// VolumePatchProperties - Patchable volume properties
type VolumePatchProperties struct {
	// Specifies whether Cool Access(tiering) is enabled for the volume.
	CoolAccess *bool

	// coolAccessRetrievalPolicy determines the data retrieval behavior from the cool tier to standard storage based on the read
	// pattern for cool access enabled volumes. The possible values for this field
	// are: Default - Data will be pulled from cool tier to standard storage on random reads. This policy is the default. OnRead
	// - All client-driven data read is pulled from cool tier to standard storage on
	// both sequential and random reads. Never - No client-driven data is pulled from cool tier to standard storage.
	CoolAccessRetrievalPolicy *CoolAccessRetrievalPolicy

	// coolAccessTieringPolicy determines which cold data blocks are moved to cool tier. The possible values for this field are:
	// Auto - Moves cold user data blocks in both the Snapshot copies and the active
	// file system to the cool tier tier. This policy is the default. SnapshotOnly - Moves user data blocks of the Volume Snapshot
	// copies that are not associated with the active file system to the cool tier.
	CoolAccessTieringPolicy *CoolAccessTieringPolicy

	// Specifies the number of days after which data that is not accessed by clients will be tiered.
	CoolnessPeriod *int32

	// DataProtection type volumes include an object containing details of the replication
	DataProtection *VolumePatchPropertiesDataProtection

	// Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
	DefaultGroupQuotaInKiBs *int64

	// Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
	DefaultUserQuotaInKiBs *int64

	// Set of export policy rules
	ExportPolicy *VolumePatchPropertiesExportPolicy

	// Specifies if default quota is enabled for the volume.
	IsDefaultQuotaEnabled *bool

	// Set of protocol types, default NFSv3, CIFS for SMB protocol
	ProtocolTypes []*string

	// The service level of the file system
	ServiceLevel *ServiceLevel

	// Enables access-based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
	SmbAccessBasedEnumeration *SmbAccessBasedEnumeration

	// Enables non-browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
	SmbNonBrowsable *SmbNonBrowsable

	// If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's
	// snapshots.
	SnapshotDirectoryVisible *bool

	// Maximum throughput in MiB/s that can be achieved by this volume and this will be accepted as input only for manual qosType
	// volume
	ThroughputMibps *float32

	// UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID
	// (2) and sticky (1) attributes. Second digit selects permission for the owner of
	// the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth
	// for other users not in the group. 0755 - gives read/write/execute permissions to
	// owner and read/execute to group and other users.
	UnixPermissions *string

	// Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. For regular volumes,
	// valid values are in the range 50GiB to 100TiB. For large volumes, valid
	// values are in the range 100TiB to 500TiB, and on an exceptional basis, from to 2400GiB to 2400TiB. Values expressed in
	// bytes as multiples of 1 GiB.
	UsageThreshold *int64
}

// VolumePatchPropertiesDataProtection - DataProtection type volumes include an object containing details of the replication
type VolumePatchPropertiesDataProtection struct {
	// Backup Properties
	Backup *VolumeBackupProperties

	// Snapshot properties.
	Snapshot *VolumeSnapshotProperties
}

// VolumePatchPropertiesExportPolicy - Set of export policy rules
type VolumePatchPropertiesExportPolicy struct {
	// Export policy rule
	Rules []*ExportPolicyRule
}

// VolumeProperties - Volume properties
type VolumeProperties struct {
	// REQUIRED; A unique file path for the volume. Used when creating mount targets
	CreationToken *string

	// REQUIRED; The Azure Resource URI for a delegated subnet. Must have the delegation Microsoft.NetApp/volumes
	SubnetID *string

	// REQUIRED; Maximum storage quota allowed for a file system in bytes. This is a soft quota used for alerting only. For regular
	// volumes, valid values are in the range 50GiB to 100TiB. For large volumes, valid
	// values are in the range 100TiB to 500TiB, and on an exceptional basis, from to 2400GiB to 2400TiB. Values expressed in
	// bytes as multiples of 1 GiB.
	UsageThreshold *int64

	// Specifies whether the volume is enabled for Azure VMware Solution (AVS) datastore purpose
	AvsDataStore *AvsDataStore

	// Resource identifier used to identify the Backup.
	BackupID *string

	// Pool Resource Id used in case of creating a volume through volume group
	CapacityPoolResourceID *string

	// Specifies whether Cool Access(tiering) is enabled for the volume.
	CoolAccess *bool

	// coolAccessRetrievalPolicy determines the data retrieval behavior from the cool tier to standard storage based on the read
	// pattern for cool access enabled volumes. The possible values for this field
	// are: Default - Data will be pulled from cool tier to standard storage on random reads. This policy is the default. OnRead
	// - All client-driven data read is pulled from cool tier to standard storage on
	// both sequential and random reads. Never - No client-driven data is pulled from cool tier to standard storage.
	CoolAccessRetrievalPolicy *CoolAccessRetrievalPolicy

	// coolAccessTieringPolicy determines which cold data blocks are moved to cool tier. The possible values for this field are:
	// Auto - Moves cold user data blocks in both the Snapshot copies and the active
	// file system to the cool tier tier. This policy is the default. SnapshotOnly - Moves user data blocks of the Volume Snapshot
	// copies that are not associated with the active file system to the cool tier.
	CoolAccessTieringPolicy *CoolAccessTieringPolicy

	// Specifies the number of days after which data that is not accessed by clients will be tiered.
	CoolnessPeriod *int32

	// DataProtection type volumes include an object containing details of the replication
	DataProtection *VolumePropertiesDataProtection

	// Default group quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies.
	DefaultGroupQuotaInKiBs *int64

	// Default user quota for volume in KiBs. If isDefaultQuotaEnabled is set, the minimum value of 4 KiBs applies .
	DefaultUserQuotaInKiBs *int64

	// If enabled (true) the snapshot the volume was created from will be automatically deleted after the volume create operation
	// has finished. Defaults to false
	DeleteBaseSnapshot *bool

	// Flag indicating whether subvolume operations are enabled on the volume
	EnableSubvolumes *EnableSubvolumes

	// Source of key used to encrypt data in volume. Applicable if NetApp account has encryption.keySource = 'Microsoft.KeyVault'.
	// Possible values (case-insensitive) are: 'Microsoft.NetApp,
	// Microsoft.KeyVault'
	EncryptionKeySource *EncryptionKeySource

	// Set of export policy rules
	ExportPolicy *VolumePropertiesExportPolicy

	// Specifies if default quota is enabled for the volume.
	IsDefaultQuotaEnabled *bool

	// Specifies whether volume is a Large Volume or Regular Volume.
	IsLargeVolume *bool

	// Describe if a volume is KerberosEnabled. To be use with swagger version 2020-05-01 or later
	KerberosEnabled *bool

	// The resource ID of private endpoint for KeyVault. It must reside in the same VNET as the volume. Only applicable if encryptionKeySource
	// = 'Microsoft.KeyVault'.
	KeyVaultPrivateEndpointResourceID *string

	// Specifies whether LDAP is enabled or not for a given NFS volume.
	LdapEnabled *bool

	// The original value of the network features type available to the volume at the time it was created.
	NetworkFeatures *NetworkFeatures

	// Application specific placement rules for the particular volume
	PlacementRules []*PlacementKeyValuePairs

	// Set of protocol types, default NFSv3, CIFS for SMB protocol
	ProtocolTypes []*string

	// Proximity placement group associated with the volume
	ProximityPlacementGroup *string

	// The security style of volume, default unix, defaults to ntfs for dual protocol or CIFS protocol
	SecurityStyle *SecurityStyle

	// The service level of the file system
	ServiceLevel *ServiceLevel

	// Enables access-based enumeration share property for SMB Shares. Only applicable for SMB/DualProtocol volume
	SmbAccessBasedEnumeration *SmbAccessBasedEnumeration

	// Enables continuously available share property for smb volume. Only applicable for SMB volume
	SmbContinuouslyAvailable *bool

	// Enables encryption for in-flight smb3 data. Only applicable for SMB/DualProtocol volume. To be used with swagger version
	// 2020-08-01 or later
	SmbEncryption *bool

	// Enables non-browsable property for SMB Shares. Only applicable for SMB/DualProtocol volume
	SmbNonBrowsable *SmbNonBrowsable

	// If enabled (true) the volume will contain a read-only snapshot directory which provides access to each of the volume's
	// snapshots (defaults to true).
	SnapshotDirectoryVisible *bool

	// Resource identifier used to identify the Snapshot.
	SnapshotID *string

	// Maximum throughput in MiB/s that can be achieved by this volume and this will be accepted as input only for manual qosType
	// volume
	ThroughputMibps *float32

	// UNIX permissions for NFS volume accepted in octal 4 digit format. First digit selects the set user ID(4), set group ID
	// (2) and sticky (1) attributes. Second digit selects permission for the owner of
	// the file: read (4), write (2) and execute (1). Third selects permissions for other users in the same group. the fourth
	// for other users not in the group. 0755 - gives read/write/execute permissions to
	// owner and read/execute to group and other users.
	UnixPermissions *string

	// Volume spec name is the application specific designation or identifier for the particular volume in a volume group for
	// e.g. data, log
	VolumeSpecName *string

	// What type of volume is this. For destination volumes in Cross Region Replication, set type to DataProtection
	VolumeType *string

	// READ-ONLY; Actual throughput in MiB/s for auto qosType volumes calculated based on size and serviceLevel
	ActualThroughputMibps *float32

	// READ-ONLY; Unique Baremetal Tenant Identifier.
	BaremetalTenantID *string

	// READ-ONLY; When a volume is being restored from another volume's snapshot, will show the percentage completion of this
	// cloning process. When this value is empty/null there is no cloning process currently
	// happening on this volume. This value will update every 5 minutes during cloning.
	CloneProgress *int32

	// READ-ONLY; Data store resource unique identifier
	DataStoreResourceID []*string

	// READ-ONLY; The effective value of the network features type available to the volume, or current effective state of update.
	EffectiveNetworkFeatures *NetworkFeatures

	// READ-ONLY; Specifies if the volume is encrypted or not. Only available on volumes created or updated after 2022-01-01.
	Encrypted *bool

	// READ-ONLY; Flag indicating whether file access logs are enabled for the volume, based on active diagnostic settings present
	// on the volume.
	FileAccessLogs *FileAccessLogs

	// READ-ONLY; Unique FileSystem Identifier.
	FileSystemID *string

	// READ-ONLY; Restoring
	IsRestoring *bool

	// READ-ONLY; Maximum number of files allowed. Needs a service request in order to be changed. Only allowed to be changed
	// if volume quota is more than 4TiB.
	MaximumNumberOfFiles *int64

	// READ-ONLY; List of mount targets
	MountTargets []*MountTargetProperties

	// READ-ONLY; Network Sibling Set ID for the the group of volumes sharing networking resources.
	NetworkSiblingSetID *string

	// READ-ONLY; Id of the snapshot or backup that the volume is restored from.
	OriginatingResourceID *string

	// READ-ONLY; The availability zone where the volume is provisioned. This refers to the logical availability zone where the
	// volume resides.
	ProvisionedAvailabilityZone *string

	// READ-ONLY; Azure lifecycle management
	ProvisioningState *string

	// READ-ONLY; Provides storage to network proximity information for the volume.
	StorageToNetworkProximity *VolumeStorageToNetworkProximity

	// READ-ONLY; T2 network information
	T2Network *string

	// READ-ONLY; Volume Group Name
	VolumeGroupName *string
}

// VolumePropertiesDataProtection - DataProtection type volumes include an object containing details of the replication
type VolumePropertiesDataProtection struct {
	// Backup Properties
	Backup *VolumeBackupProperties

	// Replication properties
	Replication *ReplicationObject

	// Snapshot properties.
	Snapshot *VolumeSnapshotProperties

	// VolumeRelocation properties
	VolumeRelocation *VolumeRelocationProperties
}

// VolumePropertiesExportPolicy - Set of export policy rules
type VolumePropertiesExportPolicy struct {
	// Export policy rule
	Rules []*ExportPolicyRule
}

// VolumeQuotaRule - Quota Rule of a Volume
type VolumeQuotaRule struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Volume Quota Rule Properties
	Properties *VolumeQuotaRulesProperties

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// VolumeQuotaRulePatch - Patchable Quota Rule of a Volume
type VolumeQuotaRulePatch struct {
	// Volume Quota Rule Properties
	Properties *VolumeQuotaRulesProperties

	// Resource tags
	Tags map[string]*string
}

// VolumeQuotaRulesList - List of Volume Quota Rules
type VolumeQuotaRulesList struct {
	// A list of Volume Quota Rules
	Value []*VolumeQuotaRule
}

// VolumeQuotaRulesProperties - Volume Quota Rule properties
type VolumeQuotaRulesProperties struct {
	// Size of quota
	QuotaSizeInKiBs *int64

	// UserID/GroupID/SID based on the quota target type. UserID and groupID can be found by running ‘id’ or ‘getent’ command
	// for the user or group and SID can be found by running
	QuotaTarget *string

	// Type of quota
	QuotaType *Type

	// READ-ONLY; Gets the status of the VolumeQuotaRule at the time the operation was called.
	ProvisioningState *ProvisioningState
}

// VolumeRelocationProperties - Volume relocation properties
type VolumeRelocationProperties struct {
	// Has relocation been requested for this volume
	RelocationRequested *bool

	// READ-ONLY; Has relocation finished and is ready to be cleaned up
	ReadyToBeFinalized *bool
}

// VolumeRevert - revert a volume to the snapshot
type VolumeRevert struct {
	// Resource id of the snapshot
	SnapshotID *string
}

// VolumeSnapshotProperties - Volume Snapshot Properties
type VolumeSnapshotProperties struct {
	// Snapshot Policy ResourceId
	SnapshotPolicyID *string
}

// WeeklySchedule - Weekly Schedule properties, make a snapshot every week at a specific day or days
type WeeklySchedule struct {
	// Indicates which weekdays snapshot should be taken, accepts a comma separated list of week day names in english
	Day *string

	// Indicates which hour in UTC timezone a snapshot should be taken
	Hour *int32

	// Indicates which minute snapshot should be taken
	Minute *int32

	// Weekly snapshot count to keep
	SnapshotsToKeep *int32

	// Resource size in bytes, current storage usage for the volume in bytes
	UsedBytes *int64
}
