// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetapp

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// ResourceUsagesClient contains the methods for the NetAppResourceUsages group.
// Don't use this type directly, use NewResourceUsagesClient() instead.
type ResourceUsagesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewResourceUsagesClient creates a new instance of ResourceUsagesClient with the specified values.
//   - subscriptionID - The ID of the target subscription. The value must be an UUID.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewResourceUsagesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ResourceUsagesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ResourceUsagesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Get - Get current subscription usage of the specific type
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2025-01-01
//   - location - The name of the Azure region.
//   - usageType - The type of usage
//   - options - ResourceUsagesClientGetOptions contains the optional parameters for the ResourceUsagesClient.Get method.
func (client *ResourceUsagesClient) Get(ctx context.Context, location string, usageType string, options *ResourceUsagesClientGetOptions) (ResourceUsagesClientGetResponse, error) {
	var err error
	const operationName = "ResourceUsagesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, location, usageType, options)
	if err != nil {
		return ResourceUsagesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ResourceUsagesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ResourceUsagesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ResourceUsagesClient) getCreateRequest(ctx context.Context, location string, usageType string, _ *ResourceUsagesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.NetApp/locations/{location}/usages/{usageType}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	if usageType == "" {
		return nil, errors.New("parameter usageType cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{usageType}", url.PathEscape(usageType))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2025-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ResourceUsagesClient) getHandleResponse(resp *http.Response) (ResourceUsagesClientGetResponse, error) {
	result := ResourceUsagesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsageResult); err != nil {
		return ResourceUsagesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Get current subscription usages
//
// Generated from API version 2025-01-01
//   - location - The name of the Azure region.
//   - options - ResourceUsagesClientListOptions contains the optional parameters for the ResourceUsagesClient.NewListPager method.
func (client *ResourceUsagesClient) NewListPager(location string, options *ResourceUsagesClientListOptions) *runtime.Pager[ResourceUsagesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ResourceUsagesClientListResponse]{
		More: func(page ResourceUsagesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ResourceUsagesClientListResponse) (ResourceUsagesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ResourceUsagesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, location, options)
			}, nil)
			if err != nil {
				return ResourceUsagesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ResourceUsagesClient) listCreateRequest(ctx context.Context, location string, _ *ResourceUsagesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.NetApp/locations/{location}/usages"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if location == "" {
		return nil, errors.New("parameter location cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{location}", url.PathEscape(location))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2025-01-01")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ResourceUsagesClient) listHandleResponse(resp *http.Response) (ResourceUsagesClientListResponse, error) {
	result := ResourceUsagesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.UsagesListResult); err != nil {
		return ResourceUsagesClientListResponse{}, err
	}
	return result, nil
}
