//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package azsecrets

import "time"

// BackupSecretResult - The backup secret result, containing the backup blob.
type BackupSecretResult struct {
	// READ-ONLY; The backup blob containing the backed up secret.
	Value []byte
}

// DeletedSecret - A Deleted Secret consisting of its previous id, attributes and its tags, as well as information on when
// it will be purged.
type DeletedSecret struct {
	// The secret management attributes.
	Attributes *SecretAttributes

	// The content type of the secret.
	ContentType *string

	// The secret id.
	ID *ID

	// The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string

	// The secret value.
	Value *string

	// READ-ONLY; The time when the secret was deleted, in UTC
	DeletedDate *time.Time

	// READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV
	// certificate.
	KID *ID

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed
	// will be true.
	Managed *bool

	// READ-ONLY; The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time
}

// DeletedSecretProperties - The deleted secret item containing metadata about the deleted secret.
type DeletedSecretProperties struct {
	// The secret management attributes.
	Attributes *SecretAttributes

	// Type of the secret value such as a password.
	ContentType *string

	// Secret identifier.
	ID *ID

	// The url of the recovery object, used to identify and recover the deleted secret.
	RecoveryID *string

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string

	// READ-ONLY; The time when the secret was deleted, in UTC
	DeletedDate *time.Time

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed
	// will be true.
	Managed *bool

	// READ-ONLY; The time when the secret is scheduled to be purged, in UTC
	ScheduledPurgeDate *time.Time
}

// DeletedSecretPropertiesListResult - The deleted secret list result
type DeletedSecretPropertiesListResult struct {
	// READ-ONLY; The URL to get the next set of deleted secrets.
	NextLink *string

	// READ-ONLY; A response message containing a list of the deleted secrets in the vault along with a link to the next page
	// of deleted secrets
	Value []*DeletedSecretProperties
}

// RestoreSecretParameters - The secret restore parameters.
type RestoreSecretParameters struct {
	// REQUIRED; The backup blob associated with a secret bundle.
	SecretBackup []byte
}

// Secret - A secret consisting of a value, id and its attributes.
type Secret struct {
	// The secret management attributes.
	Attributes *SecretAttributes

	// The content type of the secret.
	ContentType *string

	// The secret id.
	ID *ID

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string

	// The secret value.
	Value *string

	// READ-ONLY; If this is a secret backing a KV certificate, then this field specifies the corresponding key backing the KV
	// certificate.
	KID *ID

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a secret backing a certificate, then managed
	// will be true.
	Managed *bool
}

// SecretAttributes - The secret management attributes.
type SecretAttributes struct {
	// Determines whether the object is enabled.
	Enabled *bool

	// Expiry date in UTC.
	Expires *time.Time

	// Not before date in UTC.
	NotBefore *time.Time

	// READ-ONLY; Creation time in UTC.
	Created *time.Time

	// READ-ONLY; softDelete data retention days. Value should be >=7 and <=90 when softDelete enabled, otherwise 0.
	RecoverableDays *int32

	// READ-ONLY; Reflects the deletion recovery level currently in effect for secrets in the current vault. If it contains 'Purgeable',
	// the secret can be permanently deleted by a privileged user; otherwise, only the
	// system can purge the secret, at the end of the retention interval.
	RecoveryLevel *string

	// READ-ONLY; Last updated time in UTC.
	Updated *time.Time
}

// SecretProperties - The secret item containing secret metadata.
type SecretProperties struct {
	// The secret management attributes.
	Attributes *SecretAttributes

	// Type of the secret value such as a password.
	ContentType *string

	// Secret identifier.
	ID *ID

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string

	// READ-ONLY; True if the secret's lifetime is managed by key vault. If this is a key backing a certificate, then managed
	// will be true.
	Managed *bool
}

// SecretPropertiesListResult - The secret list result.
type SecretPropertiesListResult struct {
	// READ-ONLY; The URL to get the next set of secrets.
	NextLink *string

	// READ-ONLY; A response message containing a list of secrets in the key vault along with a link to the next page of secrets.
	Value []*SecretProperties
}

// SetSecretParameters - The secret set parameters.
type SetSecretParameters struct {
	// REQUIRED; The value of the secret.
	Value *string

	// Type of the secret value such as a password.
	ContentType *string

	// The secret management attributes.
	SecretAttributes *SecretAttributes

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string
}

// UpdateSecretPropertiesParameters - The secret update parameters.
type UpdateSecretPropertiesParameters struct {
	// Type of the secret value such as a password.
	ContentType *string

	// The secret management attributes.
	SecretAttributes *SecretAttributes

	// Application specific metadata in the form of key-value pairs.
	Tags map[string]*string
}
