// Copyright 2024 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/operator/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/operator/crd/client/clientset/versioned/scheme"
)

// TridentConfiguratorsGetter has a method to return a TridentConfiguratorInterface.
// A group's client should implement this interface.
type TridentConfiguratorsGetter interface {
	TridentConfigurators() TridentConfiguratorInterface
}

// TridentConfiguratorInterface has methods to work with TridentConfigurator resources.
type TridentConfiguratorInterface interface {
	Create(ctx context.Context, tridentConfigurator *v1.TridentConfigurator, opts metav1.CreateOptions) (*v1.TridentConfigurator, error)
	Update(ctx context.Context, tridentConfigurator *v1.TridentConfigurator, opts metav1.UpdateOptions) (*v1.TridentConfigurator, error)
	UpdateStatus(ctx context.Context, tridentConfigurator *v1.TridentConfigurator, opts metav1.UpdateOptions) (*v1.TridentConfigurator, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentConfigurator, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentConfiguratorList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentConfigurator, err error)
	TridentConfiguratorExpansion
}

// tridentConfigurators implements TridentConfiguratorInterface
type tridentConfigurators struct {
	client rest.Interface
}

// newTridentConfigurators returns a TridentConfigurators
func newTridentConfigurators(c *TridentV1Client) *tridentConfigurators {
	return &tridentConfigurators{
		client: c.RESTClient(),
	}
}

// Get takes name of the tridentConfigurator, and returns the corresponding tridentConfigurator object, and an error if there is any.
func (c *tridentConfigurators) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentConfigurator, err error) {
	result = &v1.TridentConfigurator{}
	err = c.client.Get().
		Resource("tridentconfigurators").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentConfigurators that match those selectors.
func (c *tridentConfigurators) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentConfiguratorList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentConfiguratorList{}
	err = c.client.Get().
		Resource("tridentconfigurators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentConfigurators.
func (c *tridentConfigurators) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("tridentconfigurators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentConfigurator and creates it.  Returns the server's representation of the tridentConfigurator, and an error, if there is any.
func (c *tridentConfigurators) Create(ctx context.Context, tridentConfigurator *v1.TridentConfigurator, opts metav1.CreateOptions) (result *v1.TridentConfigurator, err error) {
	result = &v1.TridentConfigurator{}
	err = c.client.Post().
		Resource("tridentconfigurators").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentConfigurator).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentConfigurator and updates it. Returns the server's representation of the tridentConfigurator, and an error, if there is any.
func (c *tridentConfigurators) Update(ctx context.Context, tridentConfigurator *v1.TridentConfigurator, opts metav1.UpdateOptions) (result *v1.TridentConfigurator, err error) {
	result = &v1.TridentConfigurator{}
	err = c.client.Put().
		Resource("tridentconfigurators").
		Name(tridentConfigurator.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentConfigurator).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tridentConfigurators) UpdateStatus(ctx context.Context, tridentConfigurator *v1.TridentConfigurator, opts metav1.UpdateOptions) (result *v1.TridentConfigurator, err error) {
	result = &v1.TridentConfigurator{}
	err = c.client.Put().
		Resource("tridentconfigurators").
		Name(tridentConfigurator.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentConfigurator).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentConfigurator and deletes it. Returns an error if one occurs.
func (c *tridentConfigurators) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("tridentconfigurators").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentConfigurators) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("tridentconfigurators").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentConfigurator.
func (c *tridentConfigurators) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentConfigurator, err error) {
	result = &v1.TridentConfigurator{}
	err = c.client.Patch(pt).
		Resource("tridentconfigurators").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
