// Copyright 2025 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	"github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

type TridentV1Interface interface {
	RESTClient() rest.Interface
	TridentActionMirrorUpdatesGetter
	TridentActionSnapshotRestoresGetter
	TridentBackendsGetter
	TridentBackendConfigsGetter
	TridentGroupSnapshotsGetter
	TridentMirrorRelationshipsGetter
	TridentNodesGetter
	TridentSnapshotsGetter
	TridentSnapshotInfosGetter
	TridentStorageClassesGetter
	TridentTransactionsGetter
	TridentVersionsGetter
	TridentVolumesGetter
	TridentVolumePublicationsGetter
	TridentVolumeReferencesGetter
}

// TridentV1Client is used to interact with features provided by the trident.netapp.io group.
type TridentV1Client struct {
	restClient rest.Interface
}

func (c *TridentV1Client) TridentActionMirrorUpdates(namespace string) TridentActionMirrorUpdateInterface {
	return newTridentActionMirrorUpdates(c, namespace)
}

func (c *TridentV1Client) TridentActionSnapshotRestores(namespace string) TridentActionSnapshotRestoreInterface {
	return newTridentActionSnapshotRestores(c, namespace)
}

func (c *TridentV1Client) TridentBackends(namespace string) TridentBackendInterface {
	return newTridentBackends(c, namespace)
}

func (c *TridentV1Client) TridentBackendConfigs(namespace string) TridentBackendConfigInterface {
	return newTridentBackendConfigs(c, namespace)
}

func (c *TridentV1Client) TridentGroupSnapshots(namespace string) TridentGroupSnapshotInterface {
	return newTridentGroupSnapshots(c, namespace)
}

func (c *TridentV1Client) TridentMirrorRelationships(namespace string) TridentMirrorRelationshipInterface {
	return newTridentMirrorRelationships(c, namespace)
}

func (c *TridentV1Client) TridentNodes(namespace string) TridentNodeInterface {
	return newTridentNodes(c, namespace)
}

func (c *TridentV1Client) TridentSnapshots(namespace string) TridentSnapshotInterface {
	return newTridentSnapshots(c, namespace)
}

func (c *TridentV1Client) TridentSnapshotInfos(namespace string) TridentSnapshotInfoInterface {
	return newTridentSnapshotInfos(c, namespace)
}

func (c *TridentV1Client) TridentStorageClasses(namespace string) TridentStorageClassInterface {
	return newTridentStorageClasses(c, namespace)
}

func (c *TridentV1Client) TridentTransactions(namespace string) TridentTransactionInterface {
	return newTridentTransactions(c, namespace)
}

func (c *TridentV1Client) TridentVersions(namespace string) TridentVersionInterface {
	return newTridentVersions(c, namespace)
}

func (c *TridentV1Client) TridentVolumes(namespace string) TridentVolumeInterface {
	return newTridentVolumes(c, namespace)
}

func (c *TridentV1Client) TridentVolumePublications(namespace string) TridentVolumePublicationInterface {
	return newTridentVolumePublications(c, namespace)
}

func (c *TridentV1Client) TridentVolumeReferences(namespace string) TridentVolumeReferenceInterface {
	return newTridentVolumeReferences(c, namespace)
}

// NewForConfig creates a new TridentV1Client for the given config.
func NewForConfig(c *rest.Config) (*TridentV1Client, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &TridentV1Client{client}, nil
}

// NewForConfigOrDie creates a new TridentV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *TridentV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new TridentV1Client for the given RESTClient.
func New(c rest.Interface) *TridentV1Client {
	return &TridentV1Client{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *TridentV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
