// Copyright 2023 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentActionMirrorUpdatesGetter has a method to return a TridentActionMirrorUpdateInterface.
// A group's client should implement this interface.
type TridentActionMirrorUpdatesGetter interface {
	TridentActionMirrorUpdates(namespace string) TridentActionMirrorUpdateInterface
}

// TridentActionMirrorUpdateInterface has methods to work with TridentActionMirrorUpdate resources.
type TridentActionMirrorUpdateInterface interface {
	Create(ctx context.Context, tridentActionMirrorUpdate *v1.TridentActionMirrorUpdate, opts metav1.CreateOptions) (*v1.TridentActionMirrorUpdate, error)
	Update(ctx context.Context, tridentActionMirrorUpdate *v1.TridentActionMirrorUpdate, opts metav1.UpdateOptions) (*v1.TridentActionMirrorUpdate, error)
	UpdateStatus(ctx context.Context, tridentActionMirrorUpdate *v1.TridentActionMirrorUpdate, opts metav1.UpdateOptions) (*v1.TridentActionMirrorUpdate, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentActionMirrorUpdate, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentActionMirrorUpdateList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentActionMirrorUpdate, err error)
	TridentActionMirrorUpdateExpansion
}

// tridentActionMirrorUpdates implements TridentActionMirrorUpdateInterface
type tridentActionMirrorUpdates struct {
	client rest.Interface
	ns     string
}

// newTridentActionMirrorUpdates returns a TridentActionMirrorUpdates
func newTridentActionMirrorUpdates(c *TridentV1Client, namespace string) *tridentActionMirrorUpdates {
	return &tridentActionMirrorUpdates{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentActionMirrorUpdate, and returns the corresponding tridentActionMirrorUpdate object, and an error if there is any.
func (c *tridentActionMirrorUpdates) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentActionMirrorUpdate, err error) {
	result = &v1.TridentActionMirrorUpdate{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentActionMirrorUpdates that match those selectors.
func (c *tridentActionMirrorUpdates) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentActionMirrorUpdateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentActionMirrorUpdateList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentActionMirrorUpdates.
func (c *tridentActionMirrorUpdates) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentActionMirrorUpdate and creates it.  Returns the server's representation of the tridentActionMirrorUpdate, and an error, if there is any.
func (c *tridentActionMirrorUpdates) Create(ctx context.Context, tridentActionMirrorUpdate *v1.TridentActionMirrorUpdate, opts metav1.CreateOptions) (result *v1.TridentActionMirrorUpdate, err error) {
	result = &v1.TridentActionMirrorUpdate{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentActionMirrorUpdate).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentActionMirrorUpdate and updates it. Returns the server's representation of the tridentActionMirrorUpdate, and an error, if there is any.
func (c *tridentActionMirrorUpdates) Update(ctx context.Context, tridentActionMirrorUpdate *v1.TridentActionMirrorUpdate, opts metav1.UpdateOptions) (result *v1.TridentActionMirrorUpdate, err error) {
	result = &v1.TridentActionMirrorUpdate{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		Name(tridentActionMirrorUpdate.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentActionMirrorUpdate).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tridentActionMirrorUpdates) UpdateStatus(ctx context.Context, tridentActionMirrorUpdate *v1.TridentActionMirrorUpdate, opts metav1.UpdateOptions) (result *v1.TridentActionMirrorUpdate, err error) {
	result = &v1.TridentActionMirrorUpdate{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		Name(tridentActionMirrorUpdate.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentActionMirrorUpdate).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentActionMirrorUpdate and deletes it. Returns an error if one occurs.
func (c *tridentActionMirrorUpdates) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentActionMirrorUpdates) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentActionMirrorUpdate.
func (c *tridentActionMirrorUpdates) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentActionMirrorUpdate, err error) {
	result = &v1.TridentActionMirrorUpdate{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentactionmirrorupdates").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
