// Copyright 2023 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentBackendConfigsGetter has a method to return a TridentBackendConfigInterface.
// A group's client should implement this interface.
type TridentBackendConfigsGetter interface {
	TridentBackendConfigs(namespace string) TridentBackendConfigInterface
}

// TridentBackendConfigInterface has methods to work with TridentBackendConfig resources.
type TridentBackendConfigInterface interface {
	Create(ctx context.Context, tridentBackendConfig *v1.TridentBackendConfig, opts metav1.CreateOptions) (*v1.TridentBackendConfig, error)
	Update(ctx context.Context, tridentBackendConfig *v1.TridentBackendConfig, opts metav1.UpdateOptions) (*v1.TridentBackendConfig, error)
	UpdateStatus(ctx context.Context, tridentBackendConfig *v1.TridentBackendConfig, opts metav1.UpdateOptions) (*v1.TridentBackendConfig, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentBackendConfig, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentBackendConfigList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentBackendConfig, err error)
	TridentBackendConfigExpansion
}

// tridentBackendConfigs implements TridentBackendConfigInterface
type tridentBackendConfigs struct {
	client rest.Interface
	ns     string
}

// newTridentBackendConfigs returns a TridentBackendConfigs
func newTridentBackendConfigs(c *TridentV1Client, namespace string) *tridentBackendConfigs {
	return &tridentBackendConfigs{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentBackendConfig, and returns the corresponding tridentBackendConfig object, and an error if there is any.
func (c *tridentBackendConfigs) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentBackendConfig, err error) {
	result = &v1.TridentBackendConfig{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentBackendConfigs that match those selectors.
func (c *tridentBackendConfigs) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentBackendConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentBackendConfigList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentBackendConfigs.
func (c *tridentBackendConfigs) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentBackendConfig and creates it.  Returns the server's representation of the tridentBackendConfig, and an error, if there is any.
func (c *tridentBackendConfigs) Create(ctx context.Context, tridentBackendConfig *v1.TridentBackendConfig, opts metav1.CreateOptions) (result *v1.TridentBackendConfig, err error) {
	result = &v1.TridentBackendConfig{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentBackendConfig).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentBackendConfig and updates it. Returns the server's representation of the tridentBackendConfig, and an error, if there is any.
func (c *tridentBackendConfigs) Update(ctx context.Context, tridentBackendConfig *v1.TridentBackendConfig, opts metav1.UpdateOptions) (result *v1.TridentBackendConfig, err error) {
	result = &v1.TridentBackendConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		Name(tridentBackendConfig.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentBackendConfig).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *tridentBackendConfigs) UpdateStatus(ctx context.Context, tridentBackendConfig *v1.TridentBackendConfig, opts metav1.UpdateOptions) (result *v1.TridentBackendConfig, err error) {
	result = &v1.TridentBackendConfig{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		Name(tridentBackendConfig.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentBackendConfig).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentBackendConfig and deletes it. Returns an error if one occurs.
func (c *tridentBackendConfigs) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentBackendConfigs) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentBackendConfig.
func (c *tridentBackendConfigs) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentBackendConfig, err error) {
	result = &v1.TridentBackendConfig{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentbackendconfigs").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
