// Copyright 2025 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentGroupSnapshotsGetter has a method to return a TridentGroupSnapshotInterface.
// A group's client should implement this interface.
type TridentGroupSnapshotsGetter interface {
	TridentGroupSnapshots(namespace string) TridentGroupSnapshotInterface
}

// TridentGroupSnapshotInterface has methods to work with TridentGroupSnapshot resources.
type TridentGroupSnapshotInterface interface {
	Create(ctx context.Context, tridentGroupSnapshot *v1.TridentGroupSnapshot, opts metav1.CreateOptions) (*v1.TridentGroupSnapshot, error)
	Update(ctx context.Context, tridentGroupSnapshot *v1.TridentGroupSnapshot, opts metav1.UpdateOptions) (*v1.TridentGroupSnapshot, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentGroupSnapshot, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentGroupSnapshotList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentGroupSnapshot, err error)
	TridentGroupSnapshotExpansion
}

// tridentGroupSnapshots implements TridentGroupSnapshotInterface
type tridentGroupSnapshots struct {
	client rest.Interface
	ns     string
}

// newTridentGroupSnapshots returns a TridentGroupSnapshots
func newTridentGroupSnapshots(c *TridentV1Client, namespace string) *tridentGroupSnapshots {
	return &tridentGroupSnapshots{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentGroupSnapshot, and returns the corresponding tridentGroupSnapshot object, and an error if there is any.
func (c *tridentGroupSnapshots) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentGroupSnapshot, err error) {
	result = &v1.TridentGroupSnapshot{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentGroupSnapshots that match those selectors.
func (c *tridentGroupSnapshots) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentGroupSnapshotList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentGroupSnapshotList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentGroupSnapshots.
func (c *tridentGroupSnapshots) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentGroupSnapshot and creates it.  Returns the server's representation of the tridentGroupSnapshot, and an error, if there is any.
func (c *tridentGroupSnapshots) Create(ctx context.Context, tridentGroupSnapshot *v1.TridentGroupSnapshot, opts metav1.CreateOptions) (result *v1.TridentGroupSnapshot, err error) {
	result = &v1.TridentGroupSnapshot{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentGroupSnapshot).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentGroupSnapshot and updates it. Returns the server's representation of the tridentGroupSnapshot, and an error, if there is any.
func (c *tridentGroupSnapshots) Update(ctx context.Context, tridentGroupSnapshot *v1.TridentGroupSnapshot, opts metav1.UpdateOptions) (result *v1.TridentGroupSnapshot, err error) {
	result = &v1.TridentGroupSnapshot{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		Name(tridentGroupSnapshot.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentGroupSnapshot).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentGroupSnapshot and deletes it. Returns an error if one occurs.
func (c *tridentGroupSnapshots) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentGroupSnapshots) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentGroupSnapshot.
func (c *tridentGroupSnapshots) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentGroupSnapshot, err error) {
	result = &v1.TridentGroupSnapshot{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentgroupsnapshots").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
