// Copyright 2023 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentNodesGetter has a method to return a TridentNodeInterface.
// A group's client should implement this interface.
type TridentNodesGetter interface {
	TridentNodes(namespace string) TridentNodeInterface
}

// TridentNodeInterface has methods to work with TridentNode resources.
type TridentNodeInterface interface {
	Create(ctx context.Context, tridentNode *v1.TridentNode, opts metav1.CreateOptions) (*v1.TridentNode, error)
	Update(ctx context.Context, tridentNode *v1.TridentNode, opts metav1.UpdateOptions) (*v1.TridentNode, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentNode, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentNodeList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentNode, err error)
	TridentNodeExpansion
}

// tridentNodes implements TridentNodeInterface
type tridentNodes struct {
	client rest.Interface
	ns     string
}

// newTridentNodes returns a TridentNodes
func newTridentNodes(c *TridentV1Client, namespace string) *tridentNodes {
	return &tridentNodes{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentNode, and returns the corresponding tridentNode object, and an error if there is any.
func (c *tridentNodes) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentNode, err error) {
	result = &v1.TridentNode{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentnodes").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentNodes that match those selectors.
func (c *tridentNodes) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentNodeList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentNodeList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentnodes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentNodes.
func (c *tridentNodes) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentnodes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentNode and creates it.  Returns the server's representation of the tridentNode, and an error, if there is any.
func (c *tridentNodes) Create(ctx context.Context, tridentNode *v1.TridentNode, opts metav1.CreateOptions) (result *v1.TridentNode, err error) {
	result = &v1.TridentNode{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentnodes").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentNode).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentNode and updates it. Returns the server's representation of the tridentNode, and an error, if there is any.
func (c *tridentNodes) Update(ctx context.Context, tridentNode *v1.TridentNode, opts metav1.UpdateOptions) (result *v1.TridentNode, err error) {
	result = &v1.TridentNode{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentnodes").
		Name(tridentNode.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentNode).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentNode and deletes it. Returns an error if one occurs.
func (c *tridentNodes) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentnodes").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentNodes) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentnodes").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentNode.
func (c *tridentNodes) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentNode, err error) {
	result = &v1.TridentNode{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentnodes").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
