// Copyright 2023 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentSnapshotsGetter has a method to return a TridentSnapshotInterface.
// A group's client should implement this interface.
type TridentSnapshotsGetter interface {
	TridentSnapshots(namespace string) TridentSnapshotInterface
}

// TridentSnapshotInterface has methods to work with TridentSnapshot resources.
type TridentSnapshotInterface interface {
	Create(ctx context.Context, tridentSnapshot *v1.TridentSnapshot, opts metav1.CreateOptions) (*v1.TridentSnapshot, error)
	Update(ctx context.Context, tridentSnapshot *v1.TridentSnapshot, opts metav1.UpdateOptions) (*v1.TridentSnapshot, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentSnapshot, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentSnapshotList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentSnapshot, err error)
	TridentSnapshotExpansion
}

// tridentSnapshots implements TridentSnapshotInterface
type tridentSnapshots struct {
	client rest.Interface
	ns     string
}

// newTridentSnapshots returns a TridentSnapshots
func newTridentSnapshots(c *TridentV1Client, namespace string) *tridentSnapshots {
	return &tridentSnapshots{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentSnapshot, and returns the corresponding tridentSnapshot object, and an error if there is any.
func (c *tridentSnapshots) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentSnapshot, err error) {
	result = &v1.TridentSnapshot{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentSnapshots that match those selectors.
func (c *tridentSnapshots) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentSnapshotList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentSnapshotList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentSnapshots.
func (c *tridentSnapshots) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentSnapshot and creates it.  Returns the server's representation of the tridentSnapshot, and an error, if there is any.
func (c *tridentSnapshots) Create(ctx context.Context, tridentSnapshot *v1.TridentSnapshot, opts metav1.CreateOptions) (result *v1.TridentSnapshot, err error) {
	result = &v1.TridentSnapshot{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentSnapshot).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentSnapshot and updates it. Returns the server's representation of the tridentSnapshot, and an error, if there is any.
func (c *tridentSnapshots) Update(ctx context.Context, tridentSnapshot *v1.TridentSnapshot, opts metav1.UpdateOptions) (result *v1.TridentSnapshot, err error) {
	result = &v1.TridentSnapshot{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		Name(tridentSnapshot.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentSnapshot).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentSnapshot and deletes it. Returns an error if one occurs.
func (c *tridentSnapshots) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentSnapshots) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentsnapshots").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentSnapshot.
func (c *tridentSnapshots) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentSnapshot, err error) {
	result = &v1.TridentSnapshot{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentsnapshots").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
