// Copyright 2023 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentVolumePublicationsGetter has a method to return a TridentVolumePublicationInterface.
// A group's client should implement this interface.
type TridentVolumePublicationsGetter interface {
	TridentVolumePublications(namespace string) TridentVolumePublicationInterface
}

// TridentVolumePublicationInterface has methods to work with TridentVolumePublication resources.
type TridentVolumePublicationInterface interface {
	Create(ctx context.Context, tridentVolumePublication *v1.TridentVolumePublication, opts metav1.CreateOptions) (*v1.TridentVolumePublication, error)
	Update(ctx context.Context, tridentVolumePublication *v1.TridentVolumePublication, opts metav1.UpdateOptions) (*v1.TridentVolumePublication, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentVolumePublication, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentVolumePublicationList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentVolumePublication, err error)
	TridentVolumePublicationExpansion
}

// tridentVolumePublications implements TridentVolumePublicationInterface
type tridentVolumePublications struct {
	client rest.Interface
	ns     string
}

// newTridentVolumePublications returns a TridentVolumePublications
func newTridentVolumePublications(c *TridentV1Client, namespace string) *tridentVolumePublications {
	return &tridentVolumePublications{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentVolumePublication, and returns the corresponding tridentVolumePublication object, and an error if there is any.
func (c *tridentVolumePublications) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentVolumePublication, err error) {
	result = &v1.TridentVolumePublication{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentVolumePublications that match those selectors.
func (c *tridentVolumePublications) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentVolumePublicationList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentVolumePublicationList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentVolumePublications.
func (c *tridentVolumePublications) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentVolumePublication and creates it.  Returns the server's representation of the tridentVolumePublication, and an error, if there is any.
func (c *tridentVolumePublications) Create(ctx context.Context, tridentVolumePublication *v1.TridentVolumePublication, opts metav1.CreateOptions) (result *v1.TridentVolumePublication, err error) {
	result = &v1.TridentVolumePublication{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentVolumePublication).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentVolumePublication and updates it. Returns the server's representation of the tridentVolumePublication, and an error, if there is any.
func (c *tridentVolumePublications) Update(ctx context.Context, tridentVolumePublication *v1.TridentVolumePublication, opts metav1.UpdateOptions) (result *v1.TridentVolumePublication, err error) {
	result = &v1.TridentVolumePublication{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		Name(tridentVolumePublication.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentVolumePublication).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentVolumePublication and deletes it. Returns an error if one occurs.
func (c *tridentVolumePublications) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentVolumePublications) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentVolumePublication.
func (c *tridentVolumePublications) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentVolumePublication, err error) {
	result = &v1.TridentVolumePublication{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentvolumepublications").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
