// Copyright 2023 NetApp, Inc. All Rights Reserved.

// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"context"
	"time"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"

	v1 "github.com/netapp/trident/persistent_store/crd/apis/netapp/v1"
	scheme "github.com/netapp/trident/persistent_store/crd/client/clientset/versioned/scheme"
)

// TridentVolumeReferencesGetter has a method to return a TridentVolumeReferenceInterface.
// A group's client should implement this interface.
type TridentVolumeReferencesGetter interface {
	TridentVolumeReferences(namespace string) TridentVolumeReferenceInterface
}

// TridentVolumeReferenceInterface has methods to work with TridentVolumeReference resources.
type TridentVolumeReferenceInterface interface {
	Create(ctx context.Context, tridentVolumeReference *v1.TridentVolumeReference, opts metav1.CreateOptions) (*v1.TridentVolumeReference, error)
	Update(ctx context.Context, tridentVolumeReference *v1.TridentVolumeReference, opts metav1.UpdateOptions) (*v1.TridentVolumeReference, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.TridentVolumeReference, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.TridentVolumeReferenceList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentVolumeReference, err error)
	TridentVolumeReferenceExpansion
}

// tridentVolumeReferences implements TridentVolumeReferenceInterface
type tridentVolumeReferences struct {
	client rest.Interface
	ns     string
}

// newTridentVolumeReferences returns a TridentVolumeReferences
func newTridentVolumeReferences(c *TridentV1Client, namespace string) *tridentVolumeReferences {
	return &tridentVolumeReferences{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the tridentVolumeReference, and returns the corresponding tridentVolumeReference object, and an error if there is any.
func (c *tridentVolumeReferences) Get(ctx context.Context, name string, options metav1.GetOptions) (result *v1.TridentVolumeReference, err error) {
	result = &v1.TridentVolumeReference{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of TridentVolumeReferences that match those selectors.
func (c *tridentVolumeReferences) List(ctx context.Context, opts metav1.ListOptions) (result *v1.TridentVolumeReferenceList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.TridentVolumeReferenceList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested tridentVolumeReferences.
func (c *tridentVolumeReferences) Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a tridentVolumeReference and creates it.  Returns the server's representation of the tridentVolumeReference, and an error, if there is any.
func (c *tridentVolumeReferences) Create(ctx context.Context, tridentVolumeReference *v1.TridentVolumeReference, opts metav1.CreateOptions) (result *v1.TridentVolumeReference, err error) {
	result = &v1.TridentVolumeReference{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentVolumeReference).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a tridentVolumeReference and updates it. Returns the server's representation of the tridentVolumeReference, and an error, if there is any.
func (c *tridentVolumeReferences) Update(ctx context.Context, tridentVolumeReference *v1.TridentVolumeReference, opts metav1.UpdateOptions) (result *v1.TridentVolumeReference, err error) {
	result = &v1.TridentVolumeReference{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		Name(tridentVolumeReference.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(tridentVolumeReference).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the tridentVolumeReference and deletes it. Returns an error if one occurs.
func (c *tridentVolumeReferences) Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *tridentVolumeReferences) DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched tridentVolumeReference.
func (c *tridentVolumeReferences) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.TridentVolumeReference, err error) {
	result = &v1.TridentVolumeReference{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("tridentvolumereferences").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
