// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new application API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for application API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ApplicationCollectionGet(params *ApplicationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationCollectionGetOK, error)

	ApplicationComponentCollectionGet(params *ApplicationComponentCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentCollectionGetOK, error)

	ApplicationComponentGet(params *ApplicationComponentGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentGetOK, error)

	ApplicationComponentSnapshotCollectionGet(params *ApplicationComponentSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotCollectionGetOK, error)

	ApplicationComponentSnapshotCreate(params *ApplicationComponentSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotCreateCreated, *ApplicationComponentSnapshotCreateAccepted, error)

	ApplicationComponentSnapshotDelete(params *ApplicationComponentSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotDeleteOK, *ApplicationComponentSnapshotDeleteAccepted, error)

	ApplicationComponentSnapshotDeleteCollection(params *ApplicationComponentSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotDeleteCollectionOK, *ApplicationComponentSnapshotDeleteCollectionAccepted, error)

	ApplicationComponentSnapshotGet(params *ApplicationComponentSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotGetOK, error)

	ApplicationComponentSnapshotRestore(params *ApplicationComponentSnapshotRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotRestoreCreated, *ApplicationComponentSnapshotRestoreAccepted, error)

	ApplicationCreate(params *ApplicationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationCreateCreated, *ApplicationCreateAccepted, error)

	ApplicationDelete(params *ApplicationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationDeleteOK, *ApplicationDeleteAccepted, error)

	ApplicationDeleteCollection(params *ApplicationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationDeleteCollectionOK, *ApplicationDeleteCollectionAccepted, error)

	ApplicationGet(params *ApplicationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationGetOK, error)

	ApplicationModify(params *ApplicationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationModifyOK, *ApplicationModifyAccepted, error)

	ApplicationModifyCollection(params *ApplicationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationModifyCollectionOK, *ApplicationModifyCollectionAccepted, error)

	ApplicationSnapshotCollectionGet(params *ApplicationSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotCollectionGetOK, error)

	ApplicationSnapshotCreate(params *ApplicationSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotCreateCreated, *ApplicationSnapshotCreateAccepted, error)

	ApplicationSnapshotDelete(params *ApplicationSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotDeleteOK, *ApplicationSnapshotDeleteAccepted, error)

	ApplicationSnapshotDeleteCollection(params *ApplicationSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotDeleteCollectionOK, *ApplicationSnapshotDeleteCollectionAccepted, error)

	ApplicationSnapshotGet(params *ApplicationSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotGetOK, error)

	ApplicationSnapshotRestore(params *ApplicationSnapshotRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotRestoreCreated, *ApplicationSnapshotRestoreAccepted, error)

	ApplicationTemplateCollectionGet(params *ApplicationTemplateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationTemplateCollectionGetOK, error)

	ApplicationTemplateGet(params *ApplicationTemplateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationTemplateGetOK, error)

	ConsistencyGroupCollectionGet(params *ConsistencyGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupCollectionGetOK, error)

	ConsistencyGroupCreate(params *ConsistencyGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupCreateCreated, *ConsistencyGroupCreateAccepted, error)

	ConsistencyGroupDelete(params *ConsistencyGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupDeleteOK, *ConsistencyGroupDeleteAccepted, error)

	ConsistencyGroupDeleteCollection(params *ConsistencyGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupDeleteCollectionOK, *ConsistencyGroupDeleteCollectionAccepted, error)

	ConsistencyGroupGet(params *ConsistencyGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupGetOK, error)

	ConsistencyGroupMetricsCollectionGet(params *ConsistencyGroupMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupMetricsCollectionGetOK, error)

	ConsistencyGroupModify(params *ConsistencyGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupModifyOK, *ConsistencyGroupModifyAccepted, error)

	ConsistencyGroupModifyCollection(params *ConsistencyGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupModifyCollectionOK, *ConsistencyGroupModifyCollectionAccepted, error)

	ConsistencyGroupSnapshotCollectionGet(params *ConsistencyGroupSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotCollectionGetOK, error)

	ConsistencyGroupSnapshotCreate(params *ConsistencyGroupSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotCreateCreated, *ConsistencyGroupSnapshotCreateAccepted, error)

	ConsistencyGroupSnapshotDelete(params *ConsistencyGroupSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotDeleteOK, *ConsistencyGroupSnapshotDeleteAccepted, error)

	ConsistencyGroupSnapshotDeleteCollection(params *ConsistencyGroupSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotDeleteCollectionOK, *ConsistencyGroupSnapshotDeleteCollectionAccepted, error)

	ConsistencyGroupSnapshotGet(params *ConsistencyGroupSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotGetOK, error)

	ConsistencyGroupSnapshotModify(params *ConsistencyGroupSnapshotModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotModifyOK, *ConsistencyGroupSnapshotModifyAccepted, error)

	ConsistencyGroupSnapshotModifyCollection(params *ConsistencyGroupSnapshotModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotModifyCollectionOK, *ConsistencyGroupSnapshotModifyCollectionAccepted, error)

	ContainerCreate(params *ContainerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ContainerCreateCreated, *ContainerCreateAccepted, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	ApplicationCollectionGet Retrieves applications.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `<template>` the property corresponding to the `template.name` of the application
### Query examples
Numerous queries are available for classifying and sorting applications:
 1. Return a list of applications sorted by name.
    ```
    GET /application/applications?order_by=name
    ```
    <br/>
 2. Return a list of applications for a specific SVM.
    ```
    GET /application/applications?svm.name=<name>
    ```
    <br/>
 3. Return a list of all SQL applications.
    ```
    GET /application/applications?template.name=sql*
    ```
    <br/>
 4. Return a list of all applications that can be accessed via SAN.<br/>
    ```
    GET /application/applications?template.protocol=san
    ```
    <br/>
 5. Return the top five applications consuming the most IOPS.<br/>
    ```
    GET /application/applications?order_by=statistics.iops.total desc&max_records=5
    ```

<br/>The above examples are not comprehensive. There are many more properties available for queries. Also, multiple queries can be mixed and matched with other query parameters for a large variety of requests. See the per-property documentation below for the full list of supported query parameters.
### Learn more
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationCollectionGet(params *ApplicationCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_collection_get",
		Method:             "GET",
		PathPattern:        "/application/applications",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentCollectionGet Retrieves application components.

### Overview
The application component object exposes how to access an application. Most application interfaces abstract away the underlying ONTAP storage elements, but this interface exposes what is necessary to connect to and uses the storage that is provisioned for an application. See the application component model for a detailed description of each property.
### Query examples
Queries are limited on this API. Most of the details are nested under the `nfs_access`, `cifs_access`, or `san_access` properties, but those properties do not support queries, and properties nested under those properties cannot be requested individually in the current release.<br/>
The following query returns all application components with names beginning in _secondary_.<br/><br/>
```
GET /application/applications/{application.uuid}/components?name=secondary*
```
<br/>The following query returns all application components at the _extreme_ storage service.<br/><br/>
```
GET /application/applications/{application.uuid}/components?storage_service.name=extreme
```
### Learn more
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationComponentCollectionGet(params *ApplicationComponentCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_collection_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{application.uuid}/components",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationComponentCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentGet Retrieves an application component.

### Overview
The application component object exposes how to access an application. Most application interfaces abstract away the underlying ONTAP storage elements, but this interface exposes what is necessary to connect to and uses the storage that is provisioned for an application. See the application component model for a detailed description of each property.
### Access
Each application component can be accessed via NFS, CIFS, or SAN. NFS and CIFS access can be enabled simultaneously. Each access section includes a `backing_storage` property. This property is used to correlate the storage elements with the access elements of the application. The `backing_storage` portion of the access section provides the `type` and `uuid` of the backing storage. There is another `backing_storage` property at the same level as the access properties which contains lists of backing storage elements corresponding to the types listed in the access section.
### Learn more
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationComponentGet(params *ApplicationComponentGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{application.uuid}/components/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationComponentGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentSnapshotCollectionGet Retrieves snapshots of an application component.<br/>

This endpoint is only supported for Maxdata template applications.<br/>
Component snapshots are essentially more granular application snapshots. There is no difference beyond the scope of the operation.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`GET /application/applications/{uuid}/snapshots`](#operations-application-application_snapshot_collection_get)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationComponentSnapshotCollectionGet(params *ApplicationComponentSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentSnapshotCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_snapshot_collection_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{application.uuid}/components/{component.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentSnapshotCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationComponentSnapshotCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentSnapshotCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentSnapshotCreate Creates a snapshot of an application component.<br/>

This endpoint is only supported for Maxdata template applications.<br/>
### Required properties
* `name`
### Recommended optional properties
* `consistency_type` - Track whether this snapshot is _application_ or _crash_ consistent.
Component snapshots are essentially more granular application snapshots. There is no difference beyond the scope of the operation.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`GET /application/applications/{uuid}/snapshots`](#operations-application-application_snapshot_create)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationComponentSnapshotCreate(params *ApplicationComponentSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotCreateCreated, *ApplicationComponentSnapshotCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentSnapshotCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_snapshot_create",
		Method:             "POST",
		PathPattern:        "/application/applications/{application.uuid}/components/{component.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentSnapshotCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationComponentSnapshotCreateCreated:
		return value, nil, nil
	case *ApplicationComponentSnapshotCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentSnapshotCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentSnapshotDelete Delete a snapshot of an application component.<br/>

This endpoint is only supported for Maxdata template applications.<br/>
Component snapshots are essentially more granular application snapshots. There is no difference beyond the scope of the operation.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`DELETE /application/applications/{uuid}/snapshots`](#operations-application-application_snapshot_delete)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationComponentSnapshotDelete(params *ApplicationComponentSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotDeleteOK, *ApplicationComponentSnapshotDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentSnapshotDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_snapshot_delete",
		Method:             "DELETE",
		PathPattern:        "/application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentSnapshotDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationComponentSnapshotDeleteOK:
		return value, nil, nil
	case *ApplicationComponentSnapshotDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentSnapshotDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ApplicationComponentSnapshotDeleteCollection application component snapshot delete collection API
*/
func (a *Client) ApplicationComponentSnapshotDeleteCollection(params *ApplicationComponentSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotDeleteCollectionOK, *ApplicationComponentSnapshotDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentSnapshotDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_snapshot_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/application/applications/{application.uuid}/components/{component.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentSnapshotDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationComponentSnapshotDeleteCollectionOK:
		return value, nil, nil
	case *ApplicationComponentSnapshotDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentSnapshotDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentSnapshotGet Retrieve a snapshot of an application component.<br/>

This endpoint is only supported for Maxdata template applications.<br/>
Component snapshots are essentially more granular application snapshots. There is no difference beyond the scope of the operation.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`GET /application/applications/{uuid}/snapshots`](#operations-application-application_snapshot_get)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationComponentSnapshotGet(params *ApplicationComponentSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentSnapshotGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_snapshot_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentSnapshotGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationComponentSnapshotGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentSnapshotGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationComponentSnapshotRestore Restore a snapshot of an application component.<br/>

This endpoint is only supported for Maxdata template applications.<br/>
Component snapshots are essentially more granular application snapshots. There is no difference beyond the scope of the operation.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`POST /application/applications/{application.uuid}/snapshots/{uuid}/restore`](#operations-application-application_snapshot_restore)
* [`DOC /application`](#docs-application-overview)
* [`Asynchronous operations`](#Synchronous_and_asynchronous_operations)
*/
func (a *Client) ApplicationComponentSnapshotRestore(params *ApplicationComponentSnapshotRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationComponentSnapshotRestoreCreated, *ApplicationComponentSnapshotRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationComponentSnapshotRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_component_snapshot_restore",
		Method:             "POST",
		PathPattern:        "/application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationComponentSnapshotRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationComponentSnapshotRestoreCreated:
		return value, nil, nil
	case *ApplicationComponentSnapshotRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationComponentSnapshotRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationCreate Creates an application.

### Supported templates
* MongoDBOnSAN
* MultiComponentNAS
* NAS
* NVME
* OracleOnNFS
* OracleOnSAN
* OracleRACOnNFS
* OracleRACOnSAN
* S3
* SAN
* SAPHANAOnNFS
* SQLOnSAN
* SQLOnSMB
* VDIOnNAS
* VDIOnSAN
* VSIOnNAS
* VSIOnSAN
### Template properties
The application APIs appear to be complex and long in this documentation because we document every possible template, of which there are currently 14. When creating an application, only a single template is used, so it is best to focus only on the template of interest. Other than the properties for the chosen template, only the `name` and `svm` of the application must be provided. The following three sections provided guidelines on using the properties of the templates, but the whole idea behind the templates is to automatically follow the best practices of the given application, so the only way to determine the exact list of required properties and default values is to dig in to the model section of the template. The templates are all top level properties of the application object with names matching the values returned by [`GET /application/templates`](#operations-application-application_template_collection_get).
### Required properties
* `svm.uuid` or `svm.name` - The existing SVM in which to create the application.
* `name` - The name for the application.
* `<template>` - Properties for one template must be provided. In general, the following properties are required, however the naming of these may vary slightly from template to template.
  - `<template>.name` - The generic templates require names for the components of the application. Other templates name the components automatically.
  - `<template>.application_component.size` - This generally refers to the size of an application component, which may be spread across multiple underlying storage objects (volumes, LUNs, etc...).
  - One of the following must be specified:
  - `nas.nfs_access` or an identifier (name or id) of an existing `export-policy`.
  - `nas.cifs_access`
  - `san.application_application.igroup_name`
  - To specify that a NAS application is not to be exposed via NFS nor CIFS:
  - `nas.application_component.export_policy.name` is 'none', and
  - `nas.application.cifs_share_name` is 'none'.
  - The name of the CIFS share can be provided through the `nas.application.cifs_share_name` attribute. If not provided, the CIFS share name will be the same as the `nas.application_component.name` attribute, including any suffix applied due to creating multiple application components in one post.
  - `san.os_type` - All SAN applications require an os_type to be specified in some way. Some templates refer to this as the `hypervisor`.

### Recommended optional properties
* `<template>` - The following properties are available in some templates.
  - `san.new_igroups.*` - SAN applications can use existing initiator groups or create new ones. When creating new initiator groups, `new_igroups.name` is required and the other properties may be used to fully specify the new initiator group.

### Default property values
If not specified in POST, the follow default property values are assigned. It is recommended that most of these properties be provided explicitly rather than relying upon the defaults. The defaults are intended to make it as easy as possible to provision and connect to an application.
* `template.name` - Defaults to match the `<template>` provided. If specified, the value of this property must match the provided template properties.
* `<template>` - The majority of template properties have default values. The defaults may vary from template to template. See the model of each template for complete details. In general the following patterns are common across all template properties. The location of these properties varies from template to template.
  - `<template>.storage_service.name` - _value_
  - `<template>.protection_type.local_rpo` - _hourly_ (Hourly snapshots)
  - `<template>.protection_type.remote_rpo` - _none_ (Not MetroCluster)
  - `san.new_igroups.os_type` - Defaults to match the `os_type` provided for the application, but may need to be provided explicitly when using virtualization.

### Optional components
A common pattern across many templates are objects that are optional, but once any property in the object is specified, other properties within the object become required. Many applications have optional components. For example, provisioning a database without a component to store the logs is supported. If the properties related to the logs are omitted, no storage will be provisioned for logs. But when the additional component is desired, the size is required. Specifying any other property of a component without specifying the size is not supported. In the model of each template, the required components are indicated with a red '*'. When a `size` property is listed as optional, that means the component itself is optional, and the size should be specified to include that component in the application.
### POST body examples
 1. Create a generic SAN application that exposes four LUNs to an existing initiator group, _igroup_1_.<br/>
    ```
    {
    "name": "app1",
    "svm": { "name": "svm1" },
    "san": {
    "os_type": "linux",
    "application_components": [
    { "name": "component1", "total_size": "10GB", "lun_count": 4, "igroup_name": "igroup_1" }
    ]
    }
    }
    ```
    <br/>
 2. Create an SQL application that can be accessed via initiator _iqn.2017-01.com.example:foo_ from a new initiator group, _igroup_2_.<br/>
    ```
    {
    "name": "app2",
    "svm": { "name": "svm1" },
    "sql_on_san": {
    "db": { "size": "5GB" },
    "log": { "size": "1GB" },
    "temp_db": { "size": "2GB" },
    "igroup_name": "igroup_2",
    "new_igroups": [
    { "name": "igroup_2", "initiators": [ "iqn.2017-01.com.example:foo" ] }
    ]
    }
    }
    ```
    <br/>
 3. The following body creates the exact same SQL application, but manually provides all the defaults that were excluded from the previous call. Note: The model of a _sql_on_san_ application documents all these default values.<br/>
    ```
    {
    "name": "app3",
    "svm": { "name": "svm1" },
    "template": { "name": "sql_on_san" },
    "sql_on_san": {
    "os_type": "windows_2008",
    "server_cores_count": 8,
    "db": { "size": "5GB", "storage_service": { "name": "value" } },
    "log": { "size": "1GB", "storage_service": { "name": "value" } },
    "temp_db": { "size": "2GB", "storage_service": { "name": "value" } },
    "igroup_name": "igroup_2",
    "new_igroups": [
    {
    "name": "igroup_2",
    "protocol": "mixed",
    "os_type": "windows",
    "initiators": [ "iqn.a.new.initiator" ]
    }
    ],
    "protection_type": { "local_rpo": "none" }
    }
    }
    ```

### Learn more
* [`DOC /application`](#docs-application-overview)
* [`Asynchronous operations`](#Synchronous_and_asynchronous_operations)
*/
func (a *Client) ApplicationCreate(params *ApplicationCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationCreateCreated, *ApplicationCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_create",
		Method:             "POST",
		PathPattern:        "/application/applications",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationCreateCreated:
		return value, nil, nil
	case *ApplicationCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationDelete Deletes an application and all associated data.

### Warning - this deletes it all, including your data
This deletes everything created with the application, including any volumes, LUNs, NFS export policies, CIFS shares, and initiator groups. Initiator groups are only destroyed if they were created as part of an application and are no longer in use by other applications.
### Learn more
* [`DOC /application`](#docs-application-overview)
* [`Asynchronous operations`](#Synchronous_and_asynchronous_operations)
*/
func (a *Client) ApplicationDelete(params *ApplicationDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationDeleteOK, *ApplicationDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_delete",
		Method:             "DELETE",
		PathPattern:        "/application/applications/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationDeleteOK:
		return value, nil, nil
	case *ApplicationDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ApplicationDeleteCollection application delete collection API
*/
func (a *Client) ApplicationDeleteCollection(params *ApplicationDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationDeleteCollectionOK, *ApplicationDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/application/applications",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationDeleteCollectionOK:
		return value, nil, nil
	case *ApplicationDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationGet Retrieves an application

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `<template>` the property corresponding to the `template.name` of the application
### Property overview
An application includes three main groups or properties.
* Generic properties - such as the `name`, `template.name`, and `state` of the application. These properties are all inexpensive to retrieve and their meaning is consistent for every type of application.
* `statistics.*` - application statistics report live usage data about the application and its components. Various space and IOPS details are included at both the application level and at a per component level. The application model includes a detailed description of each property. These properties are slightly more expensive than the generic properties because live data must be collected from every storage element in the application.
* `<template>` - the property corresponding to the value of the `template.name` returns the contents of the application in the same layout that was used to provision the application. This information is very expensive to retrieve because it requires collecting information about all the storage and access settings for every element of the application. There are a few notable limitations to what can be returned in the `<template>` section:
  - The `new_igroups` array of many SAN templates is not returned by GET. This property allows igroup creation in the same call that creates an application, but is not a property of the application itself. The `new_igroups` array is allowed during PATCH operations, but that does not modify the `new_igroups` of the application. It is another way to allow igroup creation while updating the application to use a different igroup.
  - The `vdi_on_san` and `vdi_on_nas` `desktops.count` property is rounded to the nearest 1000 during creation, and is reported with that rounding applied.
  - The `mongo_db_on_san` `dataset.element_count` property is rounded up to an even number, and is reported with that rounding applied.
  - The `sql_on_san` and `sql_on_smb` `server_cores_count` property is limited to 8 for GET operations. Higher values are accepted by POST, but the impact of the `server_cores_count` property on the application layout currently reaches its limit at 8.

### Learn more
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationGet(params *ApplicationGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationModify Updates the properties of an application.

### Overview
Similar to creating an application, modification is done using the template properties of an application. The `storage_service`, `size`, and `igroup_name` of an application may be modified.
### `storage_service`
Storage service modifications are processed in place, meaning that the storage can not be moved to a location with more performance headroom to accommodate the request. If the current backing storage of the application is in a location that can support increased performance, the QoS policies associated with the application will be modified to allow it. If not, an error will be returned. A storage service modification to a lower tier of performance is always allowed, but the reverse modification may not be supported if the cluster is over provisioned and the cluster is unlikely to be able to fulfil the original storage service.
### `size`
Size modifications are processed in a variety of ways depending on the type of application. For NAS applications, volumes are grown or new volumes are added. For SAN applications, LUNs are grown, new LUNs are added to existing volumes, or new LUNs are added to new volumes. If new storage elements are created, they can be found using the [`GET /application/applications/{application.uuid}/components`](#operations-application-application_component_collection_get) interface. The creation time of each storage object is included, and the newly created objects will use the same naming scheme as the previous objects. Resize follows the best practices associated with the type of application being expanded. Reducing the size of an application is not supported.
### `igroup_name`
Modification of the igroup name allows an entire application to be mapped from one initiator group to another. Data access will be interrupted as the LUNs are unmapped from the original igroup and remapped to the new one.
### Application state
During a modification, the `state` property of the application updates to indicate `modifying`. In `modifying` state, statistics are not available and snapshot operations are not allowed. If the modification fails, it is possible for the application to be left in an inconsistent state, with the underlying ONTAP storage elements not matching across a component. When this occurs, the application is left in the `modifying` state until the command is either retried and succeeds or a call to restore the original state is successful.
### Examples
 1. Change the storage service of the database of the Oracle application to _extreme_ and resize the redo logs to _100GB_.
    ```
    {
    "oracle_on_nfs": {
    "db": {
    "storage_service": {
    "name": "extreme"
    }
    },
    "redo_log": {
    "size": "100GB"
    }
    }
    }
    ```
    <br/>
 2. Change the storage service, size, and igroup of a generic application by component name.
    ```
    {
    "san": {
    "application_components": [
    {
    "name": "component1",
    "storage_service": {
    "name": "value"
    }
    },
    {
    "name": "component2",
    "size": "200GB"
    },
    {
    "name": "component3",
    "igroup_name": "igroup5"
    }
    ]
    }
    }
    ```
    <br/>

### Learn more
* [`DOC /application`](#docs-application-overview)
* [`Asynchronous operations`](#Synchronous_and_asynchronous_operations)
*/
func (a *Client) ApplicationModify(params *ApplicationModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationModifyOK, *ApplicationModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_modify",
		Method:             "PATCH",
		PathPattern:        "/application/applications/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationModifyOK:
		return value, nil, nil
	case *ApplicationModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ApplicationModifyCollection application modify collection API
*/
func (a *Client) ApplicationModifyCollection(params *ApplicationModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationModifyCollectionOK, *ApplicationModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/application/applications",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationModifyCollectionOK:
		return value, nil, nil
	case *ApplicationModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationSnapshotCollectionGet Retrieves snapshots of an application.

### Query examples
The following query returns all snapshots from May 4, 2017 EST. For readability, the colon (`:`) is left in this example. For an actual call, they should be escaped as `%3A`.<br/><br/>
```
GET /application/applications/{application.uuid}/snapshots?create_time=2017-05-04T00:00:00-05:00..2017-05-04T23:59:59-05:00
```
<br/>The following query returns all snapshots that have been flagged as _application consistent_.<br/><br/>
```
GET /application/applications/{application.uuid}/snapshots?consistency_type=application
```
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationSnapshotCollectionGet(params *ApplicationSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationSnapshotCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_snapshot_collection_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{application.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationSnapshotCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationSnapshotCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationSnapshotCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationSnapshotCreate Creates a snapshot of the application.

### Required properties
* `name`
### Recommended optional properties
* `consistency_type` - Track whether this snapshot is _application_ or _crash_ consistent.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationSnapshotCreate(params *ApplicationSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotCreateCreated, *ApplicationSnapshotCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationSnapshotCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_snapshot_create",
		Method:             "POST",
		PathPattern:        "/application/applications/{application.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationSnapshotCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationSnapshotCreateCreated:
		return value, nil, nil
	case *ApplicationSnapshotCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationSnapshotCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationSnapshotDelete Delete a snapshot of an application

### Query examples
Individual snapshots can be destroyed with no query parameters, or a range of snapshots can be destroyed at one time using a query.<br/>
The following query deletes all application snapshots created before May 4, 2017<br/><br/>
```
DELETE /application/applications/{application.uuid}/snapshots?create_time=<2017-05-04T00:00:00-05:00
```
*/
func (a *Client) ApplicationSnapshotDelete(params *ApplicationSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotDeleteOK, *ApplicationSnapshotDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationSnapshotDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_snapshot_delete",
		Method:             "DELETE",
		PathPattern:        "/application/applications/{application.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationSnapshotDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationSnapshotDeleteOK:
		return value, nil, nil
	case *ApplicationSnapshotDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationSnapshotDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ApplicationSnapshotDeleteCollection application snapshot delete collection API
*/
func (a *Client) ApplicationSnapshotDeleteCollection(params *ApplicationSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotDeleteCollectionOK, *ApplicationSnapshotDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationSnapshotDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_snapshot_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/application/applications/{application.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationSnapshotDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationSnapshotDeleteCollectionOK:
		return value, nil, nil
	case *ApplicationSnapshotDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationSnapshotDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationSnapshotGet Retrieve a snapshot of an application component.<br/>

This endpoint is only supported for Maxdata template applications.<br/>
Component snapshots are essentially more granular application snapshots. There is no difference beyond the scope of the operation.
### Learn more
* [`DOC /application/applications/{application.uuid}/snapshots`](#docs-application-application_applications_{application.uuid}_snapshots)
* [`GET /application/applications/{uuid}/snapshots`](#operations-application-application_snapshot_create)
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationSnapshotGet(params *ApplicationSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationSnapshotGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_snapshot_get",
		Method:             "GET",
		PathPattern:        "/application/applications/{application.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationSnapshotGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationSnapshotGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationSnapshotGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationSnapshotRestore Restore an application snapshot<br/>

Restoring an application snapshot reverts all storage elements in the snapshot to the state in which the snapshot was in when the snapshot was taken. This restoration does not apply to access settings that might have changed since the snapshot was created.
### Learn more
* [`DOC /application`](#docs-application-overview)
* [`Asynchronous operations`](#Synchronous_and_asynchronous_operations)
*/
func (a *Client) ApplicationSnapshotRestore(params *ApplicationSnapshotRestoreParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationSnapshotRestoreCreated, *ApplicationSnapshotRestoreAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationSnapshotRestoreParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_snapshot_restore",
		Method:             "POST",
		PathPattern:        "/application/applications/{application.uuid}/snapshots/{uuid}/restore",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationSnapshotRestoreReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ApplicationSnapshotRestoreCreated:
		return value, nil, nil
	case *ApplicationSnapshotRestoreAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationSnapshotRestoreDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationTemplateCollectionGet Retrieves application templates.

### Query examples
The most useful queries on this API allows searches by name or protocol access. The following query returns all templates that are used to provision an Oracle application.<br/><br/>
```
GET /application/templates?name=ora*
```
<br/>Similarly, the following query returns all templates that support SAN access.<br/><br/>
```
GET /application/templates?protocol=san
```
### Learn more
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationTemplateCollectionGet(params *ApplicationTemplateCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationTemplateCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationTemplateCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_template_collection_get",
		Method:             "GET",
		PathPattern:        "/application/templates",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationTemplateCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationTemplateCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationTemplateCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ApplicationTemplateGet Retrieves an application template.

### Template properties
Each application template has a set of properties. These properties are always nested under a property with the same name as the template. <personalities supports=unified> For example, when using the `s3_bucket` template, the properties are found nested inside the `s3_bucket` property.</personalities> The properties nested under the template property are all specific to the template. The model for the application template object includes all the available templates, but only the object that corresponds to the template's name is returned, and only one is provided in any application API.<br/>
The model of each template includes a description of each property and its allowed values or usage. Default values are also indicated when available. The template properties returned by this API include an example value for each property.
### Template prerequisites
Each template has a set of prerequisites required for its use. If any of these prerequisites are not met, the `missing_prerequisites` property indicates which prerequisite is missing.
### Learn more
* [`DOC /application`](#docs-application-overview)
*/
func (a *Client) ApplicationTemplateGet(params *ApplicationTemplateGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ApplicationTemplateGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewApplicationTemplateGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "application_template_get",
		Method:             "GET",
		PathPattern:        "/application/templates/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ApplicationTemplateGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ApplicationTemplateGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ApplicationTemplateGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupCollectionGet Retrieve details of a collection or a specific consistency group.

## Notes
When volume granular properties, such as, the storage SLC, Fabric Pool tiering are not the same for all the existing volumes of a consistency group, the corresponding property is not reported at consistency group granularity. It is only reported if all the volumes of the consistency group have the same value for that property.
<br>If this consistency group instance has 1 or more replication relationships, the "replicated" parameter is true.  If there are no associated replication relationships, it is false. This parameter is only included in the output for Single-CG and Parent-CG, not for Child-CG.
If this consistency group instance has 1 or more replication relationships, the "replication_relationships" parameter is included in the output for Single-CG and Parent-CG instances.  If there are no associated replication relationships, this parameter is not included in the output.
Note that this parameter is an array and as such it has as many elements as the number of replication relationships associated with this consistency group. Each element of the array describes properties of one replication relationship associated with this consistency group. The "uuid" parameter identifies a specific replication relationship and the "href" parameter is a link to the corresponding SnapMirror relationship. The "is_source" parameter is true if this consistency group is the source in that relationship, otherwise it is false.
## Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`DOC Requesting specific fields`](#docs-docs-Requesting-specific-fields) to learn more.
<personalities supports=aiml,unified>
* `volumes`
</personalities>
<personalities supports=unified,asar2>
* `luns`
* `namespaces`
</personalities>
## Related ONTAP commands
* `vserver consistency-group show'
*/
func (a *Client) ConsistencyGroupCollectionGet(params *ConsistencyGroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_collection_get",
		Method:             "GET",
		PathPattern:        "/application/consistency-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConsistencyGroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupCreate Creates a consistency group with one or more consistency groups having:

* new SAN volumes,
* existing SAN, NVMe or NAS FlexVol volumes in a new or existing consistency group
## Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the group.
<personalities supports=aiml,unified>
* `volumes`
</personalities>
<personalities supports=unified,asar2>
* `luns` or `namespaces`
</personalities>
## Naming Conventions
### Consistency groups
  - name or consistency_groups[].name, if specified
  - derived from volumes[0].name, if only one volume is specified, same as volume name

<personalities supports=aiml,unified>
### Volume
  - volumes[].name, if specified
  - derived from volume prefix in luns[].name
  - derived from cg[].name, suffixed by "_#" where "#" is a system generated unique number
  - suffixed by "_#" where "#" is a system generated unique number, if provisioning_options.count is provided

</personalities>
<personalities supports=unified,asar2>
### LUN
  - luns[].name, if specified
  - derived from volumes[].name, suffixed by "_#" where "#" is a system generated unique number
  - suffixed by "_#" where "#" is a system generated unique number, if provisioning_options.count is provided

### NVMe Namespace
  - namespaces[].name, if specified
  - derived from volumes[].name, suffixed by "_#" where "#" is a system generated unique number
  - suffixed by "_#" where "#" is a system generated unique number, if provisioning_options.count is provided

</personalities>
## Related ONTAP commands
* `vserver consistency-group create`
*/
func (a *Client) ConsistencyGroupCreate(params *ConsistencyGroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupCreateCreated, *ConsistencyGroupCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_create",
		Method:             "POST",
		PathPattern:        "/application/consistency-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupCreateCreated:
		return value, nil, nil
	case *ConsistencyGroupCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupDelete Deletes a consistency group.

<br>Note this will not delete any associated volumes or LUNs. To delete those elements, use the appropriate object endpoint.
## Related ONTAP commands
* `vserver consistency-group delete`
*/
func (a *Client) ConsistencyGroupDelete(params *ConsistencyGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupDeleteOK, *ConsistencyGroupDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_delete",
		Method:             "DELETE",
		PathPattern:        "/application/consistency-groups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupDeleteOK:
		return value, nil, nil
	case *ConsistencyGroupDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConsistencyGroupDeleteCollection consistency group delete collection API
*/
func (a *Client) ConsistencyGroupDeleteCollection(params *ConsistencyGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupDeleteCollectionOK, *ConsistencyGroupDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/application/consistency-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupDeleteCollectionOK:
		return value, nil, nil
	case *ConsistencyGroupDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupGet Retrieves a single consistency group.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`DOC Requesting specific fields`](#docs-docs-Requesting-specific-fields) to learn more.
* `volumes`
<personalities supports=asar2,unified>
* `luns`
* `namespaces`
</personalities>
## Related ONTAP commands
* `vserver consistency-group show`
*/
func (a *Client) ConsistencyGroupGet(params *ConsistencyGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_get",
		Method:             "GET",
		PathPattern:        "/application/consistency-groups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConsistencyGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConsistencyGroupMetricsCollectionGet Retrieves historical performance and capacity metrics for a consistency group.
*/
func (a *Client) ConsistencyGroupMetricsCollectionGet(params *ConsistencyGroupMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConsistencyGroupMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupModify Updates a consistency group.

<br>Note that this operation will never delete storage elements. You can specify only elements that should be added to the consistency group regardless of existing storage objects.
<personalities supports=unified>Mapping or unmapping a consistency group from igroups or subsystems is not supported.</personalities>
## Related ONTAP commands
* `vserver consistency-group modify`
*/
func (a *Client) ConsistencyGroupModify(params *ConsistencyGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupModifyOK, *ConsistencyGroupModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_modify",
		Method:             "PATCH",
		PathPattern:        "/application/consistency-groups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupModifyOK:
		return value, nil, nil
	case *ConsistencyGroupModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConsistencyGroupModifyCollection consistency group modify collection API
*/
func (a *Client) ConsistencyGroupModifyCollection(params *ConsistencyGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupModifyCollectionOK, *ConsistencyGroupModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/application/consistency-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupModifyCollectionOK:
		return value, nil, nil
	case *ConsistencyGroupModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupSnapshotCollectionGet Retrieves snapshots for a consistency group.

## Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`DOC Requesting specific fields`](#docs-docs-Requesting-specific-fields) to learn more.
* `is_partial`
* `missing_volumes.uuid`
* `missing_volumes.name`
*/
func (a *Client) ConsistencyGroupSnapshotCollectionGet(params *ConsistencyGroupSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_collection_get",
		Method:             "GET",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConsistencyGroupSnapshotCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupSnapshotCreate Creates a snapshot of an existing consistency group.

### Required properties
* `consistency_group.uuid` - Existing consistency group UUID in which to create the snapshot.
*/
func (a *Client) ConsistencyGroupSnapshotCreate(params *ConsistencyGroupSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotCreateCreated, *ConsistencyGroupSnapshotCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_create",
		Method:             "POST",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupSnapshotCreateCreated:
		return value, nil, nil
	case *ConsistencyGroupSnapshotCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupSnapshotDelete Deletes a snapshot of a consistency group.

## Examples
*/
func (a *Client) ConsistencyGroupSnapshotDelete(params *ConsistencyGroupSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotDeleteOK, *ConsistencyGroupSnapshotDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_delete",
		Method:             "DELETE",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupSnapshotDeleteOK:
		return value, nil, nil
	case *ConsistencyGroupSnapshotDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConsistencyGroupSnapshotDeleteCollection consistency group snapshot delete collection API
*/
func (a *Client) ConsistencyGroupSnapshotDeleteCollection(params *ConsistencyGroupSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotDeleteCollectionOK, *ConsistencyGroupSnapshotDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupSnapshotDeleteCollectionOK:
		return value, nil, nil
	case *ConsistencyGroupSnapshotDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupSnapshotGet Retrieves details of a specific snapshot for a consistency group.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`DOC Requesting specific fields`](#docs-docs-Requesting-specific-fields) to learn more.
* `is_partial`
* `missing_volumes.uuid`
* `missing_volumes.name`
*/
func (a *Client) ConsistencyGroupSnapshotGet(params *ConsistencyGroupSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_get",
		Method:             "GET",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConsistencyGroupSnapshotGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ConsistencyGroupSnapshotModify Completes a snapshot operation of a consistency group.

<personalities supports=asar2>
This can also be used to modify the SnapLock expiry time of a locked snapshot in SnapLock for SnapVault destination.
</personalities>
## Example
### Completing a snapshot operation

	The following example shows how to complete the snapshot operation by committing an existing snapshot to disk:
	```
	curl -X PATCH https://<mgmt-ip>/api/application/consistency-groups/a8d0626a-17a0-11eb-b141-005056acd498/snapshots/92c6c770-17a1-11eb-b141-005056acd498?action=commit
	```

#### Response:

	```
	{
	}
	```

<personalities supports=asar2>
### Modifying the SnapLock expiry time of a snapshot in SnapLock for SnapVault

	The following example shows how to modify the SnapLock expiry time of a locked snapshot in SnapLock for SnapVault destination:
	```
	curl -X PATCH 'https://<mgmt-ip>/api/application/consistency-groups/a8d0626a-17a0-11eb-b141-005056acd498/snapshots/92c6c770-17a1-11eb-b141-005056acd498' -d '{"snaplock.expiry_time" : "2/28/2024 10:11:10 +05:30"}' -H "accept: application/hal+json"
	```

#### Response:

	```
	{
	  "job": {
	    "uuid": "8c9cabf3-0a88-11ec-a449-005056bbcf9f",
	    "_links": {
	      "self": {
	        "href": "/api/cluster/jobs/8c9cabf3-0a88-11ec-a449-005056bbcf9f"
	      }
	    }
	  }
	}
	```
	</personalities>
*/
func (a *Client) ConsistencyGroupSnapshotModify(params *ConsistencyGroupSnapshotModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotModifyOK, *ConsistencyGroupSnapshotModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_modify",
		Method:             "PATCH",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupSnapshotModifyOK:
		return value, nil, nil
	case *ConsistencyGroupSnapshotModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConsistencyGroupSnapshotModifyCollection consistency group snapshot modify collection API
*/
func (a *Client) ConsistencyGroupSnapshotModifyCollection(params *ConsistencyGroupSnapshotModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConsistencyGroupSnapshotModifyCollectionOK, *ConsistencyGroupSnapshotModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConsistencyGroupSnapshotModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "consistency_group_snapshot_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/application/consistency-groups/{consistency_group.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ConsistencyGroupSnapshotModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ConsistencyGroupSnapshotModifyCollectionOK:
		return value, nil, nil
	case *ConsistencyGroupSnapshotModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConsistencyGroupSnapshotModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	ContainerCreate <personalities supports=asar2>

* POST is not supported
</personalities>
<personalities supports=aiml,unified>
Creates one or more of the following:
* New NAS FlexVol or FlexGroup volumes
* S3 buckets
* Access policies for NFS, CIFS and S3
* FlexCache volumes
## Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the container.
* `volumes`
## Naming Conventions
### Volume
  - volumes[].name, if specified
  - suffixed by "_#" where "#" is a system generated unique number, if provisioning_options.count is provided

</personalities>
*/
func (a *Client) ContainerCreate(params *ContainerCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ContainerCreateCreated, *ContainerCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewContainerCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "container_create",
		Method:             "POST",
		PathPattern:        "/application/containers",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &ContainerCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *ContainerCreateCreated:
		return value, nil, nil
	case *ContainerCreateAccepted:
		return nil, value, nil
	}
	// safeguard: normally, absent a default response, unknown success responses return an error above: so this is a codegen issue
	msg := fmt.Sprintf("unexpected success response for application: API contract not enforced by server. Client expected to get an error, but got: %T", result)
	panic(msg)
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
