// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationCollectionGetParams creates a new ApplicationCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationCollectionGetParams() *ApplicationCollectionGetParams {
	return &ApplicationCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationCollectionGetParamsWithTimeout creates a new ApplicationCollectionGetParams object
// with the ability to set a timeout on a request.
func NewApplicationCollectionGetParamsWithTimeout(timeout time.Duration) *ApplicationCollectionGetParams {
	return &ApplicationCollectionGetParams{
		timeout: timeout,
	}
}

// NewApplicationCollectionGetParamsWithContext creates a new ApplicationCollectionGetParams object
// with the ability to set a context for a request.
func NewApplicationCollectionGetParamsWithContext(ctx context.Context) *ApplicationCollectionGetParams {
	return &ApplicationCollectionGetParams{
		Context: ctx,
	}
}

// NewApplicationCollectionGetParamsWithHTTPClient creates a new ApplicationCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationCollectionGetParamsWithHTTPClient(client *http.Client) *ApplicationCollectionGetParams {
	return &ApplicationCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ApplicationCollectionGetParams contains all the parameters to send to the API endpoint

	for the application collection get operation.

	Typically these are written to a http.Request.
*/
type ApplicationCollectionGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Generation.

	   Filter by generation
	*/
	Generation *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ProtectionGranularity.

	   Filter by protection granularity
	*/
	ProtectionGranularity *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* RpoComponentsName.

	   Filter by rpo.components.name
	*/
	RpoComponentsName *string

	/* RpoComponentsRpoLocalDescription.

	   Filter by rpo.components.rpo.local.description
	*/
	RpoComponentsRpoLocalDescription *string

	/* RpoComponentsRpoLocalName.

	   Filter by rpo.components.rpo.local.name
	*/
	RpoComponentsRpoLocalName *string

	/* RpoComponentsRpoRemoteDescription.

	   Filter by rpo.components.rpo.remote.description
	*/
	RpoComponentsRpoRemoteDescription *string

	/* RpoComponentsRpoRemoteName.

	   Filter by rpo.components.rpo.remote.name
	*/
	RpoComponentsRpoRemoteName *string

	/* RpoComponentsUUID.

	   Filter by rpo.components.uuid
	*/
	RpoComponentsUUID *string

	/* RpoIsSupported.

	   Filter by rpo.is_supported
	*/
	RpoIsSupported *string

	/* RpoLocalDescription.

	   Filter by rpo.local.description
	*/
	RpoLocalDescription *string

	/* RpoLocalName.

	   Filter by rpo.local.name
	*/
	RpoLocalName *string

	/* RpoRemoteDescription.

	   Filter by rpo.remote.description
	*/
	RpoRemoteDescription *string

	/* RpoRemoteName.

	   Filter by rpo.remote.name
	*/
	RpoRemoteName *string

	/* SmartContainer.

	   Filter by smart_container
	*/
	SmartContainer *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsComponentsIopsPerTb.

	   Filter by statistics.components.iops.per_tb
	*/
	StatisticsComponentsIopsPerTb *string

	/* StatisticsComponentsIopsTotal.

	   Filter by statistics.components.iops.total
	*/
	StatisticsComponentsIopsTotal *string

	/* StatisticsComponentsLatencyAverage.

	   Filter by statistics.components.latency.average
	*/
	StatisticsComponentsLatencyAverage *string

	/* StatisticsComponentsLatencyRaw.

	   Filter by statistics.components.latency.raw
	*/
	StatisticsComponentsLatencyRaw *string

	/* StatisticsComponentsName.

	   Filter by statistics.components.name
	*/
	StatisticsComponentsName *string

	/* StatisticsComponentsSharedStoragePool.

	   Filter by statistics.components.shared_storage_pool
	*/
	StatisticsComponentsSharedStoragePool *string

	/* StatisticsComponentsSnapshotReserve.

	   Filter by statistics.components.snapshot.reserve
	*/
	StatisticsComponentsSnapshotReserve *string

	/* StatisticsComponentsSnapshotUsed.

	   Filter by statistics.components.snapshot.used
	*/
	StatisticsComponentsSnapshotUsed *string

	/* StatisticsComponentsSpaceAvailable.

	   Filter by statistics.components.space.available
	*/
	StatisticsComponentsSpaceAvailable *string

	/* StatisticsComponentsSpaceLogicalUsed.

	   Filter by statistics.components.space.logical_used
	*/
	StatisticsComponentsSpaceLogicalUsed *string

	/* StatisticsComponentsSpaceProvisioned.

	   Filter by statistics.components.space.provisioned
	*/
	StatisticsComponentsSpaceProvisioned *string

	/* StatisticsComponentsSpaceReservedUnused.

	   Filter by statistics.components.space.reserved_unused
	*/
	StatisticsComponentsSpaceReservedUnused *string

	/* StatisticsComponentsSpaceSavings.

	   Filter by statistics.components.space.savings
	*/
	StatisticsComponentsSpaceSavings *string

	/* StatisticsComponentsSpaceUsed.

	   Filter by statistics.components.space.used
	*/
	StatisticsComponentsSpaceUsed *string

	/* StatisticsComponentsSpaceUsedExcludingReserves.

	   Filter by statistics.components.space.used_excluding_reserves
	*/
	StatisticsComponentsSpaceUsedExcludingReserves *string

	/* StatisticsComponentsSpaceUsedPercent.

	   Filter by statistics.components.space.used_percent
	*/
	StatisticsComponentsSpaceUsedPercent *string

	/* StatisticsComponentsStatisticsIncomplete.

	   Filter by statistics.components.statistics_incomplete
	*/
	StatisticsComponentsStatisticsIncomplete *string

	/* StatisticsComponentsStorageServiceName.

	   Filter by statistics.components.storage_service.name
	*/
	StatisticsComponentsStorageServiceName *string

	/* StatisticsComponentsUUID.

	   Filter by statistics.components.uuid
	*/
	StatisticsComponentsUUID *string

	/* StatisticsIopsPerTb.

	   Filter by statistics.iops.per_tb
	*/
	StatisticsIopsPerTb *string

	/* StatisticsIopsTotal.

	   Filter by statistics.iops.total
	*/
	StatisticsIopsTotal *string

	/* StatisticsLatencyAverage.

	   Filter by statistics.latency.average
	*/
	StatisticsLatencyAverage *string

	/* StatisticsLatencyRaw.

	   Filter by statistics.latency.raw
	*/
	StatisticsLatencyRaw *string

	/* StatisticsSharedStoragePool.

	   Filter by statistics.shared_storage_pool
	*/
	StatisticsSharedStoragePool *string

	/* StatisticsSnapshotReserve.

	   Filter by statistics.snapshot.reserve
	*/
	StatisticsSnapshotReserve *string

	/* StatisticsSnapshotUsed.

	   Filter by statistics.snapshot.used
	*/
	StatisticsSnapshotUsed *string

	/* StatisticsSpaceAvailable.

	   Filter by statistics.space.available
	*/
	StatisticsSpaceAvailable *string

	/* StatisticsSpaceLogicalUsed.

	   Filter by statistics.space.logical_used
	*/
	StatisticsSpaceLogicalUsed *string

	/* StatisticsSpaceProvisioned.

	   Filter by statistics.space.provisioned
	*/
	StatisticsSpaceProvisioned *string

	/* StatisticsSpaceReservedUnused.

	   Filter by statistics.space.reserved_unused
	*/
	StatisticsSpaceReservedUnused *string

	/* StatisticsSpaceSavings.

	   Filter by statistics.space.savings
	*/
	StatisticsSpaceSavings *string

	/* StatisticsSpaceUsed.

	   Filter by statistics.space.used
	*/
	StatisticsSpaceUsed *string

	/* StatisticsSpaceUsedExcludingReserves.

	   Filter by statistics.space.used_excluding_reserves
	*/
	StatisticsSpaceUsedExcludingReserves *string

	/* StatisticsSpaceUsedPercent.

	   Filter by statistics.space.used_percent
	*/
	StatisticsSpaceUsedPercent *string

	/* StatisticsStatisticsIncomplete.

	   Filter by statistics.statistics_incomplete
	*/
	StatisticsStatisticsIncomplete *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TemplateName.

	   Filter by template.name
	*/
	TemplateName *string

	/* TemplateProtocol.

	   Filter by template.protocol
	*/
	TemplateProtocol *string

	/* TemplateVersion.

	   Filter by template.version
	*/
	TemplateVersion *string

	/* UUID.

	   Filter by UUID
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationCollectionGetParams) WithDefaults() *ApplicationCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ApplicationCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application collection get params
func (o *ApplicationCollectionGetParams) WithTimeout(timeout time.Duration) *ApplicationCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application collection get params
func (o *ApplicationCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application collection get params
func (o *ApplicationCollectionGetParams) WithContext(ctx context.Context) *ApplicationCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application collection get params
func (o *ApplicationCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application collection get params
func (o *ApplicationCollectionGetParams) WithHTTPClient(client *http.Client) *ApplicationCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application collection get params
func (o *ApplicationCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the application collection get params
func (o *ApplicationCollectionGetParams) WithFields(fields []string) *ApplicationCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the application collection get params
func (o *ApplicationCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGeneration adds the generation to the application collection get params
func (o *ApplicationCollectionGetParams) WithGeneration(generation *string) *ApplicationCollectionGetParams {
	o.SetGeneration(generation)
	return o
}

// SetGeneration adds the generation to the application collection get params
func (o *ApplicationCollectionGetParams) SetGeneration(generation *string) {
	o.Generation = generation
}

// WithMaxRecords adds the maxRecords to the application collection get params
func (o *ApplicationCollectionGetParams) WithMaxRecords(maxRecords *int64) *ApplicationCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the application collection get params
func (o *ApplicationCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the application collection get params
func (o *ApplicationCollectionGetParams) WithName(name *string) *ApplicationCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the application collection get params
func (o *ApplicationCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the application collection get params
func (o *ApplicationCollectionGetParams) WithOrderBy(orderBy []string) *ApplicationCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the application collection get params
func (o *ApplicationCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithProtectionGranularity adds the protectionGranularity to the application collection get params
func (o *ApplicationCollectionGetParams) WithProtectionGranularity(protectionGranularity *string) *ApplicationCollectionGetParams {
	o.SetProtectionGranularity(protectionGranularity)
	return o
}

// SetProtectionGranularity adds the protectionGranularity to the application collection get params
func (o *ApplicationCollectionGetParams) SetProtectionGranularity(protectionGranularity *string) {
	o.ProtectionGranularity = protectionGranularity
}

// WithReturnRecords adds the returnRecords to the application collection get params
func (o *ApplicationCollectionGetParams) WithReturnRecords(returnRecords *bool) *ApplicationCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the application collection get params
func (o *ApplicationCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the application collection get params
func (o *ApplicationCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ApplicationCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application collection get params
func (o *ApplicationCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRpoComponentsName adds the rpoComponentsName to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoComponentsName(rpoComponentsName *string) *ApplicationCollectionGetParams {
	o.SetRpoComponentsName(rpoComponentsName)
	return o
}

// SetRpoComponentsName adds the rpoComponentsName to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoComponentsName(rpoComponentsName *string) {
	o.RpoComponentsName = rpoComponentsName
}

// WithRpoComponentsRpoLocalDescription adds the rpoComponentsRpoLocalDescription to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoComponentsRpoLocalDescription(rpoComponentsRpoLocalDescription *string) *ApplicationCollectionGetParams {
	o.SetRpoComponentsRpoLocalDescription(rpoComponentsRpoLocalDescription)
	return o
}

// SetRpoComponentsRpoLocalDescription adds the rpoComponentsRpoLocalDescription to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoComponentsRpoLocalDescription(rpoComponentsRpoLocalDescription *string) {
	o.RpoComponentsRpoLocalDescription = rpoComponentsRpoLocalDescription
}

// WithRpoComponentsRpoLocalName adds the rpoComponentsRpoLocalName to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoComponentsRpoLocalName(rpoComponentsRpoLocalName *string) *ApplicationCollectionGetParams {
	o.SetRpoComponentsRpoLocalName(rpoComponentsRpoLocalName)
	return o
}

// SetRpoComponentsRpoLocalName adds the rpoComponentsRpoLocalName to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoComponentsRpoLocalName(rpoComponentsRpoLocalName *string) {
	o.RpoComponentsRpoLocalName = rpoComponentsRpoLocalName
}

// WithRpoComponentsRpoRemoteDescription adds the rpoComponentsRpoRemoteDescription to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoComponentsRpoRemoteDescription(rpoComponentsRpoRemoteDescription *string) *ApplicationCollectionGetParams {
	o.SetRpoComponentsRpoRemoteDescription(rpoComponentsRpoRemoteDescription)
	return o
}

// SetRpoComponentsRpoRemoteDescription adds the rpoComponentsRpoRemoteDescription to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoComponentsRpoRemoteDescription(rpoComponentsRpoRemoteDescription *string) {
	o.RpoComponentsRpoRemoteDescription = rpoComponentsRpoRemoteDescription
}

// WithRpoComponentsRpoRemoteName adds the rpoComponentsRpoRemoteName to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoComponentsRpoRemoteName(rpoComponentsRpoRemoteName *string) *ApplicationCollectionGetParams {
	o.SetRpoComponentsRpoRemoteName(rpoComponentsRpoRemoteName)
	return o
}

// SetRpoComponentsRpoRemoteName adds the rpoComponentsRpoRemoteName to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoComponentsRpoRemoteName(rpoComponentsRpoRemoteName *string) {
	o.RpoComponentsRpoRemoteName = rpoComponentsRpoRemoteName
}

// WithRpoComponentsUUID adds the rpoComponentsUUID to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoComponentsUUID(rpoComponentsUUID *string) *ApplicationCollectionGetParams {
	o.SetRpoComponentsUUID(rpoComponentsUUID)
	return o
}

// SetRpoComponentsUUID adds the rpoComponentsUuid to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoComponentsUUID(rpoComponentsUUID *string) {
	o.RpoComponentsUUID = rpoComponentsUUID
}

// WithRpoIsSupported adds the rpoIsSupported to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoIsSupported(rpoIsSupported *string) *ApplicationCollectionGetParams {
	o.SetRpoIsSupported(rpoIsSupported)
	return o
}

// SetRpoIsSupported adds the rpoIsSupported to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoIsSupported(rpoIsSupported *string) {
	o.RpoIsSupported = rpoIsSupported
}

// WithRpoLocalDescription adds the rpoLocalDescription to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoLocalDescription(rpoLocalDescription *string) *ApplicationCollectionGetParams {
	o.SetRpoLocalDescription(rpoLocalDescription)
	return o
}

// SetRpoLocalDescription adds the rpoLocalDescription to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoLocalDescription(rpoLocalDescription *string) {
	o.RpoLocalDescription = rpoLocalDescription
}

// WithRpoLocalName adds the rpoLocalName to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoLocalName(rpoLocalName *string) *ApplicationCollectionGetParams {
	o.SetRpoLocalName(rpoLocalName)
	return o
}

// SetRpoLocalName adds the rpoLocalName to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoLocalName(rpoLocalName *string) {
	o.RpoLocalName = rpoLocalName
}

// WithRpoRemoteDescription adds the rpoRemoteDescription to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoRemoteDescription(rpoRemoteDescription *string) *ApplicationCollectionGetParams {
	o.SetRpoRemoteDescription(rpoRemoteDescription)
	return o
}

// SetRpoRemoteDescription adds the rpoRemoteDescription to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoRemoteDescription(rpoRemoteDescription *string) {
	o.RpoRemoteDescription = rpoRemoteDescription
}

// WithRpoRemoteName adds the rpoRemoteName to the application collection get params
func (o *ApplicationCollectionGetParams) WithRpoRemoteName(rpoRemoteName *string) *ApplicationCollectionGetParams {
	o.SetRpoRemoteName(rpoRemoteName)
	return o
}

// SetRpoRemoteName adds the rpoRemoteName to the application collection get params
func (o *ApplicationCollectionGetParams) SetRpoRemoteName(rpoRemoteName *string) {
	o.RpoRemoteName = rpoRemoteName
}

// WithSmartContainer adds the smartContainer to the application collection get params
func (o *ApplicationCollectionGetParams) WithSmartContainer(smartContainer *string) *ApplicationCollectionGetParams {
	o.SetSmartContainer(smartContainer)
	return o
}

// SetSmartContainer adds the smartContainer to the application collection get params
func (o *ApplicationCollectionGetParams) SetSmartContainer(smartContainer *string) {
	o.SmartContainer = smartContainer
}

// WithState adds the state to the application collection get params
func (o *ApplicationCollectionGetParams) WithState(state *string) *ApplicationCollectionGetParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the application collection get params
func (o *ApplicationCollectionGetParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsComponentsIopsPerTb adds the statisticsComponentsIopsPerTb to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsIopsPerTb(statisticsComponentsIopsPerTb *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsIopsPerTb(statisticsComponentsIopsPerTb)
	return o
}

// SetStatisticsComponentsIopsPerTb adds the statisticsComponentsIopsPerTb to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsIopsPerTb(statisticsComponentsIopsPerTb *string) {
	o.StatisticsComponentsIopsPerTb = statisticsComponentsIopsPerTb
}

// WithStatisticsComponentsIopsTotal adds the statisticsComponentsIopsTotal to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsIopsTotal(statisticsComponentsIopsTotal *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsIopsTotal(statisticsComponentsIopsTotal)
	return o
}

// SetStatisticsComponentsIopsTotal adds the statisticsComponentsIopsTotal to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsIopsTotal(statisticsComponentsIopsTotal *string) {
	o.StatisticsComponentsIopsTotal = statisticsComponentsIopsTotal
}

// WithStatisticsComponentsLatencyAverage adds the statisticsComponentsLatencyAverage to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsLatencyAverage(statisticsComponentsLatencyAverage *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsLatencyAverage(statisticsComponentsLatencyAverage)
	return o
}

// SetStatisticsComponentsLatencyAverage adds the statisticsComponentsLatencyAverage to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsLatencyAverage(statisticsComponentsLatencyAverage *string) {
	o.StatisticsComponentsLatencyAverage = statisticsComponentsLatencyAverage
}

// WithStatisticsComponentsLatencyRaw adds the statisticsComponentsLatencyRaw to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsLatencyRaw(statisticsComponentsLatencyRaw *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsLatencyRaw(statisticsComponentsLatencyRaw)
	return o
}

// SetStatisticsComponentsLatencyRaw adds the statisticsComponentsLatencyRaw to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsLatencyRaw(statisticsComponentsLatencyRaw *string) {
	o.StatisticsComponentsLatencyRaw = statisticsComponentsLatencyRaw
}

// WithStatisticsComponentsName adds the statisticsComponentsName to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsName(statisticsComponentsName *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsName(statisticsComponentsName)
	return o
}

// SetStatisticsComponentsName adds the statisticsComponentsName to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsName(statisticsComponentsName *string) {
	o.StatisticsComponentsName = statisticsComponentsName
}

// WithStatisticsComponentsSharedStoragePool adds the statisticsComponentsSharedStoragePool to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSharedStoragePool(statisticsComponentsSharedStoragePool *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSharedStoragePool(statisticsComponentsSharedStoragePool)
	return o
}

// SetStatisticsComponentsSharedStoragePool adds the statisticsComponentsSharedStoragePool to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSharedStoragePool(statisticsComponentsSharedStoragePool *string) {
	o.StatisticsComponentsSharedStoragePool = statisticsComponentsSharedStoragePool
}

// WithStatisticsComponentsSnapshotReserve adds the statisticsComponentsSnapshotReserve to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSnapshotReserve(statisticsComponentsSnapshotReserve *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSnapshotReserve(statisticsComponentsSnapshotReserve)
	return o
}

// SetStatisticsComponentsSnapshotReserve adds the statisticsComponentsSnapshotReserve to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSnapshotReserve(statisticsComponentsSnapshotReserve *string) {
	o.StatisticsComponentsSnapshotReserve = statisticsComponentsSnapshotReserve
}

// WithStatisticsComponentsSnapshotUsed adds the statisticsComponentsSnapshotUsed to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSnapshotUsed(statisticsComponentsSnapshotUsed *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSnapshotUsed(statisticsComponentsSnapshotUsed)
	return o
}

// SetStatisticsComponentsSnapshotUsed adds the statisticsComponentsSnapshotUsed to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSnapshotUsed(statisticsComponentsSnapshotUsed *string) {
	o.StatisticsComponentsSnapshotUsed = statisticsComponentsSnapshotUsed
}

// WithStatisticsComponentsSpaceAvailable adds the statisticsComponentsSpaceAvailable to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceAvailable(statisticsComponentsSpaceAvailable *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceAvailable(statisticsComponentsSpaceAvailable)
	return o
}

// SetStatisticsComponentsSpaceAvailable adds the statisticsComponentsSpaceAvailable to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceAvailable(statisticsComponentsSpaceAvailable *string) {
	o.StatisticsComponentsSpaceAvailable = statisticsComponentsSpaceAvailable
}

// WithStatisticsComponentsSpaceLogicalUsed adds the statisticsComponentsSpaceLogicalUsed to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceLogicalUsed(statisticsComponentsSpaceLogicalUsed *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceLogicalUsed(statisticsComponentsSpaceLogicalUsed)
	return o
}

// SetStatisticsComponentsSpaceLogicalUsed adds the statisticsComponentsSpaceLogicalUsed to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceLogicalUsed(statisticsComponentsSpaceLogicalUsed *string) {
	o.StatisticsComponentsSpaceLogicalUsed = statisticsComponentsSpaceLogicalUsed
}

// WithStatisticsComponentsSpaceProvisioned adds the statisticsComponentsSpaceProvisioned to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceProvisioned(statisticsComponentsSpaceProvisioned *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceProvisioned(statisticsComponentsSpaceProvisioned)
	return o
}

// SetStatisticsComponentsSpaceProvisioned adds the statisticsComponentsSpaceProvisioned to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceProvisioned(statisticsComponentsSpaceProvisioned *string) {
	o.StatisticsComponentsSpaceProvisioned = statisticsComponentsSpaceProvisioned
}

// WithStatisticsComponentsSpaceReservedUnused adds the statisticsComponentsSpaceReservedUnused to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceReservedUnused(statisticsComponentsSpaceReservedUnused *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceReservedUnused(statisticsComponentsSpaceReservedUnused)
	return o
}

// SetStatisticsComponentsSpaceReservedUnused adds the statisticsComponentsSpaceReservedUnused to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceReservedUnused(statisticsComponentsSpaceReservedUnused *string) {
	o.StatisticsComponentsSpaceReservedUnused = statisticsComponentsSpaceReservedUnused
}

// WithStatisticsComponentsSpaceSavings adds the statisticsComponentsSpaceSavings to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceSavings(statisticsComponentsSpaceSavings *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceSavings(statisticsComponentsSpaceSavings)
	return o
}

// SetStatisticsComponentsSpaceSavings adds the statisticsComponentsSpaceSavings to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceSavings(statisticsComponentsSpaceSavings *string) {
	o.StatisticsComponentsSpaceSavings = statisticsComponentsSpaceSavings
}

// WithStatisticsComponentsSpaceUsed adds the statisticsComponentsSpaceUsed to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceUsed(statisticsComponentsSpaceUsed *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceUsed(statisticsComponentsSpaceUsed)
	return o
}

// SetStatisticsComponentsSpaceUsed adds the statisticsComponentsSpaceUsed to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceUsed(statisticsComponentsSpaceUsed *string) {
	o.StatisticsComponentsSpaceUsed = statisticsComponentsSpaceUsed
}

// WithStatisticsComponentsSpaceUsedExcludingReserves adds the statisticsComponentsSpaceUsedExcludingReserves to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceUsedExcludingReserves(statisticsComponentsSpaceUsedExcludingReserves *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceUsedExcludingReserves(statisticsComponentsSpaceUsedExcludingReserves)
	return o
}

// SetStatisticsComponentsSpaceUsedExcludingReserves adds the statisticsComponentsSpaceUsedExcludingReserves to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceUsedExcludingReserves(statisticsComponentsSpaceUsedExcludingReserves *string) {
	o.StatisticsComponentsSpaceUsedExcludingReserves = statisticsComponentsSpaceUsedExcludingReserves
}

// WithStatisticsComponentsSpaceUsedPercent adds the statisticsComponentsSpaceUsedPercent to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsSpaceUsedPercent(statisticsComponentsSpaceUsedPercent *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsSpaceUsedPercent(statisticsComponentsSpaceUsedPercent)
	return o
}

// SetStatisticsComponentsSpaceUsedPercent adds the statisticsComponentsSpaceUsedPercent to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsSpaceUsedPercent(statisticsComponentsSpaceUsedPercent *string) {
	o.StatisticsComponentsSpaceUsedPercent = statisticsComponentsSpaceUsedPercent
}

// WithStatisticsComponentsStatisticsIncomplete adds the statisticsComponentsStatisticsIncomplete to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsStatisticsIncomplete(statisticsComponentsStatisticsIncomplete *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsStatisticsIncomplete(statisticsComponentsStatisticsIncomplete)
	return o
}

// SetStatisticsComponentsStatisticsIncomplete adds the statisticsComponentsStatisticsIncomplete to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsStatisticsIncomplete(statisticsComponentsStatisticsIncomplete *string) {
	o.StatisticsComponentsStatisticsIncomplete = statisticsComponentsStatisticsIncomplete
}

// WithStatisticsComponentsStorageServiceName adds the statisticsComponentsStorageServiceName to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsStorageServiceName(statisticsComponentsStorageServiceName *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsStorageServiceName(statisticsComponentsStorageServiceName)
	return o
}

// SetStatisticsComponentsStorageServiceName adds the statisticsComponentsStorageServiceName to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsStorageServiceName(statisticsComponentsStorageServiceName *string) {
	o.StatisticsComponentsStorageServiceName = statisticsComponentsStorageServiceName
}

// WithStatisticsComponentsUUID adds the statisticsComponentsUUID to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsComponentsUUID(statisticsComponentsUUID *string) *ApplicationCollectionGetParams {
	o.SetStatisticsComponentsUUID(statisticsComponentsUUID)
	return o
}

// SetStatisticsComponentsUUID adds the statisticsComponentsUuid to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsComponentsUUID(statisticsComponentsUUID *string) {
	o.StatisticsComponentsUUID = statisticsComponentsUUID
}

// WithStatisticsIopsPerTb adds the statisticsIopsPerTb to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsIopsPerTb(statisticsIopsPerTb *string) *ApplicationCollectionGetParams {
	o.SetStatisticsIopsPerTb(statisticsIopsPerTb)
	return o
}

// SetStatisticsIopsPerTb adds the statisticsIopsPerTb to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsIopsPerTb(statisticsIopsPerTb *string) {
	o.StatisticsIopsPerTb = statisticsIopsPerTb
}

// WithStatisticsIopsTotal adds the statisticsIopsTotal to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsIopsTotal(statisticsIopsTotal *string) *ApplicationCollectionGetParams {
	o.SetStatisticsIopsTotal(statisticsIopsTotal)
	return o
}

// SetStatisticsIopsTotal adds the statisticsIopsTotal to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsIopsTotal(statisticsIopsTotal *string) {
	o.StatisticsIopsTotal = statisticsIopsTotal
}

// WithStatisticsLatencyAverage adds the statisticsLatencyAverage to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsLatencyAverage(statisticsLatencyAverage *string) *ApplicationCollectionGetParams {
	o.SetStatisticsLatencyAverage(statisticsLatencyAverage)
	return o
}

// SetStatisticsLatencyAverage adds the statisticsLatencyAverage to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsLatencyAverage(statisticsLatencyAverage *string) {
	o.StatisticsLatencyAverage = statisticsLatencyAverage
}

// WithStatisticsLatencyRaw adds the statisticsLatencyRaw to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsLatencyRaw(statisticsLatencyRaw *string) *ApplicationCollectionGetParams {
	o.SetStatisticsLatencyRaw(statisticsLatencyRaw)
	return o
}

// SetStatisticsLatencyRaw adds the statisticsLatencyRaw to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsLatencyRaw(statisticsLatencyRaw *string) {
	o.StatisticsLatencyRaw = statisticsLatencyRaw
}

// WithStatisticsSharedStoragePool adds the statisticsSharedStoragePool to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSharedStoragePool(statisticsSharedStoragePool *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSharedStoragePool(statisticsSharedStoragePool)
	return o
}

// SetStatisticsSharedStoragePool adds the statisticsSharedStoragePool to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSharedStoragePool(statisticsSharedStoragePool *string) {
	o.StatisticsSharedStoragePool = statisticsSharedStoragePool
}

// WithStatisticsSnapshotReserve adds the statisticsSnapshotReserve to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSnapshotReserve(statisticsSnapshotReserve *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSnapshotReserve(statisticsSnapshotReserve)
	return o
}

// SetStatisticsSnapshotReserve adds the statisticsSnapshotReserve to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSnapshotReserve(statisticsSnapshotReserve *string) {
	o.StatisticsSnapshotReserve = statisticsSnapshotReserve
}

// WithStatisticsSnapshotUsed adds the statisticsSnapshotUsed to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSnapshotUsed(statisticsSnapshotUsed *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSnapshotUsed(statisticsSnapshotUsed)
	return o
}

// SetStatisticsSnapshotUsed adds the statisticsSnapshotUsed to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSnapshotUsed(statisticsSnapshotUsed *string) {
	o.StatisticsSnapshotUsed = statisticsSnapshotUsed
}

// WithStatisticsSpaceAvailable adds the statisticsSpaceAvailable to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceAvailable(statisticsSpaceAvailable *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceAvailable(statisticsSpaceAvailable)
	return o
}

// SetStatisticsSpaceAvailable adds the statisticsSpaceAvailable to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceAvailable(statisticsSpaceAvailable *string) {
	o.StatisticsSpaceAvailable = statisticsSpaceAvailable
}

// WithStatisticsSpaceLogicalUsed adds the statisticsSpaceLogicalUsed to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceLogicalUsed(statisticsSpaceLogicalUsed *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceLogicalUsed(statisticsSpaceLogicalUsed)
	return o
}

// SetStatisticsSpaceLogicalUsed adds the statisticsSpaceLogicalUsed to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceLogicalUsed(statisticsSpaceLogicalUsed *string) {
	o.StatisticsSpaceLogicalUsed = statisticsSpaceLogicalUsed
}

// WithStatisticsSpaceProvisioned adds the statisticsSpaceProvisioned to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceProvisioned(statisticsSpaceProvisioned *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceProvisioned(statisticsSpaceProvisioned)
	return o
}

// SetStatisticsSpaceProvisioned adds the statisticsSpaceProvisioned to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceProvisioned(statisticsSpaceProvisioned *string) {
	o.StatisticsSpaceProvisioned = statisticsSpaceProvisioned
}

// WithStatisticsSpaceReservedUnused adds the statisticsSpaceReservedUnused to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceReservedUnused(statisticsSpaceReservedUnused *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceReservedUnused(statisticsSpaceReservedUnused)
	return o
}

// SetStatisticsSpaceReservedUnused adds the statisticsSpaceReservedUnused to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceReservedUnused(statisticsSpaceReservedUnused *string) {
	o.StatisticsSpaceReservedUnused = statisticsSpaceReservedUnused
}

// WithStatisticsSpaceSavings adds the statisticsSpaceSavings to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceSavings(statisticsSpaceSavings *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceSavings(statisticsSpaceSavings)
	return o
}

// SetStatisticsSpaceSavings adds the statisticsSpaceSavings to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceSavings(statisticsSpaceSavings *string) {
	o.StatisticsSpaceSavings = statisticsSpaceSavings
}

// WithStatisticsSpaceUsed adds the statisticsSpaceUsed to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceUsed(statisticsSpaceUsed *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceUsed(statisticsSpaceUsed)
	return o
}

// SetStatisticsSpaceUsed adds the statisticsSpaceUsed to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceUsed(statisticsSpaceUsed *string) {
	o.StatisticsSpaceUsed = statisticsSpaceUsed
}

// WithStatisticsSpaceUsedExcludingReserves adds the statisticsSpaceUsedExcludingReserves to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceUsedExcludingReserves(statisticsSpaceUsedExcludingReserves *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceUsedExcludingReserves(statisticsSpaceUsedExcludingReserves)
	return o
}

// SetStatisticsSpaceUsedExcludingReserves adds the statisticsSpaceUsedExcludingReserves to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceUsedExcludingReserves(statisticsSpaceUsedExcludingReserves *string) {
	o.StatisticsSpaceUsedExcludingReserves = statisticsSpaceUsedExcludingReserves
}

// WithStatisticsSpaceUsedPercent adds the statisticsSpaceUsedPercent to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsSpaceUsedPercent(statisticsSpaceUsedPercent *string) *ApplicationCollectionGetParams {
	o.SetStatisticsSpaceUsedPercent(statisticsSpaceUsedPercent)
	return o
}

// SetStatisticsSpaceUsedPercent adds the statisticsSpaceUsedPercent to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsSpaceUsedPercent(statisticsSpaceUsedPercent *string) {
	o.StatisticsSpaceUsedPercent = statisticsSpaceUsedPercent
}

// WithStatisticsStatisticsIncomplete adds the statisticsStatisticsIncomplete to the application collection get params
func (o *ApplicationCollectionGetParams) WithStatisticsStatisticsIncomplete(statisticsStatisticsIncomplete *string) *ApplicationCollectionGetParams {
	o.SetStatisticsStatisticsIncomplete(statisticsStatisticsIncomplete)
	return o
}

// SetStatisticsStatisticsIncomplete adds the statisticsStatisticsIncomplete to the application collection get params
func (o *ApplicationCollectionGetParams) SetStatisticsStatisticsIncomplete(statisticsStatisticsIncomplete *string) {
	o.StatisticsStatisticsIncomplete = statisticsStatisticsIncomplete
}

// WithSvmName adds the svmName to the application collection get params
func (o *ApplicationCollectionGetParams) WithSvmName(svmName *string) *ApplicationCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the application collection get params
func (o *ApplicationCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the application collection get params
func (o *ApplicationCollectionGetParams) WithSvmUUID(svmUUID *string) *ApplicationCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the application collection get params
func (o *ApplicationCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTemplateName adds the templateName to the application collection get params
func (o *ApplicationCollectionGetParams) WithTemplateName(templateName *string) *ApplicationCollectionGetParams {
	o.SetTemplateName(templateName)
	return o
}

// SetTemplateName adds the templateName to the application collection get params
func (o *ApplicationCollectionGetParams) SetTemplateName(templateName *string) {
	o.TemplateName = templateName
}

// WithTemplateProtocol adds the templateProtocol to the application collection get params
func (o *ApplicationCollectionGetParams) WithTemplateProtocol(templateProtocol *string) *ApplicationCollectionGetParams {
	o.SetTemplateProtocol(templateProtocol)
	return o
}

// SetTemplateProtocol adds the templateProtocol to the application collection get params
func (o *ApplicationCollectionGetParams) SetTemplateProtocol(templateProtocol *string) {
	o.TemplateProtocol = templateProtocol
}

// WithTemplateVersion adds the templateVersion to the application collection get params
func (o *ApplicationCollectionGetParams) WithTemplateVersion(templateVersion *string) *ApplicationCollectionGetParams {
	o.SetTemplateVersion(templateVersion)
	return o
}

// SetTemplateVersion adds the templateVersion to the application collection get params
func (o *ApplicationCollectionGetParams) SetTemplateVersion(templateVersion *string) {
	o.TemplateVersion = templateVersion
}

// WithUUID adds the uuid to the application collection get params
func (o *ApplicationCollectionGetParams) WithUUID(uuid *string) *ApplicationCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application collection get params
func (o *ApplicationCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Generation != nil {

		// query param generation
		var qrGeneration string

		if o.Generation != nil {
			qrGeneration = *o.Generation
		}
		qGeneration := qrGeneration
		if qGeneration != "" {

			if err := r.SetQueryParam("generation", qGeneration); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ProtectionGranularity != nil {

		// query param protection_granularity
		var qrProtectionGranularity string

		if o.ProtectionGranularity != nil {
			qrProtectionGranularity = *o.ProtectionGranularity
		}
		qProtectionGranularity := qrProtectionGranularity
		if qProtectionGranularity != "" {

			if err := r.SetQueryParam("protection_granularity", qProtectionGranularity); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsName != nil {

		// query param rpo.components.name
		var qrRpoComponentsName string

		if o.RpoComponentsName != nil {
			qrRpoComponentsName = *o.RpoComponentsName
		}
		qRpoComponentsName := qrRpoComponentsName
		if qRpoComponentsName != "" {

			if err := r.SetQueryParam("rpo.components.name", qRpoComponentsName); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoLocalDescription != nil {

		// query param rpo.components.rpo.local.description
		var qrRpoComponentsRpoLocalDescription string

		if o.RpoComponentsRpoLocalDescription != nil {
			qrRpoComponentsRpoLocalDescription = *o.RpoComponentsRpoLocalDescription
		}
		qRpoComponentsRpoLocalDescription := qrRpoComponentsRpoLocalDescription
		if qRpoComponentsRpoLocalDescription != "" {

			if err := r.SetQueryParam("rpo.components.rpo.local.description", qRpoComponentsRpoLocalDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoLocalName != nil {

		// query param rpo.components.rpo.local.name
		var qrRpoComponentsRpoLocalName string

		if o.RpoComponentsRpoLocalName != nil {
			qrRpoComponentsRpoLocalName = *o.RpoComponentsRpoLocalName
		}
		qRpoComponentsRpoLocalName := qrRpoComponentsRpoLocalName
		if qRpoComponentsRpoLocalName != "" {

			if err := r.SetQueryParam("rpo.components.rpo.local.name", qRpoComponentsRpoLocalName); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoRemoteDescription != nil {

		// query param rpo.components.rpo.remote.description
		var qrRpoComponentsRpoRemoteDescription string

		if o.RpoComponentsRpoRemoteDescription != nil {
			qrRpoComponentsRpoRemoteDescription = *o.RpoComponentsRpoRemoteDescription
		}
		qRpoComponentsRpoRemoteDescription := qrRpoComponentsRpoRemoteDescription
		if qRpoComponentsRpoRemoteDescription != "" {

			if err := r.SetQueryParam("rpo.components.rpo.remote.description", qRpoComponentsRpoRemoteDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoRemoteName != nil {

		// query param rpo.components.rpo.remote.name
		var qrRpoComponentsRpoRemoteName string

		if o.RpoComponentsRpoRemoteName != nil {
			qrRpoComponentsRpoRemoteName = *o.RpoComponentsRpoRemoteName
		}
		qRpoComponentsRpoRemoteName := qrRpoComponentsRpoRemoteName
		if qRpoComponentsRpoRemoteName != "" {

			if err := r.SetQueryParam("rpo.components.rpo.remote.name", qRpoComponentsRpoRemoteName); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsUUID != nil {

		// query param rpo.components.uuid
		var qrRpoComponentsUUID string

		if o.RpoComponentsUUID != nil {
			qrRpoComponentsUUID = *o.RpoComponentsUUID
		}
		qRpoComponentsUUID := qrRpoComponentsUUID
		if qRpoComponentsUUID != "" {

			if err := r.SetQueryParam("rpo.components.uuid", qRpoComponentsUUID); err != nil {
				return err
			}
		}
	}

	if o.RpoIsSupported != nil {

		// query param rpo.is_supported
		var qrRpoIsSupported string

		if o.RpoIsSupported != nil {
			qrRpoIsSupported = *o.RpoIsSupported
		}
		qRpoIsSupported := qrRpoIsSupported
		if qRpoIsSupported != "" {

			if err := r.SetQueryParam("rpo.is_supported", qRpoIsSupported); err != nil {
				return err
			}
		}
	}

	if o.RpoLocalDescription != nil {

		// query param rpo.local.description
		var qrRpoLocalDescription string

		if o.RpoLocalDescription != nil {
			qrRpoLocalDescription = *o.RpoLocalDescription
		}
		qRpoLocalDescription := qrRpoLocalDescription
		if qRpoLocalDescription != "" {

			if err := r.SetQueryParam("rpo.local.description", qRpoLocalDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoLocalName != nil {

		// query param rpo.local.name
		var qrRpoLocalName string

		if o.RpoLocalName != nil {
			qrRpoLocalName = *o.RpoLocalName
		}
		qRpoLocalName := qrRpoLocalName
		if qRpoLocalName != "" {

			if err := r.SetQueryParam("rpo.local.name", qRpoLocalName); err != nil {
				return err
			}
		}
	}

	if o.RpoRemoteDescription != nil {

		// query param rpo.remote.description
		var qrRpoRemoteDescription string

		if o.RpoRemoteDescription != nil {
			qrRpoRemoteDescription = *o.RpoRemoteDescription
		}
		qRpoRemoteDescription := qrRpoRemoteDescription
		if qRpoRemoteDescription != "" {

			if err := r.SetQueryParam("rpo.remote.description", qRpoRemoteDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoRemoteName != nil {

		// query param rpo.remote.name
		var qrRpoRemoteName string

		if o.RpoRemoteName != nil {
			qrRpoRemoteName = *o.RpoRemoteName
		}
		qRpoRemoteName := qrRpoRemoteName
		if qRpoRemoteName != "" {

			if err := r.SetQueryParam("rpo.remote.name", qRpoRemoteName); err != nil {
				return err
			}
		}
	}

	if o.SmartContainer != nil {

		// query param smart_container
		var qrSmartContainer string

		if o.SmartContainer != nil {
			qrSmartContainer = *o.SmartContainer
		}
		qSmartContainer := qrSmartContainer
		if qSmartContainer != "" {

			if err := r.SetQueryParam("smart_container", qSmartContainer); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsIopsPerTb != nil {

		// query param statistics.components.iops.per_tb
		var qrStatisticsComponentsIopsPerTb string

		if o.StatisticsComponentsIopsPerTb != nil {
			qrStatisticsComponentsIopsPerTb = *o.StatisticsComponentsIopsPerTb
		}
		qStatisticsComponentsIopsPerTb := qrStatisticsComponentsIopsPerTb
		if qStatisticsComponentsIopsPerTb != "" {

			if err := r.SetQueryParam("statistics.components.iops.per_tb", qStatisticsComponentsIopsPerTb); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsIopsTotal != nil {

		// query param statistics.components.iops.total
		var qrStatisticsComponentsIopsTotal string

		if o.StatisticsComponentsIopsTotal != nil {
			qrStatisticsComponentsIopsTotal = *o.StatisticsComponentsIopsTotal
		}
		qStatisticsComponentsIopsTotal := qrStatisticsComponentsIopsTotal
		if qStatisticsComponentsIopsTotal != "" {

			if err := r.SetQueryParam("statistics.components.iops.total", qStatisticsComponentsIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsLatencyAverage != nil {

		// query param statistics.components.latency.average
		var qrStatisticsComponentsLatencyAverage string

		if o.StatisticsComponentsLatencyAverage != nil {
			qrStatisticsComponentsLatencyAverage = *o.StatisticsComponentsLatencyAverage
		}
		qStatisticsComponentsLatencyAverage := qrStatisticsComponentsLatencyAverage
		if qStatisticsComponentsLatencyAverage != "" {

			if err := r.SetQueryParam("statistics.components.latency.average", qStatisticsComponentsLatencyAverage); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsLatencyRaw != nil {

		// query param statistics.components.latency.raw
		var qrStatisticsComponentsLatencyRaw string

		if o.StatisticsComponentsLatencyRaw != nil {
			qrStatisticsComponentsLatencyRaw = *o.StatisticsComponentsLatencyRaw
		}
		qStatisticsComponentsLatencyRaw := qrStatisticsComponentsLatencyRaw
		if qStatisticsComponentsLatencyRaw != "" {

			if err := r.SetQueryParam("statistics.components.latency.raw", qStatisticsComponentsLatencyRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsName != nil {

		// query param statistics.components.name
		var qrStatisticsComponentsName string

		if o.StatisticsComponentsName != nil {
			qrStatisticsComponentsName = *o.StatisticsComponentsName
		}
		qStatisticsComponentsName := qrStatisticsComponentsName
		if qStatisticsComponentsName != "" {

			if err := r.SetQueryParam("statistics.components.name", qStatisticsComponentsName); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSharedStoragePool != nil {

		// query param statistics.components.shared_storage_pool
		var qrStatisticsComponentsSharedStoragePool string

		if o.StatisticsComponentsSharedStoragePool != nil {
			qrStatisticsComponentsSharedStoragePool = *o.StatisticsComponentsSharedStoragePool
		}
		qStatisticsComponentsSharedStoragePool := qrStatisticsComponentsSharedStoragePool
		if qStatisticsComponentsSharedStoragePool != "" {

			if err := r.SetQueryParam("statistics.components.shared_storage_pool", qStatisticsComponentsSharedStoragePool); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSnapshotReserve != nil {

		// query param statistics.components.snapshot.reserve
		var qrStatisticsComponentsSnapshotReserve string

		if o.StatisticsComponentsSnapshotReserve != nil {
			qrStatisticsComponentsSnapshotReserve = *o.StatisticsComponentsSnapshotReserve
		}
		qStatisticsComponentsSnapshotReserve := qrStatisticsComponentsSnapshotReserve
		if qStatisticsComponentsSnapshotReserve != "" {

			if err := r.SetQueryParam("statistics.components.snapshot.reserve", qStatisticsComponentsSnapshotReserve); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSnapshotUsed != nil {

		// query param statistics.components.snapshot.used
		var qrStatisticsComponentsSnapshotUsed string

		if o.StatisticsComponentsSnapshotUsed != nil {
			qrStatisticsComponentsSnapshotUsed = *o.StatisticsComponentsSnapshotUsed
		}
		qStatisticsComponentsSnapshotUsed := qrStatisticsComponentsSnapshotUsed
		if qStatisticsComponentsSnapshotUsed != "" {

			if err := r.SetQueryParam("statistics.components.snapshot.used", qStatisticsComponentsSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceAvailable != nil {

		// query param statistics.components.space.available
		var qrStatisticsComponentsSpaceAvailable string

		if o.StatisticsComponentsSpaceAvailable != nil {
			qrStatisticsComponentsSpaceAvailable = *o.StatisticsComponentsSpaceAvailable
		}
		qStatisticsComponentsSpaceAvailable := qrStatisticsComponentsSpaceAvailable
		if qStatisticsComponentsSpaceAvailable != "" {

			if err := r.SetQueryParam("statistics.components.space.available", qStatisticsComponentsSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceLogicalUsed != nil {

		// query param statistics.components.space.logical_used
		var qrStatisticsComponentsSpaceLogicalUsed string

		if o.StatisticsComponentsSpaceLogicalUsed != nil {
			qrStatisticsComponentsSpaceLogicalUsed = *o.StatisticsComponentsSpaceLogicalUsed
		}
		qStatisticsComponentsSpaceLogicalUsed := qrStatisticsComponentsSpaceLogicalUsed
		if qStatisticsComponentsSpaceLogicalUsed != "" {

			if err := r.SetQueryParam("statistics.components.space.logical_used", qStatisticsComponentsSpaceLogicalUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceProvisioned != nil {

		// query param statistics.components.space.provisioned
		var qrStatisticsComponentsSpaceProvisioned string

		if o.StatisticsComponentsSpaceProvisioned != nil {
			qrStatisticsComponentsSpaceProvisioned = *o.StatisticsComponentsSpaceProvisioned
		}
		qStatisticsComponentsSpaceProvisioned := qrStatisticsComponentsSpaceProvisioned
		if qStatisticsComponentsSpaceProvisioned != "" {

			if err := r.SetQueryParam("statistics.components.space.provisioned", qStatisticsComponentsSpaceProvisioned); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceReservedUnused != nil {

		// query param statistics.components.space.reserved_unused
		var qrStatisticsComponentsSpaceReservedUnused string

		if o.StatisticsComponentsSpaceReservedUnused != nil {
			qrStatisticsComponentsSpaceReservedUnused = *o.StatisticsComponentsSpaceReservedUnused
		}
		qStatisticsComponentsSpaceReservedUnused := qrStatisticsComponentsSpaceReservedUnused
		if qStatisticsComponentsSpaceReservedUnused != "" {

			if err := r.SetQueryParam("statistics.components.space.reserved_unused", qStatisticsComponentsSpaceReservedUnused); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceSavings != nil {

		// query param statistics.components.space.savings
		var qrStatisticsComponentsSpaceSavings string

		if o.StatisticsComponentsSpaceSavings != nil {
			qrStatisticsComponentsSpaceSavings = *o.StatisticsComponentsSpaceSavings
		}
		qStatisticsComponentsSpaceSavings := qrStatisticsComponentsSpaceSavings
		if qStatisticsComponentsSpaceSavings != "" {

			if err := r.SetQueryParam("statistics.components.space.savings", qStatisticsComponentsSpaceSavings); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceUsed != nil {

		// query param statistics.components.space.used
		var qrStatisticsComponentsSpaceUsed string

		if o.StatisticsComponentsSpaceUsed != nil {
			qrStatisticsComponentsSpaceUsed = *o.StatisticsComponentsSpaceUsed
		}
		qStatisticsComponentsSpaceUsed := qrStatisticsComponentsSpaceUsed
		if qStatisticsComponentsSpaceUsed != "" {

			if err := r.SetQueryParam("statistics.components.space.used", qStatisticsComponentsSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceUsedExcludingReserves != nil {

		// query param statistics.components.space.used_excluding_reserves
		var qrStatisticsComponentsSpaceUsedExcludingReserves string

		if o.StatisticsComponentsSpaceUsedExcludingReserves != nil {
			qrStatisticsComponentsSpaceUsedExcludingReserves = *o.StatisticsComponentsSpaceUsedExcludingReserves
		}
		qStatisticsComponentsSpaceUsedExcludingReserves := qrStatisticsComponentsSpaceUsedExcludingReserves
		if qStatisticsComponentsSpaceUsedExcludingReserves != "" {

			if err := r.SetQueryParam("statistics.components.space.used_excluding_reserves", qStatisticsComponentsSpaceUsedExcludingReserves); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceUsedPercent != nil {

		// query param statistics.components.space.used_percent
		var qrStatisticsComponentsSpaceUsedPercent string

		if o.StatisticsComponentsSpaceUsedPercent != nil {
			qrStatisticsComponentsSpaceUsedPercent = *o.StatisticsComponentsSpaceUsedPercent
		}
		qStatisticsComponentsSpaceUsedPercent := qrStatisticsComponentsSpaceUsedPercent
		if qStatisticsComponentsSpaceUsedPercent != "" {

			if err := r.SetQueryParam("statistics.components.space.used_percent", qStatisticsComponentsSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsStatisticsIncomplete != nil {

		// query param statistics.components.statistics_incomplete
		var qrStatisticsComponentsStatisticsIncomplete string

		if o.StatisticsComponentsStatisticsIncomplete != nil {
			qrStatisticsComponentsStatisticsIncomplete = *o.StatisticsComponentsStatisticsIncomplete
		}
		qStatisticsComponentsStatisticsIncomplete := qrStatisticsComponentsStatisticsIncomplete
		if qStatisticsComponentsStatisticsIncomplete != "" {

			if err := r.SetQueryParam("statistics.components.statistics_incomplete", qStatisticsComponentsStatisticsIncomplete); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsStorageServiceName != nil {

		// query param statistics.components.storage_service.name
		var qrStatisticsComponentsStorageServiceName string

		if o.StatisticsComponentsStorageServiceName != nil {
			qrStatisticsComponentsStorageServiceName = *o.StatisticsComponentsStorageServiceName
		}
		qStatisticsComponentsStorageServiceName := qrStatisticsComponentsStorageServiceName
		if qStatisticsComponentsStorageServiceName != "" {

			if err := r.SetQueryParam("statistics.components.storage_service.name", qStatisticsComponentsStorageServiceName); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsUUID != nil {

		// query param statistics.components.uuid
		var qrStatisticsComponentsUUID string

		if o.StatisticsComponentsUUID != nil {
			qrStatisticsComponentsUUID = *o.StatisticsComponentsUUID
		}
		qStatisticsComponentsUUID := qrStatisticsComponentsUUID
		if qStatisticsComponentsUUID != "" {

			if err := r.SetQueryParam("statistics.components.uuid", qStatisticsComponentsUUID); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsPerTb != nil {

		// query param statistics.iops.per_tb
		var qrStatisticsIopsPerTb string

		if o.StatisticsIopsPerTb != nil {
			qrStatisticsIopsPerTb = *o.StatisticsIopsPerTb
		}
		qStatisticsIopsPerTb := qrStatisticsIopsPerTb
		if qStatisticsIopsPerTb != "" {

			if err := r.SetQueryParam("statistics.iops.per_tb", qStatisticsIopsPerTb); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsTotal != nil {

		// query param statistics.iops.total
		var qrStatisticsIopsTotal string

		if o.StatisticsIopsTotal != nil {
			qrStatisticsIopsTotal = *o.StatisticsIopsTotal
		}
		qStatisticsIopsTotal := qrStatisticsIopsTotal
		if qStatisticsIopsTotal != "" {

			if err := r.SetQueryParam("statistics.iops.total", qStatisticsIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyAverage != nil {

		// query param statistics.latency.average
		var qrStatisticsLatencyAverage string

		if o.StatisticsLatencyAverage != nil {
			qrStatisticsLatencyAverage = *o.StatisticsLatencyAverage
		}
		qStatisticsLatencyAverage := qrStatisticsLatencyAverage
		if qStatisticsLatencyAverage != "" {

			if err := r.SetQueryParam("statistics.latency.average", qStatisticsLatencyAverage); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRaw != nil {

		// query param statistics.latency.raw
		var qrStatisticsLatencyRaw string

		if o.StatisticsLatencyRaw != nil {
			qrStatisticsLatencyRaw = *o.StatisticsLatencyRaw
		}
		qStatisticsLatencyRaw := qrStatisticsLatencyRaw
		if qStatisticsLatencyRaw != "" {

			if err := r.SetQueryParam("statistics.latency.raw", qStatisticsLatencyRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSharedStoragePool != nil {

		// query param statistics.shared_storage_pool
		var qrStatisticsSharedStoragePool string

		if o.StatisticsSharedStoragePool != nil {
			qrStatisticsSharedStoragePool = *o.StatisticsSharedStoragePool
		}
		qStatisticsSharedStoragePool := qrStatisticsSharedStoragePool
		if qStatisticsSharedStoragePool != "" {

			if err := r.SetQueryParam("statistics.shared_storage_pool", qStatisticsSharedStoragePool); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSnapshotReserve != nil {

		// query param statistics.snapshot.reserve
		var qrStatisticsSnapshotReserve string

		if o.StatisticsSnapshotReserve != nil {
			qrStatisticsSnapshotReserve = *o.StatisticsSnapshotReserve
		}
		qStatisticsSnapshotReserve := qrStatisticsSnapshotReserve
		if qStatisticsSnapshotReserve != "" {

			if err := r.SetQueryParam("statistics.snapshot.reserve", qStatisticsSnapshotReserve); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSnapshotUsed != nil {

		// query param statistics.snapshot.used
		var qrStatisticsSnapshotUsed string

		if o.StatisticsSnapshotUsed != nil {
			qrStatisticsSnapshotUsed = *o.StatisticsSnapshotUsed
		}
		qStatisticsSnapshotUsed := qrStatisticsSnapshotUsed
		if qStatisticsSnapshotUsed != "" {

			if err := r.SetQueryParam("statistics.snapshot.used", qStatisticsSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceAvailable != nil {

		// query param statistics.space.available
		var qrStatisticsSpaceAvailable string

		if o.StatisticsSpaceAvailable != nil {
			qrStatisticsSpaceAvailable = *o.StatisticsSpaceAvailable
		}
		qStatisticsSpaceAvailable := qrStatisticsSpaceAvailable
		if qStatisticsSpaceAvailable != "" {

			if err := r.SetQueryParam("statistics.space.available", qStatisticsSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceLogicalUsed != nil {

		// query param statistics.space.logical_used
		var qrStatisticsSpaceLogicalUsed string

		if o.StatisticsSpaceLogicalUsed != nil {
			qrStatisticsSpaceLogicalUsed = *o.StatisticsSpaceLogicalUsed
		}
		qStatisticsSpaceLogicalUsed := qrStatisticsSpaceLogicalUsed
		if qStatisticsSpaceLogicalUsed != "" {

			if err := r.SetQueryParam("statistics.space.logical_used", qStatisticsSpaceLogicalUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceProvisioned != nil {

		// query param statistics.space.provisioned
		var qrStatisticsSpaceProvisioned string

		if o.StatisticsSpaceProvisioned != nil {
			qrStatisticsSpaceProvisioned = *o.StatisticsSpaceProvisioned
		}
		qStatisticsSpaceProvisioned := qrStatisticsSpaceProvisioned
		if qStatisticsSpaceProvisioned != "" {

			if err := r.SetQueryParam("statistics.space.provisioned", qStatisticsSpaceProvisioned); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceReservedUnused != nil {

		// query param statistics.space.reserved_unused
		var qrStatisticsSpaceReservedUnused string

		if o.StatisticsSpaceReservedUnused != nil {
			qrStatisticsSpaceReservedUnused = *o.StatisticsSpaceReservedUnused
		}
		qStatisticsSpaceReservedUnused := qrStatisticsSpaceReservedUnused
		if qStatisticsSpaceReservedUnused != "" {

			if err := r.SetQueryParam("statistics.space.reserved_unused", qStatisticsSpaceReservedUnused); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceSavings != nil {

		// query param statistics.space.savings
		var qrStatisticsSpaceSavings string

		if o.StatisticsSpaceSavings != nil {
			qrStatisticsSpaceSavings = *o.StatisticsSpaceSavings
		}
		qStatisticsSpaceSavings := qrStatisticsSpaceSavings
		if qStatisticsSpaceSavings != "" {

			if err := r.SetQueryParam("statistics.space.savings", qStatisticsSpaceSavings); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceUsed != nil {

		// query param statistics.space.used
		var qrStatisticsSpaceUsed string

		if o.StatisticsSpaceUsed != nil {
			qrStatisticsSpaceUsed = *o.StatisticsSpaceUsed
		}
		qStatisticsSpaceUsed := qrStatisticsSpaceUsed
		if qStatisticsSpaceUsed != "" {

			if err := r.SetQueryParam("statistics.space.used", qStatisticsSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceUsedExcludingReserves != nil {

		// query param statistics.space.used_excluding_reserves
		var qrStatisticsSpaceUsedExcludingReserves string

		if o.StatisticsSpaceUsedExcludingReserves != nil {
			qrStatisticsSpaceUsedExcludingReserves = *o.StatisticsSpaceUsedExcludingReserves
		}
		qStatisticsSpaceUsedExcludingReserves := qrStatisticsSpaceUsedExcludingReserves
		if qStatisticsSpaceUsedExcludingReserves != "" {

			if err := r.SetQueryParam("statistics.space.used_excluding_reserves", qStatisticsSpaceUsedExcludingReserves); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceUsedPercent != nil {

		// query param statistics.space.used_percent
		var qrStatisticsSpaceUsedPercent string

		if o.StatisticsSpaceUsedPercent != nil {
			qrStatisticsSpaceUsedPercent = *o.StatisticsSpaceUsedPercent
		}
		qStatisticsSpaceUsedPercent := qrStatisticsSpaceUsedPercent
		if qStatisticsSpaceUsedPercent != "" {

			if err := r.SetQueryParam("statistics.space.used_percent", qStatisticsSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatisticsIncomplete != nil {

		// query param statistics.statistics_incomplete
		var qrStatisticsStatisticsIncomplete string

		if o.StatisticsStatisticsIncomplete != nil {
			qrStatisticsStatisticsIncomplete = *o.StatisticsStatisticsIncomplete
		}
		qStatisticsStatisticsIncomplete := qrStatisticsStatisticsIncomplete
		if qStatisticsStatisticsIncomplete != "" {

			if err := r.SetQueryParam("statistics.statistics_incomplete", qStatisticsStatisticsIncomplete); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TemplateName != nil {

		// query param template.name
		var qrTemplateName string

		if o.TemplateName != nil {
			qrTemplateName = *o.TemplateName
		}
		qTemplateName := qrTemplateName
		if qTemplateName != "" {

			if err := r.SetQueryParam("template.name", qTemplateName); err != nil {
				return err
			}
		}
	}

	if o.TemplateProtocol != nil {

		// query param template.protocol
		var qrTemplateProtocol string

		if o.TemplateProtocol != nil {
			qrTemplateProtocol = *o.TemplateProtocol
		}
		qTemplateProtocol := qrTemplateProtocol
		if qTemplateProtocol != "" {

			if err := r.SetQueryParam("template.protocol", qTemplateProtocol); err != nil {
				return err
			}
		}
	}

	if o.TemplateVersion != nil {

		// query param template.version
		var qrTemplateVersion string

		if o.TemplateVersion != nil {
			qrTemplateVersion = *o.TemplateVersion
		}
		qTemplateVersion := qrTemplateVersion
		if qTemplateVersion != "" {

			if err := r.SetQueryParam("template.version", qTemplateVersion); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamApplicationCollectionGet binds the parameter fields
func (o *ApplicationCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamApplicationCollectionGet binds the parameter order_by
func (o *ApplicationCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
