// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationCollectionGetReader is a Reader for the ApplicationCollectionGet structure.
type ApplicationCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationCollectionGetOK creates a ApplicationCollectionGetOK with default headers values
func NewApplicationCollectionGetOK() *ApplicationCollectionGetOK {
	return &ApplicationCollectionGetOK{}
}

/*
ApplicationCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationCollectionGetOK struct {
	Payload *models.ApplicationResponse
}

// IsSuccess returns true when this application collection get o k response has a 2xx status code
func (o *ApplicationCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application collection get o k response has a 3xx status code
func (o *ApplicationCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application collection get o k response has a 4xx status code
func (o *ApplicationCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application collection get o k response has a 5xx status code
func (o *ApplicationCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application collection get o k response a status code equal to that given
func (o *ApplicationCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application collection get o k response
func (o *ApplicationCollectionGetOK) Code() int {
	return 200
}

func (o *ApplicationCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications][%d] applicationCollectionGetOK %s", 200, payload)
}

func (o *ApplicationCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications][%d] applicationCollectionGetOK %s", 200, payload)
}

func (o *ApplicationCollectionGetOK) GetPayload() *models.ApplicationResponse {
	return o.Payload
}

func (o *ApplicationCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationCollectionGetDefault creates a ApplicationCollectionGetDefault with default headers values
func NewApplicationCollectionGetDefault(code int) *ApplicationCollectionGetDefault {
	return &ApplicationCollectionGetDefault{
		_statusCode: code,
	}
}

/*
ApplicationCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application collection get default response has a 2xx status code
func (o *ApplicationCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application collection get default response has a 3xx status code
func (o *ApplicationCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application collection get default response has a 4xx status code
func (o *ApplicationCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application collection get default response has a 5xx status code
func (o *ApplicationCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application collection get default response a status code equal to that given
func (o *ApplicationCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application collection get default response
func (o *ApplicationCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications][%d] application_collection_get default %s", o._statusCode, payload)
}

func (o *ApplicationCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications][%d] application_collection_get default %s", o._statusCode, payload)
}

func (o *ApplicationCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
