// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationComponentSnapshotCollectionGetParams creates a new ApplicationComponentSnapshotCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationComponentSnapshotCollectionGetParams() *ApplicationComponentSnapshotCollectionGetParams {
	return &ApplicationComponentSnapshotCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationComponentSnapshotCollectionGetParamsWithTimeout creates a new ApplicationComponentSnapshotCollectionGetParams object
// with the ability to set a timeout on a request.
func NewApplicationComponentSnapshotCollectionGetParamsWithTimeout(timeout time.Duration) *ApplicationComponentSnapshotCollectionGetParams {
	return &ApplicationComponentSnapshotCollectionGetParams{
		timeout: timeout,
	}
}

// NewApplicationComponentSnapshotCollectionGetParamsWithContext creates a new ApplicationComponentSnapshotCollectionGetParams object
// with the ability to set a context for a request.
func NewApplicationComponentSnapshotCollectionGetParamsWithContext(ctx context.Context) *ApplicationComponentSnapshotCollectionGetParams {
	return &ApplicationComponentSnapshotCollectionGetParams{
		Context: ctx,
	}
}

// NewApplicationComponentSnapshotCollectionGetParamsWithHTTPClient creates a new ApplicationComponentSnapshotCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationComponentSnapshotCollectionGetParamsWithHTTPClient(client *http.Client) *ApplicationComponentSnapshotCollectionGetParams {
	return &ApplicationComponentSnapshotCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ApplicationComponentSnapshotCollectionGetParams contains all the parameters to send to the API endpoint

	for the application component snapshot collection get operation.

	Typically these are written to a http.Request.
*/
type ApplicationComponentSnapshotCollectionGetParams struct {

	/* ApplicationUUID.

	   Application UUID
	*/
	ApplicationUUID string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ComponentName.

	   Filter by Application Component Name
	*/
	ComponentName *string

	/* ComponentUUID.

	   Application Component UUID
	*/
	ComponentUUID string

	/* ConsistencyType.

	   Filter by consistency_type
	*/
	ConsistencyType *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application component snapshot collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotCollectionGetParams) WithDefaults() *ApplicationComponentSnapshotCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application component snapshot collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ApplicationComponentSnapshotCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithTimeout(timeout time.Duration) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithContext(ctx context.Context) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithHTTPClient(client *http.Client) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationUUID adds the applicationUUID to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithApplicationUUID(applicationUUID string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetApplicationUUID(applicationUUID string) {
	o.ApplicationUUID = applicationUUID
}

// WithComment adds the comment to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithComment(comment *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithComponentName adds the componentName to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithComponentName(componentName *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetComponentName(componentName)
	return o
}

// SetComponentName adds the componentName to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetComponentName(componentName *string) {
	o.ComponentName = componentName
}

// WithComponentUUID adds the componentUUID to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithComponentUUID(componentUUID string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetComponentUUID(componentUUID)
	return o
}

// SetComponentUUID adds the componentUuid to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetComponentUUID(componentUUID string) {
	o.ComponentUUID = componentUUID
}

// WithConsistencyType adds the consistencyType to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithConsistencyType(consistencyType *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetConsistencyType(consistencyType)
	return o
}

// SetConsistencyType adds the consistencyType to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetConsistencyType(consistencyType *string) {
	o.ConsistencyType = consistencyType
}

// WithCreateTime adds the createTime to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithCreateTime(createTime *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithFields adds the fields to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithFields(fields []string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIsPartial adds the isPartial to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithIsPartial(isPartial *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetIsPartial(isPartial *string) {
	o.IsPartial = isPartial
}

// WithMaxRecords adds the maxRecords to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithMaxRecords(maxRecords *int64) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithName(name *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithOrderBy(orderBy []string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithReturnRecords(returnRecords *bool) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) WithUUID(uuid *string) *ApplicationComponentSnapshotCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application component snapshot collection get params
func (o *ApplicationComponentSnapshotCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationComponentSnapshotCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.uuid
	if err := r.SetPathParam("application.uuid", o.ApplicationUUID); err != nil {
		return err
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ComponentName != nil {

		// query param component.name
		var qrComponentName string

		if o.ComponentName != nil {
			qrComponentName = *o.ComponentName
		}
		qComponentName := qrComponentName
		if qComponentName != "" {

			if err := r.SetQueryParam("component.name", qComponentName); err != nil {
				return err
			}
		}
	}

	// path param component.uuid
	if err := r.SetPathParam("component.uuid", o.ComponentUUID); err != nil {
		return err
	}

	if o.ConsistencyType != nil {

		// query param consistency_type
		var qrConsistencyType string

		if o.ConsistencyType != nil {
			qrConsistencyType = *o.ConsistencyType
		}
		qConsistencyType := qrConsistencyType
		if qConsistencyType != "" {

			if err := r.SetQueryParam("consistency_type", qConsistencyType); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial string

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := qrIsPartial
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamApplicationComponentSnapshotCollectionGet binds the parameter fields
func (o *ApplicationComponentSnapshotCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamApplicationComponentSnapshotCollectionGet binds the parameter order_by
func (o *ApplicationComponentSnapshotCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
