// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationComponentSnapshotCollectionGetReader is a Reader for the ApplicationComponentSnapshotCollectionGet structure.
type ApplicationComponentSnapshotCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationComponentSnapshotCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationComponentSnapshotCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationComponentSnapshotCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationComponentSnapshotCollectionGetOK creates a ApplicationComponentSnapshotCollectionGetOK with default headers values
func NewApplicationComponentSnapshotCollectionGetOK() *ApplicationComponentSnapshotCollectionGetOK {
	return &ApplicationComponentSnapshotCollectionGetOK{}
}

/*
ApplicationComponentSnapshotCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationComponentSnapshotCollectionGetOK struct {
	Payload *models.ApplicationComponentSnapshotResponse
}

// IsSuccess returns true when this application component snapshot collection get o k response has a 2xx status code
func (o *ApplicationComponentSnapshotCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application component snapshot collection get o k response has a 3xx status code
func (o *ApplicationComponentSnapshotCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application component snapshot collection get o k response has a 4xx status code
func (o *ApplicationComponentSnapshotCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application component snapshot collection get o k response has a 5xx status code
func (o *ApplicationComponentSnapshotCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application component snapshot collection get o k response a status code equal to that given
func (o *ApplicationComponentSnapshotCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application component snapshot collection get o k response
func (o *ApplicationComponentSnapshotCollectionGetOK) Code() int {
	return 200
}

func (o *ApplicationComponentSnapshotCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] applicationComponentSnapshotCollectionGetOK %s", 200, payload)
}

func (o *ApplicationComponentSnapshotCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] applicationComponentSnapshotCollectionGetOK %s", 200, payload)
}

func (o *ApplicationComponentSnapshotCollectionGetOK) GetPayload() *models.ApplicationComponentSnapshotResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationComponentSnapshotResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationComponentSnapshotCollectionGetDefault creates a ApplicationComponentSnapshotCollectionGetDefault with default headers values
func NewApplicationComponentSnapshotCollectionGetDefault(code int) *ApplicationComponentSnapshotCollectionGetDefault {
	return &ApplicationComponentSnapshotCollectionGetDefault{
		_statusCode: code,
	}
}

/*
ApplicationComponentSnapshotCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationComponentSnapshotCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application component snapshot collection get default response has a 2xx status code
func (o *ApplicationComponentSnapshotCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application component snapshot collection get default response has a 3xx status code
func (o *ApplicationComponentSnapshotCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application component snapshot collection get default response has a 4xx status code
func (o *ApplicationComponentSnapshotCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application component snapshot collection get default response has a 5xx status code
func (o *ApplicationComponentSnapshotCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application component snapshot collection get default response a status code equal to that given
func (o *ApplicationComponentSnapshotCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application component snapshot collection get default response
func (o *ApplicationComponentSnapshotCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationComponentSnapshotCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] application_component_snapshot_collection_get default %s", o._statusCode, payload)
}

func (o *ApplicationComponentSnapshotCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] application_component_snapshot_collection_get default %s", o._statusCode, payload)
}

func (o *ApplicationComponentSnapshotCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
