// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationComponentSnapshotDeleteCollectionReader is a Reader for the ApplicationComponentSnapshotDeleteCollection structure.
type ApplicationComponentSnapshotDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationComponentSnapshotDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationComponentSnapshotDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationComponentSnapshotDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationComponentSnapshotDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationComponentSnapshotDeleteCollectionOK creates a ApplicationComponentSnapshotDeleteCollectionOK with default headers values
func NewApplicationComponentSnapshotDeleteCollectionOK() *ApplicationComponentSnapshotDeleteCollectionOK {
	return &ApplicationComponentSnapshotDeleteCollectionOK{}
}

/*
ApplicationComponentSnapshotDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationComponentSnapshotDeleteCollectionOK struct {
	Payload *models.ApplicationComponentSnapshotJobLinkResponse
}

// IsSuccess returns true when this application component snapshot delete collection o k response has a 2xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application component snapshot delete collection o k response has a 3xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application component snapshot delete collection o k response has a 4xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application component snapshot delete collection o k response has a 5xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application component snapshot delete collection o k response a status code equal to that given
func (o *ApplicationComponentSnapshotDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application component snapshot delete collection o k response
func (o *ApplicationComponentSnapshotDeleteCollectionOK) Code() int {
	return 200
}

func (o *ApplicationComponentSnapshotDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] applicationComponentSnapshotDeleteCollectionOK %s", 200, payload)
}

func (o *ApplicationComponentSnapshotDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] applicationComponentSnapshotDeleteCollectionOK %s", 200, payload)
}

func (o *ApplicationComponentSnapshotDeleteCollectionOK) GetPayload() *models.ApplicationComponentSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationComponentSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationComponentSnapshotDeleteCollectionAccepted creates a ApplicationComponentSnapshotDeleteCollectionAccepted with default headers values
func NewApplicationComponentSnapshotDeleteCollectionAccepted() *ApplicationComponentSnapshotDeleteCollectionAccepted {
	return &ApplicationComponentSnapshotDeleteCollectionAccepted{}
}

/*
ApplicationComponentSnapshotDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationComponentSnapshotDeleteCollectionAccepted struct {
	Payload *models.ApplicationComponentSnapshotJobLinkResponse
}

// IsSuccess returns true when this application component snapshot delete collection accepted response has a 2xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application component snapshot delete collection accepted response has a 3xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application component snapshot delete collection accepted response has a 4xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application component snapshot delete collection accepted response has a 5xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application component snapshot delete collection accepted response a status code equal to that given
func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application component snapshot delete collection accepted response
func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] applicationComponentSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] applicationComponentSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) GetPayload() *models.ApplicationComponentSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationComponentSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationComponentSnapshotDeleteCollectionDefault creates a ApplicationComponentSnapshotDeleteCollectionDefault with default headers values
func NewApplicationComponentSnapshotDeleteCollectionDefault(code int) *ApplicationComponentSnapshotDeleteCollectionDefault {
	return &ApplicationComponentSnapshotDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
ApplicationComponentSnapshotDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationComponentSnapshotDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application component snapshot delete collection default response has a 2xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application component snapshot delete collection default response has a 3xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application component snapshot delete collection default response has a 4xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application component snapshot delete collection default response has a 5xx status code
func (o *ApplicationComponentSnapshotDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application component snapshot delete collection default response a status code equal to that given
func (o *ApplicationComponentSnapshotDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application component snapshot delete collection default response
func (o *ApplicationComponentSnapshotDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationComponentSnapshotDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] application_component_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *ApplicationComponentSnapshotDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/components/{component.uuid}/snapshots][%d] application_component_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *ApplicationComponentSnapshotDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ApplicationComponentSnapshotDeleteCollectionBody application component snapshot delete collection body
swagger:model ApplicationComponentSnapshotDeleteCollectionBody
*/
type ApplicationComponentSnapshotDeleteCollectionBody struct {

	// application component snapshot response inline records
	ApplicationComponentSnapshotResponseInlineRecords []*models.ApplicationComponentSnapshot `json:"records,omitempty"`
}

// Validate validates this application component snapshot delete collection body
func (o *ApplicationComponentSnapshotDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateApplicationComponentSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationComponentSnapshotDeleteCollectionBody) validateApplicationComponentSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationComponentSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ApplicationComponentSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.ApplicationComponentSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ApplicationComponentSnapshotResponseInlineRecords[i] != nil {
			if err := o.ApplicationComponentSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this application component snapshot delete collection body based on the context it is used
func (o *ApplicationComponentSnapshotDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateApplicationComponentSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationComponentSnapshotDeleteCollectionBody) contextValidateApplicationComponentSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ApplicationComponentSnapshotResponseInlineRecords); i++ {

		if o.ApplicationComponentSnapshotResponseInlineRecords[i] != nil {
			if err := o.ApplicationComponentSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationComponentSnapshotDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationComponentSnapshotDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ApplicationComponentSnapshotDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
