// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationComponentSnapshotDeleteParams creates a new ApplicationComponentSnapshotDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationComponentSnapshotDeleteParams() *ApplicationComponentSnapshotDeleteParams {
	return &ApplicationComponentSnapshotDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationComponentSnapshotDeleteParamsWithTimeout creates a new ApplicationComponentSnapshotDeleteParams object
// with the ability to set a timeout on a request.
func NewApplicationComponentSnapshotDeleteParamsWithTimeout(timeout time.Duration) *ApplicationComponentSnapshotDeleteParams {
	return &ApplicationComponentSnapshotDeleteParams{
		timeout: timeout,
	}
}

// NewApplicationComponentSnapshotDeleteParamsWithContext creates a new ApplicationComponentSnapshotDeleteParams object
// with the ability to set a context for a request.
func NewApplicationComponentSnapshotDeleteParamsWithContext(ctx context.Context) *ApplicationComponentSnapshotDeleteParams {
	return &ApplicationComponentSnapshotDeleteParams{
		Context: ctx,
	}
}

// NewApplicationComponentSnapshotDeleteParamsWithHTTPClient creates a new ApplicationComponentSnapshotDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationComponentSnapshotDeleteParamsWithHTTPClient(client *http.Client) *ApplicationComponentSnapshotDeleteParams {
	return &ApplicationComponentSnapshotDeleteParams{
		HTTPClient: client,
	}
}

/*
ApplicationComponentSnapshotDeleteParams contains all the parameters to send to the API endpoint

	for the application component snapshot delete operation.

	Typically these are written to a http.Request.
*/
type ApplicationComponentSnapshotDeleteParams struct {

	/* ApplicationUUID.

	   Application UUID
	*/
	ApplicationUUID string

	/* ComponentUUID.

	   Application Component UUID
	*/
	ComponentUUID string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Snapshot UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application component snapshot delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotDeleteParams) WithDefaults() *ApplicationComponentSnapshotDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application component snapshot delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := ApplicationComponentSnapshotDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithTimeout(timeout time.Duration) *ApplicationComponentSnapshotDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithContext(ctx context.Context) *ApplicationComponentSnapshotDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithHTTPClient(client *http.Client) *ApplicationComponentSnapshotDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationUUID adds the applicationUUID to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithApplicationUUID(applicationUUID string) *ApplicationComponentSnapshotDeleteParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetApplicationUUID(applicationUUID string) {
	o.ApplicationUUID = applicationUUID
}

// WithComponentUUID adds the componentUUID to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithComponentUUID(componentUUID string) *ApplicationComponentSnapshotDeleteParams {
	o.SetComponentUUID(componentUUID)
	return o
}

// SetComponentUUID adds the componentUuid to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetComponentUUID(componentUUID string) {
	o.ComponentUUID = componentUUID
}

// WithReturnTimeout adds the returnTimeout to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithReturnTimeout(returnTimeout *int64) *ApplicationComponentSnapshotDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) WithUUID(uuid string) *ApplicationComponentSnapshotDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application component snapshot delete params
func (o *ApplicationComponentSnapshotDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationComponentSnapshotDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.uuid
	if err := r.SetPathParam("application.uuid", o.ApplicationUUID); err != nil {
		return err
	}

	// path param component.uuid
	if err := r.SetPathParam("component.uuid", o.ComponentUUID); err != nil {
		return err
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
