// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationComponentSnapshotGetParams creates a new ApplicationComponentSnapshotGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationComponentSnapshotGetParams() *ApplicationComponentSnapshotGetParams {
	return &ApplicationComponentSnapshotGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationComponentSnapshotGetParamsWithTimeout creates a new ApplicationComponentSnapshotGetParams object
// with the ability to set a timeout on a request.
func NewApplicationComponentSnapshotGetParamsWithTimeout(timeout time.Duration) *ApplicationComponentSnapshotGetParams {
	return &ApplicationComponentSnapshotGetParams{
		timeout: timeout,
	}
}

// NewApplicationComponentSnapshotGetParamsWithContext creates a new ApplicationComponentSnapshotGetParams object
// with the ability to set a context for a request.
func NewApplicationComponentSnapshotGetParamsWithContext(ctx context.Context) *ApplicationComponentSnapshotGetParams {
	return &ApplicationComponentSnapshotGetParams{
		Context: ctx,
	}
}

// NewApplicationComponentSnapshotGetParamsWithHTTPClient creates a new ApplicationComponentSnapshotGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationComponentSnapshotGetParamsWithHTTPClient(client *http.Client) *ApplicationComponentSnapshotGetParams {
	return &ApplicationComponentSnapshotGetParams{
		HTTPClient: client,
	}
}

/*
ApplicationComponentSnapshotGetParams contains all the parameters to send to the API endpoint

	for the application component snapshot get operation.

	Typically these are written to a http.Request.
*/
type ApplicationComponentSnapshotGetParams struct {

	/* ApplicationUUID.

	   Application UUID
	*/
	ApplicationUUID string

	/* ComponentUUID.

	   Application Component UUID
	*/
	ComponentUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Snapshot UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application component snapshot get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotGetParams) WithDefaults() *ApplicationComponentSnapshotGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application component snapshot get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithTimeout(timeout time.Duration) *ApplicationComponentSnapshotGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithContext(ctx context.Context) *ApplicationComponentSnapshotGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithHTTPClient(client *http.Client) *ApplicationComponentSnapshotGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationUUID adds the applicationUUID to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithApplicationUUID(applicationUUID string) *ApplicationComponentSnapshotGetParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetApplicationUUID(applicationUUID string) {
	o.ApplicationUUID = applicationUUID
}

// WithComponentUUID adds the componentUUID to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithComponentUUID(componentUUID string) *ApplicationComponentSnapshotGetParams {
	o.SetComponentUUID(componentUUID)
	return o
}

// SetComponentUUID adds the componentUuid to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetComponentUUID(componentUUID string) {
	o.ComponentUUID = componentUUID
}

// WithFields adds the fields to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithFields(fields []string) *ApplicationComponentSnapshotGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) WithUUID(uuid string) *ApplicationComponentSnapshotGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application component snapshot get params
func (o *ApplicationComponentSnapshotGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationComponentSnapshotGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.uuid
	if err := r.SetPathParam("application.uuid", o.ApplicationUUID); err != nil {
		return err
	}

	// path param component.uuid
	if err := r.SetPathParam("component.uuid", o.ComponentUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamApplicationComponentSnapshotGet binds the parameter fields
func (o *ApplicationComponentSnapshotGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
