// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationComponentSnapshotRestoreParams creates a new ApplicationComponentSnapshotRestoreParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationComponentSnapshotRestoreParams() *ApplicationComponentSnapshotRestoreParams {
	return &ApplicationComponentSnapshotRestoreParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationComponentSnapshotRestoreParamsWithTimeout creates a new ApplicationComponentSnapshotRestoreParams object
// with the ability to set a timeout on a request.
func NewApplicationComponentSnapshotRestoreParamsWithTimeout(timeout time.Duration) *ApplicationComponentSnapshotRestoreParams {
	return &ApplicationComponentSnapshotRestoreParams{
		timeout: timeout,
	}
}

// NewApplicationComponentSnapshotRestoreParamsWithContext creates a new ApplicationComponentSnapshotRestoreParams object
// with the ability to set a context for a request.
func NewApplicationComponentSnapshotRestoreParamsWithContext(ctx context.Context) *ApplicationComponentSnapshotRestoreParams {
	return &ApplicationComponentSnapshotRestoreParams{
		Context: ctx,
	}
}

// NewApplicationComponentSnapshotRestoreParamsWithHTTPClient creates a new ApplicationComponentSnapshotRestoreParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationComponentSnapshotRestoreParamsWithHTTPClient(client *http.Client) *ApplicationComponentSnapshotRestoreParams {
	return &ApplicationComponentSnapshotRestoreParams{
		HTTPClient: client,
	}
}

/*
ApplicationComponentSnapshotRestoreParams contains all the parameters to send to the API endpoint

	for the application component snapshot restore operation.

	Typically these are written to a http.Request.
*/
type ApplicationComponentSnapshotRestoreParams struct {

	/* ApplicationUUID.

	   Application UUID
	*/
	ApplicationUUID string

	/* ComponentUUID.

	   Application Component UUID
	*/
	ComponentUUID string

	/* ReturnRecords.

	   The default is false.  If set to true, the records are returned.
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Snapshot UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application component snapshot restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotRestoreParams) WithDefaults() *ApplicationComponentSnapshotRestoreParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application component snapshot restore params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationComponentSnapshotRestoreParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(false)

		returnTimeoutDefault = int64(0)
	)

	val := ApplicationComponentSnapshotRestoreParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithTimeout(timeout time.Duration) *ApplicationComponentSnapshotRestoreParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithContext(ctx context.Context) *ApplicationComponentSnapshotRestoreParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithHTTPClient(client *http.Client) *ApplicationComponentSnapshotRestoreParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationUUID adds the applicationUUID to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithApplicationUUID(applicationUUID string) *ApplicationComponentSnapshotRestoreParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetApplicationUUID(applicationUUID string) {
	o.ApplicationUUID = applicationUUID
}

// WithComponentUUID adds the componentUUID to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithComponentUUID(componentUUID string) *ApplicationComponentSnapshotRestoreParams {
	o.SetComponentUUID(componentUUID)
	return o
}

// SetComponentUUID adds the componentUuid to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetComponentUUID(componentUUID string) {
	o.ComponentUUID = componentUUID
}

// WithReturnRecords adds the returnRecords to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithReturnRecords(returnRecords *bool) *ApplicationComponentSnapshotRestoreParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithReturnTimeout(returnTimeout *int64) *ApplicationComponentSnapshotRestoreParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) WithUUID(uuid string) *ApplicationComponentSnapshotRestoreParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application component snapshot restore params
func (o *ApplicationComponentSnapshotRestoreParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationComponentSnapshotRestoreParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.uuid
	if err := r.SetPathParam("application.uuid", o.ApplicationUUID); err != nil {
		return err
	}

	// path param component.uuid
	if err := r.SetPathParam("component.uuid", o.ComponentUUID); err != nil {
		return err
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
