// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationComponentSnapshotRestoreReader is a Reader for the ApplicationComponentSnapshotRestore structure.
type ApplicationComponentSnapshotRestoreReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationComponentSnapshotRestoreReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewApplicationComponentSnapshotRestoreCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationComponentSnapshotRestoreAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationComponentSnapshotRestoreDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationComponentSnapshotRestoreCreated creates a ApplicationComponentSnapshotRestoreCreated with default headers values
func NewApplicationComponentSnapshotRestoreCreated() *ApplicationComponentSnapshotRestoreCreated {
	return &ApplicationComponentSnapshotRestoreCreated{}
}

/*
ApplicationComponentSnapshotRestoreCreated describes a response with status code 201, with default header values.

Created
*/
type ApplicationComponentSnapshotRestoreCreated struct {
	Payload *models.ApplicationComponentSnapshotJobLinkResponse
}

// IsSuccess returns true when this application component snapshot restore created response has a 2xx status code
func (o *ApplicationComponentSnapshotRestoreCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application component snapshot restore created response has a 3xx status code
func (o *ApplicationComponentSnapshotRestoreCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application component snapshot restore created response has a 4xx status code
func (o *ApplicationComponentSnapshotRestoreCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this application component snapshot restore created response has a 5xx status code
func (o *ApplicationComponentSnapshotRestoreCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this application component snapshot restore created response a status code equal to that given
func (o *ApplicationComponentSnapshotRestoreCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the application component snapshot restore created response
func (o *ApplicationComponentSnapshotRestoreCreated) Code() int {
	return 201
}

func (o *ApplicationComponentSnapshotRestoreCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore][%d] applicationComponentSnapshotRestoreCreated %s", 201, payload)
}

func (o *ApplicationComponentSnapshotRestoreCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore][%d] applicationComponentSnapshotRestoreCreated %s", 201, payload)
}

func (o *ApplicationComponentSnapshotRestoreCreated) GetPayload() *models.ApplicationComponentSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotRestoreCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationComponentSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationComponentSnapshotRestoreAccepted creates a ApplicationComponentSnapshotRestoreAccepted with default headers values
func NewApplicationComponentSnapshotRestoreAccepted() *ApplicationComponentSnapshotRestoreAccepted {
	return &ApplicationComponentSnapshotRestoreAccepted{}
}

/*
ApplicationComponentSnapshotRestoreAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationComponentSnapshotRestoreAccepted struct {
	Payload *models.ApplicationComponentSnapshotJobLinkResponse
}

// IsSuccess returns true when this application component snapshot restore accepted response has a 2xx status code
func (o *ApplicationComponentSnapshotRestoreAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application component snapshot restore accepted response has a 3xx status code
func (o *ApplicationComponentSnapshotRestoreAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application component snapshot restore accepted response has a 4xx status code
func (o *ApplicationComponentSnapshotRestoreAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application component snapshot restore accepted response has a 5xx status code
func (o *ApplicationComponentSnapshotRestoreAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application component snapshot restore accepted response a status code equal to that given
func (o *ApplicationComponentSnapshotRestoreAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application component snapshot restore accepted response
func (o *ApplicationComponentSnapshotRestoreAccepted) Code() int {
	return 202
}

func (o *ApplicationComponentSnapshotRestoreAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore][%d] applicationComponentSnapshotRestoreAccepted %s", 202, payload)
}

func (o *ApplicationComponentSnapshotRestoreAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore][%d] applicationComponentSnapshotRestoreAccepted %s", 202, payload)
}

func (o *ApplicationComponentSnapshotRestoreAccepted) GetPayload() *models.ApplicationComponentSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotRestoreAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationComponentSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationComponentSnapshotRestoreDefault creates a ApplicationComponentSnapshotRestoreDefault with default headers values
func NewApplicationComponentSnapshotRestoreDefault(code int) *ApplicationComponentSnapshotRestoreDefault {
	return &ApplicationComponentSnapshotRestoreDefault{
		_statusCode: code,
	}
}

/*
ApplicationComponentSnapshotRestoreDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationComponentSnapshotRestoreDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application component snapshot restore default response has a 2xx status code
func (o *ApplicationComponentSnapshotRestoreDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application component snapshot restore default response has a 3xx status code
func (o *ApplicationComponentSnapshotRestoreDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application component snapshot restore default response has a 4xx status code
func (o *ApplicationComponentSnapshotRestoreDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application component snapshot restore default response has a 5xx status code
func (o *ApplicationComponentSnapshotRestoreDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application component snapshot restore default response a status code equal to that given
func (o *ApplicationComponentSnapshotRestoreDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application component snapshot restore default response
func (o *ApplicationComponentSnapshotRestoreDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationComponentSnapshotRestoreDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore][%d] application_component_snapshot_restore default %s", o._statusCode, payload)
}

func (o *ApplicationComponentSnapshotRestoreDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/components/{component.uuid}/snapshots/{uuid}/restore][%d] application_component_snapshot_restore default %s", o._statusCode, payload)
}

func (o *ApplicationComponentSnapshotRestoreDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationComponentSnapshotRestoreDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
