// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationDeleteCollectionParams creates a new ApplicationDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationDeleteCollectionParams() *ApplicationDeleteCollectionParams {
	return &ApplicationDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationDeleteCollectionParamsWithTimeout creates a new ApplicationDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewApplicationDeleteCollectionParamsWithTimeout(timeout time.Duration) *ApplicationDeleteCollectionParams {
	return &ApplicationDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewApplicationDeleteCollectionParamsWithContext creates a new ApplicationDeleteCollectionParams object
// with the ability to set a context for a request.
func NewApplicationDeleteCollectionParamsWithContext(ctx context.Context) *ApplicationDeleteCollectionParams {
	return &ApplicationDeleteCollectionParams{
		Context: ctx,
	}
}

// NewApplicationDeleteCollectionParamsWithHTTPClient creates a new ApplicationDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationDeleteCollectionParamsWithHTTPClient(client *http.Client) *ApplicationDeleteCollectionParams {
	return &ApplicationDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ApplicationDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the application delete collection operation.

	Typically these are written to a http.Request.
*/
type ApplicationDeleteCollectionParams struct {

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* DeleteData.

	   By default, deleting an application deletes all of the application's data. By setting this parameter to "false", the application's data is preserved, but can no longer be managed through application APIs.


	   Default: true
	*/
	DeleteData *bool

	/* Generation.

	   Filter by generation
	*/
	Generation *string

	/* Info.

	   Info specification
	*/
	Info ApplicationDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ProtectionGranularity.

	   Filter by protection granularity
	*/
	ProtectionGranularity *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* RpoComponentsName.

	   Filter by rpo.components.name
	*/
	RpoComponentsName *string

	/* RpoComponentsRpoLocalDescription.

	   Filter by rpo.components.rpo.local.description
	*/
	RpoComponentsRpoLocalDescription *string

	/* RpoComponentsRpoLocalName.

	   Filter by rpo.components.rpo.local.name
	*/
	RpoComponentsRpoLocalName *string

	/* RpoComponentsRpoRemoteDescription.

	   Filter by rpo.components.rpo.remote.description
	*/
	RpoComponentsRpoRemoteDescription *string

	/* RpoComponentsRpoRemoteName.

	   Filter by rpo.components.rpo.remote.name
	*/
	RpoComponentsRpoRemoteName *string

	/* RpoComponentsUUID.

	   Filter by rpo.components.uuid
	*/
	RpoComponentsUUID *string

	/* RpoIsSupported.

	   Filter by rpo.is_supported
	*/
	RpoIsSupported *string

	/* RpoLocalDescription.

	   Filter by rpo.local.description
	*/
	RpoLocalDescription *string

	/* RpoLocalName.

	   Filter by rpo.local.name
	*/
	RpoLocalName *string

	/* RpoRemoteDescription.

	   Filter by rpo.remote.description
	*/
	RpoRemoteDescription *string

	/* RpoRemoteName.

	   Filter by rpo.remote.name
	*/
	RpoRemoteName *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SmartContainer.

	   Filter by smart_container
	*/
	SmartContainer *string

	/* State.

	   Filter by state
	*/
	State *string

	/* StatisticsComponentsIopsPerTb.

	   Filter by statistics.components.iops.per_tb
	*/
	StatisticsComponentsIopsPerTb *string

	/* StatisticsComponentsIopsTotal.

	   Filter by statistics.components.iops.total
	*/
	StatisticsComponentsIopsTotal *string

	/* StatisticsComponentsLatencyAverage.

	   Filter by statistics.components.latency.average
	*/
	StatisticsComponentsLatencyAverage *string

	/* StatisticsComponentsLatencyRaw.

	   Filter by statistics.components.latency.raw
	*/
	StatisticsComponentsLatencyRaw *string

	/* StatisticsComponentsName.

	   Filter by statistics.components.name
	*/
	StatisticsComponentsName *string

	/* StatisticsComponentsSharedStoragePool.

	   Filter by statistics.components.shared_storage_pool
	*/
	StatisticsComponentsSharedStoragePool *string

	/* StatisticsComponentsSnapshotReserve.

	   Filter by statistics.components.snapshot.reserve
	*/
	StatisticsComponentsSnapshotReserve *string

	/* StatisticsComponentsSnapshotUsed.

	   Filter by statistics.components.snapshot.used
	*/
	StatisticsComponentsSnapshotUsed *string

	/* StatisticsComponentsSpaceAvailable.

	   Filter by statistics.components.space.available
	*/
	StatisticsComponentsSpaceAvailable *string

	/* StatisticsComponentsSpaceLogicalUsed.

	   Filter by statistics.components.space.logical_used
	*/
	StatisticsComponentsSpaceLogicalUsed *string

	/* StatisticsComponentsSpaceProvisioned.

	   Filter by statistics.components.space.provisioned
	*/
	StatisticsComponentsSpaceProvisioned *string

	/* StatisticsComponentsSpaceReservedUnused.

	   Filter by statistics.components.space.reserved_unused
	*/
	StatisticsComponentsSpaceReservedUnused *string

	/* StatisticsComponentsSpaceSavings.

	   Filter by statistics.components.space.savings
	*/
	StatisticsComponentsSpaceSavings *string

	/* StatisticsComponentsSpaceUsed.

	   Filter by statistics.components.space.used
	*/
	StatisticsComponentsSpaceUsed *string

	/* StatisticsComponentsSpaceUsedExcludingReserves.

	   Filter by statistics.components.space.used_excluding_reserves
	*/
	StatisticsComponentsSpaceUsedExcludingReserves *string

	/* StatisticsComponentsSpaceUsedPercent.

	   Filter by statistics.components.space.used_percent
	*/
	StatisticsComponentsSpaceUsedPercent *string

	/* StatisticsComponentsStatisticsIncomplete.

	   Filter by statistics.components.statistics_incomplete
	*/
	StatisticsComponentsStatisticsIncomplete *string

	/* StatisticsComponentsStorageServiceName.

	   Filter by statistics.components.storage_service.name
	*/
	StatisticsComponentsStorageServiceName *string

	/* StatisticsComponentsUUID.

	   Filter by statistics.components.uuid
	*/
	StatisticsComponentsUUID *string

	/* StatisticsIopsPerTb.

	   Filter by statistics.iops.per_tb
	*/
	StatisticsIopsPerTb *string

	/* StatisticsIopsTotal.

	   Filter by statistics.iops.total
	*/
	StatisticsIopsTotal *string

	/* StatisticsLatencyAverage.

	   Filter by statistics.latency.average
	*/
	StatisticsLatencyAverage *string

	/* StatisticsLatencyRaw.

	   Filter by statistics.latency.raw
	*/
	StatisticsLatencyRaw *string

	/* StatisticsSharedStoragePool.

	   Filter by statistics.shared_storage_pool
	*/
	StatisticsSharedStoragePool *string

	/* StatisticsSnapshotReserve.

	   Filter by statistics.snapshot.reserve
	*/
	StatisticsSnapshotReserve *string

	/* StatisticsSnapshotUsed.

	   Filter by statistics.snapshot.used
	*/
	StatisticsSnapshotUsed *string

	/* StatisticsSpaceAvailable.

	   Filter by statistics.space.available
	*/
	StatisticsSpaceAvailable *string

	/* StatisticsSpaceLogicalUsed.

	   Filter by statistics.space.logical_used
	*/
	StatisticsSpaceLogicalUsed *string

	/* StatisticsSpaceProvisioned.

	   Filter by statistics.space.provisioned
	*/
	StatisticsSpaceProvisioned *string

	/* StatisticsSpaceReservedUnused.

	   Filter by statistics.space.reserved_unused
	*/
	StatisticsSpaceReservedUnused *string

	/* StatisticsSpaceSavings.

	   Filter by statistics.space.savings
	*/
	StatisticsSpaceSavings *string

	/* StatisticsSpaceUsed.

	   Filter by statistics.space.used
	*/
	StatisticsSpaceUsed *string

	/* StatisticsSpaceUsedExcludingReserves.

	   Filter by statistics.space.used_excluding_reserves
	*/
	StatisticsSpaceUsedExcludingReserves *string

	/* StatisticsSpaceUsedPercent.

	   Filter by statistics.space.used_percent
	*/
	StatisticsSpaceUsedPercent *string

	/* StatisticsStatisticsIncomplete.

	   Filter by statistics.statistics_incomplete
	*/
	StatisticsStatisticsIncomplete *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* TemplateName.

	   Filter by template.name
	*/
	TemplateName *string

	/* TemplateProtocol.

	   Filter by template.protocol
	*/
	TemplateProtocol *string

	/* TemplateVersion.

	   Filter by template.version
	*/
	TemplateVersion *string

	/* UUID.

	   Filter by UUID
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationDeleteCollectionParams) WithDefaults() *ApplicationDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		deleteDataDefault = bool(true)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ApplicationDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		DeleteData:        &deleteDataDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithTimeout(timeout time.Duration) *ApplicationDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithContext(ctx context.Context) *ApplicationDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithHTTPClient(client *http.Client) *ApplicationDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithContinueOnFailure adds the continueOnFailure to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ApplicationDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDeleteData adds the deleteData to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithDeleteData(deleteData *bool) *ApplicationDeleteCollectionParams {
	o.SetDeleteData(deleteData)
	return o
}

// SetDeleteData adds the deleteData to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetDeleteData(deleteData *bool) {
	o.DeleteData = deleteData
}

// WithGeneration adds the generation to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithGeneration(generation *string) *ApplicationDeleteCollectionParams {
	o.SetGeneration(generation)
	return o
}

// SetGeneration adds the generation to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetGeneration(generation *string) {
	o.Generation = generation
}

// WithInfo adds the info to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithInfo(info ApplicationDeleteCollectionBody) *ApplicationDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetInfo(info ApplicationDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithName(name *string) *ApplicationDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithProtectionGranularity adds the protectionGranularity to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithProtectionGranularity(protectionGranularity *string) *ApplicationDeleteCollectionParams {
	o.SetProtectionGranularity(protectionGranularity)
	return o
}

// SetProtectionGranularity adds the protectionGranularity to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetProtectionGranularity(protectionGranularity *string) {
	o.ProtectionGranularity = protectionGranularity
}

// WithReturnRecords adds the returnRecords to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ApplicationDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ApplicationDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRpoComponentsName adds the rpoComponentsName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoComponentsName(rpoComponentsName *string) *ApplicationDeleteCollectionParams {
	o.SetRpoComponentsName(rpoComponentsName)
	return o
}

// SetRpoComponentsName adds the rpoComponentsName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoComponentsName(rpoComponentsName *string) {
	o.RpoComponentsName = rpoComponentsName
}

// WithRpoComponentsRpoLocalDescription adds the rpoComponentsRpoLocalDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoComponentsRpoLocalDescription(rpoComponentsRpoLocalDescription *string) *ApplicationDeleteCollectionParams {
	o.SetRpoComponentsRpoLocalDescription(rpoComponentsRpoLocalDescription)
	return o
}

// SetRpoComponentsRpoLocalDescription adds the rpoComponentsRpoLocalDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoComponentsRpoLocalDescription(rpoComponentsRpoLocalDescription *string) {
	o.RpoComponentsRpoLocalDescription = rpoComponentsRpoLocalDescription
}

// WithRpoComponentsRpoLocalName adds the rpoComponentsRpoLocalName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoComponentsRpoLocalName(rpoComponentsRpoLocalName *string) *ApplicationDeleteCollectionParams {
	o.SetRpoComponentsRpoLocalName(rpoComponentsRpoLocalName)
	return o
}

// SetRpoComponentsRpoLocalName adds the rpoComponentsRpoLocalName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoComponentsRpoLocalName(rpoComponentsRpoLocalName *string) {
	o.RpoComponentsRpoLocalName = rpoComponentsRpoLocalName
}

// WithRpoComponentsRpoRemoteDescription adds the rpoComponentsRpoRemoteDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoComponentsRpoRemoteDescription(rpoComponentsRpoRemoteDescription *string) *ApplicationDeleteCollectionParams {
	o.SetRpoComponentsRpoRemoteDescription(rpoComponentsRpoRemoteDescription)
	return o
}

// SetRpoComponentsRpoRemoteDescription adds the rpoComponentsRpoRemoteDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoComponentsRpoRemoteDescription(rpoComponentsRpoRemoteDescription *string) {
	o.RpoComponentsRpoRemoteDescription = rpoComponentsRpoRemoteDescription
}

// WithRpoComponentsRpoRemoteName adds the rpoComponentsRpoRemoteName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoComponentsRpoRemoteName(rpoComponentsRpoRemoteName *string) *ApplicationDeleteCollectionParams {
	o.SetRpoComponentsRpoRemoteName(rpoComponentsRpoRemoteName)
	return o
}

// SetRpoComponentsRpoRemoteName adds the rpoComponentsRpoRemoteName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoComponentsRpoRemoteName(rpoComponentsRpoRemoteName *string) {
	o.RpoComponentsRpoRemoteName = rpoComponentsRpoRemoteName
}

// WithRpoComponentsUUID adds the rpoComponentsUUID to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoComponentsUUID(rpoComponentsUUID *string) *ApplicationDeleteCollectionParams {
	o.SetRpoComponentsUUID(rpoComponentsUUID)
	return o
}

// SetRpoComponentsUUID adds the rpoComponentsUuid to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoComponentsUUID(rpoComponentsUUID *string) {
	o.RpoComponentsUUID = rpoComponentsUUID
}

// WithRpoIsSupported adds the rpoIsSupported to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoIsSupported(rpoIsSupported *string) *ApplicationDeleteCollectionParams {
	o.SetRpoIsSupported(rpoIsSupported)
	return o
}

// SetRpoIsSupported adds the rpoIsSupported to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoIsSupported(rpoIsSupported *string) {
	o.RpoIsSupported = rpoIsSupported
}

// WithRpoLocalDescription adds the rpoLocalDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoLocalDescription(rpoLocalDescription *string) *ApplicationDeleteCollectionParams {
	o.SetRpoLocalDescription(rpoLocalDescription)
	return o
}

// SetRpoLocalDescription adds the rpoLocalDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoLocalDescription(rpoLocalDescription *string) {
	o.RpoLocalDescription = rpoLocalDescription
}

// WithRpoLocalName adds the rpoLocalName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoLocalName(rpoLocalName *string) *ApplicationDeleteCollectionParams {
	o.SetRpoLocalName(rpoLocalName)
	return o
}

// SetRpoLocalName adds the rpoLocalName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoLocalName(rpoLocalName *string) {
	o.RpoLocalName = rpoLocalName
}

// WithRpoRemoteDescription adds the rpoRemoteDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoRemoteDescription(rpoRemoteDescription *string) *ApplicationDeleteCollectionParams {
	o.SetRpoRemoteDescription(rpoRemoteDescription)
	return o
}

// SetRpoRemoteDescription adds the rpoRemoteDescription to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoRemoteDescription(rpoRemoteDescription *string) {
	o.RpoRemoteDescription = rpoRemoteDescription
}

// WithRpoRemoteName adds the rpoRemoteName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithRpoRemoteName(rpoRemoteName *string) *ApplicationDeleteCollectionParams {
	o.SetRpoRemoteName(rpoRemoteName)
	return o
}

// SetRpoRemoteName adds the rpoRemoteName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetRpoRemoteName(rpoRemoteName *string) {
	o.RpoRemoteName = rpoRemoteName
}

// WithSerialRecords adds the serialRecords to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ApplicationDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSmartContainer adds the smartContainer to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithSmartContainer(smartContainer *string) *ApplicationDeleteCollectionParams {
	o.SetSmartContainer(smartContainer)
	return o
}

// SetSmartContainer adds the smartContainer to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetSmartContainer(smartContainer *string) {
	o.SmartContainer = smartContainer
}

// WithState adds the state to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithState(state *string) *ApplicationDeleteCollectionParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetState(state *string) {
	o.State = state
}

// WithStatisticsComponentsIopsPerTb adds the statisticsComponentsIopsPerTb to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsIopsPerTb(statisticsComponentsIopsPerTb *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsIopsPerTb(statisticsComponentsIopsPerTb)
	return o
}

// SetStatisticsComponentsIopsPerTb adds the statisticsComponentsIopsPerTb to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsIopsPerTb(statisticsComponentsIopsPerTb *string) {
	o.StatisticsComponentsIopsPerTb = statisticsComponentsIopsPerTb
}

// WithStatisticsComponentsIopsTotal adds the statisticsComponentsIopsTotal to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsIopsTotal(statisticsComponentsIopsTotal *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsIopsTotal(statisticsComponentsIopsTotal)
	return o
}

// SetStatisticsComponentsIopsTotal adds the statisticsComponentsIopsTotal to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsIopsTotal(statisticsComponentsIopsTotal *string) {
	o.StatisticsComponentsIopsTotal = statisticsComponentsIopsTotal
}

// WithStatisticsComponentsLatencyAverage adds the statisticsComponentsLatencyAverage to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsLatencyAverage(statisticsComponentsLatencyAverage *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsLatencyAverage(statisticsComponentsLatencyAverage)
	return o
}

// SetStatisticsComponentsLatencyAverage adds the statisticsComponentsLatencyAverage to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsLatencyAverage(statisticsComponentsLatencyAverage *string) {
	o.StatisticsComponentsLatencyAverage = statisticsComponentsLatencyAverage
}

// WithStatisticsComponentsLatencyRaw adds the statisticsComponentsLatencyRaw to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsLatencyRaw(statisticsComponentsLatencyRaw *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsLatencyRaw(statisticsComponentsLatencyRaw)
	return o
}

// SetStatisticsComponentsLatencyRaw adds the statisticsComponentsLatencyRaw to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsLatencyRaw(statisticsComponentsLatencyRaw *string) {
	o.StatisticsComponentsLatencyRaw = statisticsComponentsLatencyRaw
}

// WithStatisticsComponentsName adds the statisticsComponentsName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsName(statisticsComponentsName *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsName(statisticsComponentsName)
	return o
}

// SetStatisticsComponentsName adds the statisticsComponentsName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsName(statisticsComponentsName *string) {
	o.StatisticsComponentsName = statisticsComponentsName
}

// WithStatisticsComponentsSharedStoragePool adds the statisticsComponentsSharedStoragePool to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSharedStoragePool(statisticsComponentsSharedStoragePool *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSharedStoragePool(statisticsComponentsSharedStoragePool)
	return o
}

// SetStatisticsComponentsSharedStoragePool adds the statisticsComponentsSharedStoragePool to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSharedStoragePool(statisticsComponentsSharedStoragePool *string) {
	o.StatisticsComponentsSharedStoragePool = statisticsComponentsSharedStoragePool
}

// WithStatisticsComponentsSnapshotReserve adds the statisticsComponentsSnapshotReserve to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSnapshotReserve(statisticsComponentsSnapshotReserve *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSnapshotReserve(statisticsComponentsSnapshotReserve)
	return o
}

// SetStatisticsComponentsSnapshotReserve adds the statisticsComponentsSnapshotReserve to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSnapshotReserve(statisticsComponentsSnapshotReserve *string) {
	o.StatisticsComponentsSnapshotReserve = statisticsComponentsSnapshotReserve
}

// WithStatisticsComponentsSnapshotUsed adds the statisticsComponentsSnapshotUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSnapshotUsed(statisticsComponentsSnapshotUsed *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSnapshotUsed(statisticsComponentsSnapshotUsed)
	return o
}

// SetStatisticsComponentsSnapshotUsed adds the statisticsComponentsSnapshotUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSnapshotUsed(statisticsComponentsSnapshotUsed *string) {
	o.StatisticsComponentsSnapshotUsed = statisticsComponentsSnapshotUsed
}

// WithStatisticsComponentsSpaceAvailable adds the statisticsComponentsSpaceAvailable to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceAvailable(statisticsComponentsSpaceAvailable *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceAvailable(statisticsComponentsSpaceAvailable)
	return o
}

// SetStatisticsComponentsSpaceAvailable adds the statisticsComponentsSpaceAvailable to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceAvailable(statisticsComponentsSpaceAvailable *string) {
	o.StatisticsComponentsSpaceAvailable = statisticsComponentsSpaceAvailable
}

// WithStatisticsComponentsSpaceLogicalUsed adds the statisticsComponentsSpaceLogicalUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceLogicalUsed(statisticsComponentsSpaceLogicalUsed *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceLogicalUsed(statisticsComponentsSpaceLogicalUsed)
	return o
}

// SetStatisticsComponentsSpaceLogicalUsed adds the statisticsComponentsSpaceLogicalUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceLogicalUsed(statisticsComponentsSpaceLogicalUsed *string) {
	o.StatisticsComponentsSpaceLogicalUsed = statisticsComponentsSpaceLogicalUsed
}

// WithStatisticsComponentsSpaceProvisioned adds the statisticsComponentsSpaceProvisioned to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceProvisioned(statisticsComponentsSpaceProvisioned *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceProvisioned(statisticsComponentsSpaceProvisioned)
	return o
}

// SetStatisticsComponentsSpaceProvisioned adds the statisticsComponentsSpaceProvisioned to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceProvisioned(statisticsComponentsSpaceProvisioned *string) {
	o.StatisticsComponentsSpaceProvisioned = statisticsComponentsSpaceProvisioned
}

// WithStatisticsComponentsSpaceReservedUnused adds the statisticsComponentsSpaceReservedUnused to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceReservedUnused(statisticsComponentsSpaceReservedUnused *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceReservedUnused(statisticsComponentsSpaceReservedUnused)
	return o
}

// SetStatisticsComponentsSpaceReservedUnused adds the statisticsComponentsSpaceReservedUnused to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceReservedUnused(statisticsComponentsSpaceReservedUnused *string) {
	o.StatisticsComponentsSpaceReservedUnused = statisticsComponentsSpaceReservedUnused
}

// WithStatisticsComponentsSpaceSavings adds the statisticsComponentsSpaceSavings to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceSavings(statisticsComponentsSpaceSavings *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceSavings(statisticsComponentsSpaceSavings)
	return o
}

// SetStatisticsComponentsSpaceSavings adds the statisticsComponentsSpaceSavings to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceSavings(statisticsComponentsSpaceSavings *string) {
	o.StatisticsComponentsSpaceSavings = statisticsComponentsSpaceSavings
}

// WithStatisticsComponentsSpaceUsed adds the statisticsComponentsSpaceUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceUsed(statisticsComponentsSpaceUsed *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceUsed(statisticsComponentsSpaceUsed)
	return o
}

// SetStatisticsComponentsSpaceUsed adds the statisticsComponentsSpaceUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceUsed(statisticsComponentsSpaceUsed *string) {
	o.StatisticsComponentsSpaceUsed = statisticsComponentsSpaceUsed
}

// WithStatisticsComponentsSpaceUsedExcludingReserves adds the statisticsComponentsSpaceUsedExcludingReserves to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceUsedExcludingReserves(statisticsComponentsSpaceUsedExcludingReserves *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceUsedExcludingReserves(statisticsComponentsSpaceUsedExcludingReserves)
	return o
}

// SetStatisticsComponentsSpaceUsedExcludingReserves adds the statisticsComponentsSpaceUsedExcludingReserves to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceUsedExcludingReserves(statisticsComponentsSpaceUsedExcludingReserves *string) {
	o.StatisticsComponentsSpaceUsedExcludingReserves = statisticsComponentsSpaceUsedExcludingReserves
}

// WithStatisticsComponentsSpaceUsedPercent adds the statisticsComponentsSpaceUsedPercent to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsSpaceUsedPercent(statisticsComponentsSpaceUsedPercent *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsSpaceUsedPercent(statisticsComponentsSpaceUsedPercent)
	return o
}

// SetStatisticsComponentsSpaceUsedPercent adds the statisticsComponentsSpaceUsedPercent to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsSpaceUsedPercent(statisticsComponentsSpaceUsedPercent *string) {
	o.StatisticsComponentsSpaceUsedPercent = statisticsComponentsSpaceUsedPercent
}

// WithStatisticsComponentsStatisticsIncomplete adds the statisticsComponentsStatisticsIncomplete to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsStatisticsIncomplete(statisticsComponentsStatisticsIncomplete *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsStatisticsIncomplete(statisticsComponentsStatisticsIncomplete)
	return o
}

// SetStatisticsComponentsStatisticsIncomplete adds the statisticsComponentsStatisticsIncomplete to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsStatisticsIncomplete(statisticsComponentsStatisticsIncomplete *string) {
	o.StatisticsComponentsStatisticsIncomplete = statisticsComponentsStatisticsIncomplete
}

// WithStatisticsComponentsStorageServiceName adds the statisticsComponentsStorageServiceName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsStorageServiceName(statisticsComponentsStorageServiceName *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsStorageServiceName(statisticsComponentsStorageServiceName)
	return o
}

// SetStatisticsComponentsStorageServiceName adds the statisticsComponentsStorageServiceName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsStorageServiceName(statisticsComponentsStorageServiceName *string) {
	o.StatisticsComponentsStorageServiceName = statisticsComponentsStorageServiceName
}

// WithStatisticsComponentsUUID adds the statisticsComponentsUUID to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsComponentsUUID(statisticsComponentsUUID *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsComponentsUUID(statisticsComponentsUUID)
	return o
}

// SetStatisticsComponentsUUID adds the statisticsComponentsUuid to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsComponentsUUID(statisticsComponentsUUID *string) {
	o.StatisticsComponentsUUID = statisticsComponentsUUID
}

// WithStatisticsIopsPerTb adds the statisticsIopsPerTb to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsIopsPerTb(statisticsIopsPerTb *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsIopsPerTb(statisticsIopsPerTb)
	return o
}

// SetStatisticsIopsPerTb adds the statisticsIopsPerTb to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsIopsPerTb(statisticsIopsPerTb *string) {
	o.StatisticsIopsPerTb = statisticsIopsPerTb
}

// WithStatisticsIopsTotal adds the statisticsIopsTotal to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsIopsTotal(statisticsIopsTotal *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsIopsTotal(statisticsIopsTotal)
	return o
}

// SetStatisticsIopsTotal adds the statisticsIopsTotal to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsIopsTotal(statisticsIopsTotal *string) {
	o.StatisticsIopsTotal = statisticsIopsTotal
}

// WithStatisticsLatencyAverage adds the statisticsLatencyAverage to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsLatencyAverage(statisticsLatencyAverage *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsLatencyAverage(statisticsLatencyAverage)
	return o
}

// SetStatisticsLatencyAverage adds the statisticsLatencyAverage to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsLatencyAverage(statisticsLatencyAverage *string) {
	o.StatisticsLatencyAverage = statisticsLatencyAverage
}

// WithStatisticsLatencyRaw adds the statisticsLatencyRaw to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsLatencyRaw(statisticsLatencyRaw *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsLatencyRaw(statisticsLatencyRaw)
	return o
}

// SetStatisticsLatencyRaw adds the statisticsLatencyRaw to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsLatencyRaw(statisticsLatencyRaw *string) {
	o.StatisticsLatencyRaw = statisticsLatencyRaw
}

// WithStatisticsSharedStoragePool adds the statisticsSharedStoragePool to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSharedStoragePool(statisticsSharedStoragePool *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSharedStoragePool(statisticsSharedStoragePool)
	return o
}

// SetStatisticsSharedStoragePool adds the statisticsSharedStoragePool to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSharedStoragePool(statisticsSharedStoragePool *string) {
	o.StatisticsSharedStoragePool = statisticsSharedStoragePool
}

// WithStatisticsSnapshotReserve adds the statisticsSnapshotReserve to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSnapshotReserve(statisticsSnapshotReserve *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSnapshotReserve(statisticsSnapshotReserve)
	return o
}

// SetStatisticsSnapshotReserve adds the statisticsSnapshotReserve to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSnapshotReserve(statisticsSnapshotReserve *string) {
	o.StatisticsSnapshotReserve = statisticsSnapshotReserve
}

// WithStatisticsSnapshotUsed adds the statisticsSnapshotUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSnapshotUsed(statisticsSnapshotUsed *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSnapshotUsed(statisticsSnapshotUsed)
	return o
}

// SetStatisticsSnapshotUsed adds the statisticsSnapshotUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSnapshotUsed(statisticsSnapshotUsed *string) {
	o.StatisticsSnapshotUsed = statisticsSnapshotUsed
}

// WithStatisticsSpaceAvailable adds the statisticsSpaceAvailable to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceAvailable(statisticsSpaceAvailable *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceAvailable(statisticsSpaceAvailable)
	return o
}

// SetStatisticsSpaceAvailable adds the statisticsSpaceAvailable to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceAvailable(statisticsSpaceAvailable *string) {
	o.StatisticsSpaceAvailable = statisticsSpaceAvailable
}

// WithStatisticsSpaceLogicalUsed adds the statisticsSpaceLogicalUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceLogicalUsed(statisticsSpaceLogicalUsed *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceLogicalUsed(statisticsSpaceLogicalUsed)
	return o
}

// SetStatisticsSpaceLogicalUsed adds the statisticsSpaceLogicalUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceLogicalUsed(statisticsSpaceLogicalUsed *string) {
	o.StatisticsSpaceLogicalUsed = statisticsSpaceLogicalUsed
}

// WithStatisticsSpaceProvisioned adds the statisticsSpaceProvisioned to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceProvisioned(statisticsSpaceProvisioned *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceProvisioned(statisticsSpaceProvisioned)
	return o
}

// SetStatisticsSpaceProvisioned adds the statisticsSpaceProvisioned to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceProvisioned(statisticsSpaceProvisioned *string) {
	o.StatisticsSpaceProvisioned = statisticsSpaceProvisioned
}

// WithStatisticsSpaceReservedUnused adds the statisticsSpaceReservedUnused to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceReservedUnused(statisticsSpaceReservedUnused *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceReservedUnused(statisticsSpaceReservedUnused)
	return o
}

// SetStatisticsSpaceReservedUnused adds the statisticsSpaceReservedUnused to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceReservedUnused(statisticsSpaceReservedUnused *string) {
	o.StatisticsSpaceReservedUnused = statisticsSpaceReservedUnused
}

// WithStatisticsSpaceSavings adds the statisticsSpaceSavings to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceSavings(statisticsSpaceSavings *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceSavings(statisticsSpaceSavings)
	return o
}

// SetStatisticsSpaceSavings adds the statisticsSpaceSavings to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceSavings(statisticsSpaceSavings *string) {
	o.StatisticsSpaceSavings = statisticsSpaceSavings
}

// WithStatisticsSpaceUsed adds the statisticsSpaceUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceUsed(statisticsSpaceUsed *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceUsed(statisticsSpaceUsed)
	return o
}

// SetStatisticsSpaceUsed adds the statisticsSpaceUsed to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceUsed(statisticsSpaceUsed *string) {
	o.StatisticsSpaceUsed = statisticsSpaceUsed
}

// WithStatisticsSpaceUsedExcludingReserves adds the statisticsSpaceUsedExcludingReserves to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceUsedExcludingReserves(statisticsSpaceUsedExcludingReserves *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceUsedExcludingReserves(statisticsSpaceUsedExcludingReserves)
	return o
}

// SetStatisticsSpaceUsedExcludingReserves adds the statisticsSpaceUsedExcludingReserves to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceUsedExcludingReserves(statisticsSpaceUsedExcludingReserves *string) {
	o.StatisticsSpaceUsedExcludingReserves = statisticsSpaceUsedExcludingReserves
}

// WithStatisticsSpaceUsedPercent adds the statisticsSpaceUsedPercent to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsSpaceUsedPercent(statisticsSpaceUsedPercent *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsSpaceUsedPercent(statisticsSpaceUsedPercent)
	return o
}

// SetStatisticsSpaceUsedPercent adds the statisticsSpaceUsedPercent to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsSpaceUsedPercent(statisticsSpaceUsedPercent *string) {
	o.StatisticsSpaceUsedPercent = statisticsSpaceUsedPercent
}

// WithStatisticsStatisticsIncomplete adds the statisticsStatisticsIncomplete to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithStatisticsStatisticsIncomplete(statisticsStatisticsIncomplete *string) *ApplicationDeleteCollectionParams {
	o.SetStatisticsStatisticsIncomplete(statisticsStatisticsIncomplete)
	return o
}

// SetStatisticsStatisticsIncomplete adds the statisticsStatisticsIncomplete to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetStatisticsStatisticsIncomplete(statisticsStatisticsIncomplete *string) {
	o.StatisticsStatisticsIncomplete = statisticsStatisticsIncomplete
}

// WithSvmName adds the svmName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithSvmName(svmName *string) *ApplicationDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithSvmUUID(svmUUID *string) *ApplicationDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithTemplateName adds the templateName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithTemplateName(templateName *string) *ApplicationDeleteCollectionParams {
	o.SetTemplateName(templateName)
	return o
}

// SetTemplateName adds the templateName to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetTemplateName(templateName *string) {
	o.TemplateName = templateName
}

// WithTemplateProtocol adds the templateProtocol to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithTemplateProtocol(templateProtocol *string) *ApplicationDeleteCollectionParams {
	o.SetTemplateProtocol(templateProtocol)
	return o
}

// SetTemplateProtocol adds the templateProtocol to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetTemplateProtocol(templateProtocol *string) {
	o.TemplateProtocol = templateProtocol
}

// WithTemplateVersion adds the templateVersion to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithTemplateVersion(templateVersion *string) *ApplicationDeleteCollectionParams {
	o.SetTemplateVersion(templateVersion)
	return o
}

// SetTemplateVersion adds the templateVersion to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetTemplateVersion(templateVersion *string) {
	o.TemplateVersion = templateVersion
}

// WithUUID adds the uuid to the application delete collection params
func (o *ApplicationDeleteCollectionParams) WithUUID(uuid *string) *ApplicationDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application delete collection params
func (o *ApplicationDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.DeleteData != nil {

		// query param delete_data
		var qrDeleteData bool

		if o.DeleteData != nil {
			qrDeleteData = *o.DeleteData
		}
		qDeleteData := swag.FormatBool(qrDeleteData)
		if qDeleteData != "" {

			if err := r.SetQueryParam("delete_data", qDeleteData); err != nil {
				return err
			}
		}
	}

	if o.Generation != nil {

		// query param generation
		var qrGeneration string

		if o.Generation != nil {
			qrGeneration = *o.Generation
		}
		qGeneration := qrGeneration
		if qGeneration != "" {

			if err := r.SetQueryParam("generation", qGeneration); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ProtectionGranularity != nil {

		// query param protection_granularity
		var qrProtectionGranularity string

		if o.ProtectionGranularity != nil {
			qrProtectionGranularity = *o.ProtectionGranularity
		}
		qProtectionGranularity := qrProtectionGranularity
		if qProtectionGranularity != "" {

			if err := r.SetQueryParam("protection_granularity", qProtectionGranularity); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsName != nil {

		// query param rpo.components.name
		var qrRpoComponentsName string

		if o.RpoComponentsName != nil {
			qrRpoComponentsName = *o.RpoComponentsName
		}
		qRpoComponentsName := qrRpoComponentsName
		if qRpoComponentsName != "" {

			if err := r.SetQueryParam("rpo.components.name", qRpoComponentsName); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoLocalDescription != nil {

		// query param rpo.components.rpo.local.description
		var qrRpoComponentsRpoLocalDescription string

		if o.RpoComponentsRpoLocalDescription != nil {
			qrRpoComponentsRpoLocalDescription = *o.RpoComponentsRpoLocalDescription
		}
		qRpoComponentsRpoLocalDescription := qrRpoComponentsRpoLocalDescription
		if qRpoComponentsRpoLocalDescription != "" {

			if err := r.SetQueryParam("rpo.components.rpo.local.description", qRpoComponentsRpoLocalDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoLocalName != nil {

		// query param rpo.components.rpo.local.name
		var qrRpoComponentsRpoLocalName string

		if o.RpoComponentsRpoLocalName != nil {
			qrRpoComponentsRpoLocalName = *o.RpoComponentsRpoLocalName
		}
		qRpoComponentsRpoLocalName := qrRpoComponentsRpoLocalName
		if qRpoComponentsRpoLocalName != "" {

			if err := r.SetQueryParam("rpo.components.rpo.local.name", qRpoComponentsRpoLocalName); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoRemoteDescription != nil {

		// query param rpo.components.rpo.remote.description
		var qrRpoComponentsRpoRemoteDescription string

		if o.RpoComponentsRpoRemoteDescription != nil {
			qrRpoComponentsRpoRemoteDescription = *o.RpoComponentsRpoRemoteDescription
		}
		qRpoComponentsRpoRemoteDescription := qrRpoComponentsRpoRemoteDescription
		if qRpoComponentsRpoRemoteDescription != "" {

			if err := r.SetQueryParam("rpo.components.rpo.remote.description", qRpoComponentsRpoRemoteDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsRpoRemoteName != nil {

		// query param rpo.components.rpo.remote.name
		var qrRpoComponentsRpoRemoteName string

		if o.RpoComponentsRpoRemoteName != nil {
			qrRpoComponentsRpoRemoteName = *o.RpoComponentsRpoRemoteName
		}
		qRpoComponentsRpoRemoteName := qrRpoComponentsRpoRemoteName
		if qRpoComponentsRpoRemoteName != "" {

			if err := r.SetQueryParam("rpo.components.rpo.remote.name", qRpoComponentsRpoRemoteName); err != nil {
				return err
			}
		}
	}

	if o.RpoComponentsUUID != nil {

		// query param rpo.components.uuid
		var qrRpoComponentsUUID string

		if o.RpoComponentsUUID != nil {
			qrRpoComponentsUUID = *o.RpoComponentsUUID
		}
		qRpoComponentsUUID := qrRpoComponentsUUID
		if qRpoComponentsUUID != "" {

			if err := r.SetQueryParam("rpo.components.uuid", qRpoComponentsUUID); err != nil {
				return err
			}
		}
	}

	if o.RpoIsSupported != nil {

		// query param rpo.is_supported
		var qrRpoIsSupported string

		if o.RpoIsSupported != nil {
			qrRpoIsSupported = *o.RpoIsSupported
		}
		qRpoIsSupported := qrRpoIsSupported
		if qRpoIsSupported != "" {

			if err := r.SetQueryParam("rpo.is_supported", qRpoIsSupported); err != nil {
				return err
			}
		}
	}

	if o.RpoLocalDescription != nil {

		// query param rpo.local.description
		var qrRpoLocalDescription string

		if o.RpoLocalDescription != nil {
			qrRpoLocalDescription = *o.RpoLocalDescription
		}
		qRpoLocalDescription := qrRpoLocalDescription
		if qRpoLocalDescription != "" {

			if err := r.SetQueryParam("rpo.local.description", qRpoLocalDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoLocalName != nil {

		// query param rpo.local.name
		var qrRpoLocalName string

		if o.RpoLocalName != nil {
			qrRpoLocalName = *o.RpoLocalName
		}
		qRpoLocalName := qrRpoLocalName
		if qRpoLocalName != "" {

			if err := r.SetQueryParam("rpo.local.name", qRpoLocalName); err != nil {
				return err
			}
		}
	}

	if o.RpoRemoteDescription != nil {

		// query param rpo.remote.description
		var qrRpoRemoteDescription string

		if o.RpoRemoteDescription != nil {
			qrRpoRemoteDescription = *o.RpoRemoteDescription
		}
		qRpoRemoteDescription := qrRpoRemoteDescription
		if qRpoRemoteDescription != "" {

			if err := r.SetQueryParam("rpo.remote.description", qRpoRemoteDescription); err != nil {
				return err
			}
		}
	}

	if o.RpoRemoteName != nil {

		// query param rpo.remote.name
		var qrRpoRemoteName string

		if o.RpoRemoteName != nil {
			qrRpoRemoteName = *o.RpoRemoteName
		}
		qRpoRemoteName := qrRpoRemoteName
		if qRpoRemoteName != "" {

			if err := r.SetQueryParam("rpo.remote.name", qRpoRemoteName); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SmartContainer != nil {

		// query param smart_container
		var qrSmartContainer string

		if o.SmartContainer != nil {
			qrSmartContainer = *o.SmartContainer
		}
		qSmartContainer := qrSmartContainer
		if qSmartContainer != "" {

			if err := r.SetQueryParam("smart_container", qSmartContainer); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsIopsPerTb != nil {

		// query param statistics.components.iops.per_tb
		var qrStatisticsComponentsIopsPerTb string

		if o.StatisticsComponentsIopsPerTb != nil {
			qrStatisticsComponentsIopsPerTb = *o.StatisticsComponentsIopsPerTb
		}
		qStatisticsComponentsIopsPerTb := qrStatisticsComponentsIopsPerTb
		if qStatisticsComponentsIopsPerTb != "" {

			if err := r.SetQueryParam("statistics.components.iops.per_tb", qStatisticsComponentsIopsPerTb); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsIopsTotal != nil {

		// query param statistics.components.iops.total
		var qrStatisticsComponentsIopsTotal string

		if o.StatisticsComponentsIopsTotal != nil {
			qrStatisticsComponentsIopsTotal = *o.StatisticsComponentsIopsTotal
		}
		qStatisticsComponentsIopsTotal := qrStatisticsComponentsIopsTotal
		if qStatisticsComponentsIopsTotal != "" {

			if err := r.SetQueryParam("statistics.components.iops.total", qStatisticsComponentsIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsLatencyAverage != nil {

		// query param statistics.components.latency.average
		var qrStatisticsComponentsLatencyAverage string

		if o.StatisticsComponentsLatencyAverage != nil {
			qrStatisticsComponentsLatencyAverage = *o.StatisticsComponentsLatencyAverage
		}
		qStatisticsComponentsLatencyAverage := qrStatisticsComponentsLatencyAverage
		if qStatisticsComponentsLatencyAverage != "" {

			if err := r.SetQueryParam("statistics.components.latency.average", qStatisticsComponentsLatencyAverage); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsLatencyRaw != nil {

		// query param statistics.components.latency.raw
		var qrStatisticsComponentsLatencyRaw string

		if o.StatisticsComponentsLatencyRaw != nil {
			qrStatisticsComponentsLatencyRaw = *o.StatisticsComponentsLatencyRaw
		}
		qStatisticsComponentsLatencyRaw := qrStatisticsComponentsLatencyRaw
		if qStatisticsComponentsLatencyRaw != "" {

			if err := r.SetQueryParam("statistics.components.latency.raw", qStatisticsComponentsLatencyRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsName != nil {

		// query param statistics.components.name
		var qrStatisticsComponentsName string

		if o.StatisticsComponentsName != nil {
			qrStatisticsComponentsName = *o.StatisticsComponentsName
		}
		qStatisticsComponentsName := qrStatisticsComponentsName
		if qStatisticsComponentsName != "" {

			if err := r.SetQueryParam("statistics.components.name", qStatisticsComponentsName); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSharedStoragePool != nil {

		// query param statistics.components.shared_storage_pool
		var qrStatisticsComponentsSharedStoragePool string

		if o.StatisticsComponentsSharedStoragePool != nil {
			qrStatisticsComponentsSharedStoragePool = *o.StatisticsComponentsSharedStoragePool
		}
		qStatisticsComponentsSharedStoragePool := qrStatisticsComponentsSharedStoragePool
		if qStatisticsComponentsSharedStoragePool != "" {

			if err := r.SetQueryParam("statistics.components.shared_storage_pool", qStatisticsComponentsSharedStoragePool); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSnapshotReserve != nil {

		// query param statistics.components.snapshot.reserve
		var qrStatisticsComponentsSnapshotReserve string

		if o.StatisticsComponentsSnapshotReserve != nil {
			qrStatisticsComponentsSnapshotReserve = *o.StatisticsComponentsSnapshotReserve
		}
		qStatisticsComponentsSnapshotReserve := qrStatisticsComponentsSnapshotReserve
		if qStatisticsComponentsSnapshotReserve != "" {

			if err := r.SetQueryParam("statistics.components.snapshot.reserve", qStatisticsComponentsSnapshotReserve); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSnapshotUsed != nil {

		// query param statistics.components.snapshot.used
		var qrStatisticsComponentsSnapshotUsed string

		if o.StatisticsComponentsSnapshotUsed != nil {
			qrStatisticsComponentsSnapshotUsed = *o.StatisticsComponentsSnapshotUsed
		}
		qStatisticsComponentsSnapshotUsed := qrStatisticsComponentsSnapshotUsed
		if qStatisticsComponentsSnapshotUsed != "" {

			if err := r.SetQueryParam("statistics.components.snapshot.used", qStatisticsComponentsSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceAvailable != nil {

		// query param statistics.components.space.available
		var qrStatisticsComponentsSpaceAvailable string

		if o.StatisticsComponentsSpaceAvailable != nil {
			qrStatisticsComponentsSpaceAvailable = *o.StatisticsComponentsSpaceAvailable
		}
		qStatisticsComponentsSpaceAvailable := qrStatisticsComponentsSpaceAvailable
		if qStatisticsComponentsSpaceAvailable != "" {

			if err := r.SetQueryParam("statistics.components.space.available", qStatisticsComponentsSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceLogicalUsed != nil {

		// query param statistics.components.space.logical_used
		var qrStatisticsComponentsSpaceLogicalUsed string

		if o.StatisticsComponentsSpaceLogicalUsed != nil {
			qrStatisticsComponentsSpaceLogicalUsed = *o.StatisticsComponentsSpaceLogicalUsed
		}
		qStatisticsComponentsSpaceLogicalUsed := qrStatisticsComponentsSpaceLogicalUsed
		if qStatisticsComponentsSpaceLogicalUsed != "" {

			if err := r.SetQueryParam("statistics.components.space.logical_used", qStatisticsComponentsSpaceLogicalUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceProvisioned != nil {

		// query param statistics.components.space.provisioned
		var qrStatisticsComponentsSpaceProvisioned string

		if o.StatisticsComponentsSpaceProvisioned != nil {
			qrStatisticsComponentsSpaceProvisioned = *o.StatisticsComponentsSpaceProvisioned
		}
		qStatisticsComponentsSpaceProvisioned := qrStatisticsComponentsSpaceProvisioned
		if qStatisticsComponentsSpaceProvisioned != "" {

			if err := r.SetQueryParam("statistics.components.space.provisioned", qStatisticsComponentsSpaceProvisioned); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceReservedUnused != nil {

		// query param statistics.components.space.reserved_unused
		var qrStatisticsComponentsSpaceReservedUnused string

		if o.StatisticsComponentsSpaceReservedUnused != nil {
			qrStatisticsComponentsSpaceReservedUnused = *o.StatisticsComponentsSpaceReservedUnused
		}
		qStatisticsComponentsSpaceReservedUnused := qrStatisticsComponentsSpaceReservedUnused
		if qStatisticsComponentsSpaceReservedUnused != "" {

			if err := r.SetQueryParam("statistics.components.space.reserved_unused", qStatisticsComponentsSpaceReservedUnused); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceSavings != nil {

		// query param statistics.components.space.savings
		var qrStatisticsComponentsSpaceSavings string

		if o.StatisticsComponentsSpaceSavings != nil {
			qrStatisticsComponentsSpaceSavings = *o.StatisticsComponentsSpaceSavings
		}
		qStatisticsComponentsSpaceSavings := qrStatisticsComponentsSpaceSavings
		if qStatisticsComponentsSpaceSavings != "" {

			if err := r.SetQueryParam("statistics.components.space.savings", qStatisticsComponentsSpaceSavings); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceUsed != nil {

		// query param statistics.components.space.used
		var qrStatisticsComponentsSpaceUsed string

		if o.StatisticsComponentsSpaceUsed != nil {
			qrStatisticsComponentsSpaceUsed = *o.StatisticsComponentsSpaceUsed
		}
		qStatisticsComponentsSpaceUsed := qrStatisticsComponentsSpaceUsed
		if qStatisticsComponentsSpaceUsed != "" {

			if err := r.SetQueryParam("statistics.components.space.used", qStatisticsComponentsSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceUsedExcludingReserves != nil {

		// query param statistics.components.space.used_excluding_reserves
		var qrStatisticsComponentsSpaceUsedExcludingReserves string

		if o.StatisticsComponentsSpaceUsedExcludingReserves != nil {
			qrStatisticsComponentsSpaceUsedExcludingReserves = *o.StatisticsComponentsSpaceUsedExcludingReserves
		}
		qStatisticsComponentsSpaceUsedExcludingReserves := qrStatisticsComponentsSpaceUsedExcludingReserves
		if qStatisticsComponentsSpaceUsedExcludingReserves != "" {

			if err := r.SetQueryParam("statistics.components.space.used_excluding_reserves", qStatisticsComponentsSpaceUsedExcludingReserves); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsSpaceUsedPercent != nil {

		// query param statistics.components.space.used_percent
		var qrStatisticsComponentsSpaceUsedPercent string

		if o.StatisticsComponentsSpaceUsedPercent != nil {
			qrStatisticsComponentsSpaceUsedPercent = *o.StatisticsComponentsSpaceUsedPercent
		}
		qStatisticsComponentsSpaceUsedPercent := qrStatisticsComponentsSpaceUsedPercent
		if qStatisticsComponentsSpaceUsedPercent != "" {

			if err := r.SetQueryParam("statistics.components.space.used_percent", qStatisticsComponentsSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsStatisticsIncomplete != nil {

		// query param statistics.components.statistics_incomplete
		var qrStatisticsComponentsStatisticsIncomplete string

		if o.StatisticsComponentsStatisticsIncomplete != nil {
			qrStatisticsComponentsStatisticsIncomplete = *o.StatisticsComponentsStatisticsIncomplete
		}
		qStatisticsComponentsStatisticsIncomplete := qrStatisticsComponentsStatisticsIncomplete
		if qStatisticsComponentsStatisticsIncomplete != "" {

			if err := r.SetQueryParam("statistics.components.statistics_incomplete", qStatisticsComponentsStatisticsIncomplete); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsStorageServiceName != nil {

		// query param statistics.components.storage_service.name
		var qrStatisticsComponentsStorageServiceName string

		if o.StatisticsComponentsStorageServiceName != nil {
			qrStatisticsComponentsStorageServiceName = *o.StatisticsComponentsStorageServiceName
		}
		qStatisticsComponentsStorageServiceName := qrStatisticsComponentsStorageServiceName
		if qStatisticsComponentsStorageServiceName != "" {

			if err := r.SetQueryParam("statistics.components.storage_service.name", qStatisticsComponentsStorageServiceName); err != nil {
				return err
			}
		}
	}

	if o.StatisticsComponentsUUID != nil {

		// query param statistics.components.uuid
		var qrStatisticsComponentsUUID string

		if o.StatisticsComponentsUUID != nil {
			qrStatisticsComponentsUUID = *o.StatisticsComponentsUUID
		}
		qStatisticsComponentsUUID := qrStatisticsComponentsUUID
		if qStatisticsComponentsUUID != "" {

			if err := r.SetQueryParam("statistics.components.uuid", qStatisticsComponentsUUID); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsPerTb != nil {

		// query param statistics.iops.per_tb
		var qrStatisticsIopsPerTb string

		if o.StatisticsIopsPerTb != nil {
			qrStatisticsIopsPerTb = *o.StatisticsIopsPerTb
		}
		qStatisticsIopsPerTb := qrStatisticsIopsPerTb
		if qStatisticsIopsPerTb != "" {

			if err := r.SetQueryParam("statistics.iops.per_tb", qStatisticsIopsPerTb); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsTotal != nil {

		// query param statistics.iops.total
		var qrStatisticsIopsTotal string

		if o.StatisticsIopsTotal != nil {
			qrStatisticsIopsTotal = *o.StatisticsIopsTotal
		}
		qStatisticsIopsTotal := qrStatisticsIopsTotal
		if qStatisticsIopsTotal != "" {

			if err := r.SetQueryParam("statistics.iops.total", qStatisticsIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyAverage != nil {

		// query param statistics.latency.average
		var qrStatisticsLatencyAverage string

		if o.StatisticsLatencyAverage != nil {
			qrStatisticsLatencyAverage = *o.StatisticsLatencyAverage
		}
		qStatisticsLatencyAverage := qrStatisticsLatencyAverage
		if qStatisticsLatencyAverage != "" {

			if err := r.SetQueryParam("statistics.latency.average", qStatisticsLatencyAverage); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRaw != nil {

		// query param statistics.latency.raw
		var qrStatisticsLatencyRaw string

		if o.StatisticsLatencyRaw != nil {
			qrStatisticsLatencyRaw = *o.StatisticsLatencyRaw
		}
		qStatisticsLatencyRaw := qrStatisticsLatencyRaw
		if qStatisticsLatencyRaw != "" {

			if err := r.SetQueryParam("statistics.latency.raw", qStatisticsLatencyRaw); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSharedStoragePool != nil {

		// query param statistics.shared_storage_pool
		var qrStatisticsSharedStoragePool string

		if o.StatisticsSharedStoragePool != nil {
			qrStatisticsSharedStoragePool = *o.StatisticsSharedStoragePool
		}
		qStatisticsSharedStoragePool := qrStatisticsSharedStoragePool
		if qStatisticsSharedStoragePool != "" {

			if err := r.SetQueryParam("statistics.shared_storage_pool", qStatisticsSharedStoragePool); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSnapshotReserve != nil {

		// query param statistics.snapshot.reserve
		var qrStatisticsSnapshotReserve string

		if o.StatisticsSnapshotReserve != nil {
			qrStatisticsSnapshotReserve = *o.StatisticsSnapshotReserve
		}
		qStatisticsSnapshotReserve := qrStatisticsSnapshotReserve
		if qStatisticsSnapshotReserve != "" {

			if err := r.SetQueryParam("statistics.snapshot.reserve", qStatisticsSnapshotReserve); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSnapshotUsed != nil {

		// query param statistics.snapshot.used
		var qrStatisticsSnapshotUsed string

		if o.StatisticsSnapshotUsed != nil {
			qrStatisticsSnapshotUsed = *o.StatisticsSnapshotUsed
		}
		qStatisticsSnapshotUsed := qrStatisticsSnapshotUsed
		if qStatisticsSnapshotUsed != "" {

			if err := r.SetQueryParam("statistics.snapshot.used", qStatisticsSnapshotUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceAvailable != nil {

		// query param statistics.space.available
		var qrStatisticsSpaceAvailable string

		if o.StatisticsSpaceAvailable != nil {
			qrStatisticsSpaceAvailable = *o.StatisticsSpaceAvailable
		}
		qStatisticsSpaceAvailable := qrStatisticsSpaceAvailable
		if qStatisticsSpaceAvailable != "" {

			if err := r.SetQueryParam("statistics.space.available", qStatisticsSpaceAvailable); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceLogicalUsed != nil {

		// query param statistics.space.logical_used
		var qrStatisticsSpaceLogicalUsed string

		if o.StatisticsSpaceLogicalUsed != nil {
			qrStatisticsSpaceLogicalUsed = *o.StatisticsSpaceLogicalUsed
		}
		qStatisticsSpaceLogicalUsed := qrStatisticsSpaceLogicalUsed
		if qStatisticsSpaceLogicalUsed != "" {

			if err := r.SetQueryParam("statistics.space.logical_used", qStatisticsSpaceLogicalUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceProvisioned != nil {

		// query param statistics.space.provisioned
		var qrStatisticsSpaceProvisioned string

		if o.StatisticsSpaceProvisioned != nil {
			qrStatisticsSpaceProvisioned = *o.StatisticsSpaceProvisioned
		}
		qStatisticsSpaceProvisioned := qrStatisticsSpaceProvisioned
		if qStatisticsSpaceProvisioned != "" {

			if err := r.SetQueryParam("statistics.space.provisioned", qStatisticsSpaceProvisioned); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceReservedUnused != nil {

		// query param statistics.space.reserved_unused
		var qrStatisticsSpaceReservedUnused string

		if o.StatisticsSpaceReservedUnused != nil {
			qrStatisticsSpaceReservedUnused = *o.StatisticsSpaceReservedUnused
		}
		qStatisticsSpaceReservedUnused := qrStatisticsSpaceReservedUnused
		if qStatisticsSpaceReservedUnused != "" {

			if err := r.SetQueryParam("statistics.space.reserved_unused", qStatisticsSpaceReservedUnused); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceSavings != nil {

		// query param statistics.space.savings
		var qrStatisticsSpaceSavings string

		if o.StatisticsSpaceSavings != nil {
			qrStatisticsSpaceSavings = *o.StatisticsSpaceSavings
		}
		qStatisticsSpaceSavings := qrStatisticsSpaceSavings
		if qStatisticsSpaceSavings != "" {

			if err := r.SetQueryParam("statistics.space.savings", qStatisticsSpaceSavings); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceUsed != nil {

		// query param statistics.space.used
		var qrStatisticsSpaceUsed string

		if o.StatisticsSpaceUsed != nil {
			qrStatisticsSpaceUsed = *o.StatisticsSpaceUsed
		}
		qStatisticsSpaceUsed := qrStatisticsSpaceUsed
		if qStatisticsSpaceUsed != "" {

			if err := r.SetQueryParam("statistics.space.used", qStatisticsSpaceUsed); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceUsedExcludingReserves != nil {

		// query param statistics.space.used_excluding_reserves
		var qrStatisticsSpaceUsedExcludingReserves string

		if o.StatisticsSpaceUsedExcludingReserves != nil {
			qrStatisticsSpaceUsedExcludingReserves = *o.StatisticsSpaceUsedExcludingReserves
		}
		qStatisticsSpaceUsedExcludingReserves := qrStatisticsSpaceUsedExcludingReserves
		if qStatisticsSpaceUsedExcludingReserves != "" {

			if err := r.SetQueryParam("statistics.space.used_excluding_reserves", qStatisticsSpaceUsedExcludingReserves); err != nil {
				return err
			}
		}
	}

	if o.StatisticsSpaceUsedPercent != nil {

		// query param statistics.space.used_percent
		var qrStatisticsSpaceUsedPercent string

		if o.StatisticsSpaceUsedPercent != nil {
			qrStatisticsSpaceUsedPercent = *o.StatisticsSpaceUsedPercent
		}
		qStatisticsSpaceUsedPercent := qrStatisticsSpaceUsedPercent
		if qStatisticsSpaceUsedPercent != "" {

			if err := r.SetQueryParam("statistics.space.used_percent", qStatisticsSpaceUsedPercent); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatisticsIncomplete != nil {

		// query param statistics.statistics_incomplete
		var qrStatisticsStatisticsIncomplete string

		if o.StatisticsStatisticsIncomplete != nil {
			qrStatisticsStatisticsIncomplete = *o.StatisticsStatisticsIncomplete
		}
		qStatisticsStatisticsIncomplete := qrStatisticsStatisticsIncomplete
		if qStatisticsStatisticsIncomplete != "" {

			if err := r.SetQueryParam("statistics.statistics_incomplete", qStatisticsStatisticsIncomplete); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.TemplateName != nil {

		// query param template.name
		var qrTemplateName string

		if o.TemplateName != nil {
			qrTemplateName = *o.TemplateName
		}
		qTemplateName := qrTemplateName
		if qTemplateName != "" {

			if err := r.SetQueryParam("template.name", qTemplateName); err != nil {
				return err
			}
		}
	}

	if o.TemplateProtocol != nil {

		// query param template.protocol
		var qrTemplateProtocol string

		if o.TemplateProtocol != nil {
			qrTemplateProtocol = *o.TemplateProtocol
		}
		qTemplateProtocol := qrTemplateProtocol
		if qTemplateProtocol != "" {

			if err := r.SetQueryParam("template.protocol", qTemplateProtocol); err != nil {
				return err
			}
		}
	}

	if o.TemplateVersion != nil {

		// query param template.version
		var qrTemplateVersion string

		if o.TemplateVersion != nil {
			qrTemplateVersion = *o.TemplateVersion
		}
		qTemplateVersion := qrTemplateVersion
		if qTemplateVersion != "" {

			if err := r.SetQueryParam("template.version", qTemplateVersion); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
