// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationDeleteCollectionReader is a Reader for the ApplicationDeleteCollection structure.
type ApplicationDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationDeleteCollectionOK creates a ApplicationDeleteCollectionOK with default headers values
func NewApplicationDeleteCollectionOK() *ApplicationDeleteCollectionOK {
	return &ApplicationDeleteCollectionOK{}
}

/*
ApplicationDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationDeleteCollectionOK struct {
	Payload *models.ApplicationJobLinkResponse
}

// IsSuccess returns true when this application delete collection o k response has a 2xx status code
func (o *ApplicationDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application delete collection o k response has a 3xx status code
func (o *ApplicationDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application delete collection o k response has a 4xx status code
func (o *ApplicationDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application delete collection o k response has a 5xx status code
func (o *ApplicationDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application delete collection o k response a status code equal to that given
func (o *ApplicationDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application delete collection o k response
func (o *ApplicationDeleteCollectionOK) Code() int {
	return 200
}

func (o *ApplicationDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications][%d] applicationDeleteCollectionOK %s", 200, payload)
}

func (o *ApplicationDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications][%d] applicationDeleteCollectionOK %s", 200, payload)
}

func (o *ApplicationDeleteCollectionOK) GetPayload() *models.ApplicationJobLinkResponse {
	return o.Payload
}

func (o *ApplicationDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationDeleteCollectionAccepted creates a ApplicationDeleteCollectionAccepted with default headers values
func NewApplicationDeleteCollectionAccepted() *ApplicationDeleteCollectionAccepted {
	return &ApplicationDeleteCollectionAccepted{}
}

/*
ApplicationDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationDeleteCollectionAccepted struct {
	Payload *models.ApplicationJobLinkResponse
}

// IsSuccess returns true when this application delete collection accepted response has a 2xx status code
func (o *ApplicationDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application delete collection accepted response has a 3xx status code
func (o *ApplicationDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application delete collection accepted response has a 4xx status code
func (o *ApplicationDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application delete collection accepted response has a 5xx status code
func (o *ApplicationDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application delete collection accepted response a status code equal to that given
func (o *ApplicationDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application delete collection accepted response
func (o *ApplicationDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *ApplicationDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications][%d] applicationDeleteCollectionAccepted %s", 202, payload)
}

func (o *ApplicationDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications][%d] applicationDeleteCollectionAccepted %s", 202, payload)
}

func (o *ApplicationDeleteCollectionAccepted) GetPayload() *models.ApplicationJobLinkResponse {
	return o.Payload
}

func (o *ApplicationDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationDeleteCollectionDefault creates a ApplicationDeleteCollectionDefault with default headers values
func NewApplicationDeleteCollectionDefault(code int) *ApplicationDeleteCollectionDefault {
	return &ApplicationDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
ApplicationDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application delete collection default response has a 2xx status code
func (o *ApplicationDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application delete collection default response has a 3xx status code
func (o *ApplicationDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application delete collection default response has a 4xx status code
func (o *ApplicationDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application delete collection default response has a 5xx status code
func (o *ApplicationDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application delete collection default response a status code equal to that given
func (o *ApplicationDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application delete collection default response
func (o *ApplicationDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications][%d] application_delete_collection default %s", o._statusCode, payload)
}

func (o *ApplicationDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications][%d] application_delete_collection default %s", o._statusCode, payload)
}

func (o *ApplicationDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ApplicationDeleteCollectionBody application delete collection body
swagger:model ApplicationDeleteCollectionBody
*/
type ApplicationDeleteCollectionBody struct {

	// application response inline records
	ApplicationResponseInlineRecords []*models.Application `json:"records,omitempty"`
}

// Validate validates this application delete collection body
func (o *ApplicationDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateApplicationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationDeleteCollectionBody) validateApplicationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ApplicationResponseInlineRecords); i++ {
		if swag.IsZero(o.ApplicationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ApplicationResponseInlineRecords[i] != nil {
			if err := o.ApplicationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this application delete collection body based on the context it is used
func (o *ApplicationDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateApplicationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationDeleteCollectionBody) contextValidateApplicationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ApplicationResponseInlineRecords); i++ {

		if o.ApplicationResponseInlineRecords[i] != nil {
			if err := o.ApplicationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ApplicationDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
