// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationDeleteParams creates a new ApplicationDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationDeleteParams() *ApplicationDeleteParams {
	return &ApplicationDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationDeleteParamsWithTimeout creates a new ApplicationDeleteParams object
// with the ability to set a timeout on a request.
func NewApplicationDeleteParamsWithTimeout(timeout time.Duration) *ApplicationDeleteParams {
	return &ApplicationDeleteParams{
		timeout: timeout,
	}
}

// NewApplicationDeleteParamsWithContext creates a new ApplicationDeleteParams object
// with the ability to set a context for a request.
func NewApplicationDeleteParamsWithContext(ctx context.Context) *ApplicationDeleteParams {
	return &ApplicationDeleteParams{
		Context: ctx,
	}
}

// NewApplicationDeleteParamsWithHTTPClient creates a new ApplicationDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationDeleteParamsWithHTTPClient(client *http.Client) *ApplicationDeleteParams {
	return &ApplicationDeleteParams{
		HTTPClient: client,
	}
}

/*
ApplicationDeleteParams contains all the parameters to send to the API endpoint

	for the application delete operation.

	Typically these are written to a http.Request.
*/
type ApplicationDeleteParams struct {

	/* DeleteData.

	   By default, deleting an application deletes all of the application's data. By setting this parameter to "false", the application's data is preserved, but can no longer be managed through application APIs.


	   Default: true
	*/
	DeleteData *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* UUID.

	   Application UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationDeleteParams) WithDefaults() *ApplicationDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationDeleteParams) SetDefaults() {
	var (
		deleteDataDefault = bool(true)

		returnTimeoutDefault = int64(0)
	)

	val := ApplicationDeleteParams{
		DeleteData:    &deleteDataDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application delete params
func (o *ApplicationDeleteParams) WithTimeout(timeout time.Duration) *ApplicationDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application delete params
func (o *ApplicationDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application delete params
func (o *ApplicationDeleteParams) WithContext(ctx context.Context) *ApplicationDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application delete params
func (o *ApplicationDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application delete params
func (o *ApplicationDeleteParams) WithHTTPClient(client *http.Client) *ApplicationDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application delete params
func (o *ApplicationDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDeleteData adds the deleteData to the application delete params
func (o *ApplicationDeleteParams) WithDeleteData(deleteData *bool) *ApplicationDeleteParams {
	o.SetDeleteData(deleteData)
	return o
}

// SetDeleteData adds the deleteData to the application delete params
func (o *ApplicationDeleteParams) SetDeleteData(deleteData *bool) {
	o.DeleteData = deleteData
}

// WithReturnTimeout adds the returnTimeout to the application delete params
func (o *ApplicationDeleteParams) WithReturnTimeout(returnTimeout *int64) *ApplicationDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application delete params
func (o *ApplicationDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the application delete params
func (o *ApplicationDeleteParams) WithUUID(uuid string) *ApplicationDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application delete params
func (o *ApplicationDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DeleteData != nil {

		// query param delete_data
		var qrDeleteData bool

		if o.DeleteData != nil {
			qrDeleteData = *o.DeleteData
		}
		qDeleteData := swag.FormatBool(qrDeleteData)
		if qDeleteData != "" {

			if err := r.SetQueryParam("delete_data", qDeleteData); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
