// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationDeleteReader is a Reader for the ApplicationDelete structure.
type ApplicationDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationDeleteAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationDeleteOK creates a ApplicationDeleteOK with default headers values
func NewApplicationDeleteOK() *ApplicationDeleteOK {
	return &ApplicationDeleteOK{}
}

/*
ApplicationDeleteOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationDeleteOK struct {
	Payload *models.ApplicationJobLinkResponse
}

// IsSuccess returns true when this application delete o k response has a 2xx status code
func (o *ApplicationDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application delete o k response has a 3xx status code
func (o *ApplicationDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application delete o k response has a 4xx status code
func (o *ApplicationDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application delete o k response has a 5xx status code
func (o *ApplicationDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application delete o k response a status code equal to that given
func (o *ApplicationDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application delete o k response
func (o *ApplicationDeleteOK) Code() int {
	return 200
}

func (o *ApplicationDeleteOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{uuid}][%d] applicationDeleteOK %s", 200, payload)
}

func (o *ApplicationDeleteOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{uuid}][%d] applicationDeleteOK %s", 200, payload)
}

func (o *ApplicationDeleteOK) GetPayload() *models.ApplicationJobLinkResponse {
	return o.Payload
}

func (o *ApplicationDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationDeleteAccepted creates a ApplicationDeleteAccepted with default headers values
func NewApplicationDeleteAccepted() *ApplicationDeleteAccepted {
	return &ApplicationDeleteAccepted{}
}

/*
ApplicationDeleteAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationDeleteAccepted struct {
	Payload *models.ApplicationJobLinkResponse
}

// IsSuccess returns true when this application delete accepted response has a 2xx status code
func (o *ApplicationDeleteAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application delete accepted response has a 3xx status code
func (o *ApplicationDeleteAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application delete accepted response has a 4xx status code
func (o *ApplicationDeleteAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application delete accepted response has a 5xx status code
func (o *ApplicationDeleteAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application delete accepted response a status code equal to that given
func (o *ApplicationDeleteAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application delete accepted response
func (o *ApplicationDeleteAccepted) Code() int {
	return 202
}

func (o *ApplicationDeleteAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{uuid}][%d] applicationDeleteAccepted %s", 202, payload)
}

func (o *ApplicationDeleteAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{uuid}][%d] applicationDeleteAccepted %s", 202, payload)
}

func (o *ApplicationDeleteAccepted) GetPayload() *models.ApplicationJobLinkResponse {
	return o.Payload
}

func (o *ApplicationDeleteAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationDeleteDefault creates a ApplicationDeleteDefault with default headers values
func NewApplicationDeleteDefault(code int) *ApplicationDeleteDefault {
	return &ApplicationDeleteDefault{
		_statusCode: code,
	}
}

/*
ApplicationDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application delete default response has a 2xx status code
func (o *ApplicationDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application delete default response has a 3xx status code
func (o *ApplicationDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application delete default response has a 4xx status code
func (o *ApplicationDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application delete default response has a 5xx status code
func (o *ApplicationDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application delete default response a status code equal to that given
func (o *ApplicationDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application delete default response
func (o *ApplicationDeleteDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{uuid}][%d] application_delete default %s", o._statusCode, payload)
}

func (o *ApplicationDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{uuid}][%d] application_delete default %s", o._statusCode, payload)
}

func (o *ApplicationDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
