// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationGetParams creates a new ApplicationGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationGetParams() *ApplicationGetParams {
	return &ApplicationGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationGetParamsWithTimeout creates a new ApplicationGetParams object
// with the ability to set a timeout on a request.
func NewApplicationGetParamsWithTimeout(timeout time.Duration) *ApplicationGetParams {
	return &ApplicationGetParams{
		timeout: timeout,
	}
}

// NewApplicationGetParamsWithContext creates a new ApplicationGetParams object
// with the ability to set a context for a request.
func NewApplicationGetParamsWithContext(ctx context.Context) *ApplicationGetParams {
	return &ApplicationGetParams{
		Context: ctx,
	}
}

// NewApplicationGetParamsWithHTTPClient creates a new ApplicationGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationGetParamsWithHTTPClient(client *http.Client) *ApplicationGetParams {
	return &ApplicationGetParams{
		HTTPClient: client,
	}
}

/*
ApplicationGetParams contains all the parameters to send to the API endpoint

	for the application get operation.

	Typically these are written to a http.Request.
*/
type ApplicationGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* UUID.

	   Application UUID
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationGetParams) WithDefaults() *ApplicationGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the application get params
func (o *ApplicationGetParams) WithTimeout(timeout time.Duration) *ApplicationGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application get params
func (o *ApplicationGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application get params
func (o *ApplicationGetParams) WithContext(ctx context.Context) *ApplicationGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application get params
func (o *ApplicationGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application get params
func (o *ApplicationGetParams) WithHTTPClient(client *http.Client) *ApplicationGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application get params
func (o *ApplicationGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the application get params
func (o *ApplicationGetParams) WithFields(fields []string) *ApplicationGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the application get params
func (o *ApplicationGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithUUID adds the uuid to the application get params
func (o *ApplicationGetParams) WithUUID(uuid string) *ApplicationGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application get params
func (o *ApplicationGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamApplicationGet binds the parameter fields
func (o *ApplicationGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
