// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationModifyCollectionReader is a Reader for the ApplicationModifyCollection structure.
type ApplicationModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationModifyCollectionOK creates a ApplicationModifyCollectionOK with default headers values
func NewApplicationModifyCollectionOK() *ApplicationModifyCollectionOK {
	return &ApplicationModifyCollectionOK{}
}

/*
ApplicationModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationModifyCollectionOK struct {
	Payload *models.ApplicationJobLinkResponse
}

// IsSuccess returns true when this application modify collection o k response has a 2xx status code
func (o *ApplicationModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application modify collection o k response has a 3xx status code
func (o *ApplicationModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application modify collection o k response has a 4xx status code
func (o *ApplicationModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application modify collection o k response has a 5xx status code
func (o *ApplicationModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application modify collection o k response a status code equal to that given
func (o *ApplicationModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application modify collection o k response
func (o *ApplicationModifyCollectionOK) Code() int {
	return 200
}

func (o *ApplicationModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/applications][%d] applicationModifyCollectionOK %s", 200, payload)
}

func (o *ApplicationModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/applications][%d] applicationModifyCollectionOK %s", 200, payload)
}

func (o *ApplicationModifyCollectionOK) GetPayload() *models.ApplicationJobLinkResponse {
	return o.Payload
}

func (o *ApplicationModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationModifyCollectionAccepted creates a ApplicationModifyCollectionAccepted with default headers values
func NewApplicationModifyCollectionAccepted() *ApplicationModifyCollectionAccepted {
	return &ApplicationModifyCollectionAccepted{}
}

/*
ApplicationModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationModifyCollectionAccepted struct {
	Payload *models.ApplicationJobLinkResponse
}

// IsSuccess returns true when this application modify collection accepted response has a 2xx status code
func (o *ApplicationModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application modify collection accepted response has a 3xx status code
func (o *ApplicationModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application modify collection accepted response has a 4xx status code
func (o *ApplicationModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application modify collection accepted response has a 5xx status code
func (o *ApplicationModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application modify collection accepted response a status code equal to that given
func (o *ApplicationModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application modify collection accepted response
func (o *ApplicationModifyCollectionAccepted) Code() int {
	return 202
}

func (o *ApplicationModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/applications][%d] applicationModifyCollectionAccepted %s", 202, payload)
}

func (o *ApplicationModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/applications][%d] applicationModifyCollectionAccepted %s", 202, payload)
}

func (o *ApplicationModifyCollectionAccepted) GetPayload() *models.ApplicationJobLinkResponse {
	return o.Payload
}

func (o *ApplicationModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationModifyCollectionDefault creates a ApplicationModifyCollectionDefault with default headers values
func NewApplicationModifyCollectionDefault(code int) *ApplicationModifyCollectionDefault {
	return &ApplicationModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
ApplicationModifyCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application modify collection default response has a 2xx status code
func (o *ApplicationModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application modify collection default response has a 3xx status code
func (o *ApplicationModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application modify collection default response has a 4xx status code
func (o *ApplicationModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application modify collection default response has a 5xx status code
func (o *ApplicationModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application modify collection default response a status code equal to that given
func (o *ApplicationModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application modify collection default response
func (o *ApplicationModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/applications][%d] application_modify_collection default %s", o._statusCode, payload)
}

func (o *ApplicationModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /application/applications][%d] application_modify_collection default %s", o._statusCode, payload)
}

func (o *ApplicationModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ApplicationModifyCollectionBody application modify collection body
swagger:model ApplicationModifyCollectionBody
*/
type ApplicationModifyCollectionBody struct {

	// links
	Links *models.ApplicationInlineLinks `json:"_links,omitempty"`

	// application response inline records
	ApplicationResponseInlineRecords []*models.Application `json:"records,omitempty"`

	// The time when the application was created.
	// Read Only: true
	CreationTimestamp *string `json:"creation_timestamp,omitempty"`

	// Should application storage elements be deleted? An application is considered to use storage elements from a shared storage pool. Possible values are 'true' and 'false'. If the value is 'true', the application will be deleted in its entirety. If the value is 'false', the storage elements will be disassociated from the application and preserved. The application will then be deleted.
	DeleteData *bool `json:"delete_data,omitempty"`

	// The generation number of the application. This indicates which features are supported on the application. For example, generation 1 applications do not support Snapshot copies. Support for Snapshot copies was added at generation 2. Any future generation numbers and their feature set will be documented.
	// Read Only: true
	Generation *int64 `json:"generation,omitempty"`

	// mongo db on san
	MongoDbOnSan *models.MongoDbOnSan `json:"mongo_db_on_san,omitempty"`

	// Application Name. This field is user supplied when the application is created.
	Name *string `json:"name,omitempty"`

	// nas
	Nas *models.Nas `json:"nas,omitempty"`

	// nvme
	Nvme *models.ZappNvme `json:"nvme,omitempty"`

	// oracle on nfs
	OracleOnNfs *models.OracleOnNfs `json:"oracle_on_nfs,omitempty"`

	// oracle on san
	OracleOnSan *models.OracleOnSan `json:"oracle_on_san,omitempty"`

	// oracle rac on nfs
	OracleRacOnNfs *models.OracleRacOnNfs `json:"oracle_rac_on_nfs,omitempty"`

	// oracle rac on san
	OracleRacOnSan *models.OracleRacOnSan `json:"oracle_rac_on_san,omitempty"`

	// Protection granularity determines the scope of Snapshot copy operations for the application. Possible values are "application" and "component". If the value is "application", Snapshot copy operations are performed on the entire application. If the value is "component", Snapshot copy operations are performed separately on the application components.
	// Read Only: true
	// Enum: ["application","component"]
	ProtectionGranularity *string `json:"protection_granularity,omitempty"`

	// rpo
	Rpo *models.ApplicationInlineRpo `json:"rpo,omitempty"`

	// s3 bucket
	S3Bucket *models.ZappS3Bucket `json:"s3_bucket,omitempty"`

	// san
	San *models.San `json:"san,omitempty"`

	// Identifies if this is a smart container or not.
	SmartContainer *bool `json:"smart_container,omitempty"`

	// sql on san
	SQLOnSan *models.SQLOnSan `json:"sql_on_san,omitempty"`

	// sql on smb
	SQLOnSmb *models.SQLOnSmb `json:"sql_on_smb,omitempty"`

	// The state of the application. For full functionality, applications must be in the online state. Other states indicate that the application is in a transient state and not all operations are supported.
	// Read Only: true
	// Enum: ["creating","deleting","modifying","online","restoring"]
	State *string `json:"state,omitempty"`

	// statistics
	Statistics *models.ApplicationInlineStatistics `json:"statistics,omitempty"`

	// svm
	Svm *models.ApplicationInlineSvm `json:"svm,omitempty"`

	// template
	Template *models.ApplicationInlineTemplate `json:"template,omitempty"`

	// Application UUID. This field is generated when the application is created.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`

	// vdi on nas
	VdiOnNas *models.VdiOnNas `json:"vdi_on_nas,omitempty"`

	// vdi on san
	VdiOnSan *models.VdiOnSan `json:"vdi_on_san,omitempty"`

	// vsi on nas
	VsiOnNas *models.VsiOnNas `json:"vsi_on_nas,omitempty"`

	// vsi on san
	VsiOnSan *models.VsiOnSan `json:"vsi_on_san,omitempty"`
}

// Validate validates this application modify collection body
func (o *ApplicationModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateApplicationResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMongoDbOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNvme(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOracleOnNfs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOracleOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOracleRacOnNfs(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateOracleRacOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtectionGranularity(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRpo(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3Bucket(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSan(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSQLOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSQLOnSmb(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStatistics(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTemplate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVdiOnNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVdiOnSan(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVsiOnNas(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVsiOnSan(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateApplicationResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ApplicationResponseInlineRecords); i++ {
		if swag.IsZero(o.ApplicationResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ApplicationResponseInlineRecords[i] != nil {
			if err := o.ApplicationResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateMongoDbOnSan(formats strfmt.Registry) error {
	if swag.IsZero(o.MongoDbOnSan) { // not required
		return nil
	}

	if o.MongoDbOnSan != nil {
		if err := o.MongoDbOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "mongo_db_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateNas(formats strfmt.Registry) error {
	if swag.IsZero(o.Nas) { // not required
		return nil
	}

	if o.Nas != nil {
		if err := o.Nas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateNvme(formats strfmt.Registry) error {
	if swag.IsZero(o.Nvme) { // not required
		return nil
	}

	if o.Nvme != nil {
		if err := o.Nvme.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateOracleOnNfs(formats strfmt.Registry) error {
	if swag.IsZero(o.OracleOnNfs) { // not required
		return nil
	}

	if o.OracleOnNfs != nil {
		if err := o.OracleOnNfs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateOracleOnSan(formats strfmt.Registry) error {
	if swag.IsZero(o.OracleOnSan) { // not required
		return nil
	}

	if o.OracleOnSan != nil {
		if err := o.OracleOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateOracleRacOnNfs(formats strfmt.Registry) error {
	if swag.IsZero(o.OracleRacOnNfs) { // not required
		return nil
	}

	if o.OracleRacOnNfs != nil {
		if err := o.OracleRacOnNfs.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_rac_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateOracleRacOnSan(formats strfmt.Registry) error {
	if swag.IsZero(o.OracleRacOnSan) { // not required
		return nil
	}

	if o.OracleRacOnSan != nil {
		if err := o.OracleRacOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_rac_on_san")
			}
			return err
		}
	}

	return nil
}

var applicationModifyCollectionBodyTypeProtectionGranularityPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["application","component"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationModifyCollectionBodyTypeProtectionGranularityPropEnum = append(applicationModifyCollectionBodyTypeProtectionGranularityPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// protection_granularity
	// ProtectionGranularity
	// application
	// END DEBUGGING
	// ApplicationModifyCollectionBodyProtectionGranularityApplication captures enum value "application"
	ApplicationModifyCollectionBodyProtectionGranularityApplication string = "application"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// protection_granularity
	// ProtectionGranularity
	// component
	// END DEBUGGING
	// ApplicationModifyCollectionBodyProtectionGranularityComponent captures enum value "component"
	ApplicationModifyCollectionBodyProtectionGranularityComponent string = "component"
)

// prop value enum
func (o *ApplicationModifyCollectionBody) validateProtectionGranularityEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationModifyCollectionBodyTypeProtectionGranularityPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationModifyCollectionBody) validateProtectionGranularity(formats strfmt.Registry) error {
	if swag.IsZero(o.ProtectionGranularity) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtectionGranularityEnum("info"+"."+"protection_granularity", "body", *o.ProtectionGranularity); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateRpo(formats strfmt.Registry) error {
	if swag.IsZero(o.Rpo) { // not required
		return nil
	}

	if o.Rpo != nil {
		if err := o.Rpo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rpo")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateS3Bucket(formats strfmt.Registry) error {
	if swag.IsZero(o.S3Bucket) { // not required
		return nil
	}

	if o.S3Bucket != nil {
		if err := o.S3Bucket.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateSan(formats strfmt.Registry) error {
	if swag.IsZero(o.San) { // not required
		return nil
	}

	if o.San != nil {
		if err := o.San.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateSQLOnSan(formats strfmt.Registry) error {
	if swag.IsZero(o.SQLOnSan) { // not required
		return nil
	}

	if o.SQLOnSan != nil {
		if err := o.SQLOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sql_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateSQLOnSmb(formats strfmt.Registry) error {
	if swag.IsZero(o.SQLOnSmb) { // not required
		return nil
	}

	if o.SQLOnSmb != nil {
		if err := o.SQLOnSmb.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sql_on_smb")
			}
			return err
		}
	}

	return nil
}

var applicationModifyCollectionBodyTypeStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["creating","deleting","modifying","online","restoring"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationModifyCollectionBodyTypeStatePropEnum = append(applicationModifyCollectionBodyTypeStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// state
	// State
	// creating
	// END DEBUGGING
	// ApplicationModifyCollectionBodyStateCreating captures enum value "creating"
	ApplicationModifyCollectionBodyStateCreating string = "creating"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// state
	// State
	// deleting
	// END DEBUGGING
	// ApplicationModifyCollectionBodyStateDeleting captures enum value "deleting"
	ApplicationModifyCollectionBodyStateDeleting string = "deleting"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// state
	// State
	// modifying
	// END DEBUGGING
	// ApplicationModifyCollectionBodyStateModifying captures enum value "modifying"
	ApplicationModifyCollectionBodyStateModifying string = "modifying"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// state
	// State
	// online
	// END DEBUGGING
	// ApplicationModifyCollectionBodyStateOnline captures enum value "online"
	ApplicationModifyCollectionBodyStateOnline string = "online"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionBody
	// ApplicationModifyCollectionBody
	// state
	// State
	// restoring
	// END DEBUGGING
	// ApplicationModifyCollectionBodyStateRestoring captures enum value "restoring"
	ApplicationModifyCollectionBodyStateRestoring string = "restoring"
)

// prop value enum
func (o *ApplicationModifyCollectionBody) validateStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationModifyCollectionBodyTypeStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationModifyCollectionBody) validateState(formats strfmt.Registry) error {
	if swag.IsZero(o.State) { // not required
		return nil
	}

	// value enum
	if err := o.validateStateEnum("info"+"."+"state", "body", *o.State); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateStatistics(formats strfmt.Registry) error {
	if swag.IsZero(o.Statistics) { // not required
		return nil
	}

	if o.Statistics != nil {
		if err := o.Statistics.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateTemplate(formats strfmt.Registry) error {
	if swag.IsZero(o.Template) { // not required
		return nil
	}

	if o.Template != nil {
		if err := o.Template.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "template")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateVdiOnNas(formats strfmt.Registry) error {
	if swag.IsZero(o.VdiOnNas) { // not required
		return nil
	}

	if o.VdiOnNas != nil {
		if err := o.VdiOnNas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vdi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateVdiOnSan(formats strfmt.Registry) error {
	if swag.IsZero(o.VdiOnSan) { // not required
		return nil
	}

	if o.VdiOnSan != nil {
		if err := o.VdiOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vdi_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateVsiOnNas(formats strfmt.Registry) error {
	if swag.IsZero(o.VsiOnNas) { // not required
		return nil
	}

	if o.VsiOnNas != nil {
		if err := o.VsiOnNas.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vsi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) validateVsiOnSan(formats strfmt.Registry) error {
	if swag.IsZero(o.VsiOnSan) { // not required
		return nil
	}

	if o.VsiOnSan != nil {
		if err := o.VsiOnSan.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vsi_on_san")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application modify collection body based on the context it is used
func (o *ApplicationModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateApplicationResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCreationTimestamp(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateGeneration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateMongoDbOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNvme(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOracleOnNfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOracleOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOracleRacOnNfs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateOracleRacOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProtectionGranularity(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRpo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3Bucket(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSQLOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSQLOnSmb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateState(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatistics(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTemplate(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVdiOnNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVdiOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVsiOnNas(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVsiOnSan(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateApplicationResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ApplicationResponseInlineRecords); i++ {

		if o.ApplicationResponseInlineRecords[i] != nil {
			if err := o.ApplicationResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateCreationTimestamp(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"creation_timestamp", "body", o.CreationTimestamp); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateGeneration(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"generation", "body", o.Generation); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateMongoDbOnSan(ctx context.Context, formats strfmt.Registry) error {

	if o.MongoDbOnSan != nil {
		if err := o.MongoDbOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "mongo_db_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateNas(ctx context.Context, formats strfmt.Registry) error {

	if o.Nas != nil {
		if err := o.Nas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nas")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateNvme(ctx context.Context, formats strfmt.Registry) error {

	if o.Nvme != nil {
		if err := o.Nvme.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "nvme")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateOracleOnNfs(ctx context.Context, formats strfmt.Registry) error {

	if o.OracleOnNfs != nil {
		if err := o.OracleOnNfs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateOracleOnSan(ctx context.Context, formats strfmt.Registry) error {

	if o.OracleOnSan != nil {
		if err := o.OracleOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateOracleRacOnNfs(ctx context.Context, formats strfmt.Registry) error {

	if o.OracleRacOnNfs != nil {
		if err := o.OracleRacOnNfs.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_rac_on_nfs")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateOracleRacOnSan(ctx context.Context, formats strfmt.Registry) error {

	if o.OracleRacOnSan != nil {
		if err := o.OracleRacOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "oracle_rac_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateProtectionGranularity(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_granularity", "body", o.ProtectionGranularity); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateRpo(ctx context.Context, formats strfmt.Registry) error {

	if o.Rpo != nil {
		if err := o.Rpo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rpo")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateS3Bucket(ctx context.Context, formats strfmt.Registry) error {

	if o.S3Bucket != nil {
		if err := o.S3Bucket.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "s3_bucket")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateSan(ctx context.Context, formats strfmt.Registry) error {

	if o.San != nil {
		if err := o.San.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateSQLOnSan(ctx context.Context, formats strfmt.Registry) error {

	if o.SQLOnSan != nil {
		if err := o.SQLOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sql_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateSQLOnSmb(ctx context.Context, formats strfmt.Registry) error {

	if o.SQLOnSmb != nil {
		if err := o.SQLOnSmb.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "sql_on_smb")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateState(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"state", "body", o.State); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateStatistics(ctx context.Context, formats strfmt.Registry) error {

	if o.Statistics != nil {
		if err := o.Statistics.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateTemplate(ctx context.Context, formats strfmt.Registry) error {

	if o.Template != nil {
		if err := o.Template.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "template")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateVdiOnNas(ctx context.Context, formats strfmt.Registry) error {

	if o.VdiOnNas != nil {
		if err := o.VdiOnNas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vdi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateVdiOnSan(ctx context.Context, formats strfmt.Registry) error {

	if o.VdiOnSan != nil {
		if err := o.VdiOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vdi_on_san")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateVsiOnNas(ctx context.Context, formats strfmt.Registry) error {

	if o.VsiOnNas != nil {
		if err := o.VsiOnNas.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vsi_on_nas")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionBody) contextValidateVsiOnSan(ctx context.Context, formats strfmt.Registry) error {

	if o.VsiOnSan != nil {
		if err := o.VsiOnSan.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "vsi_on_san")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyRpoComponentsItems0 application modify collection params body rpo components items0
swagger:model ApplicationModifyCollectionParamsBodyRpoComponentsItems0
*/
type ApplicationModifyCollectionParamsBodyRpoComponentsItems0 struct {

	// Component Name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// rpo
	Rpo *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo `json:"rpo,omitempty"`

	// Component UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application modify collection params body rpo components items0
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRpo(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) validateRpo(formats strfmt.Registry) error {
	if swag.IsZero(o.Rpo) { // not required
		return nil
	}

	if o.Rpo != nil {
		if err := o.Rpo.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application modify collection params body rpo components items0 based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRpo(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) contextValidateRpo(ctx context.Context, formats strfmt.Registry) error {

	if o.Rpo != nil {
		if err := o.Rpo.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyRpoComponentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo application modify collection params body rpo components items0 rpo
swagger:model ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo
*/
type ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo struct {

	// local
	Local *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal `json:"local,omitempty"`

	// remote
	Remote *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote `json:"remote,omitempty"`
}

// Validate validates this application modify collection params body rpo components items0 rpo
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(o.Local) { // not required
		return nil
	}

	if o.Local != nil {
		if err := o.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(o.Remote) { // not required
		return nil
	}

	if o.Remote != nil {
		if err := o.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application modify collection params body rpo components items0 rpo based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if o.Local != nil {
		if err := o.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if o.Remote != nil {
		if err := o.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyRpoComponentsItems0Rpo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal application modify collection params body rpo components items0 rpo local
swagger:model ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
*/
type ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal struct {

	// A detailed description of the local RPO. This will include details about the Snapshot copy schedule.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The local RPO of the component. This indicates how often component Snapshot copies are automatically created.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application modify collection params body rpo components items0 rpo local
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalTypeNamePropEnum = append(applicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameNr6Hourly captures enum value "6_hourly"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameNr15Minutely captures enum value "15_minutely"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameHourly captures enum value "hourly"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameNone captures enum value "none"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalNameNone string = "none"
)

// prop value enum
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocalTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("rpo"+"."+"local"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application modify collection params body rpo components items0 rpo local based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"local"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"local"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote application modify collection params body rpo components items0 rpo remote
swagger:model ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
*/
type ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote struct {

	// A detailed description of the remote RPO.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The remote RPO of the component. A remote RPO of zero indicates that the component is synchronously replicated to another cluster.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none","zero"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application modify collection params body rpo components items0 rpo remote
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteTypeNamePropEnum = append(applicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameNr6Hourly captures enum value "6_hourly"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameNr15Minutely captures enum value "15_minutely"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameHourly captures enum value "hourly"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameNone captures enum value "none"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameNone string = "none"

	// BEGIN DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	// name
	// Name
	// zero
	// END DEBUGGING
	// ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameZero captures enum value "zero"
	ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteNameZero string = "zero"
)

// prop value enum
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemoteTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("rpo"+"."+"remote"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application modify collection params body rpo components items0 rpo remote based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"remote"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "rpo"+"."+"remote"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyRpoComponentsItems0RpoRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0 application modify collection params body statistics components items0
swagger:model ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0
*/
type ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0 struct {

	// iops
	Iops *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops `json:"iops,omitempty"`

	// latency
	Latency *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency `json:"latency,omitempty"`

	// Component Name.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// An application component is considered to use a shared storage pool if storage elements for for other components reside on the same aggregate as storage elements for this component.
	// Read Only: true
	SharedStoragePool *bool `json:"shared_storage_pool,omitempty"`

	// snapshot
	Snapshot *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot `json:"snapshot,omitempty"`

	// space
	Space *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space `json:"space,omitempty"`

	// If not all storage elements of the application component are currently available, the returned statistics might only include data from those elements that were available.
	// Read Only: true
	StatisticsIncomplete *bool `json:"statistics_incomplete,omitempty"`

	// storage service
	StorageService *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService `json:"storage_service,omitempty"`

	// Component UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application modify collection params body statistics components items0
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageService(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) validateStorageService(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageService) { // not required
		return nil
	}

	if o.StorageService != nil {
		if err := o.StorageService.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application modify collection params body statistics components items0 based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSharedStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatisticsIncomplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStorageService(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("iops")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("latency")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateSharedStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "shared_storage_pool", "body", o.SharedStoragePool); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("space")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateStatisticsIncomplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "statistics_incomplete", "body", o.StatisticsIncomplete); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateStorageService(ctx context.Context, formats strfmt.Registry) error {

	if o.StorageService != nil {
		if err := o.StorageService.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("storage_service")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops application modify collection params body statistics components items0 iops
swagger:model ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops
*/
type ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops struct {

	// The number of IOPS per terabyte of logical space currently being used by the application component.
	// Read Only: true
	PerTb *int64 `json:"per_tb,omitempty"`

	// The total number of IOPS being used by the application component.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this application modify collection params body statistics components items0 iops
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application modify collection params body statistics components items0 iops based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePerTb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops) contextValidatePerTb(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "iops"+"."+"per_tb", "body", o.PerTb); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "iops"+"."+"total", "body", o.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Iops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency application modify collection params body statistics components items0 latency
swagger:model ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency
*/
type ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency struct {

	// The cumulative average response time in microseconds for this component.
	// Read Only: true
	Average *int64 `json:"average,omitempty"`

	// The cumulative response time in microseconds for this component.
	// Read Only: true
	Raw *int64 `json:"raw,omitempty"`
}

// Validate validates this application modify collection params body statistics components items0 latency
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application modify collection params body statistics components items0 latency based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAverage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency) contextValidateAverage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "latency"+"."+"average", "body", o.Average); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency) contextValidateRaw(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "latency"+"."+"raw", "body", o.Raw); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Latency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot application modify collection params body statistics components items0 snapshot
swagger:model ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot
*/
type ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot struct {

	// The amount of space reserved by the system for Snapshot copies.
	// Read Only: true
	Reserve *int64 `json:"reserve,omitempty"`

	// The amount of spacing currently in use by the system to store Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this application modify collection params body statistics components items0 snapshot
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application modify collection params body statistics components items0 snapshot based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot) contextValidateReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"reserve", "body", o.Reserve); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "snapshot"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Snapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space application modify collection params body statistics components items0 space
swagger:model ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space
*/
type ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space struct {

	// The available amount of space left in the application component. Note that this field has limited meaning for SAN applications. Space may be considered used from ONTAP's perspective while the host filesystem still considers it available.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The amount of space that would currently be used if no space saving features were enabled. For example, if compression were the only space saving feature enabled, this field would represent the uncompressed amount of space used.
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// The originally requested amount of space that was provisioned for the application component.
	// Read Only: true
	Provisioned *int64 `json:"provisioned,omitempty"`

	// The amount of space reserved for system features such as Snapshot copies that has not yet been used.
	// Read Only: true
	ReservedUnused *int64 `json:"reserved_unused,omitempty"`

	// The amount of space saved by all enabled space saving features.
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// The amount of space that is currently being used by the application component. Note that this includes any space reserved by the system for features such as Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The amount of space that is currently being used, excluding any space that is reserved by the system for features such as Snapshot copies.
	// Read Only: true
	UsedExcludingReserves *int64 `json:"used_excluding_reserves,omitempty"`

	// The percentage of the originally provisioned space that is currently being used by the application component.
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this application modify collection params body statistics components items0 space
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application modify collection params body statistics components items0 space based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReservedUnused(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedExcludingReserves(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"logical_used", "body", o.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"provisioned", "body", o.Provisioned); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateReservedUnused(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"reserved_unused", "body", o.ReservedUnused); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"savings", "body", o.Savings); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateUsedExcludingReserves(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used_excluding_reserves", "body", o.UsedExcludingReserves); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "space"+"."+"used_percent", "body", o.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0Space
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService application modify collection params body statistics components items0 storage service
swagger:model ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService
*/
type ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService struct {

	// The storage service name. AFF systems support the extreme storage service. All other systems only support value.
	// Read Only: true
	Name *string `json:"name,omitempty"`

	// The storage service UUID.
	// Read Only: true
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application modify collection params body statistics components items0 storage service
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application modify collection params body statistics components items0 storage service based on the context it is used
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_service"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "storage_service"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService) UnmarshalBinary(b []byte) error {
	var res ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0StorageService
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineLinks application inline links
swagger:model application_inline__links
*/
type ApplicationInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`

	// snapshots
	Snapshots *models.Href `json:"snapshots,omitempty"`
}

// Validate validates this application inline links
func (o *ApplicationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshots(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineLinks) validateSnapshots(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshots) { // not required
		return nil
	}

	if o.Snapshots != nil {
		if err := o.Snapshots.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "snapshots")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application inline links based on the context it is used
func (o *ApplicationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshots(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineLinks) contextValidateSnapshots(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshots != nil {
		if err := o.Snapshots.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "snapshots")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineLinks) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineRpo application inline rpo
swagger:model application_inline_rpo
*/
type ApplicationInlineRpo struct {

	// components
	// Read Only: true
	Components []*ApplicationModifyCollectionParamsBodyRpoComponentsItems0 `json:"components,omitempty"`

	// Is RPO supported for this application? Generation 1 applications did not support Snapshot copies or MetroCluster.
	// Read Only: true
	IsSupported *bool `json:"is_supported,omitempty"`

	// local
	Local *models.ApplicationInlineRpoInlineLocal `json:"local,omitempty"`

	// remote
	Remote *models.ApplicationInlineRpoInlineRemote `json:"remote,omitempty"`
}

// Validate validates this application inline rpo
func (o *ApplicationInlineRpo) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocal(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRemote(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineRpo) validateComponents(formats strfmt.Registry) error {
	if swag.IsZero(o.Components) { // not required
		return nil
	}

	for i := 0; i < len(o.Components); i++ {
		if swag.IsZero(o.Components[i]) { // not required
			continue
		}

		if o.Components[i] != nil {
			if err := o.Components[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rpo" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ApplicationInlineRpo) validateLocal(formats strfmt.Registry) error {
	if swag.IsZero(o.Local) { // not required
		return nil
	}

	if o.Local != nil {
		if err := o.Local.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineRpo) validateRemote(formats strfmt.Registry) error {
	if swag.IsZero(o.Remote) { // not required
		return nil
	}

	if o.Remote != nil {
		if err := o.Remote.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application inline rpo based on the context it is used
func (o *ApplicationInlineRpo) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsSupported(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRemote(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineRpo) contextValidateComponents(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rpo"+"."+"components", "body", []*ApplicationModifyCollectionParamsBodyRpoComponentsItems0(o.Components)); err != nil {
		return err
	}

	for i := 0; i < len(o.Components); i++ {

		if o.Components[i] != nil {
			if err := o.Components[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "rpo" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ApplicationInlineRpo) contextValidateIsSupported(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rpo"+"."+"is_supported", "body", o.IsSupported); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineRpo) contextValidateLocal(ctx context.Context, formats strfmt.Registry) error {

	if o.Local != nil {
		if err := o.Local.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rpo" + "." + "local")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineRpo) contextValidateRemote(ctx context.Context, formats strfmt.Registry) error {

	if o.Remote != nil {
		if err := o.Remote.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "rpo" + "." + "remote")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineRpo) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineRpo) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineRpo
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineRpoInlineLocal application inline rpo inline local
swagger:model application_inline_rpo_inline_local
*/
type ApplicationInlineRpoInlineLocal struct {

	// A detailed description of the local RPO. This will include details about the Snapshot copy schedule.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The local RPO of the application. This indicates how often application Snapshot copies are automatically created.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application inline rpo inline local
func (o *ApplicationInlineRpoInlineLocal) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationInlineRpoInlineLocalTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationInlineRpoInlineLocalTypeNamePropEnum = append(applicationInlineRpoInlineLocalTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameNr6Hourly captures enum value "6_hourly"
	ApplicationInlineRpoInlineLocalNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameNr15Minutely captures enum value "15_minutely"
	ApplicationInlineRpoInlineLocalNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameHourly captures enum value "hourly"
	ApplicationInlineRpoInlineLocalNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_local
	// ApplicationInlineRpoInlineLocal
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationInlineRpoInlineLocalNameNone captures enum value "none"
	ApplicationInlineRpoInlineLocalNameNone string = "none"
)

// prop value enum
func (o *ApplicationInlineRpoInlineLocal) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationInlineRpoInlineLocalTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationInlineRpoInlineLocal) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("info"+"."+"rpo"+"."+"local"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application inline rpo inline local based on the context it is used
func (o *ApplicationInlineRpoInlineLocal) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineRpoInlineLocal) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rpo"+"."+"local"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineRpoInlineLocal) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rpo"+"."+"local"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineRpoInlineLocal) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineRpoInlineLocal) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineRpoInlineLocal
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineRpoInlineRemote application inline rpo inline remote
swagger:model application_inline_rpo_inline_remote
*/
type ApplicationInlineRpoInlineRemote struct {

	// A detailed description of the remote RPO.
	// Read Only: true
	Description *string `json:"description,omitempty"`

	// The remote RPO of the application. A remote RPO of zero indicates that the application is synchronously replicated to another cluster.
	// Read Only: true
	// Enum: ["6_hourly","15_minutely","hourly","none","zero"]
	Name *string `json:"name,omitempty"`
}

// Validate validates this application inline rpo inline remote
func (o *ApplicationInlineRpoInlineRemote) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var applicationInlineRpoInlineRemoteTypeNamePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["6_hourly","15_minutely","hourly","none","zero"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationInlineRpoInlineRemoteTypeNamePropEnum = append(applicationInlineRpoInlineRemoteTypeNamePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// 6_hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameNr6Hourly captures enum value "6_hourly"
	ApplicationInlineRpoInlineRemoteNameNr6Hourly string = "6_hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// 15_minutely
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameNr15Minutely captures enum value "15_minutely"
	ApplicationInlineRpoInlineRemoteNameNr15Minutely string = "15_minutely"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// hourly
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameHourly captures enum value "hourly"
	ApplicationInlineRpoInlineRemoteNameHourly string = "hourly"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// none
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameNone captures enum value "none"
	ApplicationInlineRpoInlineRemoteNameNone string = "none"

	// BEGIN DEBUGGING
	// application_inline_rpo_inline_remote
	// ApplicationInlineRpoInlineRemote
	// name
	// Name
	// zero
	// END DEBUGGING
	// ApplicationInlineRpoInlineRemoteNameZero captures enum value "zero"
	ApplicationInlineRpoInlineRemoteNameZero string = "zero"
)

// prop value enum
func (o *ApplicationInlineRpoInlineRemote) validateNameEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationInlineRpoInlineRemoteTypeNamePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationInlineRpoInlineRemote) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	// value enum
	if err := o.validateNameEnum("info"+"."+"rpo"+"."+"remote"+"."+"name", "body", *o.Name); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application inline rpo inline remote based on the context it is used
func (o *ApplicationInlineRpoInlineRemote) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDescription(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateName(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineRpoInlineRemote) contextValidateDescription(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rpo"+"."+"remote"+"."+"description", "body", o.Description); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineRpoInlineRemote) contextValidateName(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"rpo"+"."+"remote"+"."+"name", "body", o.Name); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineRpoInlineRemote) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineRpoInlineRemote) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineRpoInlineRemote
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineStatistics application inline statistics
swagger:model application_inline_statistics
*/
type ApplicationInlineStatistics struct {

	// components
	// Read Only: true
	Components []*ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0 `json:"components,omitempty"`

	// iops
	Iops *models.ApplicationInlineStatisticsInlineIops `json:"iops,omitempty"`

	// latency
	Latency *models.ApplicationInlineStatisticsInlineLatency `json:"latency,omitempty"`

	// An application is considered to use a shared storage pool if storage elements for multiple components reside on the same aggregate.
	// Read Only: true
	SharedStoragePool *bool `json:"shared_storage_pool,omitempty"`

	// snapshot
	Snapshot *models.ApplicationInlineStatisticsInlineSnapshot `json:"snapshot,omitempty"`

	// space
	Space *models.ApplicationInlineStatisticsInlineSpace `json:"space,omitempty"`

	// If not all storage elements of the application are currently available, the returned statistics might only include data from those elements that were available.
	// Read Only: true
	StatisticsIncomplete *bool `json:"statistics_incomplete,omitempty"`
}

// Validate validates this application inline statistics
func (o *ApplicationInlineStatistics) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComponents(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLatency(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshot(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSpace(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineStatistics) validateComponents(formats strfmt.Registry) error {
	if swag.IsZero(o.Components) { // not required
		return nil
	}

	for i := 0; i < len(o.Components); i++ {
		if swag.IsZero(o.Components[i]) { // not required
			continue
		}

		if o.Components[i] != nil {
			if err := o.Components[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "statistics" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ApplicationInlineStatistics) validateIops(formats strfmt.Registry) error {
	if swag.IsZero(o.Iops) { // not required
		return nil
	}

	if o.Iops != nil {
		if err := o.Iops.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) validateLatency(formats strfmt.Registry) error {
	if swag.IsZero(o.Latency) { // not required
		return nil
	}

	if o.Latency != nil {
		if err := o.Latency.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) validateSnapshot(formats strfmt.Registry) error {
	if swag.IsZero(o.Snapshot) { // not required
		return nil
	}

	if o.Snapshot != nil {
		if err := o.Snapshot.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) validateSpace(formats strfmt.Registry) error {
	if swag.IsZero(o.Space) { // not required
		return nil
	}

	if o.Space != nil {
		if err := o.Space.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "space")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this application inline statistics based on the context it is used
func (o *ApplicationInlineStatistics) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateComponents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIops(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLatency(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSharedStoragePool(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshot(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSpace(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateStatisticsIncomplete(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineStatistics) contextValidateComponents(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"components", "body", []*ApplicationModifyCollectionParamsBodyStatisticsComponentsItems0(o.Components)); err != nil {
		return err
	}

	for i := 0; i < len(o.Components); i++ {

		if o.Components[i] != nil {
			if err := o.Components[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "statistics" + "." + "components" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *ApplicationInlineStatistics) contextValidateIops(ctx context.Context, formats strfmt.Registry) error {

	if o.Iops != nil {
		if err := o.Iops.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "iops")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) contextValidateLatency(ctx context.Context, formats strfmt.Registry) error {

	if o.Latency != nil {
		if err := o.Latency.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "latency")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) contextValidateSharedStoragePool(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"shared_storage_pool", "body", o.SharedStoragePool); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatistics) contextValidateSnapshot(ctx context.Context, formats strfmt.Registry) error {

	if o.Snapshot != nil {
		if err := o.Snapshot.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "snapshot")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) contextValidateSpace(ctx context.Context, formats strfmt.Registry) error {

	if o.Space != nil {
		if err := o.Space.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "statistics" + "." + "space")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineStatistics) contextValidateStatisticsIncomplete(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"statistics_incomplete", "body", o.StatisticsIncomplete); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineStatistics) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineStatistics) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatistics
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineStatisticsInlineIops application inline statistics inline iops
swagger:model application_inline_statistics_inline_iops
*/
type ApplicationInlineStatisticsInlineIops struct {

	// The number of IOPS per terabyte of logical space currently being used by the application.
	// Read Only: true
	PerTb *int64 `json:"per_tb,omitempty"`

	// The total number of IOPS being used by the application.
	// Read Only: true
	Total *int64 `json:"total,omitempty"`
}

// Validate validates this application inline statistics inline iops
func (o *ApplicationInlineStatisticsInlineIops) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline iops based on the context it is used
func (o *ApplicationInlineStatisticsInlineIops) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidatePerTb(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTotal(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineStatisticsInlineIops) contextValidatePerTb(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"iops"+"."+"per_tb", "body", o.PerTb); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineIops) contextValidateTotal(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"iops"+"."+"total", "body", o.Total); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineIops) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineIops) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineIops
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineStatisticsInlineLatency application inline statistics inline latency
swagger:model application_inline_statistics_inline_latency
*/
type ApplicationInlineStatisticsInlineLatency struct {

	// The cumulative average response time in microseconds for this application.
	// Read Only: true
	Average *int64 `json:"average,omitempty"`

	// The cumulative response time in microseconds for this application.
	// Read Only: true
	Raw *int64 `json:"raw,omitempty"`
}

// Validate validates this application inline statistics inline latency
func (o *ApplicationInlineStatisticsInlineLatency) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline latency based on the context it is used
func (o *ApplicationInlineStatisticsInlineLatency) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAverage(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRaw(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineStatisticsInlineLatency) contextValidateAverage(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"latency"+"."+"average", "body", o.Average); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineLatency) contextValidateRaw(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"latency"+"."+"raw", "body", o.Raw); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineLatency) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineLatency) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineLatency
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineStatisticsInlineSnapshot application inline statistics inline snapshot
swagger:model application_inline_statistics_inline_snapshot
*/
type ApplicationInlineStatisticsInlineSnapshot struct {

	// The amount of space reserved by the system for Snapshot copies.
	// Read Only: true
	Reserve *int64 `json:"reserve,omitempty"`

	// The amount of spacing currently in use by the system to store Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`
}

// Validate validates this application inline statistics inline snapshot
func (o *ApplicationInlineStatisticsInlineSnapshot) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline snapshot based on the context it is used
func (o *ApplicationInlineStatisticsInlineSnapshot) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReserve(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineStatisticsInlineSnapshot) contextValidateReserve(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"snapshot"+"."+"reserve", "body", o.Reserve); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSnapshot) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"snapshot"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineSnapshot) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineSnapshot) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineSnapshot
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineStatisticsInlineSpace application inline statistics inline space
swagger:model application_inline_statistics_inline_space
*/
type ApplicationInlineStatisticsInlineSpace struct {

	// The available amount of space left in the application. Note that this field has limited meaning for SAN applications. Space may be considered used from ONTAP's perspective while the host filesystem still considers it available.
	// Read Only: true
	Available *int64 `json:"available,omitempty"`

	// The amount of space that would currently be used if no space saving features were enabled. For example, if compression were the only space saving feature enabled, this field would represent the uncompressed amount of space used.
	// Read Only: true
	LogicalUsed *int64 `json:"logical_used,omitempty"`

	// The originally requested amount of space that was provisioned for the application.
	// Read Only: true
	Provisioned *int64 `json:"provisioned,omitempty"`

	// The amount of space reserved for system features such as Snapshot copies that has not yet been used.
	// Read Only: true
	ReservedUnused *int64 `json:"reserved_unused,omitempty"`

	// The amount of space saved by all enabled space saving features.
	// Read Only: true
	Savings *int64 `json:"savings,omitempty"`

	// The amount of space that is currently being used by the application. Note that this includes any space reserved by the system for features such as Snapshot copies.
	// Read Only: true
	Used *int64 `json:"used,omitempty"`

	// The amount of space that is currently being used, excluding any space that is reserved by the system for features such as Snapshot copies.
	// Read Only: true
	UsedExcludingReserves *int64 `json:"used_excluding_reserves,omitempty"`

	// The percentage of the originally provisioned space that is currently being used by the application.
	// Read Only: true
	UsedPercent *int64 `json:"used_percent,omitempty"`
}

// Validate validates this application inline statistics inline space
func (o *ApplicationInlineStatisticsInlineSpace) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this application inline statistics inline space based on the context it is used
func (o *ApplicationInlineStatisticsInlineSpace) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAvailable(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProvisioned(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateReservedUnused(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSavings(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsed(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedExcludingReserves(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUsedPercent(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateAvailable(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"available", "body", o.Available); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateLogicalUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"logical_used", "body", o.LogicalUsed); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateProvisioned(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"provisioned", "body", o.Provisioned); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateReservedUnused(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"reserved_unused", "body", o.ReservedUnused); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateSavings(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"savings", "body", o.Savings); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateUsed(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"used", "body", o.Used); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateUsedExcludingReserves(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"used_excluding_reserves", "body", o.UsedExcludingReserves); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineStatisticsInlineSpace) contextValidateUsedPercent(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"statistics"+"."+"space"+"."+"used_percent", "body", o.UsedPercent); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineSpace) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineStatisticsInlineSpace) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineStatisticsInlineSpace
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineSvm application inline svm
swagger:model application_inline_svm
*/
type ApplicationInlineSvm struct {

	// SVM Name. Either the SVM name or UUID must be provided to create an application.
	Name *string `json:"name,omitempty"`

	// SVM UUID. Either the SVM name or UUID must be provided to create an application.
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this application inline svm
func (o *ApplicationInlineSvm) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validates this application inline svm based on context it is used
func (o *ApplicationInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineSvm) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ApplicationInlineTemplate application inline template
swagger:model application_inline_template
*/
type ApplicationInlineTemplate struct {

	// links
	Links *models.SelfLink `json:"_links,omitempty"`

	// The name of the template that was used to provision this application.
	Name *string `json:"name,omitempty"`

	// The protocol access of the template that was used to provision this application.
	// Read Only: true
	// Enum: ["nas","nvme","s3","san"]
	Protocol *string `json:"protocol,omitempty"`

	// The version of the template that was used to provision this application. The template version changes only if the layout of the application changes over time. For example, redo logs in Oracle RAC templates were updated and provisioned differently in DATA ONTAP 9.3.0 compared to prior releases, so the version number was increased. If layouts change in the future, the changes will be documented along with the corresponding version numbers.
	// Read Only: true
	Version *int64 `json:"version,omitempty"`
}

// Validate validates this application inline template
func (o *ApplicationInlineTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtocol(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineTemplate) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

var applicationInlineTemplateTypeProtocolPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["nas","nvme","s3","san"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		applicationInlineTemplateTypeProtocolPropEnum = append(applicationInlineTemplateTypeProtocolPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// nas
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolNas captures enum value "nas"
	ApplicationInlineTemplateProtocolNas string = "nas"

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// nvme
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolNvme captures enum value "nvme"
	ApplicationInlineTemplateProtocolNvme string = "nvme"

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// s3
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolS3 captures enum value "s3"
	ApplicationInlineTemplateProtocolS3 string = "s3"

	// BEGIN DEBUGGING
	// application_inline_template
	// ApplicationInlineTemplate
	// protocol
	// Protocol
	// san
	// END DEBUGGING
	// ApplicationInlineTemplateProtocolSan captures enum value "san"
	ApplicationInlineTemplateProtocolSan string = "san"
)

// prop value enum
func (o *ApplicationInlineTemplate) validateProtocolEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, applicationInlineTemplateTypeProtocolPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *ApplicationInlineTemplate) validateProtocol(formats strfmt.Registry) error {
	if swag.IsZero(o.Protocol) { // not required
		return nil
	}

	// value enum
	if err := o.validateProtocolEnum("info"+"."+"template"+"."+"protocol", "body", *o.Protocol); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this application inline template based on the context it is used
func (o *ApplicationInlineTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProtocol(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVersion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationInlineTemplate) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "template" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *ApplicationInlineTemplate) contextValidateProtocol(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"template"+"."+"protocol", "body", o.Protocol); err != nil {
		return err
	}

	return nil
}

func (o *ApplicationInlineTemplate) contextValidateVersion(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"template"+"."+"version", "body", o.Version); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationInlineTemplate) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationInlineTemplate) UnmarshalBinary(b []byte) error {
	var res ApplicationInlineTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
