// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationSnapshotCollectionGetParams creates a new ApplicationSnapshotCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationSnapshotCollectionGetParams() *ApplicationSnapshotCollectionGetParams {
	return &ApplicationSnapshotCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationSnapshotCollectionGetParamsWithTimeout creates a new ApplicationSnapshotCollectionGetParams object
// with the ability to set a timeout on a request.
func NewApplicationSnapshotCollectionGetParamsWithTimeout(timeout time.Duration) *ApplicationSnapshotCollectionGetParams {
	return &ApplicationSnapshotCollectionGetParams{
		timeout: timeout,
	}
}

// NewApplicationSnapshotCollectionGetParamsWithContext creates a new ApplicationSnapshotCollectionGetParams object
// with the ability to set a context for a request.
func NewApplicationSnapshotCollectionGetParamsWithContext(ctx context.Context) *ApplicationSnapshotCollectionGetParams {
	return &ApplicationSnapshotCollectionGetParams{
		Context: ctx,
	}
}

// NewApplicationSnapshotCollectionGetParamsWithHTTPClient creates a new ApplicationSnapshotCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationSnapshotCollectionGetParamsWithHTTPClient(client *http.Client) *ApplicationSnapshotCollectionGetParams {
	return &ApplicationSnapshotCollectionGetParams{
		HTTPClient: client,
	}
}

/*
ApplicationSnapshotCollectionGetParams contains all the parameters to send to the API endpoint

	for the application snapshot collection get operation.

	Typically these are written to a http.Request.
*/
type ApplicationSnapshotCollectionGetParams struct {

	/* ApplicationUUID.

	   Application UUID
	*/
	ApplicationUUID string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ComponentsName.

	   Filter by components.name
	*/
	ComponentsName *string

	/* ComponentsUUID.

	   Filter by components.uuid
	*/
	ComponentsUUID *string

	/* ConsistencyType.

	   Filter by consistency_type
	*/
	ConsistencyType *string

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* UUID.

	   Filter by UUID
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application snapshot collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationSnapshotCollectionGetParams) WithDefaults() *ApplicationSnapshotCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application snapshot collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationSnapshotCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := ApplicationSnapshotCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithTimeout(timeout time.Duration) *ApplicationSnapshotCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithContext(ctx context.Context) *ApplicationSnapshotCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithHTTPClient(client *http.Client) *ApplicationSnapshotCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationUUID adds the applicationUUID to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithApplicationUUID(applicationUUID string) *ApplicationSnapshotCollectionGetParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetApplicationUUID(applicationUUID string) {
	o.ApplicationUUID = applicationUUID
}

// WithComment adds the comment to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithComment(comment *string) *ApplicationSnapshotCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithComponentsName adds the componentsName to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithComponentsName(componentsName *string) *ApplicationSnapshotCollectionGetParams {
	o.SetComponentsName(componentsName)
	return o
}

// SetComponentsName adds the componentsName to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetComponentsName(componentsName *string) {
	o.ComponentsName = componentsName
}

// WithComponentsUUID adds the componentsUUID to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithComponentsUUID(componentsUUID *string) *ApplicationSnapshotCollectionGetParams {
	o.SetComponentsUUID(componentsUUID)
	return o
}

// SetComponentsUUID adds the componentsUuid to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetComponentsUUID(componentsUUID *string) {
	o.ComponentsUUID = componentsUUID
}

// WithConsistencyType adds the consistencyType to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithConsistencyType(consistencyType *string) *ApplicationSnapshotCollectionGetParams {
	o.SetConsistencyType(consistencyType)
	return o
}

// SetConsistencyType adds the consistencyType to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetConsistencyType(consistencyType *string) {
	o.ConsistencyType = consistencyType
}

// WithCreateTime adds the createTime to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithCreateTime(createTime *string) *ApplicationSnapshotCollectionGetParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithFields adds the fields to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithFields(fields []string) *ApplicationSnapshotCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIsPartial adds the isPartial to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithIsPartial(isPartial *string) *ApplicationSnapshotCollectionGetParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetIsPartial(isPartial *string) {
	o.IsPartial = isPartial
}

// WithMaxRecords adds the maxRecords to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithMaxRecords(maxRecords *int64) *ApplicationSnapshotCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithName(name *string) *ApplicationSnapshotCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithOrderBy(orderBy []string) *ApplicationSnapshotCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithReturnRecords(returnRecords *bool) *ApplicationSnapshotCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *ApplicationSnapshotCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithUUID adds the uuid to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) WithUUID(uuid *string) *ApplicationSnapshotCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application snapshot collection get params
func (o *ApplicationSnapshotCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationSnapshotCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.uuid
	if err := r.SetPathParam("application.uuid", o.ApplicationUUID); err != nil {
		return err
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ComponentsName != nil {

		// query param components.name
		var qrComponentsName string

		if o.ComponentsName != nil {
			qrComponentsName = *o.ComponentsName
		}
		qComponentsName := qrComponentsName
		if qComponentsName != "" {

			if err := r.SetQueryParam("components.name", qComponentsName); err != nil {
				return err
			}
		}
	}

	if o.ComponentsUUID != nil {

		// query param components.uuid
		var qrComponentsUUID string

		if o.ComponentsUUID != nil {
			qrComponentsUUID = *o.ComponentsUUID
		}
		qComponentsUUID := qrComponentsUUID
		if qComponentsUUID != "" {

			if err := r.SetQueryParam("components.uuid", qComponentsUUID); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyType != nil {

		// query param consistency_type
		var qrConsistencyType string

		if o.ConsistencyType != nil {
			qrConsistencyType = *o.ConsistencyType
		}
		qConsistencyType := qrConsistencyType
		if qConsistencyType != "" {

			if err := r.SetQueryParam("consistency_type", qConsistencyType); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial string

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := qrIsPartial
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamApplicationSnapshotCollectionGet binds the parameter fields
func (o *ApplicationSnapshotCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamApplicationSnapshotCollectionGet binds the parameter order_by
func (o *ApplicationSnapshotCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
