// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewApplicationSnapshotDeleteCollectionParams creates a new ApplicationSnapshotDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewApplicationSnapshotDeleteCollectionParams() *ApplicationSnapshotDeleteCollectionParams {
	return &ApplicationSnapshotDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewApplicationSnapshotDeleteCollectionParamsWithTimeout creates a new ApplicationSnapshotDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewApplicationSnapshotDeleteCollectionParamsWithTimeout(timeout time.Duration) *ApplicationSnapshotDeleteCollectionParams {
	return &ApplicationSnapshotDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewApplicationSnapshotDeleteCollectionParamsWithContext creates a new ApplicationSnapshotDeleteCollectionParams object
// with the ability to set a context for a request.
func NewApplicationSnapshotDeleteCollectionParamsWithContext(ctx context.Context) *ApplicationSnapshotDeleteCollectionParams {
	return &ApplicationSnapshotDeleteCollectionParams{
		Context: ctx,
	}
}

// NewApplicationSnapshotDeleteCollectionParamsWithHTTPClient creates a new ApplicationSnapshotDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewApplicationSnapshotDeleteCollectionParamsWithHTTPClient(client *http.Client) *ApplicationSnapshotDeleteCollectionParams {
	return &ApplicationSnapshotDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
ApplicationSnapshotDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the application snapshot delete collection operation.

	Typically these are written to a http.Request.
*/
type ApplicationSnapshotDeleteCollectionParams struct {

	/* ApplicationUUID.

	   Application UUID
	*/
	ApplicationUUID string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ComponentsName.

	   Filter by components.name
	*/
	ComponentsName *string

	/* ComponentsUUID.

	   Filter by components.uuid
	*/
	ComponentsUUID *string

	/* ConsistencyType.

	   Filter by consistency_type
	*/
	ConsistencyType *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* CreateTime.

	   Filter by create_time
	*/
	CreateTime *string

	/* Info.

	   Info specification
	*/
	Info ApplicationSnapshotDeleteCollectionBody

	/* IsPartial.

	   Filter by is_partial
	*/
	IsPartial *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* UUID.

	   Filter by UUID
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the application snapshot delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationSnapshotDeleteCollectionParams) WithDefaults() *ApplicationSnapshotDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the application snapshot delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ApplicationSnapshotDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := ApplicationSnapshotDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithTimeout(timeout time.Duration) *ApplicationSnapshotDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithContext(ctx context.Context) *ApplicationSnapshotDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithHTTPClient(client *http.Client) *ApplicationSnapshotDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationUUID adds the applicationUUID to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithApplicationUUID(applicationUUID string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetApplicationUUID(applicationUUID)
	return o
}

// SetApplicationUUID adds the applicationUuid to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetApplicationUUID(applicationUUID string) {
	o.ApplicationUUID = applicationUUID
}

// WithComment adds the comment to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithComment(comment *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithComponentsName adds the componentsName to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithComponentsName(componentsName *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetComponentsName(componentsName)
	return o
}

// SetComponentsName adds the componentsName to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetComponentsName(componentsName *string) {
	o.ComponentsName = componentsName
}

// WithComponentsUUID adds the componentsUUID to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithComponentsUUID(componentsUUID *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetComponentsUUID(componentsUUID)
	return o
}

// SetComponentsUUID adds the componentsUuid to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetComponentsUUID(componentsUUID *string) {
	o.ComponentsUUID = componentsUUID
}

// WithConsistencyType adds the consistencyType to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithConsistencyType(consistencyType *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetConsistencyType(consistencyType)
	return o
}

// SetConsistencyType adds the consistencyType to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetConsistencyType(consistencyType *string) {
	o.ConsistencyType = consistencyType
}

// WithContinueOnFailure adds the continueOnFailure to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *ApplicationSnapshotDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithCreateTime adds the createTime to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithCreateTime(createTime *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetCreateTime(createTime)
	return o
}

// SetCreateTime adds the createTime to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetCreateTime(createTime *string) {
	o.CreateTime = createTime
}

// WithInfo adds the info to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithInfo(info ApplicationSnapshotDeleteCollectionBody) *ApplicationSnapshotDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetInfo(info ApplicationSnapshotDeleteCollectionBody) {
	o.Info = info
}

// WithIsPartial adds the isPartial to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithIsPartial(isPartial *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetIsPartial(isPartial)
	return o
}

// SetIsPartial adds the isPartial to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetIsPartial(isPartial *string) {
	o.IsPartial = isPartial
}

// WithName adds the name to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithName(name *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReturnRecords adds the returnRecords to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *ApplicationSnapshotDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *ApplicationSnapshotDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *ApplicationSnapshotDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithUUID adds the uuid to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) WithUUID(uuid *string) *ApplicationSnapshotDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the application snapshot delete collection params
func (o *ApplicationSnapshotDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *ApplicationSnapshotDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.uuid
	if err := r.SetPathParam("application.uuid", o.ApplicationUUID); err != nil {
		return err
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ComponentsName != nil {

		// query param components.name
		var qrComponentsName string

		if o.ComponentsName != nil {
			qrComponentsName = *o.ComponentsName
		}
		qComponentsName := qrComponentsName
		if qComponentsName != "" {

			if err := r.SetQueryParam("components.name", qComponentsName); err != nil {
				return err
			}
		}
	}

	if o.ComponentsUUID != nil {

		// query param components.uuid
		var qrComponentsUUID string

		if o.ComponentsUUID != nil {
			qrComponentsUUID = *o.ComponentsUUID
		}
		qComponentsUUID := qrComponentsUUID
		if qComponentsUUID != "" {

			if err := r.SetQueryParam("components.uuid", qComponentsUUID); err != nil {
				return err
			}
		}
	}

	if o.ConsistencyType != nil {

		// query param consistency_type
		var qrConsistencyType string

		if o.ConsistencyType != nil {
			qrConsistencyType = *o.ConsistencyType
		}
		qConsistencyType := qrConsistencyType
		if qConsistencyType != "" {

			if err := r.SetQueryParam("consistency_type", qConsistencyType); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.CreateTime != nil {

		// query param create_time
		var qrCreateTime string

		if o.CreateTime != nil {
			qrCreateTime = *o.CreateTime
		}
		qCreateTime := qrCreateTime
		if qCreateTime != "" {

			if err := r.SetQueryParam("create_time", qCreateTime); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.IsPartial != nil {

		// query param is_partial
		var qrIsPartial string

		if o.IsPartial != nil {
			qrIsPartial = *o.IsPartial
		}
		qIsPartial := qrIsPartial
		if qIsPartial != "" {

			if err := r.SetQueryParam("is_partial", qIsPartial); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
