// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationSnapshotDeleteCollectionReader is a Reader for the ApplicationSnapshotDeleteCollection structure.
type ApplicationSnapshotDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationSnapshotDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationSnapshotDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationSnapshotDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationSnapshotDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationSnapshotDeleteCollectionOK creates a ApplicationSnapshotDeleteCollectionOK with default headers values
func NewApplicationSnapshotDeleteCollectionOK() *ApplicationSnapshotDeleteCollectionOK {
	return &ApplicationSnapshotDeleteCollectionOK{}
}

/*
ApplicationSnapshotDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationSnapshotDeleteCollectionOK struct {
	Payload *models.ApplicationSnapshotJobLinkResponse
}

// IsSuccess returns true when this application snapshot delete collection o k response has a 2xx status code
func (o *ApplicationSnapshotDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application snapshot delete collection o k response has a 3xx status code
func (o *ApplicationSnapshotDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application snapshot delete collection o k response has a 4xx status code
func (o *ApplicationSnapshotDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application snapshot delete collection o k response has a 5xx status code
func (o *ApplicationSnapshotDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application snapshot delete collection o k response a status code equal to that given
func (o *ApplicationSnapshotDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application snapshot delete collection o k response
func (o *ApplicationSnapshotDeleteCollectionOK) Code() int {
	return 200
}

func (o *ApplicationSnapshotDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/snapshots][%d] applicationSnapshotDeleteCollectionOK %s", 200, payload)
}

func (o *ApplicationSnapshotDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/snapshots][%d] applicationSnapshotDeleteCollectionOK %s", 200, payload)
}

func (o *ApplicationSnapshotDeleteCollectionOK) GetPayload() *models.ApplicationSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationSnapshotDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationSnapshotDeleteCollectionAccepted creates a ApplicationSnapshotDeleteCollectionAccepted with default headers values
func NewApplicationSnapshotDeleteCollectionAccepted() *ApplicationSnapshotDeleteCollectionAccepted {
	return &ApplicationSnapshotDeleteCollectionAccepted{}
}

/*
ApplicationSnapshotDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationSnapshotDeleteCollectionAccepted struct {
	Payload *models.ApplicationSnapshotJobLinkResponse
}

// IsSuccess returns true when this application snapshot delete collection accepted response has a 2xx status code
func (o *ApplicationSnapshotDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application snapshot delete collection accepted response has a 3xx status code
func (o *ApplicationSnapshotDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application snapshot delete collection accepted response has a 4xx status code
func (o *ApplicationSnapshotDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application snapshot delete collection accepted response has a 5xx status code
func (o *ApplicationSnapshotDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application snapshot delete collection accepted response a status code equal to that given
func (o *ApplicationSnapshotDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application snapshot delete collection accepted response
func (o *ApplicationSnapshotDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *ApplicationSnapshotDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/snapshots][%d] applicationSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *ApplicationSnapshotDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/snapshots][%d] applicationSnapshotDeleteCollectionAccepted %s", 202, payload)
}

func (o *ApplicationSnapshotDeleteCollectionAccepted) GetPayload() *models.ApplicationSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationSnapshotDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationSnapshotDeleteCollectionDefault creates a ApplicationSnapshotDeleteCollectionDefault with default headers values
func NewApplicationSnapshotDeleteCollectionDefault(code int) *ApplicationSnapshotDeleteCollectionDefault {
	return &ApplicationSnapshotDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
ApplicationSnapshotDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationSnapshotDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application snapshot delete collection default response has a 2xx status code
func (o *ApplicationSnapshotDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application snapshot delete collection default response has a 3xx status code
func (o *ApplicationSnapshotDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application snapshot delete collection default response has a 4xx status code
func (o *ApplicationSnapshotDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application snapshot delete collection default response has a 5xx status code
func (o *ApplicationSnapshotDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application snapshot delete collection default response a status code equal to that given
func (o *ApplicationSnapshotDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application snapshot delete collection default response
func (o *ApplicationSnapshotDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationSnapshotDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/snapshots][%d] application_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *ApplicationSnapshotDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /application/applications/{application.uuid}/snapshots][%d] application_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *ApplicationSnapshotDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationSnapshotDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ApplicationSnapshotDeleteCollectionBody application snapshot delete collection body
swagger:model ApplicationSnapshotDeleteCollectionBody
*/
type ApplicationSnapshotDeleteCollectionBody struct {

	// application snapshot response inline records
	ApplicationSnapshotResponseInlineRecords []*models.ApplicationSnapshot `json:"records,omitempty"`
}

// Validate validates this application snapshot delete collection body
func (o *ApplicationSnapshotDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateApplicationSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationSnapshotDeleteCollectionBody) validateApplicationSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.ApplicationSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.ApplicationSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.ApplicationSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.ApplicationSnapshotResponseInlineRecords[i] != nil {
			if err := o.ApplicationSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this application snapshot delete collection body based on the context it is used
func (o *ApplicationSnapshotDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateApplicationSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ApplicationSnapshotDeleteCollectionBody) contextValidateApplicationSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.ApplicationSnapshotResponseInlineRecords); i++ {

		if o.ApplicationSnapshotResponseInlineRecords[i] != nil {
			if err := o.ApplicationSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *ApplicationSnapshotDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ApplicationSnapshotDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res ApplicationSnapshotDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
