// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationSnapshotGetReader is a Reader for the ApplicationSnapshotGet structure.
type ApplicationSnapshotGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationSnapshotGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewApplicationSnapshotGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationSnapshotGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationSnapshotGetOK creates a ApplicationSnapshotGetOK with default headers values
func NewApplicationSnapshotGetOK() *ApplicationSnapshotGetOK {
	return &ApplicationSnapshotGetOK{}
}

/*
ApplicationSnapshotGetOK describes a response with status code 200, with default header values.

OK
*/
type ApplicationSnapshotGetOK struct {
	Payload *models.ApplicationSnapshot
}

// IsSuccess returns true when this application snapshot get o k response has a 2xx status code
func (o *ApplicationSnapshotGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application snapshot get o k response has a 3xx status code
func (o *ApplicationSnapshotGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application snapshot get o k response has a 4xx status code
func (o *ApplicationSnapshotGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this application snapshot get o k response has a 5xx status code
func (o *ApplicationSnapshotGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this application snapshot get o k response a status code equal to that given
func (o *ApplicationSnapshotGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the application snapshot get o k response
func (o *ApplicationSnapshotGetOK) Code() int {
	return 200
}

func (o *ApplicationSnapshotGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/snapshots/{uuid}][%d] applicationSnapshotGetOK %s", 200, payload)
}

func (o *ApplicationSnapshotGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/snapshots/{uuid}][%d] applicationSnapshotGetOK %s", 200, payload)
}

func (o *ApplicationSnapshotGetOK) GetPayload() *models.ApplicationSnapshot {
	return o.Payload
}

func (o *ApplicationSnapshotGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationSnapshot)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationSnapshotGetDefault creates a ApplicationSnapshotGetDefault with default headers values
func NewApplicationSnapshotGetDefault(code int) *ApplicationSnapshotGetDefault {
	return &ApplicationSnapshotGetDefault{
		_statusCode: code,
	}
}

/*
ApplicationSnapshotGetDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationSnapshotGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application snapshot get default response has a 2xx status code
func (o *ApplicationSnapshotGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application snapshot get default response has a 3xx status code
func (o *ApplicationSnapshotGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application snapshot get default response has a 4xx status code
func (o *ApplicationSnapshotGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application snapshot get default response has a 5xx status code
func (o *ApplicationSnapshotGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application snapshot get default response a status code equal to that given
func (o *ApplicationSnapshotGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application snapshot get default response
func (o *ApplicationSnapshotGetDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationSnapshotGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/snapshots/{uuid}][%d] application_snapshot_get default %s", o._statusCode, payload)
}

func (o *ApplicationSnapshotGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /application/applications/{application.uuid}/snapshots/{uuid}][%d] application_snapshot_get default %s", o._statusCode, payload)
}

func (o *ApplicationSnapshotGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationSnapshotGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
