// Code generated by go-swagger; DO NOT EDIT.

package application

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// ApplicationSnapshotRestoreReader is a Reader for the ApplicationSnapshotRestore structure.
type ApplicationSnapshotRestoreReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ApplicationSnapshotRestoreReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewApplicationSnapshotRestoreCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewApplicationSnapshotRestoreAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewApplicationSnapshotRestoreDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewApplicationSnapshotRestoreCreated creates a ApplicationSnapshotRestoreCreated with default headers values
func NewApplicationSnapshotRestoreCreated() *ApplicationSnapshotRestoreCreated {
	return &ApplicationSnapshotRestoreCreated{}
}

/*
ApplicationSnapshotRestoreCreated describes a response with status code 201, with default header values.

Created
*/
type ApplicationSnapshotRestoreCreated struct {
	Payload *models.ApplicationSnapshotJobLinkResponse
}

// IsSuccess returns true when this application snapshot restore created response has a 2xx status code
func (o *ApplicationSnapshotRestoreCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application snapshot restore created response has a 3xx status code
func (o *ApplicationSnapshotRestoreCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application snapshot restore created response has a 4xx status code
func (o *ApplicationSnapshotRestoreCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this application snapshot restore created response has a 5xx status code
func (o *ApplicationSnapshotRestoreCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this application snapshot restore created response a status code equal to that given
func (o *ApplicationSnapshotRestoreCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the application snapshot restore created response
func (o *ApplicationSnapshotRestoreCreated) Code() int {
	return 201
}

func (o *ApplicationSnapshotRestoreCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/snapshots/{uuid}/restore][%d] applicationSnapshotRestoreCreated %s", 201, payload)
}

func (o *ApplicationSnapshotRestoreCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/snapshots/{uuid}/restore][%d] applicationSnapshotRestoreCreated %s", 201, payload)
}

func (o *ApplicationSnapshotRestoreCreated) GetPayload() *models.ApplicationSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationSnapshotRestoreCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationSnapshotRestoreAccepted creates a ApplicationSnapshotRestoreAccepted with default headers values
func NewApplicationSnapshotRestoreAccepted() *ApplicationSnapshotRestoreAccepted {
	return &ApplicationSnapshotRestoreAccepted{}
}

/*
ApplicationSnapshotRestoreAccepted describes a response with status code 202, with default header values.

Accepted
*/
type ApplicationSnapshotRestoreAccepted struct {
	Payload *models.ApplicationSnapshotJobLinkResponse
}

// IsSuccess returns true when this application snapshot restore accepted response has a 2xx status code
func (o *ApplicationSnapshotRestoreAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this application snapshot restore accepted response has a 3xx status code
func (o *ApplicationSnapshotRestoreAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this application snapshot restore accepted response has a 4xx status code
func (o *ApplicationSnapshotRestoreAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this application snapshot restore accepted response has a 5xx status code
func (o *ApplicationSnapshotRestoreAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this application snapshot restore accepted response a status code equal to that given
func (o *ApplicationSnapshotRestoreAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the application snapshot restore accepted response
func (o *ApplicationSnapshotRestoreAccepted) Code() int {
	return 202
}

func (o *ApplicationSnapshotRestoreAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/snapshots/{uuid}/restore][%d] applicationSnapshotRestoreAccepted %s", 202, payload)
}

func (o *ApplicationSnapshotRestoreAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/snapshots/{uuid}/restore][%d] applicationSnapshotRestoreAccepted %s", 202, payload)
}

func (o *ApplicationSnapshotRestoreAccepted) GetPayload() *models.ApplicationSnapshotJobLinkResponse {
	return o.Payload
}

func (o *ApplicationSnapshotRestoreAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ApplicationSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewApplicationSnapshotRestoreDefault creates a ApplicationSnapshotRestoreDefault with default headers values
func NewApplicationSnapshotRestoreDefault(code int) *ApplicationSnapshotRestoreDefault {
	return &ApplicationSnapshotRestoreDefault{
		_statusCode: code,
	}
}

/*
ApplicationSnapshotRestoreDefault describes a response with status code -1, with default header values.

Error
*/
type ApplicationSnapshotRestoreDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this application snapshot restore default response has a 2xx status code
func (o *ApplicationSnapshotRestoreDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this application snapshot restore default response has a 3xx status code
func (o *ApplicationSnapshotRestoreDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this application snapshot restore default response has a 4xx status code
func (o *ApplicationSnapshotRestoreDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this application snapshot restore default response has a 5xx status code
func (o *ApplicationSnapshotRestoreDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this application snapshot restore default response a status code equal to that given
func (o *ApplicationSnapshotRestoreDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the application snapshot restore default response
func (o *ApplicationSnapshotRestoreDefault) Code() int {
	return o._statusCode
}

func (o *ApplicationSnapshotRestoreDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/snapshots/{uuid}/restore][%d] application_snapshot_restore default %s", o._statusCode, payload)
}

func (o *ApplicationSnapshotRestoreDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /application/applications/{application.uuid}/snapshots/{uuid}/restore][%d] application_snapshot_restore default %s", o._statusCode, payload)
}

func (o *ApplicationSnapshotRestoreDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *ApplicationSnapshotRestoreDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
